
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//FR" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 8</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter8.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 8<br />
      Relative Clauses, Which Make sumti Even More Complicated</h2>

      <!--
      <h6>$Revision: 4.1 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. What are you pointing at?</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   poi NOI restrictive relative clause introducer
    ke'a    GOhA    relative pro-sumti
    ku'o    KUhO    relative clause terminator
</pre>
    Let us think about the problem of communicating what it is that
    we are pointing at when we are pointing at something. In
    Lojban, we can refer to what we are pointing at by using the
    pro-sumti ``ti'' if it is nearby, or ``ta'' if it is somewhat
    further away, or ``tu'' if it is distant. (Pro-sumti are
    explained in full in <a href="chapter7.html">Chapter 7</a>.) 

    <p>However, even with the assistance of a pointing finger, or
    pointing lips, or whatever may be appropriate in the local
    culture, it is often hard for a listener to tell just what is
    being pointed at. Suppose one is pointing at a person (in
    particular, in the direction of his or her face), and says:</p>
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  ti cu barda
    This-one is-big.
</pre>

    <p>What is the referent of ``ti''? Is it the person? Or perhaps
    it is the person's nose? Or even (for ``ti'' can be plural as
    well as singular, and mean ``these ones'' as well as ``this
    one'') the pores on the person's nose?</p>

    <p>To help solve this problem, Lojban uses a construction
    called a ``relative clause''. Relative clauses are usually
    attached to the end of sumti, but there are other places where
    they can go as well, as explained later in this chapter. A
    relative clause begins with a word of selma'o NOI, and ends
    with the elidable terminator ``ku'o'' (of selma'o KUhO). As you
    might suppose, ``noi'' is a cmavo of selma'o NOI; however,
    first we will discuss the cmavo ``poi'', which also belongs to
    selma'o NOI.</p>

    <p>In between the ``poi'' and the ``ku'o'' appears a full
    bridi, with the same syntax as any other bridi. Anywhere within
    the bridi of a relative clause, the pro-sumti ``ke'a'' (of
    selma'o KOhA) may be used, and it stands for the sumti to which
    the relative clause is attached (called the ``relativized
    sumti''). Here are some examples before we go any further:</p>

    <p></p>
<pre>
<a id="e1d2" name="e1d2">1.2)</a>  ti poi ke'a prenu ku'o cu barda
    This-thing such-that( IT is-a-person ) is-large.
    This thing which is a person is big.
    This person is big.
</pre>
<pre>
<a id="e1d3" name="e1d3">1.3)</a>  ti poi ke'a nazbi ku'o cu barda
    This-thing such-that( IT is-a-nose ) is-large.
    This thing which is a nose is big.
    This nose is big.
</pre>
<pre>
<a id="e1d4" name="e1d4">1.4)</a>  ti poi ke'a nazbi kapkevna ku'o
        cu barda
    This-thing such-that( IT is-a-nose-type-of skin-hole )
        is-big.
    These things which are nose-pores are big.
    These nose-pores are big.
</pre>
    In the literal translations throughout this chapter, the word
    ``IT'', capitalized, is used to represent the cmavo ``ke'a''.
    In each case, it serves to represent the sumti (in <a
    href="#e1d2">Examples 1.2</a> through <a
    href="#e1d4">1.4</a>, the cmavo ``ti'') to which the relative
    clause is attached. 

    <p>Of course, there is no reason why ``ke'a'' needs to appear
    in the x1 place of a relative clause bridi; it can appear in
    any place, or indeed even in a sub-bridi within the relative
    clause bridi. Here are two more examples:</p>
<pre>
<a id="e1d5" name="e1d5">1.5)</a>  tu poi le mlatu pu lacpu ke'a ku'o
        cu ratcu
    That-distant-thing such-that( the cat [past] drags IT )
        is-a-rat.
    That thing which the cat dragged is a rat.
    What the cat dragged is a rat.

<a id="e1d6" name="e1d6">1.6)</a>   ta poi mi djica le nu mi ponse ke'a [kei] ku'o
        cu bloti
    That-thing such-that( I desire the event-of( I own IT ) )
        is-a-boat.
    That thing that I want to own is a boat.
</pre>

    <p>In <a href="#e1d6">Example 1.6</a>, ``ke'a'' appears in an
    abstraction clause (abstractions are explained in <a
    href="chapter11.html">Chapter 11</a>) within a relative
    clause.</p>

    <p>Like any sumti, ``ke'a'' can be omitted. The usual
    presumption in that case is that it then falls into the x1
    place:</p>
<pre>
<a id="e1d7" name="e1d7">1.7)</a>  ti poi nazbi cu barda
    This-thing which is-a-nose is-big.
</pre>
    almost certainly means the same thing as <a
    href="#e1d3">Example 1.3</a>. However, ``ke'a'' can be omitted
    if it is clear to the listener that it belongs in some place
    other than x1: 
<pre>
<a id="e1d8" name="e1d8">1.8)</a>  tu poi le mlatu pu lacpu cu ratcu
    That-distant-thing which the cat drags is-a-rat
</pre>
    is equivalent to <a href="#e1d4">Example 1.4</a>. 

    <p>As stated before, ``ku'o'' is an elidable terminator, and in
    fact it is almost always elidable. Throughout the rest of this
    chapter, ``ku'o'' will not be written in any of the examples
    unless it is absolutely required: thus, <a href="#e1d2">Example
    1.2</a> can be written:</p>
<pre>
<a id="e1d9" name="e1d9">1.9)</a>  ti poi prenu cu barda
    That which is-a-person is-big.
    That person is big.
</pre>
    without any change in meaning. Note that ``poi'' is translated
    ``which'' rather than ``such-that'' when ``ke'a'' has been
    omitted from the x1 place of the relative clause bridi. The
    word ``which'' is used in English to introduce English relative
    clauses: other words that can be used are ``who'' and ``that'',
    as in: 
<pre>
<a id="e1d10" name="e1d10">1.10)</a>    I saw a man who was going to the store.
</pre>
    and 
<pre>
<a id="e1d11" name="e1d11">1.11)</a>    The building that the school was located in is large.
</pre>

    <p>In <a href="#e1d10">Example 1.10</a> the relative clause is
    ``who was going to the store'', and in <a href="#e1d11">Example
    1.11</a> it is ``that the school was located in''. Sometimes
    ``who'', ``which'', and ``that'' are used in literal
    translations in this chapter in order to make them read more
    smoothly.</p>

    <h3><a id="s2" name="s2">2. Incidental relative clauses</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   noi NOI incidental relative clause introducer
</pre>
    There are two basic kinds of relative clauses: restrictive
    relative clauses introduced by ``poi'', and incidental
    (sometimes called simply ``non-restrictive'') relative clauses
    introduced by ``noi''. The difference between restrictive and
    incidental relative clauses is that restrictive clauses provide
    information that is essential to identifying the referent of
    the sumti to which they are attached, whereas incidental
    relative clauses provide additional information which is
    helpful to the listener but is not essential for identifying
    the referent of the sumti. All of the examples in <a
    href="#s1">Section 1</a> are restrictive relative clauses: the
    information in the relative clause is essential to
    identification. (The title of this chapter, though, uses an
    incidental relative clause.) 

    <p>Consider the following examples:</p>
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  le gerku poi blanu cu barda
    The dog which is-blue is-large.
    The dog which is blue is large.

<a id="e2d2" name="e2d2">2.2)</a>   le gerku noi blanu cu barda
    The dog incidentally-which is-blue is-large.
    The dog, which is blue, is large.
</pre>

    <p>In <a href="#e2d1">Example 2.1</a>, the information conveyed
    by ``poi blanu'' is essential to identifying the dog in
    question: it restricts the possible referents from dogs in
    general to dogs that are blue. This is why ``poi'' relative
    clauses are called restrictive. In <a href="#e2d2">Example
    2.2</a>, on the other hand, the dog which is referred to has
    presumably already been identified clearly, and the relative
    clause ``noi blanu'' just provides additional information about
    it. (If in fact the dog hasn't been identified clearly, then
    the relative clause does not help identify it further.)</p>

    <p>In English, the distinction between restrictive and
    incidental relative clauses is expressed in writing by
    surrounding incidental, but not restrictive, clauses with
    commas. These commas are functioning as parentheses, because
    incidental relative clauses are essentially parenthetical. This
    distinction in punctuation is represented in speech by a
    difference in tone of voice. In addition, English restrictive
    relative clauses can be introduced by ``that'' as well as
    ``which'' and ``who'', whereas incidental relative clauses
    cannot begin with ``that''. Lojban, however, always uses the
    cmavo ``poi'' and ``noi'' rather than punctuation or intonation
    to make the distinction.</p>

    <p>Here are more examples of incidental relative clauses:</p>
<pre>
<a id="e2d3" name="e2d3">2.3)</a>  mi noi jdice cu zvati
    I who-incidentally am-a-judge am-at [some-place].
    I, a judge, am present.
</pre>

    <p>In this example, ``mi'' is already sufficiently restricted,
    and the additional information that I am a judge is being
    provided solely for the listener's edification.</p>
<pre>
<a id="e2d4" name="e2d4">2.4)</a>  xu do viska le mi karce noi blabi
    [True?] You see my car incidentally-which is-white.
    Do you see my car, which is white?
</pre>

    <p>In <a href="#e2d4">Example 2.4</a>, the speaker is presumed
    to have only one car, and is providing incidental information
    that it is white. (Alternatively, he or she might have more
    than one car, since ``le karce'' can be plural, in which case
    the incidental information is that each of them is white.)
    Contrast <a href="#e2d5">Example 2.5</a> with a restrictive
    relative clause:</p>
<pre>
<a id="e2d5" name="e2d5">2.5)</a>  xu do viska le mi karce poi blabi
    [True?] You see my car which is-white.
    Do you see my car that is white?
    Do you see my white car?
</pre>
    Here the speaker probably has several cars, and is restricting
    the referent of the sumti ``le mi karce'' (and thereby the
    listener's attention) to the white one only. <a
    href="#e2d5">Example 2.5</a> means much the same as <a
    href="#e2d6">Example 2.6</a>, which does not use a relative
    clause: 
<pre>
<a id="e2d6" name="e2d6">2.6)</a>  xu do viska le mi blabi karce
    [True?] You see my white car.
    Do you see my car, the white one?
</pre>
    So a restrictive relative clause attached to a description can
    often mean the same as a description involving a tanru.
    However, ``blabi karce'', like all tanru, is somewhat vague: in
    principle, it might refer to a car which carries white things,
    or even express some more complicated concept involving
    whiteness and car-ness; the restrictive relative clause of <a
    href="#e2d5">Example 2.5</a> can only refer to a car which is
    white, not to any more complex or extended concept. 

    <h3><a id="s3" name="s3">3. Relative phrases</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   pe  GOI restrictive association
    po  GOI restrictive possession
    po'e    GOI restrictive intrinsic possession
    po'u    GOI restrictive identification
    ne  GOI incidental association
    no'u    GOI incidental identification
    ge'u    GEhU    relative phrase terminator
</pre>
    There are types of relative clauses (those which have a certain
    selbri) which are frequently wanted in Lojban, and can be
    expressed using a shortcut called a relative phrase. Relative
    phrases are introduced by cmavo of selma'o GOI, and consist of
    a GOI cmavo followed by a single sumti. 

    <p>Here is an example of ``pe'', plus an equivalent sentence
    using a relative clause:</p>
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  le stizu pe mi cu blanu
    The chair associated-with me is-blue.
    My chair is blue.

<a id="e3d2" name="e3d2">3.2)</a>   le stizu poi ke'a srana mi
        cu blanu
    The chair such-that( IT is-associated-with me)
        is-blue.
</pre>

    <p>In <a href="#e3d1">Example 3.1</a> and <a
    href="#e3d2">Example 3.2</a>, the link between the chair and
    the speaker is of the loosest kind.</p>

    <p>Here is an example of ``po'':</p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  le stizu po mi cu xunre
    The chair specific-to me is red.

<a id="e3d4" name="e3d4">3.4)</a>   le stizu poi
        ke'a se steci srana mi cu xunre
    The chair such-that
        (IT is-specifically associated-with me) is-red.
</pre>
    <a href="#e3d3">Example 3.3</a> and <a href="#e3d4">Example
    3.4</a> contrast with <a href="#e3d1">Example 3.1</a> and <a
    href="#e3d2">Example 3.2</a>: the chair is more permanently
    connected with the speaker. A plausible (though not the only
    possible) contrast between <a href="#e3d1">Example 3.1</a> and
    <a href="#e3d3">Example 3.3</a> is that ``pe mi'' would be
    appropriate for a chair the speaker is currently sitting on
    (whether or not the speaker owned that chair), and ``po mi''
    for a chair owned by the speaker (whether or not he or she was
    currently occupying it). 

    <p>As a result, the relationship expressed between two sumti by
    ``po'' is usually called ``possession'', although it does not
    necessarily imply ownership, legal or otherwise. The central
    concept is that of specificity (``steci'' in Lojban).</p>

    <p>Here is an example of ``po'e'', as well as another example
    of ``po'':</p>

    <p></p>
<pre>
<a id="e3d5" name="e3d5">3.5)</a>  le birka po'e mi cu spofu
    The arm intrinsically-possessed-by me is-broken

<a id="e3d6" name="e3d6">3.6)</a>   le birka poi
        jinzi ke se steci srana mi
        cu spofu
    The arm which
        is-intrinsically (specifically associated-with) me
        is-broken

<a id="e3d7" name="e3d7">3.7)</a>   le botpi po mi cu spofu
    The bottle specific-to me is-broken
</pre>
    <a href="#e3d5">Example 3.5</a> and <a href="#e3d6">Example
    3.6</a> on the one hand, and <a href="#e3d7">Example 3.7</a> on
    the other, illustrate the contrast between two types of
    possession called ``intrinsic'' and ``extrinsic'', or sometimes
    ``inalienable'' and ``alienable'', respectively. Something is
    intrinsically (or inalienably) possessed by someone if the
    possession is part of the possessor, and cannot be changed
    without changing the possessor. In the case of <a
    href="#e3d5">Example 3.5</a>, people are usually taken to
    intrinsically possess their arms: even if an arm is cut off, it
    remains the arm of that person. (If the arm is transplanted to
    another person, however, it becomes intrinsically possessed by
    the new user, though, so intrinsic possession is a matter of
    degree.) 

    <p>By contrast, the bottle of <a href="#e3d7">Example 3.7</a>
    can be given away, or thrown away, or lost, or stolen, so it is
    possessed extrinsically (alienably). The exact line between
    intrinsic and extrinsic possession is culturally dependent. The
    U.S. Declaration of Independence speaks of the ``inalienable
    rights'' of men, but just what those rights are, and even
    whether the concept makes sense at all, varies from culture to
    culture.</p>

    <p>Note that <a href="#e3d5">Example 3.5</a> can also be
    expressed without a relative clause:</p>
<pre>
<a id="e3d8" name="e3d8">3.8)</a>  le birka be mi cu spofu
    The arm of-body me is broken
</pre>
    reflecting the fact that the gismu ``birka'' has an x2 place
    representing the body to which the arm belongs. Many, but not
    all, cases of intrinsic possession can be thus covered without
    using ``po'e'' by placing the possessor into the appropriate
    place of the description selbri. 

    <p>Here is an example of ``po'u'':</p>
<pre>
<a id="e3d9" name="e3d9">3.9)</a>  le gerku po'u le mi pendo cu cinba mi
    The dog which-is my friend kisses me.

<a id="e3d10" name="e3d10">3.10)</a> le gerku poi du le mi pendo cu cinba mi
    The dog which = my friend kisses me.
</pre>
    The cmavo ``po'u'' does not represent possession at all, but
    rather identity. (Note that it means ``poi du'' and its form
    was chosen to suggest the relationship.) 

    <p>In <a href="#e3d9">Example 3.9</a>, the use of ``po'u''
    tells us that ``le gerku'' and ``le mi pendo'' represent the
    same thing. Consider the contrast between <a
    href="#e3d9">Example 3.9</a> and:</p>
<pre>
<a id="e3d11" name="e3d11">3.11)</a>    le mi pendo po'u le gerku cu cinba mi
    My friend which-is the dog kisses me.
</pre>
    The facts of the case are the same, but the listener's
    knowledge about the situation may not be. In <a
    href="#e3d9">Example 3.9</a>, the listener is presumed not to
    understand which dog is meant by ``le gerku'', so the speaker
    adds a relative phrase clarifying that it is the particular dog
    which is the speaker's friend. 

    <p><a href="#e3d11">Example 3.11</a>, however, assumes that the
    listener does not know which of the speaker's friends is
    referred to, and specifies that it is the friend that is the
    dog (which dog is taken to be obvious). Here is another example
    of the same contrast:</p>

    <p></p>
<pre>
<a id="e3d12" name="e3d12">3.12)</a>    le tcadu po'u la nu,iork
    The city of New York [not another city].

<a id="e3d13" name="e3d13">3.13)</a> la nu,iork po'u le tcadu
    New York the city (not the state or some other New York)
</pre>
    The principle that the possessor and the possessed may change
    places applies to all the GOI cmavo, and allows for the
    possibility of odd effects: 

    <p></p>
<pre>
<a id="e3d14" name="e3d14">3.14)</a>    le kabri pe le mi pendo cu cmalu
    The cup associated-with my friend is small.
    My friend's cup is small
</pre>
<pre>
<a id="e3d15" name="e3d15">3.15)</a>    le mi pendo pe le kabri cu cmalu
    My friend associated-with the cup is small.
    My friend, the one with the cup, is small.
</pre>
    <a href="#e3d14">Example 3.14</a> is useful in a context which
    is about my friend, and states that his or her cup is small,
    whereas <a href="#e3d15">Example 3.15</a> is useful in a
    context that is primarily about a certain cup, and makes a
    claim about ``my friend of the cup'', as opposed to some other
    friend of mine. Here the cup appears to ``possess'' the person!
    English can't even express this relationship with a possessive
    --- ``the cup's friend of mine'' looks like nonsense --- but
    Lojban has no trouble doing so. 

    <p>Finally, the cmavo ``ne'' and ``no'u'' stand to ``pe'' and
    ``po'u'', respectively, as ``noi'' does to ``poi'' --- they
    provide incidental information:</p>
<pre>
<a id="e3d16" name="e3d16">3.16)</a>    le blabi gerku ne mi cu batci do
    The white dog, incidentally-associated-with me,
        bites you.
    The white dog, which is mine, bites you.
</pre>

    <p>In <a href="#e3d16">Example 3.16</a>, the white dog is
    already fully identified (after all, presumably the listener
    know which dog bit him or her!). The fact that it is yours is
    merely incidental to the main bridi claim.</p>

    <p>Distinguishing between ``po'u'' and ``no'u'' can be a little
    tricky. Consider a room with several men in it, one of whom is
    named Jim. If you don't know their names, I might say:</p>
<pre>
<a id="e3d17" name="e3d17">3.17)</a>    le nanmu no'u la djim. cu terpemci
    The man, incidentally-who-is Jim, is-a-poet.
    The man, Jim, is a poet.
</pre>

    <p>Here I am saying that one of the men is a poet, and
    incidentally telling you that he is Jim. But if you do know the
    names, then</p>
<pre>
<a id="e3d18" name="e3d18">3.18)</a>    le nanmu po'u la djim. cu terpemci
    The man who-is Jim is-a-poet.
    The man, the one named Jim, is a poet.
</pre>
    is appropriate. Now I am using the fact that the man I am
    speaking of is Jim in order to pick out which man I mean. 

    <p>It is worth mentioning that English sometimes over-specifies
    possession from the Lojban point of view (and the point of view
    of many other languages, including ones closely related to
    English). The idiomatic English sentence</p>
<pre>
<a id="e3d19" name="e3d19">3.19)</a>    The man put his hands in his pockets.
</pre>
    seems strange to a French- or German-speaking person: whose
    pockets would he put his hands into? and even odder, whose
    hands would he put into his pockets? In Lojban, the sentence 

    <p></p>
<pre>
<a id="e3d20" name="e3d20">3.20)</a>    le nanmu cu punji le xanci le daski
    The man puts the hand at-locus-the pocket.
</pre>
    is very natural. Of course, if the man is in fact putting his
    hands into another's pockets, or another's hands into his
    pockets, the fact can be specified. 

    <p>Finally, the elidable terminator for GOI cmavo is ``ge'u''
    of selma'o GEhU; it is almost never required. However, if a
    logical connective immediately follows a sumti modified by a
    relative phrase, then an explicit ``ge'u'' is needed to allow
    the connective to affect the relativized sumti rather than the
    sumti of the relative phrase. (What about the cmavo after which
    selma'o GOI is named? It is discussed in <a
    href="chapter7.html">Chapter 7</a>, as it is not semantically akin
    to the other kinds of relative phrases, although the syntax is
    the same.)</p>

    <h3><a id="s4" name="s4">4. Multiple relative clauses: ``zi'e''</h3>
<pre>
   zi'e    ZIhE        relative clause joiner
</pre>
    Sometimes it is necessary or useful to attach more than one
    relative clause to a sumti. This is made possible in Lojban by
    the cmavo ``zi'e'' (of selma'o ZIhE), which is used to join one
    or more relative clauses together into a single unit, thus
    making them apply to the same sumti. For example: 
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  le gerku poi blabi zi'e poi batci le nanmu cu klama
    The dog which is white and which bites the man goes.
</pre>
    The most usual translation of ``zi'e'' in English is ``and'',
    but ``zi'e'' is not really a logical connective: unlike most of
    the true logical connectives (which are explained in <a
    href="chapter14.html">Chapter 14</a>), it cannot be converted into
    a logical connection between sentences. 

    <p>It is perfectly correct to use ``zi'e'' to connect relative
    clauses of different kinds:</p>
<pre>
<a id="e4d2" name="e4d2">4.2)</a>  le gerku poi blabi zi'e noi
        le mi pendo cu ponse ke'a cu klama
    The dog that-is( white) and incidentally-such-that(
        my friend owns IT) goes.
    The dog that is white, which my friend owns,
        is going.
</pre>

    <p>In <a href="#e4d2">Example 4.2</a>, the restrictive clause
    ``poi blabi'' specifies which dog is referred to, but the
    incidental clause ``noi le mi pendo cu ponse'' is mere
    incidental information: the listener is supposed to already
    have identified the dog from the ``poi blabi''. Of course, the
    meaning (though not necessarily the emphasis) is the same if
    the incidental clause appears first.</p>

    <p>It is also possible to connect relative phrases with
    ``zi'e'', or a relative phrase with a relative clause:</p>
<pre>
<a id="e4d3" name="e4d3">4.3)</a>  le botpi po mi zi'e poi blanu cu spofu
    The bottle specific-to me and which-is blue is-broken.
    My blue bottle is broken.
</pre>

    <p>Note that if the colloquial translation of <a
    href="#e4d3">Example 4.3</a> were ``My bottle, which is blue,
    is broken'', then ``noi'' rather than ``poi'' would have been
    correct in the Lojban version, since that version of the
    English implies that you do not need to know the bottle is
    blue. As written, <a href="#e4d3">Example 4.3</a> suggests that
    I probably have more than one bottle, and the one in question
    needs to be picked out as the blue one.</p>

    <p></p>
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  mi ba zutse le stizu pe mi
        zi'e po do zi'e poi xunre
    I [future] sit-in the chair associated-with me and
        specific-to you and which-is red.
    I will sit in my chair (really yours), the red one.
</pre>
    <a href="#e4d4">Example 4.4</a> illustrates that more than two
    relative phrases or clauses can be connected with ``zi'e''. It
    almost defies colloquial translation because of the very
    un-English contrast between ``pe mi'', implying that the chair
    is temporarily connected with me, and ``po do'', implying that
    the chair has a more permanent association with you. (Perhaps I
    am a guest in your house, in which case the chair would
    naturally be your property.) 

    <p>Here is another example, mixing a relative phrase and two
    relative clauses, a restrictive one and a non-restrictive
    one:</p>

    <p></p>
<pre>
<a id="e4d5" name="e4d5">4.5)</a>  mi ba citka le dembi pe mi
        zi'e poi cpana le mi palta
        zi'e noi do dunda ke'a mi
    I [future] eat the beans associated-with me
        and which are-upon my plate
        and which-incidentally you gave IT to-me.
    I'll eat my beans that are on my plate, the ones
        you gave me.
</pre>

    <h3><a id="s5" name="s5">5. Non-veridical relative clauses: ``voi''</h3>
<pre>
   voi NOI non-veridical relative clause introducer
</pre>
    There is another member of selma'o NOI which serves to
    introduce a third kind of relative clause: ``voi''. Relative
    clauses introduced by ``voi'' are restrictive, like those
    introduced by ``poi''. However, there is a fundamental
    difference between ``poi'' and ``voi'' relative clauses. A
    ``poi'' relative clause is said to be veridical, in the same
    sense that a description using ``lo'' or ``loi'' is: it is
    essential to the interpretation that the bridi actually be
    true. For example: 
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  le gerku poi blabi cu klama
    The dog which is-white goes.
</pre>
    it must actually be true that the dog is white, or the sentence
    constitutes a miscommunication. If there is a white dog and a
    brown dog, and the speaker uses ``le gerku poi blabi'' to refer
    to the brown dog, then the listener will not understand
    correctly. However, 
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  le gerku voi blabi cu klama
    the dog which-I-describe-as white goes
</pre>
    puts the listener on notice that the dog in question may not
    actually meet objective standards (whatever they are) for being
    white: only the speaker can say exactly what is meant by the
    term. In this way, ``voi'' is like ``le''; the speaker's
    intention determines the meaning. 

    <p>As a result, the following two sentences</p>

    <p></p>
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  le nanmu cu ninmu
    That-which-I-describe-as a-man is-a-woman.
    The ``guy'' is actually a gal.

<a id="e5d4" name="e5d4">5.4)</a>   ti voi nanmu cu ninmu
    This-thing which-I-describe-as a-man is-a-woman.
</pre>
    mean essentially the same thing (except that <a
    href="#e5d5">Example 5.5</a> involves pointing thanks to the
    use of ``ti'', whereas <a href="#e5d4">Example 5.4</a>
    doesn't), and neither one is self-contradictory: it is
    perfectly all right to describe something as a man (although
    perhaps confusing to the listener) even if it actually is a
    woman. 

    <h3><a id="s6" name="s6">6. Relative clauses and descriptors</h3>

    <p>So far, this chapter has described the various kinds of
    relative clauses (including relative phrases). The list is now
    complete, and the rest of the chapter will be concerned with
    the syntax of sumti that include relative clauses. So far, all
    relative clauses have appeared directly after the sumti to
    which they are attached. This is the most common position (and
    originally the only one), but a variety of other placements are
    also possible which produce a variety of semantic effects.</p>

    <p>There are actually three places where a relative clause can
    be attached to a description sumti: after the descriptor
    (``le'', ``lo'', or whatever), after the embedded selbri but
    before the elidable terminator (which is ``ku''), and after the
    ``ku''. The relative clauses attached to descriptors that we
    have seen have occupied the second position. Thus <a
    href="#e5d1">Example 5.1</a>, if written out with all elidable
    terminators, would appear as:</p>
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  le gerku poi blabi ku'o ku cu klama vau
    the( dog which( is-white ) ) goes.
    The dog which is white is going.
</pre>
    Here ``ku'o'' is the terminator paired with ``poi'' and ``ku''
    with ``le'', and ``vau'' is the terminator of the whole bridi. 

    <p>When a simple descriptor using ``le'', like ``le gerku'',
    has a relative clause attached, it is purely a matter of style
    and emphasis where the relative clause should go. Therefore,
    the following examples are all equivalent in meaning to <a
    href="#e6d1">Example 6.1</a>:</p>
<pre>
<a id="e6d2" name="e6d2">6.2)</a>  le poi blabi ku'o gerku cu klama
    The such-that (it-is-white) dog goes.

<a id="e6d3" name="e6d3">6.3)</a>   le gerku ku poi blabi cu klama
    The( dog ) which is-white goes.
</pre>
    <a href="#e6d1">Example 6.1</a> will seem most natural to
    speakers of languages like English, which always puts relative
    clauses after the noun phrases they are attached to; <a
    href="#e6d2">Example 6.2</a>, on the other hand, may seem more
    natural to Finnish or Chinese speakers, who put the relative
    clause first. Note that in <a href="#e6d2">Example 6.2</a>, the
    elidable terminator ``ku'o'' must appear, or the selbri of the
    relative clause (``blabi'') will merge with the selbri of the
    description (``gerku''), resulting in an ungrammatical
    sentence. The purpose of the form appearing in <a
    href="#e6d3">Example 6.3</a> will be apparent shortly. 

    <p>As is explained in detail in <a href="chapter6.html">Chapter
    6</a>, two different numbers (known as the ``inner quantifier''
    and the ``outer quantifier'') can be attached to a description.
    The inner quantifier specifies how many things the descriptor
    refers to: it appears between the descriptor and the
    description selbri. The outer quantifier appears before the
    descriptor, and specifies how many of the things referred to by
    the descriptor are involved in this particular bridi. In the
    following example,</p>

    <p></p>
<pre>
<a id="e6d4" name="e6d4">6.4)</a>  re le mu prenu cu klama le zarci
    Two-of the five persons go to-the market.
    Two of the five people [that I have in mind]
        are going to the market.
</pre>
    ``mu'' is the inner quantifier and ``re'' is the outer
    quantifier. Now what is meant by attaching a relative clause to
    the sumti ``re le mu prenu''? Suppose the relative clause is
    ``poi ninmu'' (meaning ``who are women''). Now the three
    possible attachment points discussed previously take on
    significance. 

    <p></p>
<pre>
<a id="e6d5" name="e6d5">6.5)</a>  re le poi ninmu ku'o mu prenu
        cu klama le zarci
    Two of the such-that([they] are-women )
        five persons go to-the market.
    Two women out of the five persons go to the market.
</pre>
<pre>
<a id="e6d6" name="e6d6">6.6)</a>  re le mu prenu poi ninmu [ku]
        cu klama le zarci
    Two of the (five persons which are-women)
        go to-the market.
    Two of the five women go to the market.
</pre>
<pre>
<a id="e6d7" name="e6d7">6.7)</a>  re le mu prenu ku poi ninmu
        cu klama le zarci
    (Two of the five persons ) which are-women
        go to-the market.
    Two women out of the five persons go to the market.
</pre>
    As the parentheses show, <a href="#e6d6">Example 6.6</a> means
    that all five of the persons are women, whereas <a
    href="#e6d7">Example 6.7</a> means that the two who are going
    to the market are women. How do we remember which is which? If
    the relative clause comes after the explicit ``ku'', as in <a
    href="#e6d7">Example 6.7</a>, then the sumti as a whole is
    qualified by the relative clause. If there is no ``ku'', or if
    the relative clause comes before an explicit ``ku'', then the
    relative clause is understood to apply to everything which the
    underlying selbri applies to. 

    <p>What about <a href="#e6d5">Example 6.5</a>? By convention,
    it means the same as <a href="#e6d7">Example 6.7</a>, and it
    requires no ``ku'', but it does typically require a ``ku'o''
    instead. Note that the relative clause comes before the inner
    quantifier.</p>

    <p>When ``le'' is the descriptor being used, and the sumti has
    no explicit outer quantifier, then the outer quantifier is
    understood to be ``ro'' (meaning ``all''), as is explained in
    <a href="chapter6.html">Chapter 6</a>. Thus ``le gerku'' is taken
    to mean ``all of the things I refer to as dogs'', possibly all
    one of them. In that case, there is no difference between a
    relative clause after the ``ku'' or before it. However, if the
    descriptor is ``lo'', the difference is quite important:</p>
<pre>
<a id="e6d8" name="e6d8">6.8)</a>  lo prenu ku noi blabi
        cu klama le zarci
    (Some persons) incidentally-which are-white
        go to-the market.
    Some people, who are white, go to the market.

<a id="e6d9" name="e6d9">6.9)</a>   lo prenu noi blabi [ku]
        cu klama le zarci
    Some (persons incidentally-which are-white)
        go to-the market.
    Some of the people, who by the way are white,
        go to the market.
</pre>

    <p>Both <a href="#e6d8">Examples 6.8</a> and <a
    href="#e6d9">6.9</a> tell us that one or more persons are going
    to the market. However, they make very different incidental
    claims. Now, what does ``lo prenu noi blabi'' mean? Well, the
    default inner quantifier is ``ro'' (meaning ``all''), and the
    default outer quantifier is ``su'o'' (meaning ``at least
    one''). Therefore, we must first take all persons, then choose
    at least one of them. That one or more people will be
    going.</p>

    <p>In <a href="#e6d8">Example 6.8</a>, the relative clause
    described the sumti once the outer quantifier was applied: one
    or more people, who are white, are going. But in <a
    href="#e6d9">Example 6.9</a>, the relative clause actually
    describes the sumti before the outer quantification is applied,
    so that it ends up meaning ``First take all persons --- by the
    way, they're all white''. But not all people are white, so the
    incidental claim being made here is false.</p>

    <p>The safe strategy, therefore, is to always use ``ku'' when
    attaching a ``noi'' relative clause to a ``lo'' descriptor.
    Otherwise we may end up claiming far too much.</p>

    <p>When the descriptor is ``la'', indicating that what follows
    is a selbri used for naming, then the positioning of relative
    clauses has a different significance. A relative clause inside
    the ``ku'', whether before or after the selbri, is reckoned
    part of the name; a relative clause outside the ``ku'' is not.
    Therefore,</p>

    <p></p>
<pre>
<a id="e6d10" name="e6d10">6.10)</a>    mi viska la nanmu poi terpa le ke'a xirma [ku]
    I see that-named( ``man which fears the of-IT horse'' ).
    I see Man Afraid Of His Horse.
</pre>
    says that the speaker sees a person with a particular name, who
    does not necessarily fear any horses, whereas 
<pre>
<a id="e6d11" name="e6d11">6.11)</a>    mi viska la nanmu ku poi terpa le ke'a xirma.
    I see that-named( ``Man'' ) which fears the of-IT horse.
    I see the person named ``Man'' who is afraid of his horse.
</pre>
    refers to one (or more) of those named ``Man'', namely the
    one(s) who are afraid of their horses. 

    <p>Finally, so-called indefinite sumti like ``re karce'', which
    means almost the same as ``re lo karce'' (which in turn means
    the same as ``re lo ro karce''), can have relative clauses
    attached; these are taken to be of the outside-the-``ku''
    variety. Here is an example:</p>
<pre>
<a id="e6d12" name="e6d12">6.12)</a>    mi ponse re karce [ku] poi xekri
    I possess two cars which-are black.
</pre>
    The restrictive relative clause only affects the two cars being
    affected by the main bridi, not all cars that exist. It is
    ungrammatical to try to place a relative clause within an
    indefinite sumti (that is, before an explicitly expressed
    terminating ``ku''.) Use an explicit ``lo'' instead. 

    <h3><a id="s7" name="s7">7. Possessive sumti</h3>

    <p>In <a href="#e2d4">Examples 2.4</a> through <a
    href="#e2d6">2.6</a>, the sumti ``le mi karce'' appears,
    glossed as ``my car''. Although it might not seem so, this
    sumti actually contains a relative phrase. When a sumti appears
    between a descriptor and its description selbri, it is actually
    a ``pe'' relative phrase. So</p>

    <p></p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  le mi karce cu xunre
    my car is-red.
</pre>
    and 
<pre>
<a id="e7d2" name="e7d2">7.2)</a>  le pe mi karce cu xunre
    the (associated-with me) car is-red.
</pre>
    mean exactly the same thing. Furthermore, since there are no
    special considerations of quantifiers here, 
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  le karce pe mi cu xunre
    The car associated-with me is-red
</pre>
    means the same thing as well. A sumti like the one in <a
    href="#e7d1">Example 7.1</a> is called a ``possessive sumti''.
    Of course, it does not really indicate possession in the sense
    of ownership, but like ``pe'' relative phrases, indicates only
    weak association; you can say ``le mi karce'' even if you've
    only borrowed it for the night. (In English, ``my car'' usually
    means ``le karce po mi'', but we do not have the same sense of
    possession in ``my seat on the bus''; Lojban simply makes the
    weaker sense the standard one.) The inner sumti, ``mi'' in <a
    href="#e7d1">Example 7.1</a>, is correspondingly called the
    ``possessor sumti''. 

    <p>Historically, possessive sumti existed before any other kind
    of relative phrase or clause, and were retained when the
    machinery of relative phrases and clauses as detailed in this
    chapter so far was slowly built up. When preposed relative
    clauses of the <a href="#e7d2">Example 7.2</a> type were
    devised, possessive sumti were most easily viewed as a special
    case of them.</p>

    <p>Although any sumti, however complex, can appear in a
    full-fledged relative phrase, only simple sumti can appear as
    possessor sumti, without a ``pe''. Roughly speaking, the legal
    possessor sumti are: pro-sumti, quotations, names and
    descriptions, and numbers. In addition, the possessor sumti may
    not be preceded by a quantifier, as such a form would be
    interpreted as the unusual ``descriptor + quantifier + sumti''
    type of description. All these sumti forms are explained in
    full in <a href="chapter6.html">Chapter 6</a>.</p>

    <p>Here is an example of a description used in a possessive
    sumti:</p>
<pre>
<a id="e7d4" name="e7d4">7.4)</a>  le le nanmu ku karce cu blanu
    The (associated-with-the man) car is blue.
    The man's car is blue.


Note the explicit ``ku'' at the end of the possessor sumti,
which prevents the selbri of the possessor sumti from merging
with the selbri of the main description sumti.  Because of the
need for this ``ku'', the most common kind of possessor sumti
are pro-sumti, especially personal pro-sumti, which require no
elidable terminator.  Descriptions are more likely to be attached
with relative phrases.
</pre>

    <p>And here is a number used as a possessor sumti:</p>

    <p></p>
<pre>
<a id="e7d5" name="e7d5">7.5)</a>  le li mu jdice se bende
    The of-the-number-five judging team-member
    Juror number 5
</pre>
    which is not quite the same as ``the fifth juror''; it simply
    indicates a weak association between the particular juror and
    the number 5. 

    <p>A possessive sumti may also have regular relative clauses
    attached to it. This would need no comment if it were not for
    the following special rule: a relative clause immediately
    following the possessor sumti is understood to affect the
    possessor sumti, not the possessive. For example:</p>
<pre>
<a id="e7d6" name="e7d6">7.6)</a>  le mi noi sipna vau karce
        cu na klama
    The of-me incidentally-which( is-sleeping ) car
        isn't going.
</pre>
    means that my car isn't going; the incidental claim of ``noi
    sipna'' applies to me, not my car, however. If I wanted to say
    that the car is sleeping (whatever that might mean) I would
    need: 
<pre>
<a id="e7d7" name="e7d7">7.7)</a>  le mi karce poi sipna cu na klama
    The of-me car which sleeps isn't going.
</pre>
    Note that <a href="#e7d6">Example 7.6</a> uses ``vau'' rather
    than ``ku'o'' at the end of the relative clause: this
    terminator ends every simple bridi and is almost always
    elidable; in this case, though, it is a syllable shorter than
    the equally valid alternative, ``ku'o''. 

    <h3><a id="s8" name="s8">8. Relative clauses and complex sumti: ``vu'o''</h3>
<pre>
   vu'o    VUhO        relative clause attacher
</pre>

    <p>Normally, relative clauses attach only to simple sumti or
    parts of sumti: pro-sumti, names and descriptions, pure
    numbers, and quotations. An example of a relative clause
    attached to a pure number is:</p>

    <p></p>
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  li pai noi na'e
        frinu namcu
    The-number pi, incidentally-which
        is-a-non- fraction number
    The irrational number pi
</pre>
    And here is an incidental relative clause attached to a
    quotation: 
<pre>
<a id="e8d2" name="e8d2">8.2)</a>  lu mi klama le zarci li'u
        noi mi cusku ke'a cu jufra
    [quote] I go to-the market [unquote]
        incidentally-which( I express IT) is-a-sentence.
    ``I'm going to the market'', which I'd said, is a sentence.
</pre>
    which may serve to identify the author of the quotation or some
    other relevant, but subsidiary, fact about it. All such
    relative clauses appear only after the simple sumti, never
    before it. 

    <p>In addition, sumti with attached sumti qualifiers of selma'o
    LAhE or NAhE+BO (which are explained in detail in <a
    href="chapter6.html">Chapter 6</a>) can have a relative clause
    appearing after the qualifier and before the qualified sumti,
    as in:</p>

    <p></p>
<pre>
<a id="e8d3" name="e8d3">8.3)</a>  la'e poi tolcitno vau
        lu le xunre cmaxirma li'u
        cu zvati le vu kumfa
    A-referent-of (which is-old)
        [quote] The Red Small-horse [unquote]
        is-at the [far distance] room.
    An old ``The Red Pony'' is in the far room.
</pre>
    <a href="#e8d3">Example 8.3</a> is a bit complex, and may need
    some picking apart. The quotation ``lu le xunre cmaxirma li'u''
    means the string of words ``The Red Pony''. If the ``la'e'' at
    the beginning of the sentence were omitted, <a
    href="#e8d3">Example 8.3</a> would claim that a certain string
    of words is in a room distant from the speaker. But obviously a
    string of words can't be in a room! The effect of the ``la'e''
    is to modify the sumti so that it refers not to the words
    themselves, but to the referent of those words, a novel by John
    Steinbeck (presumably in Lojban translation). The particular
    copy of ``The Red Pony'' is identified by the restrictive
    relative clause. <a href="#e8d3">Example 8.3</a> means exactly
    the same as: 
<pre>
<a id="e8d4" name="e8d4">8.4)</a>  la'e lu le xunre cmaxirma li'u lu'u
        poi to'ercitno cu zvati le vu kumfa
    A-referent-of ([quote] The Red Small-horse [unquote])
        which is-old is-at the [far distance] room.
</pre>
    and the two sentences can be considered stylistic variants.
    Note the required ``lu'u'' terminator, which prevents the
    relative clause from attaching to the quotation itself: we do
    not wish to refer to an old quotation! 

    <p>Sometimes, however, it is important to make a relative
    clause apply to the whole of a more complex sumti, one which
    involves logical or non-logical connection (explained in <a
    href="chapter14.html">Chapter 14</a>). For example,</p>
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  la frank. .e la djordj. noi nanmu
        cu klama le zdani
    Frank and George incidentally-who is-a-man
        go to-the house.
    Frank and George, who is a man, go to the house.
</pre>

    <p>The incidental claim in <a href="#e8d5">Example 8.5</a> is
    not that Frank and George are men, but only that George is a
    man, because the incidental relative clause attaches only to
    ``la djordj'', the immediately preceding simple sumti.</p>

    <p>To make a relative clause attach to both parts of the
    logically connected sumti in <a href="#e8d5">Example 8.5</a>, a
    new cmavo is needed, ``vu'o'' (of selma'o VUhO). It is placed
    between the sumti and the relative clause, and extends the
    sphere of influence of that relative clause to the entire
    preceding sumti, including however many logical or non-logical
    connectives there may be.</p>
<pre>
<a id="e8d6" name="e8d6">8.6)</a>  la frank. .e la djordj. vu'o noi nanmu
        cu klama le zdani
    Frank and George incidentally-who are-men
        go to-the house.
    Frank and George, who are men, go to the house.
</pre>

    <p>The presence of ``vu'o'' here means that the relative clause
    ``noi nanmu'' extends to the entire logically connected sumti
    ``la frank. .e la djordj.''; in other words, both Frank and
    George are claimed to be men, as the colloquial translation
    shows.</p>

    <p>English is able to resolve the distinction correctly in the
    case of <a href="#e8d5">Example 8.5</a> and <a
    href="#e8d6">Example 8.6</a> by making use of number: ``who
    is'' rather than ``who are''. Lojban doesn't distinguish
    between singular and plural verbs: ``nanmu'' can mean ``is a
    man'' or ``are men'', so another means is required.
    Furthermore, Lojban's mechanism works correctly in general: if
    ``nanmu'' (meaning ``is-a-man'') were replaced with ``pu
    bajra'' (``ran''), English would have to make the distinction
    some other way:</p>
<pre>
<a id="e8d7" name="e8d7">8.7)</a>  la frank. .e la djordj. noi pu bajra
        cu klama le zdani
    Frank and (George who [past] runs)
        go to-the house.
    Frank and George, who ran, go to the house.

<a id="e8d8" name="e8d8">8.8)</a>   la frank. .e la djordj. vu'o noi pu bajra
        cu klama le zdani
    (Frank and George) who [past] runs
        go to-the house.
    Frank and George, who ran, go to the house.
</pre>

    <p>In spoken English, tone of voice would serve; in written
    English, one or both sentences would need rewriting.</p>

    <h3><a id="s9" name="s9">9. Relative clauses in vocative phrases</h3>

    <p>Vocative phrases are explained in more detail in <a
    href="chapter6.html">Chapter 6</a>. Briefly, they are a method of
    indicating who a sentence or discourse is addressed to: of
    identifying the intended listener. They take three general
    forms, all beginning with cmavo from selma'o COI or DOI (called
    ``vocative words''; there can be one or many), followed by
    either a name, a selbri, or a sumti. Here are three
    examples:</p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  coi. frank.
    Hello, Frank.

<a id="e9d2" name="e9d2">9.2)</a>   co'o xirma
    Goodbye, horse.

<a id="e9d3" name="e9d3">9.3)</a>   fi'i la frank. .e la djordj.
    Welcome, Frank and George!
</pre>

    <p>Note that <a href="#e9d2">Example 9.2</a> says farewell to
    something which doesn't really have to be a horse, something
    that the speaker simply thinks of as being a horse, or even
    might be something (a person, for example) who is named
    ``Horse''. In a sense, <a href="#e9d2">Example 9.2</a> is
    ambiguous between ``co'o le xirma'' and ``co'o la xirma'', a
    relatively safe semantic ambiguity, since names are ambiguous
    in general: saying ``George'' doesn't distinguish between the
    possible Georges.</p>

    <p>Similarly, <a href="#e9d1">Example 9.1</a> can be thought of
    as an abbreviation of:</p>
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  coi la frank.
    Hello, the-one-named ``Frank''.
</pre>

    <p>Syntactically, vocative phrases are a kind of free modifier,
    and can appear in many places in Lojban text, generally at the
    beginning or end of some complete construct; or, as in <a
    href="#e9d1">Examples 9.1</a> to <a href="#e9d3">9.3</a>, as
    sentences by themselves.</p>

    <p>As can be seen, the form of vocative phrases is similar to
    that of sumti, and as you might expect, vocative phrases allow
    relative clauses in various places. In vocative phrases which
    are simple names (after the vocative words), any relative
    clauses must come just after the names:</p>
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  coi. frank. poi xunre se bende
    Hello, Frank who is-a-red team-member
    Hello, Frank from the Red Team!
</pre>

    <p>The restrictive relative clause in <a href="#e9d5">Example
    9.5</a> suggests that there is some other Frank (perhaps on the
    Green Team) from whom this Frank, the one the speaker is
    greeting, must be distinguished.</p>

    <p>A vocative phrase containing a selbri can have relative
    clauses either before or after the selbri; both forms have the
    same meaning. Here are some examples:</p>
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  co'o poi mi zvati ke'a ku'o xirma
    Goodbye, such-that( I am-at IT ) horse
    Goodbye, horse where I am!

<a id="e9d7" name="e9d7">9.7)</a>   co'o xirma poi mi zvati
    Goodbye, horse such-that( I am-at-it).
</pre>
    <a href="#e9d6">Example 9.6</a> and <a href="#e9d7">Example
    9.7</a> mean the same thing. In fact, relative clauses can
    appear in both places. 

    <h3><a id="s10" name="s10">10. Relative clauses within relative clauses</h3>

    <p>For the most part, these are straightforward and
    uncomplicated: a sumti that is part of a relative clause bridi
    may itself be modified by a relative clause:</p>
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    le prenu poi zvati le kumfa poi blanu cu masno
    The person who is-in the room which is-blue is-slow.
</pre>
    However, an ambiguity can exist if ``ke'a'' is used in a
    relative clause within a relative clause: does it refer to the
    outermost sumti, or to the sumti within the outer relative
    clause to which the inner relative clause is attached? The
    latter. To refer to the former, use a subscript on ``ke'a'': 

    <p></p>
<pre>
<a id="e10d2" name="e10d2">10.2)</a>    le prenu poi zvati le kumfa
        poi ke'axire zbasu ke'a cu masno
    The person who is-in the room
        which IT-sub-2 built IT is-slow.
    The person who is in the room which he built is slow.
</pre>
    Here, the meaning of ``IT-sub-2'' is that sumti attached to the
    second relative clause, counting from the innermost, is used.
    Therefore, ``ke'axipa'' (IT-sub-1) means the same as plain
    ``ke'a''. 

    <p>Alternatively, you can use a prenex (explained in full in <a
    href="chapter16.html">Chapter 16</a>), which is syntactically a
    series of sumti followed by the special cmavo ``zo'u'',
    prefixed to the relative clause bridi:</p>
<pre>
<a id="e10d3" name="e10d3">10.3)</a>    le prenu poi ke'a goi ko'a zo'u ko'a zvati le kumfa
        poi ke'a goi ko'e zo'u ko'a zbasu ke'a cu masno
    The man who (IT = it1 : it1 is-in the room
        which (IT = it2 : it1 built it2) is-slow.
</pre>
    <a href="#e10d3">Example 10.3</a> is more verbose than <a
    href="#e10d2">Example 10.2</a>, but may be clearer, since it
    explicitly spells out the two ``ke'a'' cmavo, each on its own
    level, and assigns them to the assignable cmavo ``ko'a'' and
    ``ko'e'' (explained in Chapter ). 

    <h3><a id="s11" name="s11">11. Index of relative clause cmavo</h3>

    <p>Relative clause introducers (selma'o NOI):</p>
<pre>
   noi     incidental clauses
    poi     restrictive clauses
    voi     restrictive clauses (non-veridical)
</pre>

    <p>Relative phrase introducers (selma'o GOI):</p>
<pre>
   goi     pro-sumti assignment
    pe      restrictive association
    ne      incidental association
    po      extrinsic (alienable) possession
    po'e        intrinsic (inalienable) possession
    po'u        restrictive identification
    no'u        incidental identification
</pre>

    <p>Relativizing pro-sumti (selma'o KOhA):</p>
<pre>
   ke'a        pro-sumti for relativized sumti
</pre>

    <p>Relative clause joiner (selma'o ZIhE)</p>
<pre>
   zi'e        joins relative clauses applying to
                a single sumti
</pre>

    <p>Relative clause associator (selma'o VUhO)</p>
<pre>
   vu'o        causes relative clauses to apply to
                all of a complex sumti
</pre>

    <p>Elidable terminators (each its own selma'o)</p>
<pre>
   ku'o        relative clause elidable terminator
    ge'u        relative phrase elidable terminator
</pre>

    <hr />
    
    <p>Derni&egrave;res modifications&nbsp;: Mon Jun 27 23:11:06 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
