
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//FR" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 3</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <p class="c1"><img src="chapter3.gif" alt="[Cartoon]"
      width="405" height="405" /></p>

      <h2>Chapter 3<br />
      The Hills Are Alive With The Sounds Of Lojban</h2>

      <!-- 
      <h6>$Revision: 4.2 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. Orthography</h3>

    <p>Lojban is designed so that any properly spoken Lojban
    utterance can be uniquely transcribed in writing, and any
    properly written Lojban can be spoken so as to be uniquely
    reproduced by another person. As a consequence, the standard
    Lojban orthography must assign to each distinct sound, or
    phoneme, a unique letter or symbol. Each letter or symbol has
    only one sound or, more accurately, a limited range of sounds
    that are permitted pronunciations for that phoneme. Some
    symbols indicate stress (speech emphasis) and pause, which are
    also essential to Lojban word recognition. In addition,
    everything that is represented in other languages by
    punctuation (when written) or by tone of voice (when spoken) is
    represented in Lojban by words. These two properties together
    are known technically as ``audio-visual isomorphism''.</p>

    <p>Lojban uses a variant of the Latin (Roman) alphabet,
    consisting of the following letters and symbols:</p>

    <dl>
      <dt></dt>

      <dd>' , . a b c d e f g i j k l m n o p r s t u v x y z</dd>
    </dl>
    omitting the letters ``h'', ``q'', and ``w''. 

    <p>The alphabetic order given above is that of the ASCII coded
    character set, widely used in computers. By making Lojban
    alphabetical order the same as ASCII, computerized sorting and
    searching of Lojban text is facilitated.</p>

    <p>Capital letters are used only to represent non-standard
    stress, which can appear only in the representation of
    Lojbanized names. Thus the English name ``Josephine'', as
    normally pronounced, is Lojbanized as ``DJOsefin.'', pronounced
    <span class="c3">[&Egrave;dZo sE fin/]</span>. (See <a
    href="#s2">Section 2</a> for an explanation of the symbols
    within square brackets.) Technically, it is sufficient to
    capitalize the vowel letter, in this case ``O'', but it is
    easier on the reader to capitalize the whole syllable.</p>

    <p>Without the capitalization, the ordinary rules of Lojban
    stress would cause the ``se'' syllable to be stressed.
    Lojbanized names are meant to represent the pronunciation of
    names from other languages with as little distortion as may be;
    as such, they are exempt from many of the regular rules of
    Lojban phonology, as will appear in the rest of this
    chapter.</p>

    <h3><a id="s2" name="s2">2. Basic Phonetics</h3>

    <p>Lojban pronunciations are defined using the International
    Phonetic Alphabet, or IPA, a standard method of transcribing
    pronunciations. By convention, IPA transcriptions are always
    within square brackets: for example, the word ``cat'' is
    pronounced (in General American pronunciation) <span
    class="c3">[kQt]</span>. <a href="#s10">Section 10</a> contains
    a brief explanation of the IPA characters used in this chapter,
    with their nearest analogues in English, and will be especially
    useful to those not familiar with the technical terms used in
    describing speech sounds.</p>

    <p>The standard pronunciations and permitted variants of the
    Lojban letters are listed in the table below. The descriptions
    have deliberately been made a bit ambiguous to cover variations
    in pronunciation by speakers of different native languages and
    dialects. In all cases except ``r'' the first IPA symbol shown
    represents the preferred pronunciation; for ``r'', all of the
    variations (and any other rhotic sound) are equally
    acceptable.</p>

    <p></p>
<pre>
   Letter  IPA     Description

    '   <span
class="c3">[h]</span>        a unvoiced glottal spirant
    ,   ---     the syllable separator
    .   <span
class="c3">[/]</span>        a glottal stop or a pause
    a   <span class="c3">[a]</span>, <span
class="c3">[A]</span>  an open vowel
    b   <span class="c3">[b]</span>        a voiced bilabial stop
    c   <span class="c3">[S]</span>, <span
class="c3">[&sect;]</span>  an unvoiced coronal sibilant
    d   <span
class="c3">[d]</span>        a voiced dental/alveolar stop
    e   <span class="c3">[E]</span>, <span
class="c3">[e]</span>  a front mid vowel
    f   <span class="c3">[f]</span>, <span
class="c3">[&cedil;]</span>  an unvoiced labial fricative
    g   <span class="c3">[g]</span>        a voiced velar stop
    i   <span class="c3">[i]</span>        a front close vowel
    j   <span class="c3">[Z]</span>,<span
class="c3">[&frac12;]</span>       a voiced coronal sibilant
    k   <span class="c3">[k]</span>        an unvoiced velar stop
    l   <span class="c3">[l]</span>, <span
class="c3">[l`]</span> a voiced lateral approximant
                    (may be syllabic)
    m   <span class="c3">[m]</span>, <span
class="c3">[m`]</span> a voiced bilabial nasal
                    (may be syllabic)
    n   <span class="c3">[n]</span>, <span
class="c3">[n`]</span>,    a voiced dental or velar nasal
          <span class="c3">[N]</span>, <span
class="c3">[N`]</span>       (may be syllabic)
    o   <span class="c3">[o]</span>, <span
class="c3">[]</span>   a back mid vowel
    p   <span
class="c3">[p]</span>        an unvoiced bilabial stop
    r   <span class="c3">[r]</span>, <span
class="c3">[&uml;]</span>, <span class="c3">[R]</span>, <span
class="c3">[{]</span>, a rhotic sound
          <span class="c3">[r`]</span>, <span
class="c3">[&uml;`]</span>, <span class="c3">[R`]</span>, <span
class="c3">[{`]</span>
    s   <span
class="c3">[s]</span>        an unvoiced alveolar sibilant
    t   <span
class="c3">[t]</span>        an unvoiced dental/alveolar stop
    u   <span class="c3">[u]</span>        a back close vowel
    v   <span class="c3">[v]</span>, <span
class="c3">[B]</span>  a voiced labial fricative
    x   <span
class="c3">[x]</span>        an unvoiced velar fricative
    y   <span
class="c3">[&laquo;]</span>        a central mid vowel
    z   <span
class="c3">[z]</span>        a voiced alveolar sibilant
</pre>
    The Lojban sounds must be clearly pronounced so that they are
    not mistaken for each other. Voicing and placement of the
    tongue are the key factors in correct pronunciation, but other
    subtle differences will develop between consonants in a
    Lojban-speaking community. At this point these are the only
    mandatory rules on the range of sounds. 

    <p>Note in particular that Lojban vowels can be pronounced with
    either rounded or unrounded lips; typically ``o'' and ``u'' are
    rounded and the others are not, as in English, but this is not
    a requirement; some people round ``y'' as well. Lojban
    consonants can be aspirated or unaspirated. Palatalizing of
    consonants, as found in Russian and other languages, is not
    generally acceptable in pronunciation, though a following ``i''
    may cause it.</p>

    <p>The sounds represented by the letters ``c'', ``g'', ``j'',
    ``s'', and ``x'' require special attention for speakers of
    English, either because they are ambiguous in the orthography
    of English (``c'', ``g'', ``s''), or because they are
    strikingly different in Lojban (``c'', ``j'', ``x''). The
    English ``c'' represents three different sounds, <span
    class="c3">[k]</span> in ``cat'' and <span
    class="c3">[s]</span> in ``cent'', as well as the <span
    class="c3">[S]</span> of ``ocean''. Similarly, English ``g''
    can represent <span class="c3">[g]</span> as in ``go'', <span
    class="c3">[dZ]</span> as in ``gentle'', and <span
    class="c3">[Z]</span> as in ``garage'' (in some
    pronunciations). English ``s'' can be either <span
    class="c3">[s]</span> as in ``cats'', <span
    class="c3">[z]</span> as in ``cards'', <span
    class="c3">[S]</span> as in ``tension'', or <span
    class="c3">[Z]</span> as in ``measure''. The sound of Lojban
    ``x'' doesn't appear in most English dialects at all.</p>

    <p>There are two common English sounds that are found in Lojban
    but are not not Lojban consonants: the ``ch'' of ``church'' and
    the ``j'' of ``judge''. In Lojban, these are considered two
    consonant sounds spoken together without an intervening vowel
    sound, and so are represented in Lojban by the two separate
    consonants: ``tc'' (IPA <span class="c3">[tS]</span>) and
    ``dj'' (IPA <span class="c3">[dZ]</span>). In general, whether
    a complex sound is considered one sound or two depends on the
    language: Russian views ``ts'' as a single sound, whereas
    English, French, and Lojban consider it to be a consonant
    cluster.</p>

    <h3><a id="s3" name="s3">3. The Special Lojban Characters</h3>

    <p>The apostrophe, period, and comma need special attention.
    They are all used as indicators of a division between
    syllables, but each has a different pronunciation, and each is
    used for different reasons:</p>

    <p>The apostrophe represents a phoneme similar to a short,
    breathy English ``h'', (IPA <span class="c3">[h]</span>). The
    letter ``h'' is not used to represent this sound for two
    reasons: primarily in order to simplify explanations of the
    morphology, but also because the sound is very common, and the
    apostrophe is a visually lightweight representation of it. The
    apostrophe sound is a consonant in nature, but is not treated
    as either a consonant or a vowel for purposes of Lojban
    morphology (word-formation), which is explained in <a
    href="chapter4.html">Chapter 4</a>. In addition, the apostrophe
    visually parallels the comma and the period, which are also
    used (in different ways) to separate syllables.</p>

    <p>The apostrophe is included in Lojban only to enable a smooth
    separation between vowels, while joining the vowels within a
    single word. In fact, one way to think of the apostrophe is as
    representing a unvoiced vowel glide.</p>

    <p>As a permitted variant, any unvoiced fricative other than
    those already used in Lojban may be used to render the
    apostrophe: IPA <span class="c3">[T]</span> is one possibility.
    The convenience of the listener should be regarded as paramount
    in deciding to use a substitute for <span
    class="c3">[h]</span>.</p>

    <p>The period represents a mandatory pause, with no specified
    length; a glottal stop (IPA <span class="c3">[/]</span>) is
    considered a pause of shortest length. A pause (or glottal
    stop) may appear between any two words, and in certain cases --
    explained in detail in <a href="chapter4.html">Chapter 4</a> ---
    must occur. In particular, a word beginning with a vowel is
    always preceded by a pause, and a word ending in a consonant is
    always followed by a pause.</p>

    <p>Technically, the period is an optional reminder to the
    reader of a mandatory pause that is dictated by the rules of
    the language; because these rules are unambiguous, a missing
    period can be inferred from otherwise correct text. Periods are
    included only as an aid to the reader.</p>

    <p>A period also may be found apparently embedded in a word.
    When this occurs, such a written string is not one word but
    two, written together to indicate that the writer intends a
    unitary meaning for the compound. It is not really necessary to
    use a space between words if a period appears.</p>

    <p>The comma is used to indicate a syllable break within a
    word, generally one that is not obvious to the reader. Such a
    comma is written to separate syllables, but indicates that
    there must be no pause between them, in contrast to the period.
    Between two vowels, a comma indicates that some type of glide
    may be necessary to avoid a pause that would split the two
    syllables into separate words. It is always legal to use the
    apostrophe (IPA <span class="c3">[h]</span>) sound in
    pronouncing a comma. However, a comma cannot be pronounced as a
    pause or glottal stop between the two letters separated by the
    comma, because that pronunciation would split the word into two
    words.</p>

    <p>Otherwise, a comma is usually only used to clarify the
    presence of syllabic ``l'', ``m'', ``n'', or ``r'' (discussed
    later). Commas are never required: no two Lojban words differ
    solely because of the presence or placement of a comma.</p>

    <p>Here is a somewhat artificial example of the difference in
    pronunciation between periods, commas and apostrophes. In the
    English song about Old MacDonald's Farm, the vowel string which
    is pronounced ``ee-i-ee-i-o'' in English could be Lojbanized
    with periods as:</p>

    <p></p>
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  .i.ai.i.ai.o
    <span class="c3">[/i /aj /i /aj /o]</span>
    Ee! Eye! Ee! Eye! Oh!
</pre>

    <p>However, this would sound clipped, staccato, and unmusical
    compared to the English. Furthermore, although <a
    href="#e3d1">Example 3.1</a> is a string of meaningful Lojban
    words, as a sentence it makes very little sense. (Note the use
    of periods embedded within the written word.)</p>

    <p>If commas were used instead of periods, we could represent
    the English string as a Lojbanized name, ending in a
    consonant:</p>

    <p></p>
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  .i,ai,i,ai,on.
    <span class="c3">[/i jaj ji jaj jon/]</span>
</pre>

    <p>The commas represent new syllable breaks, but prohibit the
    use of pauses or glottal stop. The pronunciation shown is just
    one possibility, but closely parallels the intended English
    pronunciation.</p>

    <p>However, the use of commas in this way is risky to
    unambiguous interpretation, since the glides might be heard by
    some listeners as diphthongs, producing something like</p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  .i,iai,ii,iai,ion.
</pre>
    which is technically a different Lojban name. Since the intent
    with Lojbanized names is to allow them to be pronounced more
    like their native counterparts, the comma is allowed to
    represent vowel glides or some non-Lojbanic sound. Such an
    exception affects only spelling accuracy and the ability of a
    reader to replicate the desired pronunciation exactly; it will
    not affect the recognition of word boundaries. 

    <p>Still, it is better if Lojbanized names are always distinct.
    Therefore, the apostrophe is preferred in regular Lojbanized
    names that are not attempting to simulate a non-Lojban
    pronunciation perfectly. (Perfection, in any event, is not
    really achievable, because some sounds simply lack reasonable
    Lojbanic counterparts.)</p>

    <p>If apostrophes were used instead of commas in <a
    href="#e3d2">Example 3.2</a>, it would appear as:</p>

    <p></p>
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  .i'ai'i'ai'on.
    <span class="c3">[/i hai hi hai hon/]</span>
</pre>
    which preserves the rhythm and length, if not the exact sounds,
    of the original English. 

    <h3><a id="s4" name="s4">4. Diphthongs and Syllabic Consonants</h3>

    <p>There exist 16 diphthongs in the Lojban language. A
    diphthong is a vowel sound that consists of two elements, a
    short vowel sound and a glide, either a labial (IPA <span
    class="c3">[w]</span>) or palatal (IPA <span
    class="c3">[j]</span>) glide, that either precedes (an
    on-glide) or follows (an off-glide) the main vowel. Diphthongs
    always constitute a single syllable.</p>

    <p>For Lojban purposes, a vowel sound is a relatively long
    speech-sound that forms the nucleus of a syllable. Consonant
    sounds are relatively brief and normally require an
    accompanying vowel sound in order to be audible. Consonants may
    occur at the beginning or end of a syllable, around the vowel,
    and there may be several consonants in a cluster in either
    position. Each separate vowel sound constitutes a distinct
    syllable; consonant sounds do not affect the determination of
    syllables.</p>

    <p>The six Lojban vowels are ``a'', ``e'', ``i'', ``o'', ``u'',
    and ``y''. The first five vowels appear freely in all kinds of
    Lojban words. The vowel ``y'' has a limited distribution: it
    appears only in Lojbanized names, in the Lojban names of the
    letters of the alphabet, as a glue vowel in compound words, and
    standing alone as a space-filler word (like English ``uh'' or
    ``er'').</p>

    <p>The Lojban diphthongs are shown in the table below. (Variant
    pronunciations have been omitted, but are much as one would
    expect based on the variant pronunciations of the separate
    vowel letters: ``ai'' may be pronounced <span
    class="c3">[Aj]</span>, for example.)</p>

    <p></p>
<pre>
   Letters IPA Description

    ai  <span class="c3">[aj]</span>   an open vowel
                with palatal off-glide
    ei  <span class="c3">[Ej]</span>   a front mid vowel
                with palatal off-glide
    oi  <span class="c3">[oj]</span>   a back mid vowel
                with palatal off-glide
    au  <span class="c3">[aw]</span>   an open vowel
                with labial off-glide

    ia  <span class="c3">[ja]</span>   an open vowel
                with palatal on-glide
    ie  <span class="c3">[jE]</span>   a front mid vowel
                with palatal on-glide
    ii  <span class="c3">[ji]</span>   a front close vowel
                with palatal on-glide
    io  <span class="c3">[jo]</span>   a back mid vowel
                with palatal on-glide
    iu  <span class="c3">[ju]</span>   a back close vowel
                with palatal on-glide

    ua  <span class="c3">[wa]</span>   an open vowel
                with labial on-glide
    ue  <span class="c3">[wE]</span>   a front mid vowel
                with labial on-glide
    ui  <span class="c3">[wi]</span>   a front close vowel
                with labial on-glide
    uo  <span class="c3">[wo]</span>   a back mid vowel
                with labial on-glide
    uu  <span class="c3">[wu]</span>   a back close vowel
                with labial on-glide

    iy  <span class="c3">[j&laquo;]</span>   a central mid vowel
                with palatal on-glide
    uy  <span class="c3">[w&laquo;]</span>   a central mid vowel
                with labial on-glide
</pre>
    (Approximate English equivalents of most of these diphthongs
    exist: see <a href="#s11">Section 11</a> for examples.) 

    <p>The first four diphthongs above (``ai'', ``ei'', ``oi'', and
    ``au'', the ones with off-glides) are freely used in most types
    of Lojban words; the ten following ones are used only as
    stand-alone words and in Lojbanized names and borrowings; and
    the last two (``iy'' and ``uy'') are used only in Lojbanized
    names.</p>

    <p>The syllabic consonants of Lojban, <span
    class="c3">[l`]</span>, <span class="c3">[m`]</span>, <span
    class="c3">[n`]</span>, and <span class="c3">[r`]</span>, are
    variants of the non-syllabic <span class="c3">[l]</span>, <span
    class="c3">[m]</span>, <span class="c3">[n]</span>, and <span
    class="c3">[r]</span> respectively. They normally have only a
    limited distribution, appearing in Lojban names and borrowings,
    although in principle any ``l'', ``m'', ``n'', or ``r'' may be
    pronounced syllabically. If a syllabic consonant appears next
    to a ``l'', ``m'', ``n'', or ``r'' that is not syllabic, it may
    not be clear which is which:</p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  brlgan.
    <span class="c3">[br`l gan]</span>
    or <span class="c3">[brl` gan]</span>
</pre>
    is a hypothetical Lojbanized name with more than one valid
    pronunciation; however it is pronounced, it remains the same
    word. 

    <p>Syllabic consonants are treated as consonants rather than
    vowels from the standpoint of Lojban morphology. Thus
    Lojbanized names, which are generally required to end in a
    consonant, are allowed to end with a syllabic consonant. An
    example is ``rl.'', which is an approximation of the English
    name ``Earl'', and has two syllabic consonants.</p>

    <p>Syllables with syllabic consonants and no vowel are never
    stressed or counted when determining which syllables to stress
    (see <a href="#s9">Section 9</a>).</p>

    <h3><a id="s5" name="s5">5. Vowel Pairs</h3>

    <p>Lojban vowels also occur in pairs, where each vowel sound is
    in a separate syllable. These two vowel sounds are connected
    (and separated) by an apostrophe. Lojban vowel pairs should be
    pronounced continuously with the <span class="c3">[h]</span>
    sound between (and not by a glottal stop or pause, which would
    split the two vowels into separate words).</p>

    <p>All vowel combinations are permitted in two-syllable pairs
    with the apostrophe separating them; this includes those which
    constitute diphthongs when the apostrophe is not included.</p>

    <p>The Lojban vowel pairs are:</p>
<pre>
   a'a a'e a'i a'o a'u a'y
    e'a e'e e'i e'o e'u e'y
    i'a i'e i'i i'o i'u i'y
    o'a o'e o'i o'o o'u o'y
    u'a u'e u'i u'o u'u u'y
    y'a y'e y'i y'o y'u y'y
</pre>
    Vowel pairs involving ``y'' appear only in Lojbanized names.
    They could appear in cmavo (structure words), but only
    ``.y'y.'' is so used --- it is the Lojban name of the
    apostrophe letter (see <a href="chapter17.html">Chapter 17</a>). 

    <p>When more than two vowels occur together in Lojban, the
    normal pronunciation pairs vowels from the left into syllables,
    as in the Lojbanized name:</p>
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  meiin.
    mei,in.
</pre>
    <a href="#e5d1">Example 5.1</a> contains the diphthong ``ei''
    followed by the vowel ``i''. In order to indicate a different
    grouping, the comma must always be used, leading to: 
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  me,iin.
</pre>
    which contains the vowel ``e'' followed by the diphthong
    ``ii''. In rough English representation, <a
    href="#e5d1">Example 5.1</a> is ``May Een'', whereas <a
    href="#e5d2">Example 5.2</a> is ``Meh Yeen''. 

    <h3><a id="s6" name="s6">6. Consonant Clusters</h3>

    <p>A consonant sound is a relatively brief speech-sound that
    precedes or follows a vowel sound in a syllable; its presence
    either preceding or following does not add to the count of
    syllables, nor is a consonant required in either position for
    any syllable. Lojban has seventeen consonants: for the purposes
    of this section, the apostrophe is not counted as a
    consonant.</p>

    <p>An important distinction dividing Lojban consonants is that
    of voicing. The following table shows the unvoiced consonants
    and the corresponding voiced ones:</p>

    <p></p>
<pre>
   UNVOICED    VOICED

    p       b
    t       d
    k       g
    f       v
    c       j
    s       z
    x       -
</pre>

    <p>The consonant ``x'' has no voiced counterpart in Lojban. The
    remaining consonants, ``l'', ``m'', ``n'', and ``r'', are
    typically pronounced with voice, but can be pronounced
    unvoiced.</p>

    <p>Consonant sounds occur in languages as single consonants, or
    as doubled, or as clustered combinations. Single consonant
    sounds are isolated by word boundaries or by intervening vowel
    sounds from other consonant sounds. Doubled consonant sounds
    are either lengthened like <span class="c3">[s]</span> in
    English ``hiss'', or repeated like <span class="c3">[k]</span>
    in English ``backcourt''. Consonant clusters consist of two or
    more single or doubled consonant sounds in a group, each of
    which is different from its immediate neighbor. In Lojban,
    doubled consonants are excluded altogether, and clusters are
    limited to two or three members, except in Lojbanized
    names.</p>

    <p>Consonants can occur in three positions in words: initial
    (at the beginning), medial (in the middle), and final (at the
    end). In many languages, the sound of a consonant varies
    depending upon its position in the word. In Lojban, as much as
    possible, the sound of a consonant is unrelated to its
    position. In particular, the common American English trait of
    changing a ``t'' between vowels into a ``d'' or even a flap
    (IPA <span class="c3">[&uml;]</span>) is unacceptable in
    Lojban.</p>

    <p>Lojban imposes no restrictions on the appearance of single
    consonants in any valid consonant position; however, no
    consonant (including syllabic consonants) occurs final in a
    word except in Lojbanized names.</p>

    <p>Pairs of consonants can also appear freely, with the
    following restrictions:</p>

    <dl>
      <dt>1)</dt>

      <dd>It is forbidden for both consonants to be the same, as
      this would violate the rule against double consonants.</dd>
    </dl>

    <dl>
      <dt>2)</dt>

      <dd>It is forbidden for one consonant to be voiced and the
      other unvoiced. The consonants ``l'', ``m'', ``n'', and ``r''
      are exempt from this restriction. As a result, ``bf'' is
      forbidden, and so is ``sd'', but both ``fl'' and ``vl'', and
      both ``ls'' and ``lz'', are permitted.</dd>

      <dt>3)</dt>

      <dd>It is forbidden for both consonants to be drawn from the
      set ``c'', ``j'', ``s'', ``z''.</dd>

      <dt>4)</dt>

      <dd>The specific pairs ``cx'', ``kx'', ``xc'', ``xk'', and
      ``mz'' are forbidden.</dd>
    </dl>
    These rules apply to all kinds of words, even Lojbanized names.
    If a name would normally contain a forbidden consonant pair, a
    ``y'' can be inserted to break up the pair: 
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  djeimyz.
    <span class="c3">[dZEj m&laquo;z/]</span>
    James
</pre>

    <p>The regular English pronunciation of ``James'', which is
    <span class="c3">[dZEjmz]</span>, would Lojbanize as
    ``djeimz.'', which contains a forbidden consonant pair.</p>

    <h3><a id="s7" name="s7">7. Initial Consonant Pairs</h3>

    <p>The set of consonant pairs that may appear at the beginning
    of a word (excluding Lojbanized names) is far more restricted
    than the fairly large group of permissible consonant pairs
    described in <a href="#s6">Section 6</a>. Even so, it is more
    than English allows, although hopefully not more than
    English-speakers (and others) can learn to pronounce.</p>

    <p>There are just 48 such permissible initial consonant pairs,
    as follows:</p>

    <dl>
      <dt></dt>

      <dd>bl br cf ck cl cm cn cp cr ct dj dr dz fl fr gl gr jb jd
      jg jm jv kl kr ml mr pl pr sf sk sl sm sn sp sr st tc tr ts
      vl vr xl xr zb zd zg zm zv</dd>
    </dl>

    <p>Lest this list seem almost random, a pairing of voiced and
    unvoiced equivalent vowels will show significant patterns which
    may help in learning:</p>
<pre>
   pl pr           fl fr
    bl br           vl vr

    cp cf   ct ck cm cn cl cr
    jb jv   jd jg jm
    sp sf   st sk sm sn sl sr
    zb zv   zd zg zm

    tc tr   ts      kl kr
    dj dr   dz      gl gr

    ml mr           xl xr
</pre>
    Note that if both consonants of an initial pair are voiced, the
    unvoiced equivalent is also permissible, and the voiced pair
    can be pronounced simply by voicing the unvoiced pair. (The
    converse is not true: ``cn'' is a permissible initial pair, but
    ``jn'' is not.) 

    <p>Consonant triples can occur medially in Lojban words. They
    are subject to the following rules:</p>

    <p></p>

    <dl>
      <dt>1)</dt>

      <dd>The first two consonants must constitute a permissible
      consonant pair;</dd>

      <dt>2)</dt>

      <dd>The last two consonants must constitute a permissible
      initial consonant pair;</dd>

      <dt>3)</dt>

      <dd>The triples ``ndj'', ``ndz'', ``ntc'', and ``nts'' are
      forbidden.</dd>
    </dl>
    Lojbanized names can begin or end with any permissible
    consonant pair, not just the 48 initial consonant pairs listed
    above, and can have consonant triples in any location, as long
    as the pairs making up those triples are permissible. In
    addition, names can contain consonant clusters with more than
    three consonants, again requiring that each pair within the
    cluster is valid. 

    <h3><a id="s8" name="s8">8. Buffering Of Consonant Clusters</h3>

    <p>Many languages do not have consonant clusters at all, and
    even those languages that do have them often allow only a
    subset of the full Lojban set. As a result, the Lojban design
    allows the use of a buffer sound between consonant combinations
    which a speaker finds unpronounceable. This sound may be any
    non-Lojbanic vowel which is clearly separable by the listener
    from the Lojban vowels. Some possibilities are IPA <span
    class="c3">[I]</span>, <span class="c3">[&ouml;]</span>, <span
    class="c3">[U]</span>, or even <span class="c3">[Y]</span>, but
    there probably is no universally acceptable buffer sound. When
    using a consonant buffer, the sound should be made as short as
    possible. Two examples showing such buffering (we will use
    <span class="c3">[I]</span> in this chapter) are:</p>
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  vrusi
    <span class="c3">[&Egrave;vru si]</span>
    or <span class="c3">[vI &Egrave;ru si]</span>
</pre>
<pre>
<a id="e8d2" name="e8d2">8.2)</a>  .AMsterdam.
    <span class="c3">[/am ster dam/]</span>
    or <span class="c3">[&Egrave;/a mI sI tE rI da mI/]</span>
</pre>
    When a buffer vowel is used, it splits each buffered consonant
    into its own syllable. However, the buffering syllables are
    never stressed, and are not counted in determining stress. They
    are, in effect, not really syllables to a Lojban listener, and
    thus their impact is ignored. 

    <p>Here are more examples of unbuffered and buffered
    pronunciations:</p>
<pre>
<a id="e8d3" name="e8d3">8.3)</a>  klama
    <span class="c3">[&Egrave;kla ma]</span>
    <span class="c3">[kI &Egrave;la ma]</span>

<a id="e8d4" name="e8d4">8.4)</a>   xapcke
    <span class="c3">[&Egrave;xap ckE]</span>
    <span class="c3">[&Egrave;xa pI ckE]</span>
    <span class="c3">[&Egrave;xa pI cI kE]</span>
</pre>

    <p>In <a href="#e8d4">Example 8.4</a>, we see that buffering
    vowels can be used in just some, rather than all, of the
    possible places: the second pronunciation buffers the ``pc''
    consonant pair but not the ``ck''. The third pronunciation
    buffers both.</p>
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  ponyni'u
    <span class="c3">[po n&laquo; &Egrave;ni hu]</span>
</pre>
    <a href="#e8d5">Example 8.5</a> cannot contain any buffering
    vowel. It is important not to confuse the vowel ``y'', which is
    pronounced <span class="c3">[&laquo;]</span>, with the buffer,
    which has a variety of possible pronunciations and is never
    written. Consider the contrast between 
<pre>
<a id="e8d6" name="e8d6">8.6)</a>  bongynanba
    <span class="c3">[boN g&laquo; &Egrave;nan ba]</span>
</pre>
    an unlikely Lojban compound word meaning ``bone bread'' (note
    the use of <span class="c3">[N]</span> as a representative of
    ``n'' before ``g'') and 
<pre>
<a id="e8d7" name="e8d7">8.7)</a>  bongnanba
    <span class="c3">[boN &Egrave;gnan ba]</span>
</pre>
    a possible borrowing from another language (Lojban borrowings
    can only take a limited form). If <a href="#e8d7">Example
    8.7</a> were pronounced with buffering, as 
<pre>
<a id="e8d8" name="e8d8">8.8)</a>  <span
class="c3">[boN gI &Egrave;nan ba]</span>
</pre>
    it would be very similar to <a href="#e8d6">Example 8.6</a>.
    Only a clear distinction between ``y'' and any buffering vowel
    would keep the two words distinct. 

    <p>Since buffering is done for the benefit of the speaker in
    order to aid pronounceability, there is no guarantee that the
    listener will not mistake a buffer vowel for one of the six
    regular Lojban vowels. The buffer vowel should be as laxly
    pronounced as possible, as central as possible, and as short as
    possible. Furthermore, it is worthwhile for speakers who use
    buffers to pronounce their regular vowels a bit longer than
    usual, to avoid confusion with buffer vowels. The speakers of
    many languages will have trouble correctly hearing any of the
    suggested buffer vowels otherwise. By this guideline, <a
    href="#e8d8">Example 8.8</a> would be pronounced</p>
<pre>
<a id="e8d9" name="e8d9">8.9)</a>  <span
class="c3">[bo&ugrave;N gI &Egrave;na&ugrave;n ba&ugrave;]</span>
</pre>
    with lengthened vowels. 

    <h3><a id="s9" name="s9">9. Syllabication And Stress</h3>

    <p>A Lojban word has one syllable for each of its vowels,
    diphthongs, and syllabic consonants (referred to simply as
    ``vowels'' for the purposes of this section.) Syllabication
    rules determine which of the consonants separating two vowels
    belong to the preceding vowel and which to the following vowel.
    These rules are conventional only; the phonetic facts of the
    matter about how utterances are syllabified in any language are
    always very complex.</p>

    <p>A single consonant always belongs to the following vowel. A
    consonant pair is normally divided between the two vowels;
    however, if the pair constitute a valid initial consonant pair,
    they are normally both assigned to the following vowel. A
    consonant triple is divided between the first and second
    consonants. Apostrophes and commas, of course, also represent
    syllable breaks. Syllabic consonants usually appear alone in
    their syllables.</p>

    <p>It is permissible to vary from these rules in Lojbanized
    names. For example, there are no definitive rules for the
    syllabication of names with consonant clusters longer than
    three consonants. The comma is used to indicate variant
    syllabication or to explicitly mark normal syllabication.</p>

    <p>Here are some examples of Lojban syllabication:</p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  pujenaicajeba
    pu,je,nai,ca,je,ba
</pre>

    <p>This word has no consonant pairs and is therefore
    syllabified before each medial consonant.</p>
<pre>
<a id="e9d2" name="e9d2">9.2)</a>  ninmu
    nin,mu
</pre>

    <p>This word is split at a consonant pair.</p>
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  fitpri
    fit,pri
</pre>

    <p>This word is split at a consonant triple, between the first
    two consonants of the triple.</p>
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  sairgoi
    sair,goi
    sai,r,goi
</pre>

    <p>This word contains the consonant pair ``rg''; the ``r'' may
    be pronounced syllabically or not.</p>
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  klezba
    klez,ba
    kle,zba
</pre>

    <p>This word contains the permissible initial pair ``zb'', and
    so may be syllabicated either between ``z'' and ``b'' or before
    ``zb''.</p>

    <p>Stress is a relatively louder pronunciation of one syllable
    in a word or group of words. Since every syllable has a vowel
    sound (or diphthong or syllabic consonant) as its nucleus, and
    the stress is on the vowel sound itself, the terms ``stressed
    syllable'' and ``stressed vowel'' are largely interchangeable
    concepts.</p>

    <p>Most Lojban words are stressed on the next-to-the-last, or
    penultimate, syllable. In counting syllables, however,
    syllables whose vowel is ``y'' or which contain a syllabic
    consonant (``l'', ``m'', ``n'', or ``r'') are never counted.
    (The Lojban term for penultimate stress is ``da'amoi
    terbasna''.) Similarly, syllables created solely by adding a
    buffer vowel, such as <span class="c3">[I]</span>, are not
    counted.</p>

    <p>There are actually three levels of stress --- primary,
    secondary, and weak. Weak stress is the lowest level, so it
    really means no stress at all. Weak stress is required for
    syllables containing ``y'', a syllabic consonant, or a buffer
    vowel.</p>

    <p>Primary stress is required on the penultimate syllable of
    Lojban content words (called ``brivla''). Lojbanized names may
    be stressed on any syllable, but if a syllable other than the
    penultimate is stressed, the syllable (or at least its vowel)
    must be capitalized in writing. Lojban structural words (called
    ``cmavo'') may be stressed on any syllable or none at all.
    However, primary stress may not be used in a syllable just
    preceding a brivla, unless a pause divides them; otherwise, the
    two words may run together.</p>

    <p>Secondary stress is the optional and non-distinctive
    emphasis used for other syllables besides those required to
    have either weak or primary stress. There are few rules
    governing secondary stress, which typically will follow a
    speaker's native language habits or preferences. Secondary
    stress can be used for contrast, or for emphasis of a point.
    Secondary stress can be emphasized at any level up to primary
    stress, although the speaker must not allow a false primary
    stress in brivla, since errors in word resolution could
    result.</p>

    <p>The following are Lojban words with stress explicitly
    shown:</p>
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  dikyjvo
    DI,ky,jvo
</pre>
    (In a fully-buffered dialect, the pronunciation would be: <span
    class="c3">[&Egrave;di k&laquo; jI vo]</span>.) Note that the
    syllable ``ky'' is not counted in determining stress. The vowel
    ``y'' is never stressed in a normal Lojban context. 
<pre>
<a id="e9d7" name="e9d7">9.7)</a>  .armstrong.
    .ARM,strong.
</pre>

    <p>This is a Lojbanized version of the name ``Armstrong''. The
    final ``g'' must be explicitly pronounced. With full buffering,
    the name would be pronounced:</p>
<pre>
<a id="e9d8" name="e9d8">9.8)</a>  <span
class="c3">[&Egrave;/a rI mI sI tI ro nI gI/]</span>
</pre>

    <p>However, there is no need to insert a buffer in every
    possible place just because it is inserted in one place:
    partial buffering is also acceptable. In every case, however,
    the stress remains in the same place: on the first
    syllable.</p>

    <p>The English pronunciation of ``Armstrong'', as spelled in
    English, is not correct by Lojban standards; the letters ``ng''
    in English represent a velar nasal (IPA <span
    class="c3">[N]</span>) which is a single consonant. In Lojban,
    ``ng'' represents two separate consonants that must both be
    pronounced; you may not use <span class="c3">[N]</span> to
    pronounce Lojban ``ng'', although <span class="c3">[Ng]</span>
    is acceptable. English speakers are likely to have to pronounce
    the ending with a buffer, as one of the following:</p>
<pre>
<a id="e9d9" name="e9d9">9.9)</a>  <span
class="c3">[&Egrave;/arm stron gI/]</span>
    or <span class="c3">[&Egrave;/arm stroN gI/]</span>
    or even <span class="c3">[&Egrave;/arm stro nIg/]</span>
</pre>

    <p>The normal English pronunciation of the name ``Armstrong''
    could be Lojbanized as:</p>
<pre>
<a id="e9d10" name="e9d10">9.10)</a>    .ARMstron.
</pre>
    since Lojban ``n'' is allowed to be pronounced as the velar
    nasal <span class="c3">[N]</span>. 

    <p>Here is another example showing the use of ``y'':</p>
<pre>
<a id="e9d11" name="e9d11">9.11)</a>    bisydja
    BI,sy,dja
    BI,syd,ja
</pre>

    <p>This word is a compound word, or lujvo, built from the two
    affixes ``bis'' and ``dja''. When they are joined, an
    impermissible consonant pair results: ``sd''. In accordance
    with the algorithm for making lujvo, explained in <a
    href="chapter4.html">Chapter 4</a>, a ``y'' is inserted to
    separate the impermissible consonant pair; the ``y'' is not
    counted as a syllable for purposes of stress determination.</p>

    <p></p>
<pre>
<a id="e9d12" name="e9d12">9.12)</a>    da'udja
    da'UD,ja
    da'U,dja
</pre>

    <p>These two syllabications sound the same to a Lojban listener
    --- the association of unbuffered consonants in syllables is of
    no import in recognizing the word.</p>
<pre>
<a id="e9d13" name="e9d13">9.13)</a>    e'u bridi
    e'u BRI,di
    E'u BRI,di
    e'U.BRI,di
</pre>

    <p>In <a href="#e9d13">Example 9.13</a>, ``e'u'' is a cmavo and
    ``bridi'' is a brivla. Either of the first two pronunciations
    is permitted: no primary stress on either syllable of ``e'u'',
    or primary stress on the first syllable. The third
    pronunciation, which places primary stress on the second
    syllable of the cmavo, requires that --- since the following
    word is a brivla --- the two words must be separated by a
    pause. Consider the following two cases:</p>
<pre>
<a id="e9d14" name="e9d14">9.14)</a>    le re nobli prenu
    le re NObli PREnu

<a id="e9d15" name="e9d15">9.15)</a> le re no bliprenu
    le re no bliPREnu
</pre>

    <p>If the cmavo ``no'' in <a href="#e9d15">Example 9.15</a>
    were to be stressed, the phrase would sound exactly like the
    given pronunciation of <a href="#e9d14">Example 9.14</a>, which
    is unacceptable in Lojban: a single pronunciation cannot
    represent both.</p>

    <h3><a id="s10" name="s10">10. IPA For English Speakers</h3>

    <p>There are many dialects of English, thus making it difficult
    to define the standardized symbols of the IPA in terms useful
    to every reader. All the symbols used in this chapter are
    repeated here, in more or less alphabetical order, with
    examples drawn from General American. In addition, some
    attention is given to the Received Pronunciation of (British)
    English. These two dialects are referred to as GA and RP
    respectively. Speakers of other dialects should consult a book
    on phonetics or their local television sets.</p>

    <dl>
      <dt class="c4">[&Egrave;]</dt>

      <dd>An IPA indicator of primary stress; the syllable which
      follows <span class="c3">[&Egrave;]</span> receives primary
      stress.</dd>

      <dt class="c4">[/]</dt>

      <dd>An allowed variant of Lojban ``.''. This sound is not
      usually considered part of English. It is the catch in your
      throat that sometimes occurs prior to the beginning of a word
      (and sometimes a syllable) which starts with a vowel. In some
      dialects, like Cockney and some kinds of American English, it
      is used between vowels instead of ``t'': ``bottle'' <span
      class="c3">[bo/l`]</span>. The English interjection
      ``uh-oh!'' almost always has it between the syllables.</dd>

      <dt class="c4">[&ugrave;]</dt>

      <dd>A symbol indicating that the previous vowel is to be
      spoken for a longer time than usual. Lojban vowels can be
      pronounced long in order to make a greater contrast with
      buffer vowels.</dd>

      <dt class="c4">[a]</dt>

      <dd>The preferred pronunciation of Lojban ``a''. This sound
      doesn't occur in GA, but sounds somewhat like the ``ar'' of
      ``park'', as spoken in RP or New England American. It is
      pronounced further forward in the mouth than <span
      class="c3">[A]</span>.</dd>

      <dt class="c4">[A]</dt>

      <dd>An allowed variant of Lojban ``a''. The ``a'' of GA
      ``father''. The sound <span class="c3">[a]</span> is
      preferred because GA speakers often relax an unstressed <span
      class="c3">[A]</span> into a schwa <span
      class="c3">[&laquo;]</span>, as in the usual pronunciations
      of ``about'' and ``sofa''. Because schwa is a distinct vowel
      in Lojban, English speakers must either learn to avoid this
      shift or to use <span class="c3">[a]</span> instead: the
      Lojban word for ``sofa'' is ``sfofa'', pronounced <span
      class="c3">[sfofa]</span> or <span class="c3">[sfofA]</span>
      but never <span class="c3">[sfof&laquo;]</span> which would
      be the non-word ``sfofy''.</dd>

      <dt class="c4">[Q]</dt>

      <dd>Not a Lojban sound. The ``a'' of English ``cat''.</dd>

      <dt class="c4">[b]</dt>

      <dd>The preferred pronunciation of Lojban ``b''. As in
      English ``boy'', ``sober'', or ``job''.</dd>

      <dt class="c4">[B]</dt>

      <dd>An allowed variant of Lojban ``v''. Not an English sound;
      the Spanish ``b'' or ``v'' between vowels. This sound should
      not be used for Lojban ``b''.</dd>

      <dt class="c4">[d]</dt>

      <dd>The preferred pronunciation of Lojban ``d''. As in
      English ``dog'', ``soda'', or ``mad''.</dd>

      <dt class="c4">[E]</dt>

      <dd>The preferred pronunciation of Lojban ``e''. The ``e'' of
      English ``met''.</dd>

      <dt class="c4">[e]</dt>

      <dd>An allowed variant of Lojban ``e''. This sound is not
      found in English, but is the Spanish ``e'', or the tense
      ``e'' of Italian. The vowel of English ``say'' is similar
      except for the off-glide: you can learn to make this sound by
      holding your tongue steady while saying the first part of the
      English vowel.</dd>

      <dt class="c4">[&laquo;]</dt>

      <dd>The preferred pronunciation of Lojban ``y''. As in the
      ``a'' of English ``sofa'' or ``about''. Schwa is generally
      unstressed in Lojban, as it is in English. It is a totally
      relaxed sound made with the tongue in the middle of the
      mouth.</dd>

      <dt class="c4">[f]</dt>

      <dd>The preferred pronunciation of Lojban ``f''. As in
      ``fee'', ``loafer'', or ``chef''.</dd>

      <dt class="c4">[&cedil;]</dt>

      <dd>An allowed variant of Lojban ``f''. Not an English sound;
      the Japanese ``f'' sound.</dd>

      <dt class="c4">[g]</dt>

      <dd>The preferred pronunciation of Lojban ``g''. As in
      English ``go'', ``eagle'', or ``dog''.</dd>

      <dt class="c4">[h]</dt>

      <dd>The preferred pronunciation of the Lojban apostrophe
      sound. As in English ``aha'' or ``oh, hello''.</dd>

      <dt class="c4">[i]</dt>

      <dd>The preferred pronunciation of Lojban ``i''. Essentially
      like the English vowel of ``pizza'' or ``machine'', although
      the English vowel is sometimes pronounced with an off-glide,
      which should not be present in Lojban.</dd>

      <dt class="c4">[I]</dt>

      <dd>A possible Lojban buffer vowel. The ``i'' of English
      ``bit''.</dd>

      <dt class="c4">[&ouml;]</dt>

      <dd>A possible Lojban buffer vowel. The ``u'' of ``just'' in
      some varieties of GA, those which make the word sound more or
      less like ``jist''. Also Russian ``y'' as in ``byt''' (to
      be); like a schwa <span class="c3">[&laquo;]</span>, but
      higher in the mouth.</dd>

      <dt class="c4">[j]</dt>

      <dd>Used in Lojban diphthongs beginning or ending with ``i''.
      Like the ``y'' in English ``yard'' or ``say''.</dd>

      <dt class="c4">[k]</dt>

      <dd>The preferred pronunciation of Lojban ``k''. As in
      English ``kill'', ``token'', or ``flak''.</dd>

      <dt class="c4">[l]</dt>

      <dd>The preferred pronunciation of Lojban ``l''. As in
      English ``low'', ``nylon'', or ``excel''.</dd>

      <dt class="c4">[l`]</dt>

      <dd>The syllabic version of Lojban ``l'', as in English
      ``bottle'' or ``middle''.</dd>

      <dt class="c4">[m]</dt>

      <dd>The preferred pronunciation of Lojban ``m''. As in
      English ``me'', ``humor'', or ``ham''.</dd>

      <dt class="c4">[m`]</dt>

      <dd>The syllabic version of Lojban ``m''. As in English
      ``catch 'em'' or ``bottom''.</dd>

      <dt class="c4">[n]</dt>

      <dd>The preferred pronunciation of Lojban ``n''. As in
      English ``no'', ``honor'', or ``son''.</dd>

      <dt class="c4">[n`]</dt>

      <dd>The syllabic version of Lojban ``n''. As in English
      ``button''.</dd>

      <dt class="c4">[N]</dt>

      <dd>An allowed variant of Lojban ``n'', especially in
      Lojbanized names and before ``g'' or ``k''. As in English
      ``sing'' or ``singer'' (but not ``finger'' or
      ``danger'').</dd>

      <dt class="c4">[N`]</dt>

      <dd>An allowed variant of Lojban syllabic ``n'', especially
      in Lojbanized names.</dd>

      <dt class="c4">[o]</dt>

      <dd>The preferred pronunciation of Lojban ``o''. As in the
      French ``haute (cuisine)'' or Spanish ``como''. There is no
      exact English equivalent of this sound. The nearest GA
      equivalent is the ``o'' of ``dough'' or ``joke'', but it is
      essential that the off-glide (a <span
      class="c3">[w]</span>-like sound) at the end of the vowel is
      not pronounced when speaking Lojban. The RP sound in these
      words is <span class="c3">[&laquo;w]</span> in IPA terms, and
      has no <span class="c3">[o]</span> in it at all; unless you
      can speak with a Scots, Irish, or American accent, you may
      have trouble with this sound.</dd>

      <dt class="c4">[]</dt>

      <dd>An allowed variant of Lojban ``o'', especially before
      ``r''. This sound is a shortened form of the ``aw'' in GA
      ``dawn'' (for those people who don't pronounce ``dawn'' and
      ``Don'' alike; if you do, you may have trouble with this
      sound). In RP, but not GA, it is the ``o'' of ``hot''.</dd>

      <dt class="c4">[p]</dt>

      <dd>The preferred pronunciation of Lojban ``p''. As in
      English ``pay'', ``super'', or ``up''.</dd>

      <dt class="c4">[r]</dt>

      <dd>One version of Lojban ``r''. Not an English sound. The
      Spanish ``rr'' and the Scots ``r'', a tongue-tip trill.</dd>

      <dt class="c4">[&uml;]</dt>

      <dd>One version of Lojban ``r''. As in GA ``right'',
      ``baron'', or ``car''. Not found in RP.</dd>

      <dt class="c4">[R]</dt>

      <dd>One version of Lojban ``r''. In GA, appears as a variant
      of ``t'' or ``d'' in the words ``metal'' and ``medal''
      respectively. A tongue-tip flap. <span class="c3">[{]</span>
      One version of Lojban ``r''. Not an English sound. The French
      or German ``r'' in ``reine'' or ``rot'' respectively. A
      uvular trill.</dd>

      <dt></dt>

      <dd><span class="c3">[r`]</span>, <span
      class="c3">[&uml;`]</span>, <span class="c3">[R`]</span>,
      <span class="c3">[{`]</span> are syllabic versions of the
      above. <span class="c3">[&uml;`]</span> appears in the GA
      (but not RP) pronunciation of ``bird''.</dd>

      <dt class="c4">[s]</dt>

      <dd>The preferred pronunciation of Lojban ``s''. As in
      English ``so'', ``basin'', or ``yes''.</dd>

      <dt class="c4">[S]</dt>

      <dd>The preferred pronunciation of Lojban ``c''. The ``sh''
      of English ``ship'', ``ashen'', or ``dish''.</dd>

      <dt class="c4">[&sect;]</dt>

      <dd>An allowed variant of Lojban ``s''. Not an English sound.
      The Hindi retroflex ``s'' with underdot, or Klingon
      ``S''.</dd>

      <dt class="c4">[t]</dt>

      <dd>The preferred pronunciation of Lojban ``t''. As in
      English ``tea'', ``later'', or ``not''. It is important to
      avoid the GA habit of pronouncing the ``t'' between vowels as
      <span class="c3">[d]</span> or <span
      class="c3">[R]</span>.</dd>

      <dt class="c4">[T]</dt>

      <dd>Not normally a Lojban sound, but a possible variant of
      Lojban ``'''. The ``th'' of English ``thin'' (but not
      ``then'').</dd>

      <dt class="c4">[v]</dt>

      <dd>The preferred pronunciation of Lojban ``v''. As in
      English ``voice'', ``savor'', or ``live''.</dd>

      <dt class="c4">[w]</dt>

      <dd>Used in Lojban diphthongs beginning or ending with ``u''.
      Like the ``w'' in English ``wet'' <span
      class="c3">[wEt]</span> or ``cow'' <span
      class="c3">[kAw]</span>.</dd>

      <dt class="c4">[x]</dt>

      <dd>The preferred pronunciation of Lojban ``x''. Not normally
      an English sound, but used in some pronunciations of ``loch''
      and ``Bach''; ``gh'' in Scots ``might'' and ``night''. The
      German ``Ach-Laut''. To pronounce <span
      class="c3">[x]</span>, force air through your throat without
      vibrating your vocal chords; there should be lots of
      scrape.</dd>

      <dt class="c4">[Y]</dt>

      <dd>A possible Lojban buffer vowel. Not an English sound: the
      ``&uuml;'' of German ``h&uuml;bsch''.</dd>

      <dt class="c4">[z]</dt>

      <dd>The preferred pronunciation of Lojban ``z''. As in
      English ``zoo'', ``hazard'', or ``fizz''.</dd>

      <dt class="c4">[Z]</dt>

      <dd>The preferred pronunciation of Lojban ``j''. The ``si''
      of English ``vision'', or the consonant at the end of GA
      ``garage''.</dd>

      <dt class="c4">[&frac12;]</dt>

      <dd>An allowed variant of Lojban ``z''. Not an English sound.
      The voiced version of <span class="c3">[&sect;]</span>.</dd>
    </dl>

    <h3><a id="s11" name="s11">11. English Analogues For Lojban Diphthongs</h3>

    <p>Here is a list of English words that contain diphthongs that
    are similar to the Lojban diphthongs. This list does not
    constitute an official pronunciation guide; it is intended as a
    help to English-speakers.</p>
<pre>
   Lojban      English

    ai      ``pie''
    ei      ``pay''
    oi      ``boy''
    au      ``cow''

    ia      ``yard''
    ie      ``yes''
    ii      ``ye''
    io      ``yodel'' (in GA only)
    iu      ``unicorn'' or ``few''

    ua      ``suave''
    ue      ``wet''
    ui      ``we''
    uo      ``woe'' (in GA only)
    uu      ``woo''

    iy          ``million'' (the ``io'' part, that is)
    uy          ``was'' (when unstressed)
</pre>

    <h3><a id="s12" name="s12">12. Oddball Orthographies</h3>

    <p>The following notes describe ways in which Lojban has been
    written or could be written that differ from the standard
    orthography explained in the rest of this chapter. Nobody needs
    to read this section except people with an interest in the
    obscure. Technicalities are used without explanation or further
    apology.</p>

    <p>There exists an alternative orthography for Lojban, which is
    designed to be as compatible as possible (but no more so) with
    the authority used in pre-Lojban versions of Loglan. The
    consonants undergo no change, except that ``x'' is replaced by
    ``h''. The individual vowels likewise remain unchanged.
    However, the vowel pairs and diphthongs are changed as
    follows:</p>

    <dl>
      <dt></dt>

      <dd>``ai'', ``ei'', ``oi'', ``au'' become ``ai'', ``ei'',
      ``oi'', ``ao''.</dd>

      <dt></dt>

      <dd>``ia'' through ``iu'' and ``ua'' through ``uu'' remain
      unchanged.</dd>

      <dt></dt>

      <dd>``a'i'', ``e'i'', ``o'i'' and ``a'o'' become ``a,i'',
      ``e,i'', ``o,i'' and ``a,o''.</dd>

      <dt></dt>

      <dd>``i'a'' through ``i'u'' and ``u'a'' through ``u'u'' are
      changed to ``ia'' through ``iu'' and ``ua'' through ``uu'' in
      lujvo and cmavo other than attitudinals, but become ``i,a''
      through ``i,u'' and ``u,a'' through ``u,u'' in names,
      fu'ivla, and attitudinal cmavo.</dd>

      <dt></dt>

      <dd>All other vowel pairs simply drop the apostrophe.</dd>
    </dl>

    <p>The result of these rules is to eliminate the apostrophe
    altogether, replacing it with comma where necessary, and
    otherwise with nothing. In addition, names and the cmavo ``.i''
    are capitalized, and irregular stress is marked with an
    apostrophe (now no longer used for a sound) following the
    stressed syllable.</p>

    <p>Three points must be emphasized about this alternative
    orthography:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>It is not standard, and has not been used.</dd>

      <dt></dt>

      <dd>It does not represent any changes to the standard Lojban
      phonology; it is simply a representation of the same
      phonology using a different written form.</dd>

      <dt></dt>

      <dd>It was designed to aid in a planned rapprochement between
      the Logical Language Group and The Loglan Institute, a group
      headed by James Cooke Brown. The rapprochement never took
      place.</dd>
    </dl>
    There also exists a Cyrillic orthography for Lojban which was
    designed when the introductory Lojban brochure was translated
    into Russian. It uses the letters ``a'', ``be'', ``ve'',
    ``ge'', ``de'', ``e'', ``zhe'', ``ze'', ``i'', ``ka'', ``el'',
    ``em'', ``en'', ``o'', ``pe'', ``er'', ``es'', ``te'', ``u'',
    ``ef'', ``kha'', and ``sha'' in the obvious ways. The Latin
    letter ``y'' is mapped onto the hard sign, as in Bulgarian. The
    apostrophe, comma, and period are unchanged. Diphthongs are
    written as vowel pairs, as in the Roman representation. 

    <p>Finally, an orthography using the Tengwar of F&eacute;anor,
    a fictional orthography invented by J. R. R. Tolkien and
    described in the Appendixes to <cite>The Lord Of The
    Rings</cite>, has been devised for Lojban. The following
    mapping, which closely resembles that used for Westron, will be
    meaningful only to those who have read those appendixes. In
    brief, the tincot&eacute;ma and parmat&eacute;ma are used in
    the conventional ways; the calmat&eacute;ma represents palatal
    consonants, and the quesset&eacute;ma represents velar
    consonants.</p>
<pre>
   t   tinco       p   parma
    -   calma       k   quesse
    d   ando        b   umbar
    -   anga        g   ungwe
    -   thule       f   formen
    c   harma       x   hwesta
    -   anto        v   ampa
    j   anca        -   unque
    n   numen       m   malta
    -   noldo       -   nwalme
    r   ore     u   vala
    i   anna        -   vilya
</pre>

    <p>The letters ``vala'' and ``anna'' are used for ``u'' and
    ``i'' only when those letters are used to represent glides. Of
    the additional letters, ``r'', ``l'', ``s'', and ``z'' are
    written with ``r&oacute;men'', ``lambe'', ``silme'', and
    ``&aacute;re/``esse'' respectively; the inverted forms are used
    as free variants.</p>

    <p>Lojban, like Quenya, is a vowel-last language, so tehtar are
    read as following the tengwar on which they are placed. The
    conventional tehtar are used for the five regular vowels, and
    the under-dot for ``y''. The Lojban apostrophe is represented
    by ``halla''. There is no equivalent of the Lojban comma or
    period.</p>

    <dl>
      <dt></dt>
    </dl>

    <hr />
    
    <p>Derni&egrave;res modifications&nbsp;: Mon Jun 27 23:10:59 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
