
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//ES" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 20</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter20.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 20<br />
      A Catalogue of selma'o</h2>

      <!--
      <h6>$Revision: 4.3 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <p>The following paragraphs list all the selma'o of Lojban,
    with a brief explanation of what each one is about, and
    reference to the chapter number where each is explained more
    fully. As usual, all selma'o names are given in capital letters
    (with ``h'' serving as the capital of ``''') and are the names
    of a representative cmavo, often the most important or the
    first in alphabetical order. One example is given of each
    selma'o: for selma'o which have several uses, the most common
    use is shown.</p>

    <p>selma'o A (<a href="chapter14.html">Chapter 14</a>)</p>

    <p>Specifies a logical connection (e.g. ``and'', ``or'',
    ``if''), usually between sumti.</p>

    <dl>
      <dt></dt>

      <dd>la djan. .a la djein. klama le zarci John and/or Jane
      goes to the store.</dd>
    </dl>

    <p>Also used to create vowel lerfu words when followed with
    ``bu''.</p>

    <p>selma'o BAI (<a href="chapter9.html">Chapter 9</a>)</p>

    <p>May be prefixed to a sumti to specify an additional place,
    not otherwise present in the place structure of the selbri, and
    derived from a single place of some other selbri.</p>

    <dl>
      <dt></dt>

      <dd>mi tavla bau la lojban. I speak in-language Lojban.</dd>
    </dl>
    selma'o BAhE (<a href="chapter19.html">Chapter 19</a>) 

    <p>Emphasizes the next single word, or marks it as a nonce word
    (one invented for the occasion.</p>

    <dl>
      <dt></dt>

      <dd>la ba'e .djordj. klama le zarci <i>George</i> goes to the
      store. It is George who goes to the store.</dd>
    </dl>
    selma'o BE (<a href="chapter5.html">Chapter 5</a>) 

    <p>Attaches sumti which fill the place structure of a single
    unit making up a tanru. Unless otherwise indicated, the sumti
    fill the x2, x3, and successive places in that order. BE is
    most useful in descriptions formed with LE. See BEI, BEhO.</p>

    <dl>
      <dt></dt>

      <dd>mi klama be ta troci I am-a-(goer to-that) type-of-trier.
      I try to go to that place.</dd>
    </dl>
    selma'o BEI (<a href="chapter5.html">Chapter 5</a>) 

    <p>Separates multiple sumti attached by BE to a tanru unit.</p>

    <dl>
      <dt></dt>

      <dd>mi klama be le zarci bei le zdani be'o troci I am-a-(goer
      to-the store from-the home) type-of-trier. I try to go from
      the home to the market.</dd>
    </dl>
    selma'o BEhO (<a href="chapter5.html">Chapter 5</a>) 

    <p>Elidable terminator for BE. Terminates sumti that are
    attached to a tanru unit.</p>

    <dl>
      <dt></dt>

      <dd>mi klama be le zarci be'o troci I am-a-(goer to-the
      market) type-of-trier. I try to go to the market.</dd>
    </dl>
    selma'o BIhE (<a href="chapter18.html">Chapter 18</a>) 

    <p>Prefix attached to a mathematical operator to mark it as
    higher priority than other mathematical operators, binding its
    operands more closely.</p>

    <dl>
      <dt></dt>

      <dd>li ci bi'e pi'u vo su'i mu du li paze The-number 3
      [priority] times 4 plus 5 equals the-number 17. 3 * 4 + 5 =
      17</dd>
    </dl>
    selma'o BIhI (<a href="chapter14.html">Chapter 14</a>) 

    <p>Joins sumti or tanru units (as well as some other things) to
    form intervals. See GAhO.</p>

    <dl>
      <dt></dt>

      <dd>mi ca sanli la drezdn. bi'i la frankfurt. I [present]
      stand-on-surface Dresden [interval] Frankfurt. I am standing
      between Dresden and Frankfurt.</dd>
    </dl>
    selma'o BO (<a href="chapter5.html">Chapter 5</a>, <a
    href="chapter15.html">Chapter 15</a>, <a
    href="chapter18.html">Chapter 18</a>) 

    <p>Joins tanru units, binding them together closely. Also used
    to bind logically or non-logically connected phrases,
    sentences, etc. BO is always high precedence and
    right-grouping.</p>

    <dl>
      <dt></dt>

      <dd>ta cmalu nixli bo ckule That is-a-small type-of (girl
      type-of school). That is a small school for girls.</dd>
    </dl>
    selma'o BOI (<a href="chapter18.html">Chapter 18</a>) 

    <p>Elidable terminator for PA or BY. Used to terminate a number
    (string of numeric cmavo) or lerfu string (string of letter
    words) when another string immediately follows.</p>

    <dl>
      <dt></dt>

      <dd>li re du li vu'u voboi re The-number two equals
      the-number the-difference-of four-and two.</dd>
    </dl>
    selma'o BU (<a href="chapter17.html">Chapter 17</a>) 

    <p>A suffix which can be attached to any word, typically a word
    representing a letter of the alphabet or else a name, to make a
    word for a symbol or a different letter of the alphabet. In
    particular, attached to single-vowel cmavo to make words for
    vowel letters.</p>

    <dl>
      <dt></dt>

      <dd>.abu .ebu .ibu .obu .ubu .ybu a, e, i, o, u, y.</dd>
    </dl>
    selma'o BY (<a href="chapter17.html">Chapter 17</a>) 

    <p>Words representing the letters of the Lojban alphabet, plus
    various shift words which alter the interpretation of other
    letter words.</p>

    <dl>
      <dt></dt>

      <dd>.abu tavla .by le la .ibymym. skami A talks-to B
      about-the of-IBM computers. A talks to B about IBM
      computers.</dd>
    </dl>
    selma'o CAI (<a href="chapter13.html">Chapter 13</a>) 

    <p>A particle which indicates the intensity of an emotion:
    maximum, strong, weak, or not at all. Typically follows another
    particle which specifies the emotion.</p>

    <dl>
      <dt></dt>

      <dd>.ei cai mi klama le zarci [Obligation!] [Intense!] I
      go-to the market. I must go to the market.</dd>
    </dl>
    selma'o CAhA (<a href="chapter10.html">Chapter 10</a>) 

    <p>Specifies whether a bridi refers to an actual fact, a
    potential (achieved or not), or merely an innate
    capability.</p>

    <dl>
      <dt></dt>

      <dd>ro datka ka'e flulimna all ducks [capability]
      are-float-swimmers All ducks have the capability of swimming
      by floating.</dd>
    </dl>
    selma'o CEI (<a href="chapter7.html">Chapter 7</a>) 

    <p>Assigns a selbri definition to one of the five pro-bridi
    gismu: ``broda'', ``brode'', ``brodi'', ``brodo'', or
    ``brodu'', for later use.</p>

    <dl>
      <dt></dt>

      <dd>ti slasi je mlatu bo cidja lante gacri cei broda .i le
      crino broda cu barda .i le xunre broda cu cmalu This is a
      plastic cat-food can cover, or thingy. The green thingy is
      large. The red thingy is small.</dd>
    </dl>
    selma'o CEhE (<a href="chapter14.html">Chapter 14</a>, <a
    href="chapter16.html">Chapter 16</a>) 

    <p>Joins multiple terms into a termset. Termsets are used to
    associate several terms for logical connectives, for equal
    quantifier scope, or for special constructs in tenses.</p>

    <dl>
      <dt></dt>

      <dd>mi ce'e do pe'e je la djan. ce'e la djeimyz. cu pendo I
      [,] you [joint] and John [,] James are-friends-of. I am a
      friend of you, and John is a friend of James.</dd>
    </dl>
    selma'o CO (<a href="chapter5.html">Chapter 5</a>) 

    <p>When inserted between the components of a tanru, inverts it,
    so that the following tanru unit modifies the previous one.</p>

    <dl>
      <dt></dt>

      <dd>mi troci co klama le zarci le zdani I am-a-trier of-type
      (goer to-the market from-the house). I try to go to the
      market from the house.</dd>
    </dl>
    selma'o COI (<a href="chapter6.html">Chapter 6</a>, <a
    href="chapter13.html">Chapter 13</a>) 

    <p>When prefixed to a name, description, or sumti, produces a
    vocative: a phrase which indicates who is being spoken to (or
    who is speaking). Vocatives are used in conversational
    protocols, including greeting, farewell, and radio
    communication. See DOI, DOhU.</p>

    <dl>
      <dt></dt>

      <dd>coi .djan. Greetings, John.</dd>
    </dl>
    selma'o CU (<a href="chapter9.html">Chapter 9</a>) 

    <p>Separates the selbri of a bridi from any sumti which precede
    it. Never strictly necessary, but often useful to eliminate
    various elidable terminators.</p>

    <dl>
      <dt></dt>

      <dd>le gerku cu klama le zarci The dog goes to-the
      store.</dd>
    </dl>
    selma'o CUhE (<a href="chapter10.html">Chapter 10</a>) 

    <p>Forms a question which asks when, where, or in what mode the
    rest of the bridi is true. See PU, CAhA, TAhE, and BAI.</p>

    <dl>
      <dt></dt>

      <dd>do cu'e klama le zarci You [When/Where?] go to-the store?
      When are you going to the store?</dd>
    </dl>
    selma'o DAhO (<a href="chapter7.html">Chapter 7</a>) 

    <p>Cancels the assigned significance of all sumti cmavo (of
    selma'o KOhA) and bridi cmavo (of selma'o GOhA).</p>

    <p>selma'o DOI (<a href="chapter13.html">Chapter 13</a>)</p>

    <p>The non-specific vocative indicator. May be used with or
    without COI. No pause is required between ``doi'' and a
    following name. See DOhU.</p>

    <dl>
      <dt></dt>

      <dd>doi frank. mi tavla do O Frank, I speak-to you. Frank,
      I'm talking to you.</dd>
    </dl>
    selma'o DOhU (<a href="chapter13.html">Chapter 13</a>) 

    <p>Elidable terminator for COI or DOI. Signals the end of a
    vocative.</p>

    <dl>
      <dt></dt>

      <dd>coi do'u Greetings [terminator] Greetings, O unspecified
      one!</dd>
    </dl>
    selma'o FA (<a href="chapter9.html">Chapter 9</a>) 

    <p>Prefix for a sumti, indicating which numbered place in the
    place structure the sumti belongs in; overrides word order.</p>

    <dl>
      <dt></dt>

      <dd>fa mi cu klama fi la .atlantas. fe la bastn. fo le dargu
      fu le karce x1= I go x3= Atlanta x2= Boston x4= the road x5=
      the car. I go from Atlanta to Boston via the road using the
      car.</dd>
    </dl>
    selma'o FAhA (<a href="chapter10.html">Chapter 10</a>) 

    <p>Specifies the direction in which, or toward which (when
    marked with MOhI) or along which (when prefixed by VEhA or
    VIhA) the action of the bridi takes place.</p>

    <dl>
      <dt></dt>

      <dd>le nanmu zu'a batci le gerku The man [left] bites the
      dog. To my left, the man bites the dog.</dd>
    </dl>
    selma'o FAhO (<a href="chapter19.html">Chapter 19</a>) 

    <p>A mechanical signal, outside the grammar, indicating that
    there is no more text. Useful in talking to computers.</p>

    <p>selma'o FEhE (<a href="chapter10.html">Chapter 10</a>)</p>

    <p>Indicates that the following interval modifier (using TAhE,
    ROI, or ZAhO) refers to space rather than time.</p>

    <dl>
      <dt></dt>

      <dd>ko vi'i fe'e di'i sombo le gurni You-imperative
      [1-dimensional] [space] [regularly] sow the grain. Sow the
      grain in a line and evenly!</dd>
    </dl>
    selma'o FEhU (<a href="chapter9.html">Chapter 9</a>) 

    <p>Elidable terminator for FIhO. Indicates the end of an ad hoc
    modal tag: the tagged sumti immediately follows.</p>

    <dl>
      <dt></dt>

      <dd>mi viska do fi'o kanla [fe'u] le zunle I see you [modal]
      eye: the left-thing I see you with the left eye.</dd>
    </dl>
    selma'o FIhO (<a href="chapter9.html">Chapter 9</a>) 

    <p>When placed before a selbri, transforms the selbri into a
    modal tag, grammatically and semantically equivalent to a
    member of selma'o BAI.</p>

    <dl>
      <dt></dt>

      <dd>mi viska do fi'o kanla le zunle I see you with eye the
      left-thing I see you with my left eye.</dd>
    </dl>
    selma'o FOI (<a href="chapter17.html">Chapter 17</a>) 

    <p>Signals the end of a compound alphabet letter word that
    begins with TEI. Not an elidable terminator.</p>

    <dl>
      <dt></dt>

      <dd>tei .ebu .akut. bu foi ( ``e'' ``acute'' ) the letter
      ``e'' with an acute accent</dd>
    </dl>
    selma'o FUhA (<a href="chapter18.html">Chapter 18</a>) 

    <p>Indicates that the following mathematical expression is to
    be interpreted as reverse Polish (RP), a mode in which
    mathematical operators follow their operands.</p>

    <dl>
      <dt></dt>

      <dd>li fu'a reboi re[boi] su'i du li vo the-number [RP!] two,
      two, plus equals the-number four 2 + 2 = 4</dd>
    </dl>
    selma'o FUhE (<a href="chapter19.html">Chapter 19</a>) 

    <p>Indicates that the following indicator(s) of selma'o UI
    affect not the preceding word, as usual, but rather all
    following words until a FUhO.</p>

    <dl>
      <dt></dt>

      <dd>mi viska le fu'e .ia blanu zdani fu'o ponse I see the
      [start] [belief] blue house [end] possessor I see the owner
      of a blue house, or what I believe to be one.</dd>
    </dl>
    selma'o FUhO (<a href="chapter19.html">Chapter 19</a>) 

    <p>Cancels all indicators of selma'o UI which are in
    effect.</p>

    <dl>
      <dt></dt>

      <dd>mi viska le fu'e .ia blanu zdani fu'o ponse I see the
      [start] [belief] blue house [end] possessor I see the owner
      of what I believe to be a blue house.</dd>
    </dl>
    selma'o GA (<a href="chapter14.html">Chapter 14</a>) 

    <p>Indicates the beginning of two logically connected sumti,
    bridi-tails, or various other things. Logical connections
    include ``both ... and'', ``either ... or'', ``if ... then'',
    and so on. See GI.</p>

    <dl>
      <dt></dt>

      <dd>ga la djan. nanmu gi la djeimyz. ninmu Either John is a
      man or James is a woman (or both).</dd>
    </dl>
    selma'o GAhO (<a href="chapter14.html">Chapter 14</a>) 

    <p>Specifies whether an interval specified by BIhI includes or
    excludes its endpoints. Used in pairs before and after the BIhI
    cmavo, to specify the nature of both the left- and the
    right-hand endpoints.</p>

    <dl>
      <dt></dt>

      <dd>mi ca sanli la drezdn. ga'o bi'i ga'o la frankfurt. I
      [present] stand Dresden [inclusive] [interval] [inclusive]
      Frankfurt. I am standing between Dresden and Frankfurt,
      inclusive of both.</dd>
    </dl>
    selma'o GEhU (<a href="chapter8.html">Chapter 8</a>) 

    <p>Elidable terminator for GOI. Marks the end of a relative
    phrase. See KUhO.</p>

    <dl>
      <dt></dt>

      <dd>la djan. goi ko'a ge'u blanu John (referred to as #1)
      is-blue.</dd>
    </dl>
    selma'o GI (<a href="chapter14.html">Chapter 14</a>) 

    <p>Separates two logically or non-logically connected sumti,
    tanru units, bridi-tails, or other things, when the prefix is a
    forethought logical connective involving GA, GUhA, or JOI.</p>

    <dl>
      <dt></dt>

      <dd>ge la djan. nanmu gi la djeimyz. ninmu (It is true that)
      both John is a man and James is a woman.</dd>
    </dl>
    selma'o GIhA (<a href="chapter14.html">Chapter 14</a>) 

    <p>Specifies a logical connective (e.g. ``and'', ``or'',
    ``if'') between two bridi-tails: a bridi-tail is a selbri with
    any associated following sumti, but not including any preceding
    sumti.</p>

    <dl>
      <dt></dt>

      <dd>mi klama le zarci gi'e nelci la djan. I go-to the market
      and like John.</dd>
    </dl>
    selma'o GOI (<a href="chapter8.html">Chapter 8</a>) 

    <p>Specifies the beginning of a relative phrase, which
    associates a subordinate sumti (following) to another sumti
    (preceding). See GEhU, NOI.</p>

    <dl>
      <dt></dt>

      <dd>la djan. goi ko'a cu blanu John (referred to as #1) is
      blue.</dd>
    </dl>
    selma'o GOhA (<a href="chapter7.html">Chapter 7</a>) 

    <p>A general selma'o for all cmavo which can take the place of
    brivla. There are several groups of these.</p>

    <dl>
      <dt></dt>

      <dd>A: mi klama le zarci B: mi go'i A: I'm going to the
      market. B: Me, too.</dd>
    </dl>
    selma'o GUhA (<a href="chapter14.html">Chapter 14</a>) 

    <p>Indicates the beginning of two logically connected tanru
    units. Takes the place of GA when forming logically-connected
    tanru. See GI.</p>

    <dl>
      <dt></dt>

      <dd>la .alis. gu'e ricfu gi blanu Alice is both rich and
      blue.</dd>
    </dl>
    selma'o I (<a href="chapter19.html">Chapter 19</a>) 

    <p>Separates two sentences from each other.</p>

    <dl>
      <dt></dt>

      <dd>mi klama le zarci .i mi klama le zdani I go-to the
      market. I go-to the office.</dd>
    </dl>
    selma'o JA (<a href="chapter14.html">Chapter 14</a>) 

    <p>Specifies a logical connection (e.g. ``and'', ``or'',
    ``if'') between two tanru units, mathematical operands, tenses,
    or abstractions.</p>

    <dl>
      <dt></dt>

      <dd>ti blanu je zdani This is-blue and a-house.</dd>
    </dl>
    selma'o JAI (<a href="chapter9.html">Chapter 9</a>) 

    <p>When followed by a tense or modal, creates a conversion
    operator attachable to a selbri which exchanges the modal place
    with the x1 place of the selbri. When alone, is a conversion
    operator exchanging the x1 place of the selbri (which should be
    an abstract sumti) with one of the places of the
    abstracted-over bridi.</p>

    <dl>
      <dt></dt>

      <dd>mi jai gau galfi le bitmu skari I am-the-actor-in
      modifying the wall color. I act so as to modify the wall
      color. I change the color of the wall.</dd>
    </dl>
    selma'o JOI (<a href="chapter14.html">Chapter 14</a>) 

    <p>Specifies a non-logical connection (e.g.
    together-with-as-mass, -set, or -sequence) between two sumti,
    tanru units, or various other things. When immediately followed
    by GI, provides forethought non-logical connection analogous to
    GA.</p>

    <dl>
      <dt></dt>

      <dd>la djan. joi la .alis. cu bevri le pipno John massed-with
      Alice carry the piano.</dd>
    </dl>
    selma'o JOhI (<a href="chapter18.html">Chapter 18</a>) 

    <p>Indicates that the following mathematical operands (a list
    terminated by TEhU) form a mathematical vector (one-dimensional
    array).</p>

    <dl>
      <dt></dt>

      <dd>li jo'i paboi reboi te'u su'i jo'i ciboi voboi du li jo'i
      voboi xaboi the-number array( one, two ) plus array( three,
      four) equals the-number array( four, six) (1,2) + (3,4) =
      (4,6)</dd>
    </dl>
    selma'o KE (<a href="chapter5.html">Chapter 5</a>) 

    <p>Groups everything between itself and a following KEhE for
    purposes of logical connection, tanru construction, or other
    purposes. KE and KEhE are not used for mathematical (see VEI
    and VEhO) or discursive (see TO and TOI) purposes.</p>

    <dl>
      <dt></dt>

      <dd>ta ke melbi cmalu ke'e nixli ckule That is-a-( pretty
      little ) girl school. That is a school for girls who are
      pretty in their littleness.</dd>
    </dl>
    selma'o KEI (<a href="chapter11.html">Chapter 11</a>) 

    <p>Elidable terminator for NU. Marks the end of an abstraction
    bridi.</p>

    <dl>
      <dt></dt>

      <dd>la djan. cu nu sonci kei djica John is-an-(event-of
      being-a-soldier) type-of desirer. John wants to be a
      soldier.</dd>
    </dl>
    selma'o KEhE (<a href="chapter5.html">Chapter 5</a>) 

    <p>Elidable terminator for KE. Marks the end of a grouping.</p>

    <dl>
      <dt></dt>

      <dd>ta ke melbi cmalu ke'e nixli ckule That is-a-( pretty
      little ) girl school. That is a school for girls who are
      pretty in their littleness.</dd>
    </dl>
    selma'o KI (<a href="chapter10.html">Chapter 10</a>) 

    <p>When preceded by a tense, makes it ``sticky'', so that it
    applies to all further bridi until reset by another appearance
    of KI. When alone, eliminates all sticky tenses.</p>

    <p>selma'o KOhA (<a href="chapter7.html">Chapter 7</a>)</p>

    <p>A general selma'o which contains all cmavo which can
    substitute for sumti. These cmavo are divided into several
    groups.</p>

    <dl>
      <dt></dt>

      <dd>le blanu zdani goi ko'a cu barda .i ko'a na cmamau ti The
      blue house (referred to as #1) is big. #1 is-not smaller-than
      this-thing.</dd>
    </dl>
    selma'o KU (<a href="chapter6.html">Chapter 6</a>, <a
    href="chapter10.html">Chapter 10</a>) 

    <p>Elidable terminator for LE and some uses of LA. Indicates
    the end of a description sumti. Also used after a tense or
    modal to indicate that no sumti follows, and in the compound
    NA+KU to indicate natural language-style negation.</p>

    <dl>
      <dt></dt>

      <dd>le prenu ku le zdani ku klama The person, to-the house,
      goes. The person goes to the house.</dd>
    </dl>
    selma'o KUhE (<a href="chapter18.html">Chapter 18</a>) 

    <p>Elidable terminator for PEhO: indicates the end of a
    forethought mathematical expression (one in which the operator
    precedes the operands).</p>

    <dl>
      <dt></dt>

      <dd>li pe'o su'i reboi reboi re[boi] ku'e du li xa The number
      [forethought] the-sum-of two two two [end] equals the-number
      six.</dd>
    </dl>
    selma'o KUhO (<a href="chapter8.html">Chapter 8</a>) 

    <p>Elidable terminator for NOI. Indicates the end of a relative
    clause.</p>

    <dl>
      <dt></dt>

      <dd>le zdani poi blanu ku'o barda The house which is-blue
      is-big.</dd>
    </dl>
    selma'o LA (<a href="chapter5.html">Chapter 5</a>) 

    <p>Descriptors which change name words (or selbri) into sumti
    which identify people or things by name. Similar to LE. May be
    terminated with KU if followed by a description selbri.</p>

    <dl>
      <dt></dt>

      <dd>la kikeros. du la tulis. Cicero is Tully.</dd>
    </dl>
    selma'o LAU (<a href="chapter17.html">Chapter 17</a>) 

    <p>Cmavo which combine with the following alphabetic letter to
    represent a single marker: change from lower to upper case,
    change of font, punctuation, etc.)</p>

    <dl>
      <dt></dt>

      <dd>tau sy. .ibu [single-shift] ``s'' ``i'' Si (chemical
      symbol for silicon)</dd>
    </dl>
    selma'o LAhE (<a href="chapter6.html">Chapter 6</a>) 

    <p>Qualifiers which, when prefixed to a sumti, change it into
    another sumti with related meaning. Qualifiers can also consist
    of a cmavo from selma'o NAhE plus BO. See LUhU.</p>

    <dl>
      <dt></dt>

      <dd>mi viska la'e zoi kuot. A Tale of Two Cities .kuot I see
      that-represented-by the-text `` A Tale of Two Cities ''. I
      see the book ``A Tale of Two Cities''.</dd>
    </dl>
    selma'o LE (<a href="chapter6.html">Chapter 6</a>) 

    <p>Descriptors which make selbri into sumti which describe or
    specify things that fit into the x1 place of the selbri. See
    LA, KU.</p>

    <dl>
      <dt></dt>

      <dd>le gerku klama le zdani The dog goes-to the house.</dd>
    </dl>
    selma'o LEhU (<a href="chapter19.html">Chapter 19</a>) 

    <p>Indicates the end of a quotation begun with LOhU. Not an
    elidable terminator.</p>

    <dl>
      <dt></dt>

      <dd>lo'u mi du do du mi le'u cu na lojbo drani [quote] mi du
      do du mi [unquote] is-not Lojbanically correct. ``mi du do du
      mi'' is not correct Lojban.</dd>
    </dl>
    selma'o LI (<a href="chapter18.html">Chapter 18</a>) 

    <p>Descriptors which change numbers or other mathematical
    expressions into sumti which specify numbers or numerical
    expressions. See LOhO.</p>

    <dl>
      <dt></dt>

      <dd>li re su'u re na du li vo su'i vo the-number 2 minus 2
      not equals the-number 4 plus 4. $2 - 2 &lt;&gt; 4 + 4$</dd>
    </dl>
    selma'o LIhU (<a href="chapter19.html">Chapter 19</a>) 

    <p>Elidable terminator for LU. Indicates the end of a text
    quotation.</p>

    <dl>
      <dt></dt>

      <dd>mi cusku lu mi klama le zarci li'u I express [quote] I
      go-to the market [end quote].</dd>
    </dl>
    selma'o LOhO (<a href="chapter18.html">Chapter 18</a>) 

    <p>Elidable terminator for LI. Indicates the end of a
    mathematical expression used in a LI description.</p>

    <dl>
      <dt></dt>

      <dd>li vo lo'o li ci lo'o cu zmadu The-number 4 [end number],
      the number 3 [end number], is greater. $4 &gt; 3$</dd>
    </dl>
    selma'o LOhU (<a href="chapter19.html">Chapter 19</a>) 

    <p>Indicates the beginning of a quotation (a sumti) which is
    grammatical as long as the quoted material consists of Lojban
    words, whether they form a text or not. Terminated by LEhU.</p>

    <dl>
      <dt></dt>

      <dd>do cusku lo'u mi du do du ko'a le'u You express [quote]
      mi du do du ko'a [end quote]. You said, ``mi du do du
      ko'a''.</dd>
    </dl>
    selma'o LU (<a href="chapter19.html">Chapter 19</a>) 

    <p>Indicates the beginning of a quotation (a sumti) which is
    grammatical only if the quoted material also forms a
    grammatical Lojban text. Terminated by LIhU.</p>

    <dl>
      <dt></dt>

      <dd>mi cusku lu mi klama le zarci li'u I express [quote] I
      go-to the market [end quote].</dd>
    </dl>
    selma'o LUhU (<a href="chapter6.html">Chapter 6</a>) 

    <p>Elidable terminator for LAhE and NAhE+BO. Indicates the end
    of a qualified sumti.</p>

    <dl>
      <dt></dt>

      <dd>mi viska la'e lu barda gerku li'u lu'u I see
      the-referent-of [quote] big dog [end quote] [end ref] I saw
      ``Big Dog'' [not the words, but a book or movie].</dd>
    </dl>
    selma'o MAI (<a href="chapter18.html">Chapter 18</a>, <a
    href="chapter19.html">Chapter 19</a>) 

    <p>When suffixed to a number or string of letter words,
    produces a free modifier which serves as an index number within
    a text.</p>

    <dl>
      <dt></dt>

      <dd>pamai mi pu klama le zarci 1-thly, I [past] go to-the
      market. First, I went to the market.</dd>
    </dl>
    selma'o MAhO (<a href="chapter18.html">Chapter 18</a>) 

    <p>Produces a mathematical operator from a letter or other
    operand. See TEhU, VUhU.</p>

    <dl>
      <dt></dt>

      <dd>ma'o fy. boi xy. [operator] f x f(x)</dd>
    </dl>
    selma'o ME (<a href="chapter5.html">Chapter 5</a>, <a
    href="chapter18.html">Chapter 18</a>) 

    <p>Produces a tanru unit from a sumti, which is applicable to
    the things referenced by the sumti. See MEhU.</p>

    <dl>
      <dt></dt>

      <dd>ta me la ford. karce That is-a-Ford-type car That's a
      Ford car.</dd>
    </dl>
    selma'o MEhU (<a href="chapter5.html">Chapter 5</a>) 

    <p>The elidable terminator for ME. Indicates the end of a sumti
    converted to a tanru unit.</p>

    <dl>
      <dt></dt>

      <dd>ta me mi me'u zdani That's a me type of house.</dd>
    </dl>
    selma'o MOI (<a href="chapter5.html">Chapter 5</a>) 

    <p>Suffixes added to numbers or other quantifiers to make
    various numerically-based selbri.</p>

    <dl>
      <dt></dt>

      <dd>la djan. joi la frank. cu bruna remei John in-a-mass-with
      Frank are-a-brother-type-of twosome. John and Frank are two
      brothers.</dd>
    </dl>
    selma'o MOhE (<a href="chapter18.html">Chapter 18</a>) 

    <p>Produces a mathematical operand from a sumti; used to make
    dimensioned units. Terminated by TEhU.</p>

    <dl>
      <dt></dt>

      <dd>li mo'e re ratcu su'i mo'e re ractu du li mo'e vo danlu
      the-number two rats plus two rabbits equals the-number four
      animals 2 rats + 2 rabbits = 4 animals.</dd>
    </dl>
    selma'o MOhI (<a href="chapter10.html">Chapter 10</a>) 

    <p>A tense flag indicating movement in space, in a direction
    specified by a following FAhA cmavo.</p>

    <dl>
      <dt></dt>

      <dd>le verba mo'i ri'u cadzu le bisli The child [movement]
      [right] walks-on the ice. The child walks toward my right on
      the ice.</dd>
    </dl>
    selma'o NA (<a href="chapter14.html">Chapter 14</a>, <a
    href="chapter15.html">Chapter 15</a>) 

    <p>Contradictory negators, asserting that a whole bridi is
    false (or true).</p>

    <dl>
      <dt></dt>

      <dd>mi na klama le zarci It is not true that I go to the
      market.</dd>
    </dl>

    <p>Also used to construct logical connective compound
    cmavo.</p>

    <p>selma'o NAI (<a href="chapter14.html">Chapter 14</a>, <a
    href="chapter15.html">Chapter 15</a>)</p>

    <p>Negates the previous word, but can only be used with certain
    selma'o as specified by the grammar.</p>

    <p>selma'o NAhE (<a href="chapter15.html">Chapter 15</a>)</p>

    <p>Scalar negators, modifying a selbri or a sumti to a value
    other than the one stated, the opposite of the one stated, etc.
    Also used with following BO to construct a sumti qualifier; see
    LAhE.</p>

    <dl>
      <dt></dt>

      <dd>ta na'e blanu zdani That is-a-non- blue house. That is a
      house which is other than blue.</dd>
    </dl>
    selma'o NAhU (<a href="chapter18.html">Chapter 18</a>) 

    <p>Creates a mathematical operator from a selbri. See VUhU.</p>

    <dl>
      <dt></dt>

      <dd>li na'u tanjo te'u vei pai fe'i re [ve'o] du li ci'i
      the-number the-operator tangent ( pi / 2 ) = the-number
      infinity tan(pi/2) = infinity</dd>
    </dl>
    selma'o NIhE (<a href="chapter18.html">Chapter 18</a>) 

    <p>Creates a mathematical operand from a selbri, usually a
    ``ni'' abstraction. Terminated by TEhU.</p>

    <dl>
      <dt></dt>

      <dd>li ni'e ni clani [te'u] pi'i ni'e ni ganra [te'u] pi'i
      ni'e ni condi te'u du li ni'e ni canlu the-number quantity-of
      length times quantity-of width times quantity-of depth equals
      the-number quantity-of volume. Length x Width x Depth =
      Volume</dd>
    </dl>
    selma'o NIhO (<a href="chapter19.html">Chapter 19</a>) 

    <p>Marks the beginning of a new paragraph, and indicates
    whether it contains old or new subject matter.</p>

    <p>selma'o NOI (<a href="chapter8.html">Chapter 8</a>)</p>

    <p>Relative clause introducers. The following bridi modifies
    the preceding sumti. Terminated by KUhO. See GOI.</p>

    <dl>
      <dt></dt>

      <dd>le zdani poi blanu cu cmalu The house which is blue is
      small.</dd>
    </dl>
    selma'o NU (<a href="chapter11.html">Chapter 11</a>) 

    <p>Abstractors which, when prefixed to a bridi, create
    abstraction selbri. Terminated by KEI.</p>

    <dl>
      <dt></dt>

      <dd>la djan. cu djica le nu sonci [kei] John desires the
      event-of being-a-soldier.</dd>
    </dl>
    selma'o NUhA (<a href="chapter18.html">Chapter 18</a>) 

    <p>Creates a selbri from a mathematical operator. See VUhU.</p>

    <dl>
      <dt></dt>

      <dd>li ni'umu cu nu'a va'a li ma'umu the-number -5
      is-the-negation-of the-number +5</dd>
    </dl>
    selma'o NUhI (<a href="chapter14.html">Chapter 14</a>, <a
    href="chapter16.html">Chapter 16</a>) 

    <p>Marks the beginning of a termset, which is used to make
    simultaneous claims involving two or more different places of a
    selbri.</p>

    <dl>
      <dt></dt>

      <dd>mi klama nu'i le zarci le briju nu'u .e le zdani le ckule
      [nu'u] I go [start] to-the market from-the office [joint] and
      to-the house from-the school.</dd>
    </dl>
    selma'o NUhU (<a href="chapter14.html">Chapter 14</a>) 

    <p>Elidable terminator for NUhI. Marks the end of a termset,
    and is also used in the middle of one to mark the termset joint
    (a logical or non-logical connective).</p>

    <dl>
      <dt></dt>

      <dd>mi klama nu'i le zarci le briju nu'u .e le zdani le ckule
      [nu'u] I go [start] to-the market from-the office [joint] and
      to-the house from-the school.</dd>
    </dl>
    selma'o PA (<a href="chapter18.html">Chapter 18</a>) 

    <p>Digits and related quantifiers (some, all, many, etc.).</p>

    <dl>
      <dt></dt>

      <dd>mi speni re ninmu I am-married-to two women.</dd>
    </dl>
    selma'o PEhE (<a href="chapter14.html">Chapter 14</a>) 

    <p>Precedes a logical or non-logical connective that joins two
    termsets. Termsets (see CEhE) are used to associate several
    terms for logical connectives, for equal quantifier scope, or
    for special constructs in tenses.</p>

    <dl>
      <dt></dt>

      <dd>mi ce'e do pe'e je la djan. ce'e la djeimyz. cu pendo I
      [,] you [joint] and John [,] James are-friends-of. I am a
      friend of you, and John is a friend of James.</dd>
    </dl>
    selma'o PEhO (<a href="chapter18.html">Chapter 18</a>) 

    <p>An optional signal of forethought mathematical operators,
    which precede their operands. Terminated by KUhE.</p>

    <dl>
      <dt></dt>

      <dd>li vo du li pe'o su'i reboi re The-number four equals
      the-number [forethought] sum-of two two</dd>
    </dl>
    selma'o PU (<a href="chapter10.html">Chapter 10</a>) 

    <p>Specifies simple time directions (future, past, or
    neither).</p>

    <dl>
      <dt></dt>

      <dd>mi pu klama le zarci I [past] go-to the market. I went to
      the market.</dd>
    </dl>
    selma'o RAhO (<a href="chapter7.html">Chapter 7</a>) 

    <p>The pro-bridi update flag: changes the meaning of sumti
    implicitly attached to a pro-bridi (see GOhA) to fit the
    current context rather than the original context.</p>

    <dl>
      <dt></dt>

      <dd>A: mi ba lumci le mi karce B: mi go'i A: I [future] wash
      my car. B: I do-the-same (i.e. wash A's car). A: mi ba lumci
      le mi karce B: mi go'i ra'o A: I [future] wash my car. B: I
      do-the-corresponding-thing (i.e. wash B's car).</dd>
    </dl>
    selma'o ROI (<a href="chapter10.html">Chapter 10</a>) 

    <p>A particle which, when suffixed to a number, makes an
    extensional tense (e.g. once, twice, many times).</p>

    <dl>
      <dt></dt>

      <dd>mi reroi klama le zarci I twice go-to the market.</dd>
    </dl>
    selma'o SA (<a href="chapter19.html">Chapter 19</a>) 

    <p>A particle which erases the previous phrase or sentence.</p>

    <dl>
      <dt></dt>

      <dd>mi klama sa do klama le zarci I go, er, you go-to the
      market.</dd>
    </dl>
    selma'o SE (<a href="chapter5.html">Chapter 5</a>) 

    <p>Particles which convert a selbri, rearranging the order of
    places by exchanging the x1 place with a specified numbered
    place.</p>

    <dl>
      <dt></dt>

      <dd>le zarci se klama mi The market is-gone-to by me.</dd>
    </dl>

    <p>Also used in constructing connective and modal compound
    cmavo.</p>

    <p>selma'o SEI (<a href="chapter19.html">Chapter 19</a>)</p>

    <p>Marks the beginning of metalinguistic insertions which
    comment on the main bridi. Terminated by SEhU.</p>

    <dl>
      <dt></dt>

      <dd>la frank. prami sei gleki [se'u] la djein. Frank loves
      (he is happy) Jane.</dd>
    </dl>
    selma'o SEhU (<a href="chapter19.html">Chapter 19</a>) 

    <p>Elidable terminator for SEI and SOI. Ends metalinguistic
    insertions.</p>

    <dl>
      <dt></dt>

      <dd>la frank. prami sei gleki se'u la djein. Frank loves (he
      is happy) Jane.</dd>
    </dl>
    selma'o SI (<a href="chapter19.html">Chapter 19</a>) 

    <p>A particle which erases the previous single word.</p>

    <dl>
      <dt></dt>

      <dd>mi si do klama le zarci I, er, you go to-the market.</dd>
    </dl>
    selma'o SOI (<a href="chapter7.html">Chapter 7</a>) 

    <p>Marks reciprocity between two sumti (like ``vice versa'' in
    English).</p>

    <dl>
      <dt></dt>

      <dd>mi prami do soi mi I love you [reciprocally] me. I love
      you and vice versa.</dd>
    </dl>
    selma'o SU (<a href="chapter19.html">Chapter 19</a>) 

    <p>A particle which closes and erases the entire previous
    discourse.</p>

    <p>selma'o TAhE (<a href="chapter10.html">Chapter 10</a>)</p>

    <p>A tense modifier specifying frequencies within an interval
    of time or space (regularly, habitually, etc.).</p>

    <dl>
      <dt></dt>

      <dd>le verba ta'e klama le ckule The child habitually goes
      to-the school.</dd>
    </dl>
    selma'o TEI (<a href="chapter17.html">Chapter 17</a>) 

    <p>Signals the beginning of a compound letter word, which acts
    grammatically like a single letter. Compound letter words end
    with the non-elidable selma'o FOI.</p>

    <dl>
      <dt></dt>

      <dd>tei .ebu .akut. bu foi ( ``e'' ``acute'' ) the letter
      ``e'' with an acute accent</dd>
    </dl>
    selma'o TEhU (<a href="chapter18.html">Chapter 18</a>) 

    <p>Elidable terminator for JOhI, MAhO, MOhE, NAhU, or NIhE.
    Marks the end of a mathematical conversion construct.</p>

    <dl>
      <dt></dt>

      <dd>li jo'i paboi reboi te'u su'i jo'i ciboi voboi du li jo'i
      voboi xaboi the-number array( one, two ) plus array( three,
      four) equals the-number array( four, six) (1,2) + (3,4) =
      (4,6)</dd>
    </dl>
    selma'o TO (<a href="chapter19.html">Chapter 19</a>) 

    <p>Left discursive parenthesis: allows inserting a digression.
    Terminated by TOI.</p>

    <dl>
      <dt></dt>

      <dd>doi lisas. mi djica le nu to doi frank. ko sisti toi do
      viska le mlatu O Lisa, I desire the event-of ( O Frank,
      [imperative] stop! ) you see the cat. Lisa, I want you to
      (Frank! Stop!) see the cat.</dd>
    </dl>
    selma'o TOI (<a href="chapter19.html">Chapter 19</a>) 

    <p>Elidable terminator for TO. The right discursive
    parenthesis.</p>

    <dl>
      <dt></dt>

      <dd>doi lisas. mi djica le nu to doi frank. ko sisti toi do
      viska le mlatu O Lisa, I desire the event-of ( O Frank,
      [imperative] stop! ) you see the cat. Lisa, I want you to
      (Frank! Stop!) see the cat.</dd>
    </dl>
    selma'o TUhE (<a href="chapter19.html">Chapter 19</a>) 

    <p>Groups multiple sentences or paragraphs into a logical unit.
    Terminated by TUhU.</p>

    <dl>
      <dt></dt>

      <dd>xagmau zo'u tu'e ganai cidja gi cnino .i ganai vanju gi
      tolci'o [tu'u] is-best : [start] If food, then new. If wine,
      then old. As for what is best: if food, then new [is best];
      if wine, then old [is best].</dd>
    </dl>
    selma'o TUhU (<a href="chapter19.html">Chapter 19</a>) 

    <p>Logical terminator for TUhE. Marks the end of a multiple
    sentence group.</p>

    <p>selma'o UI (<a href="chapter13.html">Chapter 13</a>)</p>

    <p>Particles which indicate the speaker's emotional state or
    source of knowledge, or the present stage of discourse.</p>

    <dl>
      <dt></dt>

      <dd>.ui la djan. klama [Happiness!] John is-coming. Hurrah!
      John is coming!</dd>
    </dl>
    selma'o VA (<a href="chapter10.html">Chapter 10</a>) 

    <p>A tense indicating distance in space (near, far, or
    neither).</p>

    <dl>
      <dt></dt>

      <dd>le nanmu va batci le gerku The man [medium distance]
      bites the dog. Over there the man is biting the dog.</dd>
    </dl>
    selma'o VAU (<a href="chapter14.html">Chapter 14</a>) 

    <p>Elidable terminator for a simple bridi, or for each
    bridi-tail of a GIhA logical connection.</p>

    <dl>
      <dt></dt>

      <dd>mi dunda le cukta [vau] gi'e lebna lo rupnu vau do [vau]
      I (give the book) and (take some currency-units) to/from
      you.</dd>
    </dl>
    selma'o VEI (<a href="chapter18.html">Chapter 18</a>) 

    <p>Left mathematical parenthesis: groups mathematical
    operations. Terminated by VEhO.</p>

    <dl>
      <dt></dt>

      <dd>li vei ny. su'i pa ve'o pi'i vei ny. su'i pa [ve'o] du li
      ny. [bo] te'a re su'i re bo pi'i ny. su'i pa the-number (
      ``n'' plus one ) times ( ``n'' plus one ) equals the-number
      n-power-two plus two-times-``n'' plus 1 $(n + 1)(n + 1) =
      n<sup>2</sup> + 2n + 1$</dd>
    </dl>
    selma'o VEhA (<a href="chapter10.html">Chapter 10</a>) 

    <p>A tense indicating the size of an interval in space (long,
    medium, or short).</p>

    <p>selma'o VEhO (<a href="chapter19.html">Chapter 19</a>)</p>

    <p>Elidable terminator for VEI: right mathematical
    parenthesis.</p>

    <dl>
      <dt></dt>

      <dd>li vei ny. su'i pa ve'o pi'i vei ny. su'i pa [ve'o] du li
      ny. [bo] te'a re su'i re bo pi'i ny. su'i pa the-number (
      ``n'' plus one ) times ( ``n'' plus one ) equals the-number
      n-power-two plus two-times-``n'' plus 1 $(n + 1)(n + 1) =
      n<sup>2</sup> + 2n + 1$</dd>
    </dl>
    selma'o VIhA (<a href="chapter10.html">Chapter 10</a>) 

    <p>A tense indicating dimensionality in space (line, plane,
    volume, or space-time interval).</p>

    <dl>
      <dt></dt>

      <dd>le verba ve'a vi'a cadzu le bisli The child [medium space
      interval] [2-dimensional] walks-on the ice. In a medium-sized
      area, the child walks on the ice.</dd>
    </dl>
    selma'o VUhO (<a href="chapter8.html">Chapter 8</a>) 

    <p>A mechanism for attaching relative clauses or phrases to a
    whole (possibly connected) sumti, rather than simply to the
    leftmost portion of the sumti.</p>

    <dl>
      <dt></dt>

      <dd>la frank. ce la djordj. vu'o noi gidva cu zvati le kumfa
      Frank [in-set-with] George, which are-guides, are-in the
      room. Frank and George, who are guides, are in the room.</dd>
    </dl>
    selma'o VUhU (<a href="chapter18.html">Chapter 18</a>) 

    <p>Mathematical operators (e.g. $+$, $-$). See MAhO.</p>

    <dl>
      <dt></dt>

      <dd>li mu vu'u re du li ci The-number 5 minus 2 equals
      the-number 3. 5 - 2 = 3</dd>
    </dl>
    selma'o XI (<a href="chapter18.html">Chapter 18</a>) 

    <p>The subscript marker: the following number or lerfu string
    is a subscript for whatever precedes it.</p>

    <dl>
      <dt></dt>

      <dd>xy. xi re x sub 2 $x<sub>2</sub>$</dd>
    </dl>
    selma'o Y (<a href="chapter19.html">Chapter 19</a>) 

    <p>Hesitation noise: content-free, but holds the floor or
    continues the conversation. It is different from silence in
    that silence may be interpreted as having nothing more to
    say.</p>

    <dl>
      <dt></dt>

      <dd>doi .y. .y. djan O, uh, uh, John!</dd>
    </dl>
    selma'o ZAhO (<a href="chapter10.html">Chapter 10</a>) 

    <p>A tense modifier specifying the contour of an event (e.g.
    beginning, ending, continuing).</p>

    <dl>
      <dt></dt>

      <dd>mi pu'o damba I [inchoative] fight. I'm on the verge of
      fighting.</dd>
    </dl>
    selma'o ZEI (<a href="chapter4.html">Chapter 4</a>) 

    <p>A morphological glue word, which joins the two words it
    stands between into the equivalent of a lujvo.</p>

    <dl>
      <dt></dt>

      <dd>ta xy. zei kantu kacma That is-an-(X - ray) camera That
      is an X-ray camera.</dd>
    </dl>
    selma'o ZEhA (<a href="chapter10.html">Chapter 10</a>) 

    <p>A tense indicating the size of an interval in time (long,
    medium, or short).</p>

    <dl>
      <dt></dt>

      <dd>mi puze'a citka I [past] [short interval] eat. I ate for
      a little while.</dd>
    </dl>
    selma'o ZI (<a href="chapter10.html">Chapter 10</a>) 

    <p>A tense indicating distance in time (a long, medium or short
    time ago or in the future).</p>

    <dl>
      <dt></dt>

      <dd>mi puzi citka I [past] [short distance] eat. I ate a
      little while ago.</dd>
    </dl>
    selma'o ZIhE (<a href="chapter8.html">Chapter 8</a>) 

    <p>Joins multiple relative phrases or clauses which apply to
    the same sumti. Although it is generally translated with
    ``and'', it is not considered a logical connective.</p>

    <dl>
      <dt></dt>

      <dd>mi ponse pa gerku ku poi blabi zi'e noi mi prami ke'a I
      own one dog such-that it-is-white and such-that-incidentally
      I love it. I own a dog that is white and which, incidentally,
      I love. I own a white dog, which I love.</dd>
    </dl>
    selma'o ZO (<a href="chapter19.html">Chapter 19</a>) 

    <p>Single-word quotation: quotes the following single Lojban
    word.</p>

    <dl>
      <dt></dt>

      <dd>zo si cu lojbo valsi The-word ``si'' is-a-Lojbanic
      word.</dd>
    </dl>
    selma'o ZOI (<a href="chapter19.html">Chapter 19</a>) 

    <p>Non-Lojban quotation: quotes any text using a delimiting
    word (which can be any single Lojban word) placed before and
    after the text. The delimiting word must not appear in the
    text, and must be separated from the text by pauses.</p>

    <dl>
      <dt></dt>

      <dd>zoi kuot. Socrates is mortal .kuot. cu glico jufra
      The-text `` Socrates is mortal '' is-an-English
      sentence.</dd>
    </dl>
    selma'o ZOhU (<a href="chapter16.html">Chapter 16</a>, <a
    href="chapter19.html">Chapter 19</a>) 

    <p>Separates a logical prenex from a bridi or group of
    sentences to which it applies. Also separates a topic from a
    comment in topic/comment sentences.</p>

    <dl>
      <dt></dt>

      <dd>su'o da poi remna ro da poi finpe zo'u da prami de
      For-at-least-one X which is-a-man, for-all Ys which are-fish
      : X loves Y There is a man who loves all fish. </dd>
    </dl>

    <hr />
    
    <p>Última modificación: Mon Jun 27 23:13:26 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
