
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//ES" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 19</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter19.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 19<br />
      Putting It All Together: Notes on the Structure of Lojban
      Texts</h2>

      <h6>$Revision: 4.3 $<br />
      mkhtml: 1.1</h6>
      <br />
      <br />
    </div>

    <p></p>

    <h3><a id="s1" name="s1">1. Introductory</h3>

    <p>This chapter is incurably miscellaneous. It describes the
    cmavo that specify the structure of Lojban texts, from the
    largest scale (paragraphs) to the smallest (single words).
    There are fewer examples than are found in other chapters of
    this book, since the linguistic mechanisms described are
    generally made use of in conversation or else in long
    documents.</p>

    <p>This chapter is also not very self-contained. It makes
    passing reference to a great many concepts which are explained
    in full only in other chapters. The alternative would be a
    chapter on text structure which was as complex as all the other
    chapters put together. Lojban is a unified language, and it is
    not possible to understand any part of it (in full) before
    understanding every part of it (to some degree).</p>

    <p></p>

    <h3><a id="s2" name="s2">2. Sentences: I</h3>

    <p>The following cmavo are discussed in this section:</p>

    <p></p>
<pre>
       .i  I   sentence separator
</pre>
    Since Lojban is audio-visually isomorphic, there needs to be a
    spoken and written way of signaling the end of a sentence and
    the start of the following one. In written English, a period
    serves this purpose; in spoken English, a tone contour (rising
    or falling) usually does the job, or sometimes a long pause.
    Lojban uses a single separator: the cmavo ``.i'' (of selma'o
    I): 
<pre>
<a id="e2d1"
name="e2d1">2.1)</a>  mi klama le zarci .i do cadzu le bisli
    I go to-the store.  You walk on-the ice.
</pre>
    The word ``separator'' should be noted. ``.i'' is not normally
    used after the last sentence nor before the first one, although
    both positions are technically grammatical. ``.i'' signals a
    new sentence on the same topic, not necessarily by the same
    speaker. The relationship between the sentences is left vague,
    except in stories, where the relationship usually is temporal,
    and the following sentence states something that happened after
    the previous sentence. 

    <p>Note that although the first letter of an English sentence
    is capitalized, the cmavo ``.i'' is never capitalized. In
    writing, it is appropriate to place extra space before ``.i''
    to make it stand out better for the reader. In some styles of
    Lojban writing that have been used so far, every ``.i'' is
    placed at the beginning of a line, possibly leaving space at
    the end of the previous line.</p>

    <p>An ``.i'' cmavo may or may not be used when the speaker of
    the following sentence is different from the speaker of the
    preceding sentence, depending on whether the sentences are felt
    to be connected or not.</p>

    <p>An ``.i'' cmavo can be compounded with a logical or
    non-logical connective (a jek or joik), a modal or tense
    connective, or both: these constructs are explained in <a
    href="chapter9.html">Chapter 9</a>, <a href="chapter10.html">Chapter
    10</a>, and <a href="chapter14.html">Chapter 14</a>. In all cases,
    the ``.i'' comes first in the compound. Attitudinals can also
    be attached to an ``.i'' if they are meant to apply to the
    whole sentence: see <a href="chapter13.html">Chapter 13</a>.</p>

    <p>There exist a pair of mechanisms for binding a sequence of
    sentences closely together. If the ``.i'' (with or without
    connectives) is followed by ``bo'' (of selma'o BO), then the
    two sentences being separated are understood to be more closely
    grouped than sentences connected by ``.i'' alone.</p>

    <p> Similarly, a group of sentences can be preceded by ``tu'e'' (of
    selma'o TUhE) and followed by ``tu'u'' (of selma'o TUhU) to fuse
    them into a single unit. A common use of ``tu'e ... tu'u'' is to
    group the sentences which compose a poem: the title sentence would
    precede the group, separated from it by ``.i''. Another use might be
    a set of directions, where each numbered direction might be
    surrounded by ``tu'e ... tu'u'' and contain one or more sentences
    separated by ``.i''. Grouping with ``tu'e'' and ``tu'u'' is
    analogous to grouping with ``ke'' and ``ke'e'' to establish the
    scope of logical or non-logical connectives (see <a
    href="chapter14.html">Chapter 14</a>).</p>

    <p></p>

    <h3><a id="s3" name="s3">3. Paragraphs: NIhO</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ni'o    NIhO    new topic
    no'i    NIhO    old topic
    da'o    DAhO    cancel cmavo assignments
</pre>

    <p>The paragraph is a concept used in writing systems for two
    purposes: to indicate changes of topic, and to break up the
    hard-to-read appearance of large blocks of text on the page.
    The former function is represented in both spoken and written
    Lojban by the cmavo ``ni'o'' and ``no'i'', both of selma'o
    NIhO. Of these two, ``ni'o'' is the more common. By convention,
    written Lojban is broken into paragraphs just before any
    ``ni'o'' or ``no'i'', but a very long passage on a single topic
    might be paragraphed before an ``.i''. On the other hand, it is
    conventional in English to start a new paragraph in dialogue
    when a new speaker starts, but this convention is not commonly
    observed in Lojban dialogues. Of course, none of these
    conventions affect meaning in any way.</p>

    <p>A ``ni'o'' can take the place of an ``.i'' as a sentence
    separator, and in addition signals a new topic or paragraph.
    Grammatically, any number of ``ni'o'' cmavo can appear
    consecutively and are equivalent to a single one; semantically,
    a greater number of ``ni'o'' cmavo indicates a larger-scale
    change of topic. This feature allows complexly structured text,
    with topics, subtopics, and sub-subtopics, to be represented
    clearly and unambiguously in both spoken and written Lojban.
    However, some conventional differences do exist between
    ``ni'o'' in writing and in conversation.</p>

    <p>In written text, a single ``ni'o'' is a mere discursive
    indicator of a new subject, whereas ``ni'oni'o'' marks a change
    in the context. In this situation, ``ni'oni'o'' implicitly
    cancels the definitions of all pro-sumti of selma'o KOhA as
    well as pro-bridi of selma'o GOhA. (Explicit cancelling is
    expressed by the cmavo ``da'o'' of selma'o DAhO, which has the
    free grammar of an indicator -- it can appear almost anywhere.)
    The use of ``ni'oni'o'' does not affect indicators (of selma'o
    UI) or tense references, but ``ni'oni'oni'o'', indicating a
    drastic change of topic, would serve to reset both indicators
    and tenses. (See <a href="#s8">Section 8</a> for a discussion
    of indicator scope.)</p>

    <p>In spoken text, which is inherently less structured, these
    levels are reduced by one, with ``ni'o'' indicating a change in
    context sufficient to cancel pro-sumti and pro-bridi
    assignment. On the other hand, in a book, or in stories within
    stories such as ``The Arabian Nights'', further levels may be
    expressed by extending the ``ni'o'' string as needed. Normally,
    a written text will begin with the number of ``ni'o'' cmavo
    needed to signal the largest scale division which the text
    contains. ``ni'o'' strings may be subscripted to label each
    context of discourse: see <a href="#s6">Section 6</a>.</p>

    <p>``no'i'' is similar in effect to ``ni'o'', but indicates the
    resumption of a previous topic. In speech, it is analogous to
    (but much shorter than) such English discursive phrases as
    ``But getting back to the point ... ''. By default, the topic
    resumed is that in effect before the last ``ni'o''. When
    subtopics are nested within topics, then ``no'i'' would resume
    the previous subtopic and ``no'ino'i'' the previous topic. Note
    that ``no'i'' also resumes tense and pro-sumti assignments
    dropped at the previous ``ni'o''.</p>

    <p>If a ``ni'o'' is subscripted, then a ``no'i'' with the same
    subscript is assumed to be a continuation of it. A ``no'i'' may
    also have a negative subscript, which would specify counting
    backwards a number of paragraphs and resuming the topic found
    thereby.</p>

    <p></p>

    <h3><a id="s4" name="s4">4. Topic-comment sentences: ZOhU</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   zo'u    ZOhU    topic/comment separator
</pre>

    <p>The normal Lojban sentence is just a bridi, parallel to the
    normal English sentence which has a subject and a
    predicate:</p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  mi klama le zarci
    I went to the market
</pre>
    In Chinese, the normal sentence form is different: a topic is
    stated, and a comment about it is made. (Japanese also has the
    concept of a topic, but indicates it by attaching a suffix;
    other languages also distinguish topics in various ways.) The
    topic says what the sentence is about: 

    <p></p>
<pre>
<a id="e4d2"
name="e4d2">4.2)</a>  zhe<sup>4</sup> xiao<sup>1</sup>xi<sup>2</sup>   wo<sup>3</sup> zhi<sup>1</sup>dao le
    this news   I know [perfective]
    As for this news, I knew it.
    I've heard this news already.
</pre>
    The wide space in the first two versions of <a
    href="#e4d2">Example 4.2</a> separate the topic (``this news'')
    from the comment (``I know already''). 

    <p>Lojban uses the cmavo ``zo'u'' (of selma'o ZOhU) to separate
    topic (a sumti) from comment (a bridi):</p>
<pre>
<a id="e4d3" name="e4d3">4.3)</a>  le nuzba zo'u mi ba'o djuno
    The news : I [perfective] know.
</pre>
    <a href="#e4d3">Example 4.3</a> is the literal Lojban
    translation of <a href="#e4d2">Example 4.2</a>. Of course, the
    topic-comment structure can be changed to a straightforward
    bridi structure: 
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  mi ba'o djuno le nuzba
    I [perfective] know the news.
</pre>
    <a href="#e4d4">Example 4.4</a> means the same as <a
    href="#e4d3">Example 4.3</a>, and it is simpler. However, often
    the position of the topic in the place structure of the selbri
    within the comment is vague: 

    <p></p>
<pre>
<a id="e4d5" name="e4d5">4.5)</a>  le finpe zo'u citka
    the fish : eat
</pre>

    <p>Is the fish eating or being eaten? The sentence doesn't say.
    The Chinese equivalent of <a href="#e4d5">Example 4.5</a>
    is:</p>
<pre>
<a id="e4d6" name="e4d6">4.6)</a>  yu<sup>2</sup> chi<sup>1</sup>
    fish   eat
</pre>
    which is vague in exactly the same way. 

    <p>Grammatically, it is possible to have more than one sumti
    before ``zo'u''. This is not normally useful in topic-comment
    sentences, but is necessary in the other use of ``zo'u'': to
    separate a quantifying section from a bridi containing
    quantified variables. This usage belongs to a discussion of
    quantifier logic in Lojban (see <a href="chapter16.html">Chapter
    16</a>), but an example would be:</p>
<pre>
<a id="e4d7" name="e4d7">4.7)</a>  roda poi prenu ku'o su'ode zo'u
        de patfu da
    for-all X which-are-persons, there-exists-a-Y such-that
        Y is the father of X.
    Every person has a father.
</pre>

    <p>The string of sumti before ``zo'u'' (called the ``prenex'':
    see <a href="chapter16.html">Chapter 16</a>) may contain both a
    topic and bound variables:</p>
<pre>
<a id="e4d8" name="e4d8">4.8)</a>  loi patfu
        roda poi prenu ku'o su'ode zo'u
        de patfu da
    for-the-mass-of fathers
        for-all X which-are-persons, there-exists-a-Y such-that
        Y is the father of X.
    As for fathers, every person has one.
</pre>
    To specify a topic which affects more than one sentence, wrap
    the sentences in ``tu'e ... tu'u'' brackets and place the topic
    and the ``zo'u'' directly in front. This is the exception to
    the rule that a topic attaches directly to a sentence: 
<pre>
<a id="e4d9"
name="e4d9">4.9)</a>  loi jdini zo'u tu'e do ponse .inaja do djica [tu'u]
    the-mass-of money :  ( [if] you possess, then you want )
    Money: if you have it, you want it.
</pre>

    <p>Note: In Lojban, you do not ``want money''; you ``want to
    have money'' or something of the sort, as the x2 place of
    ``djica'' demands an event. As a result, the straightforward
    rendering of <a href="#e4d8">Example 4.8</a> without a topic is
    not:</p>
<pre>
<a id="e4d10"
name="e4d10">4.10)</a>    do ponse loi jdini .inaja do djica ri
    You possess money only-if you desire its-mere-existence
</pre>
    where ``ri'' means ``loi jdini'' and is interpreted as ``the
    mere existence of money'', but rather: 
<pre>
<a id="e4d11"
name="e4d11">4.11)</a>    do ponse loi jdini .inaja do djica tu'a ri
    You possess money only-if you desire something-about it
</pre>
    namely, the possession of money. But topic-comment sentences
    like <a href="#e4d9">Example 4.9</a> are inherently vague, and
    this difference between ``ponse'' (which expects a physical
    object in x2) and ``djica'' is ignored. See <a
    href="#e9d3">Example 9.3</a> for another topic/comment
    sentence. 

    <p>The subject of an English sentence is often the topic as
    well, but in Lojban the sumti in the x1 place is not
    necessarily the topic, especially if it is the normal
    (unconverted) x1 for the selbri. Thus Lojban sentences don't
    necessarily have a ``subject'' in the English sense.</p>

    <p></p>

    <h3><a id="s5" name="s5">5. Questions and answers</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   xu  UI  truth question
    ma  KOhA    sumti question
    mo  GOhA    bridi question
    xo  PA  number question
    ji  A   sumti connective question
    ge'i    GA  forethought connective question
    gi'i    GIhA    bridi-tail connective question
    gu'i    GUhA    tanru forethought connective question
    je'i    JA  tanru connective question
    pei UI  attitude question
    fi'a    FA  place structure question
    cu'e    CUhE    tense/modal question
    pau UI  question premarker
</pre>
    Lojban questions are not at all like English questions. There
    are two basic types: truth questions, of the form ``Is it true
    that ... '', and fill-in-the-blank questions. Truth questions
    are marked by preceding the bridi, or following any part of it
    specifically questioned, with the cmavo ``xu'' (of selma'o UI):
    
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  xu do klama le zarci
    [True or false?] You go to the store
    Are you going to the store/Did you go to the store?
</pre>
    (Since the Lojban is tenseless, either colloquial translation
    might be correct.) Truth questions are further discussed in <a
    href="chapter15.html">Chapter 15</a>. 

    <p>Fill-in-the-blank questions have a cmavo representing some
    Lojban word or phrase which is not known to the questioner, and
    which the answerer is to supply. There are a variety of cmavo
    belonging to different selma'o which provide different kinds of
    blanks.</p>

    <p>Where a sumti is not known, a question may be formed with
    ``ma'' (of selma'o KOhA), which is a kind of pro-sumti:</p>
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  ma klama le zarci
    [What sumti?] goes-to the store
    Who is going to the store?
</pre>

    <p>Of course, the ``ma'' need not be in the x1 place:</p>
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  do klama ma
    You go-to [what sumti?]
    Where are you going?
</pre>

    <p>The answer is a simple sumti:</p>
<pre>
<a id="e5d4" name="e5d4">5.4)</a>  le zarci
    The store.
</pre>

    <p>A sumti, then, is a legal utterance, although it does not by
    itself constitute a bridi -- it does not claim anything, but
    merely completes the open-ended claim of the previous
    bridi.</p>

    <p>There can be two ``ma'' cmavo in a single question:</p>
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  ma klama ma
    Who goes where?
</pre>
    and the answer would be two sumti, which are meant to fill in
    the two ``ma'' cmavo in order: 
<pre>
<a id="e5d6" name="e5d6">5.6)</a>  mi le zarci
    I, to the store.
</pre>
    An even more complex example, depending on the non-logical
    connective ``fa'u'' (of selma'o JOI), which is like the English
    ``and ... respectively'': 
<pre>
<a id="e5d7" name="e5d7">5.7)</a>  ma fa'u ma klama ma fa'u ma
    Who and who goes where and where, respectively?
</pre>

    <p>An answer might be</p>

    <p></p>
<pre>
<a id="e5d8"
name="e5d8">5.8)</a>  la djan. la marcas. le zarci le briju
    John, Marsha, the store, the office.
    John and Marsha go to the store and the office,
        respectively.
</pre>
    (Note: A mechanical substitution of <a href="#e5d8">Example
    5.8</a> into <a href="#e5d7">Example 5.7</a> produces an
    ungrammatical result, because ``* ... le zarci fa'u le briju''
    is ungrammatical Lojban: the first ``le zarci'' has to be
    closed with its proper terminator ``ku'', for reasons explained
    in <a href="chapter14.html">Chapter 14</a>. This effect is not
    important: Lojban behaves as if all elided terminators have
    been supplied in both question and answer before inserting the
    latter into the former. The exchange is grammatical if question
    and answer are each separately grammatical.) 

    <p>Questions to be answered with a selbri are expressed with
    ``mo'' of selma'o GOhA, which is a kind of pro-bridi:</p>
<pre>
<a id="e5d9" name="e5d9">5.9)</a>  la lojban. mo
    Lojban [what selbri?]
    What is Lojban?
</pre>
    Here the answerer is to supply some predicate which is true of
    Lojban. Such questions are extremely open-ended, due to the
    enormous range of possible predicate answers. The answer might
    be just a selbri, or might be a full bridi, in which case the
    sumti in the answer override those provided by the questioner.
    To limit the range of a ``mo'' question, make it part of a
    tanru. 

    <p>Questions about numbers are expressed with ``xo'' of selma'o
    PA:</p>
<pre>
<a id="e5d10" name="e5d10">5.10)</a>    do viska xo prenu
    You saw [what number?] persons.
    How many people did you see?
</pre>

    <p>The answer would be a simple number, another kind of
    non-bridi utterance:</p>
<pre>
<a id="e5d11" name="e5d11">5.11)</a>    vomu
    Forty-five.
</pre>

    <p>Fill-in-the-blank questions may also be asked about: logical
    connectives (using cmavo ``ji'' of A, ``ge'i'' of GA, ``gi'i''
    of GIhA, ``gu'i'' of GUhA, or ``je'i'' of JA, and receiving an
    ek, gihek, ijek, or ijoik as an answer) --- see <a
    href="chapter14.html">Chapter 14</a>; attitudes (using ``pei'' of
    UI, and receiving an attitudinal as an answer) --- see <a
    href="chapter13.html">Chapter 13</a>; place structures (using
    ``fi'a'' of FA, and receiving a cmavo of FA as an answer) ---
    see <a href="chapter9.html">Chapter 9</a>; tenses and modals
    (using ``cu'e'' of CUhE, and receiving any tense or BAI cmavo
    as an answer) --- see <a href="chapter9.html">Chapter 9</a> and <a
    href="chapter10.html">Chapter 10</a>.</p>

    <p>Questions can be marked by placing ``pau'' (of selma'o UI)
    before the question bridi. See <a href="chapter13.html">Chapter
    13</a> for details.</p>

    <p>The full list of non-bridi utterances suitable as answers to
    questions is:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>any number of sumti (with elidable terminator ``vau'',
      see <a href="chapter6.html">Chapter 6</a>) an ek or gihek
      (logical connectives, see <a href="chapter14.html">Chapter
      14</a>) a number, or any mathematical expression placed in
      parentheses (see <a href="chapter18.html">Chapter 18</a>) a bare
      ``na'' negator (to negate some previously expressed bridi),
      or corresponding ``ja'a'' affirmer (see <a
      href="chapter15.html">Chapter 15</a>) a relative clause (to
      modify some previously expressed sumti, see <a
      href="chapter8.html">Chapter 8</a>) a prenex/topic (to modify
      some previously expressed bridi, see <a
      href="chapter16.html">Chapter 16</a>) linked arguments
      (beginning with ``be'' or ``bei'' and attached to some
      previously expressed selbri, often in a description,see <a
      href="chapter5.html">Chapter 5</a>)</dd>
    </dl>

    <p>At the beginning of a text, the following non-bridi are also
    permitted:</p>

    <dl>
      <dt></dt>

      <dd>one or more names (to indicate direct address without
      ``doi'', see <a href="chapter6.html">Chapter 6</a>) indicators
      (to express a prevailing attitude, see <a
      href="chapter13.html">Chapter 13</a>) ``nai'' (to vaguely negate
      something or other, see <a href="chapter15.html">Chapter
      15</a>)</dd>
    </dl>

    <p>Where not needed for the expression of answers, most of
    these are made grammatical for pragmatic reasons: people will
    say them in conversation, and there is no reason to rule them
    out as ungrammatical merely because most of them are vague.</p>

    <p></p>

    <h3><a id="s6" name="s6">6. Subscripts: XI</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   xi  XI  subscript
</pre>
    The cmavo ``xi'' (of selma'o XI) indicates that a subscript (a
    number, a lerfu string, or a parenthesized mekso) follows.
    Subscripts can be attached to almost any construction and are
    placed following the construction (or its terminator word,
    which is generally required). They are useful either to extend
    the finite cmavo list to infinite length, or to make more
    refined distinctions than the standard cmavo list permits. The
    remainder of this section mentions some places where subscripts
    might naturally be used. 

    <p>Lojban gismu have at most five places:</p>
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  mi cu klama le zarci le zdani
        le dargu le karce
    I go to-the market from-the house
        via-the road using-the car.
</pre>

    <p>Consequently, selma'o SE (which operates on a selbri to
    change the order of its places) and selma'o FA (which provides
    place number tags for individual sumti) have only enough
    members to handle up to five places. Conversion of <a
    href="#e6d1">Example 6.1</a>, using ``xe'' to swap the x1 and
    x5 places, would produce:</p>
<pre>
<a id="e6d2" name="e6d2">6.2)</a>  le karce cu xe klama le zarci
        le zdani le dargu mi
    The car is-a-transportation-means to-the market
        from-the house via-the road for-me.
</pre>

    <p>And reordering of the place structures might produce:</p>
<pre>
<a id="e6d3"
name="e6d3">6.3)</a>  fo le dargu fi le zdani fa mi fe le zarci
        fu le karce cu klama
    Via the road, from the house, I, to the market,
        using-the car, go.
</pre>
    <a href="#e6d1">Examples 6.1</a> to <a href="#e6d3">6.3</a>
    all mean the same thing. But consider the lujvo ``nunkla'',
    formed by applying the abstraction operator ``nu'' to
    ``klama'': 
<pre>
<a id="e6d4" name="e6d4">6.4)</a>  la'edi'u cu nunkla
        mi le zarci le zdani
        le dargu le karce
    The-referent-of-the-previous-sentence is-an-event-of-going
        by-me to-the market from-the house
        via-the road using-the car.
</pre>
    <a href="#e6d4">Example 6.4</a> shows that ``nunkla'' has six
    places: the five places of ``klama'' plus a new one (placed
    first) for the event itself. Performing transformations similar
    to that of <a href="#e6d2">Example 6.2</a> requires an
    additional conversion cmavo that exchanges the x1 and x6
    places. The solution is to use any cmavo of SE with a
    subscript: 
<pre>
<a id="e6d5" name="e6d5">6.5)</a>  le karce cu sexixa nunkla
        mi le zarci le zdani le dargu
        la'edi'u
    The car is-a-transportation-means-in-the-event-of-going
        by-me to-the market via-the road
        which-is-referred-to-by-the-last-sentence.
</pre>

    <p>Likewise, a sixth place tag can be created by using any
    cmavo of FA with a subscript:</p>
<pre>
<a id="e6d6" name="e6d6">6.6)</a>   fu le dargu fo le zdani fe mi
        fa la'edi'u fi le zarci
        faxixa le karce cu klama
    Via the road, from the house, by me,
        the-referent-of-the-last-sentence, to the market,
        using the car, is-an-event-of-going.
</pre>
    <a href="#e6d4">Examples 6.4</a> to <a href="#e6d6">6.6</a>
    also all mean the same thing, and each is derived
    straightforwardly from any of the others, despite the tortured
    nature of the English glosses. In addition, any other member of
    SE or FA could be substituted into ``sexixa'' and ``faxixa''
    without change of meaning: ``vexixa'' means the same thing as
    ``sexixa''. 

    <p>Lojban provides two groups of pro-sumti, both belonging to
    selma'o KOhA. The ko'a-series cmavo are used to refer to
    explicitly specified sumti to which they have been bound using
    ``goi''. The da-series, on the other hand, are existentially or
    universally quantified variables. (These concepts are explained
    more fully in <a href="chapter16.html">Chapter 16</a>.) There are
    ten ko'a-series cmavo and 3 da-series cmavo available.</p>

    <p>If more are required, any cmavo of the ko'a-series or the
    da-series can be subscripted:</p>
<pre>
<a id="e6d7" name="e6d7">6.7)</a>  daxivo
    X sub 4
</pre>
    is the 4th bound variable of the 1st sequence of the da-series,
    and 
<pre>
<a id="e6d8" name="e6d8">6.8)</a>  ko'ixipaso
    something-3 sub 18
</pre>
    is the 18th free variable of the 3rd sequence of the
    ko'a-series. This convention allows 10 sequences of ko'a-type
    pro-sumti and 3 sequences of da-type pro-sumti, each with
    arbitrarily many members. Note that ``daxivo'' and ``dexivo''
    are considered to be distinct pro-sumti, unlike the situation
    with ``sexixa'' and ``vexixa'' above. Exactly similar treatment
    can be given to the bu'a-series of selma'o GOhA and to the
    gismu pro-bridi ``broda'', ``brode'', ``brodi'', ``brodo'', and
    ``brodu''. 

    <p>Subscripts on lerfu words are used in the standard
    mathematical way to extend the number of variables:</p>
<pre>
<a id="e6d9"
name="e6d9">6.9)</a>  li xy.boixipa du li xy.boixire su'i xy.boixici
    The-number x-sub-1 equals the-number x-sub-2 plus x-sub-3
    $x<sub>1</sub>  = x<sub>2</sub>  + x<sub>3</sub>$
</pre>
    and can be used to extend the number of pro-sumti as well,
    since lerfu strings outside mathematical contexts are
    grammatically and semantically equivalent to pro-sumti of the
    ko'a-series. (In <a href="#e6d9">Example 6.9</a>, note the
    required terminator ``boi'' after each ``xy.'' cmavo; this
    terminator allows the subscript to be attached without
    ambiguity.) 

    <p>Names, which are similar to pro-sumti, can also be
    subscripted to distinguish two individuals with the same
    name:</p>
<pre>
<a id="e6d10"
name="e6d10">6.10)</a>    la djan. xipa cusku lu mi'enai do li'u la djan. xire
    John<sub>1</sub> expresses ``I-am-not you'' to John<sub>2</sub>.
</pre>
    Subscripts on tenses allow talking about more than one time or
    place that is described by the same general cmavo. For example,
    ``puxipa'' could refer to one point in the past, and ``puxire''
    a second point (earlier or later). 

    <p>You can place a subscript on the word ``ja'a'', the bridi
    affirmative of selma'o NA, to express so-called fuzzy truths.
    The usual machinery for fuzzy logic (statements whose truth
    value is not merely ``true'' or ``false'', but is expressed by
    a number in the range 0 to 1) in Lojban is the abstractor
    ``jei'':</p>
<pre>
<a id="e6d11" name="e6d11">6.11)</a>    li pimu jei mi ganra
    The-number .5 is-the-truth-value-of my being-broad
</pre>

    <p>However, by convention we can attach a subscript to ``ja'a''
    to indicate fuzzy truth (or to ``na'' if we change the
    amount):</p>
<pre>
<a id="e6d12" name="e6d12">6.12)</a>    mi ja'a xipimu ganra
    I truly-sub-.5 am-broad
</pre>
    Finally, as mentioned in <a href="#s2">Section 2</a>, ``ni'o''
    and ``no'i'' cmavo with matching subscripts mark the start and
    the continuation of a given topic respectively. Different
    topics can be assigned to different subscripts. 

    <p>Other uses of subscripts will doubtless be devised in
    future.</p>

    <p></p>

    <h3><a id="s7" name="s7">7. Utterance ordinals: MAI</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   mai MAI utterance ordinal, -thly
    mo'o    MAI higher order utterance ordinal
</pre>
    Numerical free modifiers, corresponding to English ``firstly'',
    ``secondly'', and so on, can be created by suffixing ``mai'' or
    ``mo'o'' of selma'o MAI to a number or a lerfu string. Here are
    some examples: 
<pre>
<a id="e7d1"
name="e7d1">7.1)</a>  mi klama pamai le zarci .e remai le zdani
    I go-to (firstly) the store and (secondly) the market.
</pre>

    <p>This does not imply that I go to the store before I go to
    the market: that meaning requires a tense. The sumti are simply
    numbered for convenience of reference. Like other free
    modifiers, the utterance ordinals can be inserted almost
    anywhere in a sentence without affecting its grammar or its
    meaning.</p>

    <p>Any of the Lojban numbers can be used with MAI: ``romai'',
    for example, means ``all-thly'' or ``lastly''. Likewise, if you
    are enumerating a long list and have forgotten which number is
    wanted next, you can say ``ny.mai'', or ``Nthly''.</p>

    <p>The difference between ``mai'' and ``mo'o'' is that ``mo'o''
    enumerates larger subdivisions of a text; ``mai'' was designed
    for lists of numbered items, whereas ``mo'o'' was intended to
    subdivide structured works. If this chapter were translated
    into Lojban, it might number each section with ``mo'o'': this
    section would then be introduced with ``zemo'o'', or ``<a
    href="#s7">Section 7</a>.''</p>

    <h3><a id="s8" name="s8">8. Attitude scope markers: FUhE/FUhO</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   fu'e    FUhE    open attitudinal scope
    fu'o    FUhO    close attitudinal scope
</pre>
    Lojban has a complex system of ``attitudinals'', words which
    indicate the speaker's attitude to what is being said. The
    attitudinals include indicators of emotion, intensity markers,
    discursives (which show the structure of discourse), and
    evidentials (which indicate ``how the speaker knows''). Most of
    these words belong to selma'o UI; the intensity markers belong
    to selma'o CAI for historical reasons, but the two selma'o are
    grammatically identical. The individual cmavo of UI and CAI are
    discussed in <a href="chapter13.html">Chapter 13</a>; only the
    rules for applying them in discourse are presented here. 

    <p>Normally, an attitudinal applies to the preceding word only.
    However, if the preceding word is a structural cmavo which
    begins or ends a whole construction, then that whole
    construction is affected by the attitudinal:</p>
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  mi viska le blanu .ia zdani [ku]
    I see the blue [belief] house.
    I see the house, which I believe to be blue.

<a id="e8d2"
name="e8d2">8.2)</a>   mi viska le blanu zdani .ia [ku]
    I see the blue house [belief].
    I see the blue thing, which I believe to be a house.

<a id="e8d3"
name="e8d3">8.3)</a>   mi viska le .ia blanu zdani [ku]
    I see the [belief] blue house
    I see what I believe to be a blue house.

<a id="e8d4" name="e8d4">8.4)</a>   mi viska le blanu zdani ku .ia
    I see (the blue house ) [belief]
    I see what I believe to be a blue house.
</pre>

    <p>An attitudinal meant to cover a whole sentence can be
    attached to the preceding ``.i'', expressed or understood:</p>
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  [.i] .ia mi viska le blanu zdani
    [belief] I see the blue house
    I believe I see a blue house.
</pre>
    or to an explicit ``vau'' placed at the end of a bridi. 

    <p>Likewise, an attitudinal meant to cover a whole paragraph
    can be attached to ``ni'o'' or ``no'i''. An attitudinal at the
    beginning of a text applies to the whole text.</p>

    <p>However, sometimes it is necessary to be more specific about
    the range of one or more attitudinals, particularly if the
    range crosses the boundaries of standard Lojban syntactic
    constructions. The cmavo ``fu'e'' (of selma'o FUhE) and
    ``fu'o'' (of selma'o FUhO) provide explicit scope markers.
    Placing ``fu'e'' in front of an attitudinal disconnects it from
    what precedes it, and instead says that it applies to all
    following words until further notice. The notice is given by
    ``fu'o'', which can appear anywhere and cancels all in-force
    attitudinals. For example:</p>
<pre>
<a id="e8d6"
name="e8d6">8.6)</a>  mi viska le fu'e .ia blanu zdani fu'o ponse
    I see the [start] [belief] blue house [end] possessor
    I see the owner of what I believe to be a blue house.
</pre>

    <p>Here, only the ``blanu zdani'' portion of the three-part
    tanru ``blanu zdani ponse'' is marked as a belief of the
    speaker. Naturally, the attitudinal scope markers do not affect
    the rules for interpreting multi-part tanru: ``blanu zdani''
    groups first because tanru group from left to right unless
    overridden with ``ke'' or ``bo''.</p>

    <p>Other attitudinals of more local scope can appear after
    attitudinals marked by FUhE; these attitudinals are added to
    the globally active attitudinals rather than superseding
    them.</p>

    <p></p>

    <h3><a id="s9" name="s9">9. Quotations: LU, LIhU, LOhU, LEhU</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   lu  LU  begin quotation
    li'u    LIhU    end quotation
    lo'u    LOhU    begin error quotation
    le'u    LEhU    end error quotation
</pre>

    <p>Grammatically, quotations are very simple in Lojban: all of
    them are sumti, and they all mean something like ``the piece of
    text here quoted'':</p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  mi pu cusku lu mi'e djan [li'u]
    I [past] express [quote] I-am John [unquote]
    I said, ``I'm John''.
</pre>

    <p>But in fact there are four different flavors of quotation in
    the language, involving six cmavo of six different selma'o.
    This being the case, quotation deserves some elaboration.</p>

    <p>The simplest kind of quotation, exhibited in <a
    href="#e9d1">Example 9.1</a>, uses the cmavo ``lu'' (of selma'o
    LU) as the opening quotation mark, and the cmavo ``li'u'' (of
    selma'o LIhU) as the closing quotation mark. The text between
    ``lu'' and ``li'u'' must be a valid, parseable Lojban text. If
    the quotation is ungrammatical, so is the surrounding
    expression. The cmavo ``li'u'' is technically an elidable
    terminator, but it's almost never possible to elide it except
    at the end of text.</p>

    <p>The cmavo ``lo'u'' (of selma'o LOhU) and ``le'u'' (of
    selma'o LEhU) are used to surround a quotation that is not
    necessarily grammatical Lojban. However, the text must consist
    of morphologically correct Lojban words (as defined in <a
    href="chapter4.html">Chapter 4</a>), so that the ``le'u'' can be
    picked out reliably. The words need not be meaningful, but they
    must be recognizable as cmavo, brivla, or cmene. Quotation with
    ``lo'u'' is essential to quoting ungrammatical Lojban for
    teaching in the language, the equivalent of the * that is used
    in English to mark such errors:</p>
<pre>
<a id="e9d2" name="e9d2">9.2)</a>  lo'u mi du do du la djan. le'u
        na tergerna la lojban.
    [quote] mi du do du la djan. [unquote]
        is-not a-grammatical-structure-in Lojban.
</pre>
    <a href="#e9d2">Example 9.2</a> is grammatical even though the
    embedded quotation is not. Similarly, ``lo'u'' quotation can
    quote fragments of a text which themselves do not constitute
    grammatical utterances: 
<pre>
<a id="e9d3"
name="e9d3">9.3)</a>  lu le mlatu cu viska le finpe li'u zo'u
        lo'u viska le le'u
        cu selbasti .ei
        lo'u viska lo le'u
    [quote] le mlatu cu viska le finpe [unquote] :
        [quote] viska le [unquote]
        is-replaced-by [obligation!]
        [quote] viska lo [unquote].
    In the sentence ``le mlatu viska le finpe'',
        ``viska le'' should be replaced by ``viska lo''.
</pre>

    <p>Note the topic-comment formulation (<a href="#s4">Section
    4</a>) and the indicator applying to the selbri only (<a
    href="#s8">Section 8</a>). Neither ``viska le'' nor ``viska
    lo'' is a valid Lojban utterance, and both require ``lo'u''
    quotation.</p>

    <p>Additionally, pro-sumti or pro-bridi in the quoting sentence
    can refer to words appearing in the quoted sentence when ``lu
    ... li'u'' is used, but not when ``lo'u ... le'u'' is used:</p>
<pre>
<a id="e9d4"
name="e9d4">9.4)</a>  la tcarlis. cusku lu le ninmu cu morsi li'u
        .iku'i ri jmive
    Charlie says [quote] the woman is-dead [unquote].
        However, the-last-mentioned is-alive.
    Charlie says ``The woman is dead'', but she is alive.
</pre>

    <p>In <a href="#e9d4">Example 9.4</a>, ``ri'' is a pro-sumti
    which refers to the most recent previous sumti, namely ``le
    ninmu''. Compare:</p>
<pre>
<a id="e9d5"
name="e9d5">9.5)</a>  la tcarlis. cusku lo'u le ninmu cu morsi le'u
        .iku'i ri jmive
    Charlie says [quote] le ninmu cu morsi [unquote].
        However, the-last-mentioned is-alive.
    Charlie says ``le ninmu cu morsi'', but he is alive.
</pre>
    In <a href="#e9d5">Example 9.5</a>, ``ri'' cannot refer to the
    referent of the alleged sumti ``le ninmu'', because ``le ninmu
    cu morsi'' is a mere uninterpreted sequence of Lojban words.
    Instead, ``ri'' ends up referring to the referent of the sumti
    ``la tcarlis.'', and so it is Charlie who is alive. 

    <p>The metalinguistic erasers ``si'', ``sa'', and ``su'',
    discussed in <a href="#s13">Section 13</a>, do not operate in
    text between ``lo'u'' and ``le'u''. Since the first ``le'u''
    terminates a ``lo'u'' quotation, it is not directly possible to
    have a ``lo'u'' quotation within another ``lo'u'' quotation.
    However, it is possible for a ``le'u'' to occur within a ``lo'u
    ... le'u'' quotation by preceding it with the cmavo ``zo'',
    discussed in <a href="#s10">Section 10</a>. Note that ``le'u''
    is not an elidable terminator; it is required.</p>

    <h3><a id="s10" name="s10">10. More on quotations: ZO, ZOI</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   zo  ZO  quote single word
    zoi ZOI non-Lojban quotation
    la'o    ZOI non-Lojban name
</pre>
    The cmavo ``zo'' (of selma'o ZO) is a strong quotation mark for
    the single following word, which can be any Lojban word
    whatsoever. Among other uses, ``zo'' allows a metalinguistic
    word to be referenced without having it act on the surrounding
    text. The word must be a morphologically legal (but not
    necessarily meaningful) single Lojban word; compound cmavo are
    not permitted. For example: 
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    zo si cu lojbo valsi
    ``si'' is a Lojbanic word.
</pre>

    <p>Since ``zo'' acts on a single word only, there is no
    corresponding terminator. Brevity, then, is a great advantage
    of ``zo'', since the terminators for other kinds of quotation
    are rarely or never elidable.</p>

    <p>The cmavo ``zoi'' (of selma'o ZOI) is a quotation mark for
    quoting unlexable (non-Lojban) text. Its syntax is ``zoi X.
    text .X'', where X is a Lojban word (called the delimiting
    word) which is separated from the quoted text by pauses, and
    which is not found in the written text or spoken phoneme
    stream. It is common, but not required, to use the lerfu word
    (of selma'o BY) which corresponds to the Lojban name of the
    language being quoted:</p>
<pre>
<a id="e10d2"
name="e10d2">10.2)</a>    zoi gy. John is a man .gy. cu glico jufra
    ``John is a man'' is an English sentence.
</pre>
    where ``gy'' stands for ``glico''. Other popular choices of
    delimiting words are ``.kuot.'', a Lojban name which sounds
    like the English word ``quote'', and the word ``zoi'' itself.
    Another possibility is a Lojban word suggesting the topic of
    the quotation. 

    <p>Within written text, the Lojban written word used as a
    delimiting word may not appear, whereas within spoken text, the
    sound of the delimiting word may not be uttered. This leads to
    occasional breakdowns of audio-visual isomorphism: <a
    href="#e10d3">Example 10.3</a> is fine in speech but
    ungrammatical as written, whereas <a href="#e10d4">Example
    10.4</a> is correct when written but ungrammatical in
    speech.</p>
<pre>
<a id="e10d3"
name="e10d3">10.3)</a>    ?mi djuno fi le valsi po'u zoi gy. gyrations .gy.
    I know about the word which-is ``gyrations''.

<a id="e10d4"
name="e10d4">10.4)</a> ?mi djuno fi le valsi po'u zoi jai. gyrations .jai
    I know about the word which-is ``gyrations''.
</pre>

    <p>The text ``gy'' appears in the written word ``gyrations'',
    whereas the sound represented in Lojban by ``jai'' appears in
    the spoken word ``gyrations''. Such borderline cases should be
    avoided as a matter of good style.</p>

    <p>It should be noted particularly that ``zoi'' quotation is
    the only way to quote rafsi, specifically CCV rafsi, because
    they are not Lojban words, and ``zoi'' quotation is the only
    way to quote things which are not Lojban words. (CVC and CVV
    rafsi look like names and cmavo respectively, and so can be
    quoted using other methods.) For example:</p>
<pre>
<a id="e10d5"
name="e10d5">10.5)</a>    zoi ry. sku .ry. cu rafsi zo cusku
    ``sku'' is a rafsi of ``cusku''.
</pre>
    (A minor note on interaction between ``lo'u ... le'u'' and
    ``zoi'': The text between ``lo'u'' and ``le'u'' should consist
    of Lojban words only. In fact, non-Lojban material in the form
    of a ``zoi'' quotation may also appear. However, if the word
    ``le'u'' is used either as the delimiting word for the ``zoi''
    quotation, or within the quotation itself, the outer ``lo'u''
    quotation will be prematurely terminated. Therefore, ``le'u''
    should be avoided as the delimiting word in any ``zoi''
    quotation.) 

    <p>Lojban strictly avoids any confusion between things and the
    names of things:</p>
<pre>
<a id="e10d6" name="e10d6">10.6)</a>    zo .bab. cmene la bab.
    The-word ``Bob'' is-the-name-of the-one-named Bob.
</pre>
    In <a href="#e10d6">Example 10.6</a>, ``zo .bab.'' is the word,
    whereas ``la bab.'' is the thing named by the word. The cmavo
    ``la'e'' and ``lu'e'' (of selma'o LAhE) convert back and forth
    between references and their referents: 
<pre>
<a id="e10d7"
name="e10d7">10.7)</a>    zo .bab. cmene la'e zo .bab.
    The-word ``Bob'' is-the-name-of
        the-referent-of the-word ``Bob''.

<a id="e10d8" name="e10d8">10.8)</a> lu'e la bab. cmene la bab.
    A-symbol-for Bob is-the-name-of Bob.
</pre>
    <a href="#e10d6">Examples 10.6</a> through <a
    href="#e10d8">10.8</a> all mean approximately the same thing,
    except for differences in emphasis. <a href="#e10d9">Example
    10.9</a> is different: 
<pre>
<a id="e10d9" name="e10d9">10.9)</a>    la bab. cmene la bab.
    Bob is the name of Bob.
</pre>
    and says that Bob is both the name and the thing named, an
    unlikely situation. People are not names. 

    <p>(In <a href="#e10d6">Examples 10.6</a> through <a
    href="#e10d7">10.7</a>, the name ``bab.'' was separated from a
    preceding ``zo'' by a pause, thus: ``zo .bab.''. The reason for
    this extra pause is that all Lojban names must be separated by
    pause from any preceding word other than ``la'', ``lai'',
    ``la'i'' (all of selma'o LA) and ``doi'' (of selma'o DOI).
    There are numerous other cmavo that may precede a name: of
    these, ``zo'' is one of the most common.)</p>

    <p>The cmavo ``la'o'' also belongs to selma'o ZOI, and is
    mentioned here for completeness, although it does not signal
    the beginning of a quotation. Instead, ``la'o'' serves to mark
    non-Lojban names, especially the Linnaean binomial names (such
    as ``Homo sapiens'') which are the internationally standardized
    names for species of animals and plants. Internationally known
    names which can more easily be recognized by spelling rather
    than pronunciation, such as ``Goethe'', can also appear in
    Lojban text with ``la'o'':</p>
<pre>
<a id="e10d10"
name="e10d10">10.10)</a>  la'o dy. Goethe .dy. cu me la'o ly. Homo sapiens .ly.
    Goethe is a Homo sapiens.
</pre>
    Using ``la'o'' for all names rather than Lojbanizing, however,
    makes for very cumbersome text. A rough equivalent of ``la'o''
    might be ``la me zoi''. 

    <p></p>

    <h3><a id="s11" name="s11">11. Contrastive emphasis: BAhE</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ba'e    BAhE    emphasize next word
    za'e    BAhE    next word is nonce
</pre>

    <p>English often uses strong stress on a word to single it out
    for contrastive emphasis, thus</p>
<pre>
<a id="e11d1" name="e11d1">11.1)</a>    I saw George.
</pre>
    is quite different from 
<pre>
<a id="e11d2" name="e11d2">11.2)</a>    I saw <i>George</i>.
</pre>

    <p>The heavy stress on ``<i>George</i>'' (represented in
    writing by <i>italics</i>) indicates that I saw George rather
    than someone else. Lojban does not use stress in this way:
    stress is used only to help separate words (because every
    brivla is stressed on the penultimate syllable) and in names to
    match other languages' stress patterns. Note that many other
    languages do not use stress in this way either; typically word
    order is rearranged, producing something like</p>
<pre>
<a id="e11d4" name="e11d4">11.4)</a>    It was George whom I saw.
</pre>
    In Lojban, the cmavo ``ba'e'' (of selma'o BAhE) precedes a
    single word which is to be emphasized: 
<pre>
<a id="e11d4.5" name="e11d4.5">11.4.5)</a>    mi viska la ba'e .djordj.
    I saw the-one-named [emphasis] ``George''.
    I saw <i>George</i>.
</pre>

    <p>Note the pause before the name ``djordj.'', which serves to
    separate it unambiguously from the ``ba'e''. Alternatively, the
    ``ba'e'' can be moved to a position before the ``la'', which in
    effect emphasizes the whole construct ``la djordj.'':</p>
<pre>
<a id="e11d5" name="e11d5">11.5)</a>    mi viska ba'e la djordj.
    I saw [emphasis] the-one-named ``George''.
    I saw <i>George</i>.
</pre>
    Marking a word with a cmavo of BAhE does not change the word's
    grammar in any way. Any word in a bridi can receive contrastive
    emphasis marking: 
<pre>
<a id="e11d6" name="e11d6">11.6)</a>    ba'e mi viska la djordj.
    I, no one else, saw George.

<a id="e11d7" name="e11d7">11.7)</a> mi ba'e viska la djordj.
    I saw (not heard or smelled) George.
</pre>

    <p>Emphasis on one of the structural components of a Lojban
    bridi can also be achieved by rearranging it into an order that
    is not the speaker's or writer's usual order. Any sumti moved
    out of place, or the selbri when moved out of place, is
    emphatic to some degree.</p>

    <p>For completeness, the cmavo ``za'e'' should be mentioned,
    also of selma'o BAhE. It marks a word as possibly irregular,
    non-standard, or nonce (created for the occasion):</p>

    <p></p>
<pre>
<a id="e11d8"
name="e11d8">11.8)</a>    mi klama la za'e. .albeinias
    I go-to so-called Albania
</pre>
    marks a Lojbanization of an English name, where a more
    appropriate standard form might be something like ``la
    ctiipyris.'', reflecting the country's name in Albanian. 

    <p>Before a lujvo or fu'ivla, ``za'e'' indicates that the word
    has been made up on the spot and may be used in a sense that is
    not found in the unabridged dictionary (when we have an
    unabridged dictionary!).</p>

    <p></p>

    <h3><a id="s12" name="s12">12. Parenthesis and metalinguistic commentary: TO, TOI,
    SEI</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   to  TO  open parenthesis
    to'i    TO  open editorial parenthesis
    toi TOI close parenthesis
    sei SEI metalinguistic bridi marker
</pre>
    The cmavo ``to'' and ``toi'' are discursive (non-mathematical)
    parentheses, for inserting parenthetical remarks. Any text
    whatsoever can go within the parentheses, and it is completely
    invisible to its context. It can, however, refer to the context
    by the use of pro-sumti and pro-bridi: any that have been
    assigned in the context are still assigned in the parenthetical
    remarks, but the reverse is not true. 
<pre>
<a id="e12d1" name="e12d1">12.1)</a>     doi lisas. mi djica le nu
        to doi frank. ko sisti toi
        do viska le mlatu
    O Lisa, I desire the event-of
        ( O Frank, [imperative] stop! )
        you see the cat.
    Lisa, I want you to (Frank! Stop!) see the cat.
</pre>
    <a href="#e12d1">Example 12.1</a> implicitly redefines ``do''
    within the parentheses: the listener is changed by ``doi
    frank.'' When the context sentence resumes, however, the old
    listener, Lisa, is automatically restored. 

    <p>There is another cmavo of selma'o TO: ``to'i''. The
    difference between ``to'' and ``to'i'' is the difference
    between parentheses and square brackets in English prose.
    Remarks within ``to ... toi'' cmavo are implicitly by the same
    speaker, whereas remarks within ``to'i ... toi'' are implicitly
    by someone else, perhaps an editor:</p>
<pre>
<a id="e12d2"
name="e12d2">12.2)</a>    la frank. cusku lu mi prami do
        to'isa'a do du la djein. toi li'u
    Frank expresses ``I love you
        [you = Jane]''
</pre>
    The ``sa'a'' suffix is a discursive cmavo (of selma'o UI)
    meaning ``editorial insertion'', and indicating that the marked
    word or construct (in this case, the entire bracketed remark)
    is not part of the quotation. It is required whenever the
    ``to'i ... toi'' remark is physically within quotation marks,
    at least when speaking to literal-minded listeners; the
    convention may be relaxed if no actual confusion results. 

    <p>Note: The parser believes that parentheses are attached to
    the previous word or construct, because it treats them as
    syntactic equivalents of subscripts and other such so-called
    ``free modifiers''. Semantically, however, parenthetical
    remarks are not necessarily attached either to what precedes
    them or what follows them.</p>

    <p>The cmavo ``sei'' (of selma'o SEI) begins an embedded
    discursive bridi. Comments added with ``sei'' are called
    ``metalinguistic'', because they are comments about the
    discourse itself rather than about the subject matter of the
    discourse. This sense of the term ``metalinguistic'' is used
    throughout this chapter, and is not to be confused with the
    sense ``language for expressing other languages''.</p>

    <p>When marked with ``sei'', a metalinguistic utterance can be
    embedded in another utterance as a discursive. In this way,
    discursives which do not have cmavo assigned in selma'o UI can
    be expressed:</p>
<pre>
<a id="e12d3"
name="e12d3">12.3)</a>    la frank. prami sei la frank. gleki la djein.
    Frank loves (Frank is happy) Jane.
</pre>

    <p>Using the happiness attitudinal, ``.ui'', would imply that
    the speaker was happy. Instead, the speaker attributes
    happiness to Frank. It would probably be safe to elide the one
    who is happy, and say:</p>
<pre>
<a id="e12d4"
name="e12d4">12.4)</a>    la frank. prami sei gleki la djein.
    Frank loves (he is happy) Jane.
</pre>

    <p>The grammar of the bridi following ``sei'' has an unusual
    limitation: the sumti must either all precede the selbri, or
    must be glued into the selbri with ``be'' and ``bei'':</p>

    <p></p>
<pre>
<a id="e12d5"
name="e12d5">12.5)</a>    la frank. prami sei gleki be fa la suzn. la djein.
    Frank loves (Susan is happy) Jane.
</pre>

    <p>This restriction allows the terminator cmavo ``se'u'' to
    almost always be elided.</p>

    <p>Since a discursive utterance is working at a ``higher''
    level of abstraction than a non-discursive utterance, a
    non-discursive utterance cannot refer to a discursive
    utterance. Specifically, the various back-counting, reciprocal,
    and reflexive constructs in selma'o KOhA ignore the utterances
    at ``higher'' metalinguistic levels in determining their
    referent. It is possible, and sometimes necessary, to refer to
    lower metalinguistic levels. For example, the English ``he
    said'' in a conversation is metalinguistic. For this purpose,
    quotations are considered to be at a lower metalinguistic level
    than the surrounding context (a quoted text cannot refer to the
    statements of the one who quotes it), whereas parenthetical
    remarks are considered to be at a higher level than the
    context.</p>

    <p>Lojban works differently from English in that the ``he
    said'' can be marked instead of the quotation. In Lojban, you
    can say:</p>

    <p></p>
<pre>
<a id="e12d6"
name="e12d6">12.6)</a>    la djan. cusku lu mi klama le zarci li'u
    John expresses ``I go to-the store''.
</pre>
    which literally claims that John uttered the quoted text. If
    the central claim is that John made the utterance, as is likely
    in conversation, this style is the most sensible. However, in
    written text which quotes a conversation, you don't want the
    ``he said'' or ``she said'' to be considered part of the
    conversation. If unmarked, it could mess up the anaphora
    counting. Instead, you can use: 
<pre>
<a id="e12d7" name="e12d7">12.7)</a>    lu mi klama le zarci
        seisa'a la djan. cusku be dei li'u
    `` I go to-the store
        ( John expresses this-sentence ) ''
    ``I go to the store'', said John.
</pre>

    <p>And of course other orders are possible:</p>
<pre>
<a id="e12d8"
name="e12d8">12.8)</a>    lu seisa'a la djan. cusku be dei mi klama le zarci
    John said, ``I go to the store''.

<a id="e12d9"
name="e12d9">12.9)</a> lu mi klama seisa'a la djan cusku le zarci
    ``I go'', John said, ``to the store''.
</pre>

    <p>Note the ``sa'a'' following each ``sei'', marking the
    ``sei'' and its attached bridi as an editorial insert, not part
    of the quotation. In a more relaxed style, these ``sa'a'' cmavo
    would probably be dropped.</p>

    <p>The elidable terminator for ``sei'' is ``se'u'' (of selma'o
    SEhU); it is rarely needed, except to separate a selbri within
    the ``sei'' comment from an immediately following selbri (or
    component) outside the comment.</p>

    <p></p>

    <h3><a id="s13" name="s13">13. Erasure: SI, SA, SU</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   si  SI  erase word
    sa  SA  erase phrase
    su  SU  erase discourse
</pre>
    The cmavo ``si'' (of selma'o SI) is a metalinguistic operator
    that erases the preceding word, as if it had never been spoken:
    
<pre>
<a id="e13d1" name="e13d1">13.1)</a>    ti gerku si mlatu
    This is-a-dog, er, is-a-cat.
</pre>
    means the same thing as ``ti mlatu''. Multiple ``si'' cmavo in
    succession erase the appropriate number of words: 
<pre>
<a id="e13d2"
name="e13d2">13.2)</a>    ta blanu zdani si si xekri zdani
    That is-a-blue house, er, er, is-a-black house.
</pre>
    In order to erase the word ``zo'', it is necessary to use three
    ``si'' cmavo in a row: 
<pre>
<a id="e13d3"
name="e13d3">13.3)</a>    zo .bab. se cmene zo si si si la bab.
    The-word ``Bob'' is-the-name-of the word ``si'', er, er, Bob.
</pre>

    <p>The first use of ``si'' does not erase anything, but
    completes the ``zo'' quotation. Two more ``si'' cmavo are then
    necessary to erase the first ``si'' and the ``zo''.</p>

    <p>Incorrect names can likewise cause trouble with ``si'':</p>

    <p></p>
<pre>
<a id="e13d4" name="e13d4">13.4)</a>    mi tavla fo la .esperanto
        si si .esperanton.
    I talk in-language that-named ``and'' ``speranto'',
        er, er, Esperanto.
</pre>

    <p>The Lojbanized spelling ``.esperanto'' breaks up, as a
    consequence of the Lojban morphology rules (see <a
    href="chapter4.html">Chapter 4</a>) into two Lojban words, the
    cmavo ``.e'' and the undefined fu'ivla ``speranto''. Therefore,
    two ``si'' cmavo are needed to erase them. Of course, ``.e
    speranto'' is not grammatical after ``la'', but recognition of
    ``si'' is done before grammatical analysis.</p>

    <p>Even more messy is the result of an incorrect ``zoi'':</p>
<pre>
<a id="e13d5" name="e13d5">13.5)</a>    mi cusku zoi fy. gy. .fy.
        si si si si zo .djan
    I express [foreign] [quote] ``sy'' [unquote],
        er, er, er, er, ``John''.
</pre>

    <p>In <a href="#e13d5">Example 13.5</a>, the first ``fy'' is
    taken to be the delimiting word. The next word must be
    different from the delimiting word, and ``gy.'', the Lojban
    name for the letter ``g'', was chosen arbitrarily. Then the
    delimiting word must be repeated. For purposes of ``si''
    erasure, the entire quoted text is taken to be a word, so four
    words have been uttered, and four more ``si'' cmavo are needed
    to erase them altogether. Similarly, a stray ``lo'u'' quotation
    mark must be erased with ``fy. le'u si si si'', by completing
    the quotation and then erasing it all with three ``si''
    cmavo.</p>

    <p>What if less than the entire ``zo'' or ``zoi'' construct is
    erased? The result is something which has a loose ``zo'' or
    ``zoi'' in it, without its expected sequels, and which is
    incurably ungrammatical. Thus, to erase just the word quoted by
    ``zo'', it turns out to be necessary to erase the ``zo'' as
    well:</p>
<pre>
<a id="e13d6" name="e13d6">13.6)</a>    mi se cmene zo .djan.
        si si zo .djordj.
    I am-named-by the-word ``John'',
        er, er, the-word ``George''.
</pre>

    <p>The parser will reject ``zo .djan. si .djordj.'', because in
    that context ``djordj.'' is a name (of selma'o CMENE) rather
    than a quoted word.</p>

    <p>Note: The current machine parser does not implement ``si''
    erasure.</p>

    <p>As the above examples plainly show, precise erasures with
    ``si'' can be extremely hard to get right. Therefore, the cmavo
    ``sa'' (of selma'o SA) is provided for erasing more than one
    word. The cmavo following ``sa'' should be the starting marker
    of some grammatical construct. The effect of the ``sa'' is to
    erase back to and including the last starting marker of the
    same kind. For example:</p>
<pre>
<a id="e13d7"
name="e13d7">13.7)</a>    mi viska le sa .i mi cusku zo .djan.
    I see the  ...  I say the-word ``John''.
</pre>

    <p>Since the word following ``sa'' is ``.i'', the sentence
    separator, its effect is to erase the preceding sentence. So <a
    href="#e13d7">Example 13.7</a> is equivalent to:</p>
<pre>
<a id="e13d8" name="e13d8">13.8)</a>    mi cusku zo .djan.
</pre>

    <p>Another example, erasing a partial description rather than a
    partial sentence:</p>
<pre>
<a id="e13d9"
name="e13d9">13.9)</a>    mi viska le blanu zdan. sa le xekri zdani
    I see the blue hou ...  the black house.
</pre>

    <p>In <a href="#e13d9">Example 13.9</a>, ``le blanu zdan.'' is
    ungrammatical, but clearly reflects the speaker's original
    intention to say ``le blanu zdani''. However, the ``zdani'' was
    cut off before the end and changed into a name. The entire
    ungrammatical ``le'' construct is erased and replaced by ``le
    xekri zdani''.</p>

    <p>Note: The current machine parser does not implement ``sa''
    erasure. Getting ``sa'' right is even more difficult (for a
    computer) than getting ``si'' right, as the behavior of ``si''
    is defined in terms of words rather than in terms of
    grammatical constructs (possibly incorrect ones) and words are
    conceptually simpler entities. On the other hand, ``sa'' is
    generally easier for human beings, because the rules for using
    it correctly are less finicky.</p>

    <p>The cmavo ``su'' (of selma'o SU) is yet another
    metalinguistic operator that erases the entire text. However,
    if the text involves multiple speakers, then ``su'' will only
    erase the remarks made by the one who said it, unless that
    speaker has said nothing. Therefore ``susu'' is needed to
    eradicate a whole discussion in conversation.</p>

    <p>Note: The current machine parser does not implement either
    ``su'' or ``susu'' erasure.</p>

    <p></p>

    <h3><a id="s14" name="s14">14. Hesitation: Y</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   .y. Y   hesitation noise
</pre>
    Speakers often need to hesitate to think of what to say next or
    for some extra-linguistic reason. There are two ways to
    hesitate in Lojban: to pause between words (that is, to say
    nothing) or to use the cmavo ``.y.'' (of selma'o Y). This
    resembles in sound the English hesitation noise written ``uh''
    (or ``er''), but differs from it in the requirement for pauses
    before and after. Unlike a long pause, it cannot be mistaken
    for having nothing more to say: it holds the floor for the
    speaker. Since vowel length is not significant in Lojban, the
    ``y'' sound can be dragged out for as long as necessary.
    Furthermore, the sound can be repeated, provided the required
    pauses are respected. 

    <p>Since the hesitation sound in English is outside the formal
    language, English-speakers may question the need for a formal
    cmavo. Speakers of other languages, however, often hesitate by
    saying (or, if necessary, repeating) a word (``este'' in some
    dialects of Spanish, roughly meaning ``that is''), and Lojban's
    audio-visual isomorphism requires a written representation of
    all meaningful spoken behavior. Of course, ``.y.'' has no
    grammatical significance: it can appear anywhere at all in a
    Lojban sentence except in the middle of a word.</p>

    <p></p>

    <h3><a id="s15" name="s15">15. No more to say: FAhO</h3>

    <p>The following cmavo is discussed in this section:</p>
<pre>
   fa'o    FAhO    end of text
</pre>
    The cmavo ``fa'o'' (of selma'o FAhO) is the usually omitted
    marker for the end of a text; it can be used in computer
    interaction to indicate the end of input or output, or for
    explicitly giving up the floor during a discussion. It is
    outside the regular grammar, and the machine parser takes it as
    an unconditional signal to stop parsing unless it is quoted
    with ``zo'' or with ``lo'u ... le'u''. In particular, it is not
    used at the end of subordinate texts quoted with ``lu ...
    li'u'' or parenthesized with ``to ... toi''. 

    <p></p>

    <h3><a id="s16" name="s16">16. List of cmavo interactions</h3>

    <p>The following list gives the cmavo and selma'o that are
    recognized by the earliest stages of the parser, and specifies
    exactly which of them interact with which others. All of the
    cmavo are at least mentioned in this chapter. The cmavo are
    written in lower case, and the selma'o in UPPER CASE.</p>

    <p>``zo'' quotes the following word, no matter what it is.</p>

    <p>``si'' erases the preceding word unless it is a ``zo''.</p>

    <p>``sa'' erases the preceding word and other words, unless the
    preceding word is a ``zo''.</p>

    <p>``su'' is the same as ``sa'', but erases more words.</p>

    <p>``lo'u'' quotes all following words up to a ``le'u'' (but
    not a ``zo le'u'').</p>

    <p>``le'u'' is ungrammatical except at the end of a ``lo'u
    quotation.</p>

    <p>ZOI cmavo use the following word as a delimiting word, no
    matter what it is, but using ``le'u'' may create
    difficulties.</p>

    <p>``zei'' combines the preceding and the following word into a
    lujvo, but does not affect ``zo'', ``si'', ``sa'', ``su'',
    ``lo'u'', ZOI cmavo, ``fa'o'', and ``zei''.</p>

    <p>BAhE cmavo mark the following word, unless it is ``si'',
    ``sa'', or ``su'', or unless it is preceded by ``zo''. Multiple
    BAhE cmavo may be used in succession.</p>

    <p>``bu'' makes the preceding word into a lerfu word, except
    for ``zo'', ``si'', ``sa'', ``su'', ``lo'u'', ZOI cmavo,
    ``fa'o'', ``zei'', BAhE cmavo, and ``bu''. Multiple ``bu''
    cmavo may be used in succession.</p>

    <p>UI and CAI cmavo mark the previous word, except for ``zo'',
    ``si'', ``sa'', ``su'', ``lo'u'', ZOI, ``fa'o'', ``zei'', BAhE
    cmavo, and ``bu''. Multiple UI cmavo may be used in succession.
    A following ``nai'' is made part of the UI.</p>

    <p>``.y.'', ``da'o'', ``fu'e'', and ``fu'o'' are the same as
    UI, but do not absorb a following ``nai''.</p>

    <p></p>

    <h3><a id="s17" name="s17">17. List of Elidable Terminators</h3>

    <p>The following list shows all the elidable terminators of
    Lojban. The first column is the terminator, the second column
    is the selma'o that starts the corresponding construction, and
    the third column states what kinds of grammatical constructs
    are terminated. Each terminator is the only cmavo of its
    selma'o, which naturally has the same name as the cmavo.</p>
<pre>
    be'o    BE      sumti attached to a tanru unit
    boi     PA/BY       number or lerfu string
    do'u    COI/DOI     vocative phrases
    fe'u    FIhO        ad-hoc modal tags
    ge'u    GOI     relative phrases
    kei     NU      abstraction bridi
    ke'e    KE      groups of various kinds
    ku      LE/LA       description sumti
    ku'e    PEhO        forethought mekso
    ku'o    NOI     relative clauses
    li'u    LU      quotations
    lo'o    LI      number sumti
    lu'u    LAhE/NAhE+BO    sumti qualifiers
    me'u    ME      tanru units formed from sumti
    nu'u    NUhI        forethought termsets
    se'u    SEI/SOI     metalinguistic insertions
    te'u    various     mekso conversion constructs
    toi     TO      parenthetical remarks
    tu'u    TUhE        multiple sentences or paragraphs
    vau     (none)      simple bridi or bridi-tails
    ve'o    VEI     mekso parentheses
</pre>

    <hr />
    
    <p>Última modificación: Mon Jun 27 23:13:27 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
