
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//ES" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 16</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter16.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 16<br />
      ``Who Did You Pass On The Road? Nobody'': Lojban And
      Logic</h2>

      <h6>$Revision: 4.0 $<br />
      mkhtml: 1.1</h6>
      <br />
      <br />
    </div>

    <h3><a id="s1" name="s1">1. What's wrong with this picture?</h3>

    <p>The following brief dialogue is from <a
    href="chapter7.html">Chapter 7</a> of <cite>Through The Looking
    Glass</cite> by Lewis Carroll.</p>
<pre>
<a id="e1d1"
name="e1d1">1.1)</a>  ``Who did you pass on the road?'' the King went on,
    holding out his hand to the Messenger for some more
    hay.

<a id="e1d2" name="e1d2">1.2)</a>   ``Nobody,'' said the Messenger.

<a id="e1d3"
name="e1d3">1.3)</a>   ``Quite right,'' said the King:  ``this young lady saw
    him too.  So of course Nobody walks slower than you.''

<a id="e1d4"
name="e1d4">1.4)</a>   ``I do my best,'' the Messenger said in a sulky tone.
    ``I'm sure nobody walks much faster than I do!''

<a id="e1d5"
name="e1d5">1.5)</a>   ``He can't do that,'' said the King, ``or else
    he'd have been here first.''
</pre>

    <p>This nonsensical conversation results because the King
    insists on treating the word ``nobody'' as a name, a name of
    somebody. However, the essential nature of the English word
    ``nobody'' is that it doesn't refer to somebody; or to put the
    matter another way, there isn't anybody to which it refers.</p>

    <p>The central point of contradiction in the dialogue arises in
    <a href="#e1d3">Example 1.3</a>, when the King says ``...
    Nobody walks slower than you''. This claim would be plausible
    if ``Nobody'' were really a name, since the Messenger could
    only pass someone who does walk more slowly than he. But the
    Messenger interprets the word ``nobody'' in the ordinary
    English way, and says (in <a href="#e1d4">Example 1.4</a>)
    ``... nobody walks much faster than I do'' (i.e., I walk
    faster, or as fast as, almost everyone), which the King then
    again misunderstands. Both the King and the Messenger are
    correct according to their respective understandings of the
    ambiguous word ``nobody/Nobody''.</p>

    <p>There are Lojban words or phrases corresponding to the
    problematic English words ``somebody'', ``nobody'',
    ``anybody'', ``everybody'' (and their counterparts
    ``some/no/any/everyone'' and ``some/no/any/everything''), but
    they obey rules which can often be surprising to
    English-speakers. The dialogue above simply cannot be
    translated into Lojban without distortion: the name ``Nobody''
    would have to be represented by a Lojban name, which would
    spoil the perfection of the wordplay. As a matter of fact, this
    is the desired result: a logical language should not allow two
    conversationalists to affirm ``Nobody walks slower than the
    Messenger'' and ``Nobody walks faster than the Messenger'' and
    both be telling the truth. (Unless, of course, nobody but the
    Messenger walks at all, or everyone walks at exactly the same
    speed.)</p>

    <p>This chapter will explore the Lojban mechanisms that allow
    the correct and consistent construction of sentences like those
    in the dialogue. There are no new grammatical constructs
    explained in this chapter; instead, it discusses the way in
    which existing facilities that allow Lojban-speakers to resolve
    problems like the above, using the concepts of modern logic.
    However, we will not approach the matter from the viewpoint of
    logicians, although readers who know something of logic will
    discover familiar notions in Lojban guise.</p>

    <p>Although Lojban is called a logical language, not every
    feature of it is ``logical''. In particular, the use of ``le''
    is incompatible with logical reasoning based on the description
    selbri, because that selbri may not truthfully apply: you
    cannot conclude from my statement that</p>
<pre>
<a id="e1d6" name="e1d6">1.6)</a>  mi viska le nanmu
    I see the-one-I-refer-to-as-the man.
    I see the man/men.
</pre>
    that there really is a man; the only thing you can conclude is
    that there is one thing (or more) that I choose to refer to as
    a man. You cannot even tell which man is meant for sure without
    asking me (although communication is served if you already know
    from the context). 

    <p>In addition, the use of attitudinals (see <a
    href="chapter13.html">Chapter 13</a>) often reduces or removes the
    ability to make deductions about the bridi to which those
    attitudinals are applied. From the fact that I hope George will
    win the election, you can conclude nothing about George's
    actual victory or defeat.</p>

    <h3><a id="s2" name="s2">2. Existential claims, prenexes, and variables</h3>

    <p>Let us consider, to begin with, a sentence that is not in
    the dialogue:</p>

    <p></p>
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  Something sees me.
</pre>

    <p>There are two plausible Lojban translations of <a
    href="#e2d1">Example 2.1</a>. The simpler one is:</p>

    <p></p>
<pre>
<a id="e2d2" name="e2d2">2.2)</a>  [zo'e] viska mi
    Something-unspecified sees me.
</pre>
    The cmavo ``zo'e'' indicates that a sumti has been omitted
    (indeed, even ``zo'e'' itself can be omitted in this case, as
    explained in <a href="chapter7.html">Chapter 7</a>) and the
    listener must fill in the correct value from context. In other
    words, <a href="#e2d2">Example 2.2</a> means ```You-know-what'
    sees me.'' 

    <p>However, <a href="#e2d1">Example 2.1</a> is just as likely
    to assert simply that there is someone who sees me, in which
    case a correct translation is:</p>

    <p></p>
<pre>
<a id="e2d3" name="e2d3">2.3)</a>  da zo'u da viska mi
    There-is-an-X such-that X sees me.
</pre>
    <a href="#e2d3">Example 2.3</a> does not presuppose that the
    listener knows who sees the speaker, but simply tells the
    listener that there is someone who sees the speaker. Statements
    of this kind are called ``existential claims''. (Formally, the
    one doing the seeing is not restricted to being a person; it
    could be an animal or --- in principle --- an inanimate object.
    We will see in <a href="#s4">Section 4</a> how to represent
    such restrictions.) 

    <p><a href="#e2d3">Example 2.3</a> has a two-part structure:
    there is the part ``da zo'u'', called the prenex, and the part
    ``da viska mi'', the main bridi. Almost any Lojban bridi can be
    preceded by a prenex, which syntactically is any number of
    sumti followed by the cmavo ``zo'u'' (of selma'o ZOhU). For the
    moment, the sumti will consist of one or more of the cmavo
    ``da'', ``de'', and ``di'' (of selma'o KOhA), glossed in the
    literal translations as ``X'', ``Y'', and ``Z'' respectively.
    By analogy to the terminology of symbolic logic, these cmavo
    are called ``variables''.</p>

    <p>Here is an example of a prenex with two variables:</p>

    <p></p>
<pre>
<a id="e2d4" name="e2d4">2.4)</a>  da de zo'u da prami de
    There-is-an-X there-is-a-Y such that X loves Y.
    Somebody loves somebody.
</pre>
    In <a href="#e2d4">Example 2.4</a>, the literal interpretation
    of the two variables ``da'' and ``de'' as ``there-is-an-X'' and
    ``there-is-a-Y'' tells us that there are two things which stand
    in the relationship that one loves the other. It might be the
    case that the supposed two things are really just a single
    thing that loves itself; nothing in the Lojban version of <a
    href="#e2d4">Example 2.4</a> rules out that interpretation,
    which is why the colloquial translation does not say ``Somebody
    loves somebody else.'' The things referred to by different
    variables may be different or the same. (We use ``somebody''
    here rather than ``something'' for naturalness; lovers and
    beloveds are usually persons, though the Lojban does not say
    so.) 

    <p>It is perfectly all right for the variables to appear more
    than once in the main bridi:</p>

    <p></p>
<pre>
<a id="e2d5" name="e2d5">2.5)</a>  da zo'u da prami da
    There-is-an-X such that X loves X
    Somebody loves himself/herself.
</pre>
    What <a href="#e2d5">Example 2.5</a> claims is fundamentally
    different from what <a href="#e2d4">Example 2.4</a> claims,
    because ``da prami da'' is not structurally the same as ``da
    prami de''. However, 

    <p></p>
<pre>
<a id="e2d6" name="e2d6">2.6)</a>  de zo'u de prami de
    There-is-a-Y such that Y loves Y
</pre>
    means exactly the same thing as <a href="#e2d5">Example
    2.5</a>; it does not matter which variable is used as long as
    they are used consistently. 

    <p>It is not necessary for a variable to be a sumti of the main
    bridi directly:</p>

    <p></p>
<pre>
<a id="e2d7" name="e2d7">2.7)</a>  da zo'u le da gerku cu viska mi
    There-is-an-X such-that the of-X dog sees me
    Somebody's dog sees me
</pre>
    is perfectly correct even though the ``da'' is used only in a
    possessive construction. (Possessives are explained in <a
    href="chapter8.html">Chapter 8</a>.) 

    <p>It is very peculiar, however, even if technically
    grammatical, for the variable not to appear in the main bridi
    at all:</p>

    <p></p>
<pre>
<a id="e2d8" name="e2d8">2.8)</a>  da zo'u la ralf. gerku
    There is something such that Ralph is a dog.
</pre>
    has a variable bound in a prenex whose relevance to the claim
    of the following bridi is completely unspecified. 

    <h3><a id="s3" name="s3">3. Universal claims</h3>

    <p>What happens if we substitute ``everything'' for
    ``something'' in <a href="#e2d1">Example 2.1</a>? We get:</p>
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  Everything sees me.
</pre>
    Of course, this example is false, because there are many things
    which do not see the speaker. It is not easy to find simple
    truthful examples of so-called universal claims (those which
    are about everything), so bear with us for a while. (Indeed,
    some Lojbanists tend to avoid universal claims even in other
    languages, since they are so rarely true in Lojban.) 

    <p>The Lojban translation of <a href="#e3d1">Example 3.1</a>
    is</p>
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  ro da zo'u da viska mi
    For-every X : X sees me.
</pre>
    When the variable cmavo ``da'' is preceded by ``ro'', the
    combination means ``For every X'' rather than ``There is an
    X''. Superficially, these English formulations look totally
    unrelated: <a href="#s6">Section 6</a> will bring them within a
    common viewpoint. For the moment, accept the use of ``ro da''
    for ``everything'' on faith. 

    <p>Here is a universal claim with two variables:</p>

    <p></p>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  ro da ro de zo'u da prami de
    For-every X, for-every Y : X loves Y.
    Everything loves everything.
</pre>

    <p>Again, X and Y can represent the same thing, so <a
    href="#e3d3">Example 3.3</a> does not mean ``Everything loves
    everything else.'' Furthermore, because the claim is universal,
    it is about every thing, not merely every person, so we cannot
    use ``everyone'' or ``everybody'' in the translation.</p>

    <p>Note that ``ro'' appears before both ``da'' and ``de''. If
    ``ro'' is omitted before either variable, we get a mixed claim,
    partly existential like those of <a href="#s2">Section 2</a>,
    partly universal.</p>

    <p></p>
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  ro da de zo'u da viska de
    For-every X, there-is-a-Y : X sees Y.
    Everything sees something.
</pre>
<pre>
<a id="e3d5" name="e3d5">3.5)</a>  da ro de zo'u da viska de
    There-is-an-X such-that-for-every-Y : X sees Y.
    Something sees everything.
</pre>
    <a href="#e3d4">Examples 3.4</a> and <a href="#e3d5">3.5</a>
    mean completely different things. <a href="#e3d4">Example
    3.4</a> says that for everything, there is something which it
    sees, not necessarily the same thing seen for every seer. <a
    href="#e3d5">Example 3.5</a>, on the other hand, says that
    there is a particular thing which can see everything that there
    is (including itself). Both of these are fairly silly, but they
    are different kinds of silliness. 

    <p>There are various possible translations of universal claims
    in English: sometimes we use ``anybody/anything'' rather than
    ``everybody/everything''. Often it makes no difference which of
    these is used: when it does make a difference, it is a rather
    subtle one which is explained in <a href="#s8">Section
    8</a>.</p>

    <h3><a id="s4" name="s4">4. Restricted claims: ``da poi''</h3>

    <p>The universal claims of <a href="#s3">Section 3</a> are not
    only false but absurd: there is really very little to be said
    that is both true and non-trivial about every object
    whatsoever. Furthermore, we have been glossing over the
    distinction between ``everything'' and ``everybody'' and the
    other pairs ending in ``-thing'' and ``-body''. It is time to
    bring up the most useful feature of Lojban variables: the
    ability to restrict their ranges.</p>

    <p>In Lojban, a variable ``da'', ``de'', or ``di'' may be
    followed by a ``poi'' relative clause in order to restrict the
    range of things that the variable describes. Relative clauses
    are described in detail in <a href="chapter8.html">Chapter 8</a>,
    but the kind we will need at present consist of ``poi''
    followed by a bridi (often just a selbri) terminated with
    ``ku'o'' or ``vau'' (which can usually be elided). Consider the
    difference between</p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  da zo'u da viska la djim.
    There-is-an-X : X sees Jim.
    Something sees Jim.
</pre>
    and 
<pre>
<a id="e4d2"
name="e4d2">4.2)</a>  da poi prenu zo'u da viska la djim.
    There-is-an-X which is-a-person : X sees Jim.
    Someone sees Jim.
</pre>
    In <a href="#e4d1">Example 4.1</a>, the variable ``da'' can
    refer to any object whatever; there are no restrictions on it.
    In <a href="#e4d2">Example 4.2</a>, ``da'' is restricted by the
    ``poi prenu'' relative clause to persons only, and so ``da poi
    prenu'' translates as ``someone.'' (The difference between
    ``someone'' and ``somebody'' is a matter of English style, with
    no real counterpart in Lojban.) If <a href="#e4d2">Example
    4.2</a> is true, then <a href="#e4d1">Example 4.1</a> must be
    true, but not necessarily vice versa. 

    <p>Universal claims benefit even more from the existence of
    relative clauses. Consider</p>

    <p></p>
<pre>
<a id="e4d3" name="e4d3">4.3)</a>  ro da zo'u da vasxu
    For-every X : X breathes
    Everything breathes
</pre>
    and 

    <p></p>
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  ro da poi gerku zo'u da vasxu
    For-every X which is-a-dog : X breathes.
    Every dog breathes.
    Each dog breathes.
    All dogs breathe.
</pre>
    <a href="#e4d3">Example 4.3</a> is a silly falsehood, but <a
    href="#e4d4">Example 4.4</a> is an important truth (at least if
    applied in a timeless or potential sense: see <a
    href="chapter10.html">Chapter 10</a>). Note the various colloquial
    translations ``every dog'', ``each dog'', and ``all dogs''.
    They all come to the same thing in Lojban, since what is true
    of every dog is true of all dogs. ``All dogs'' is treated as an
    English plural and the others as singular, but Lojban makes no
    distinction. 

    <p>If we make an existential claim about dogs rather than a
    universal one, we get:</p>
<pre>
<a id="e4d5" name="e4d5">4.5)</a>  da poi gerku zo'u da vasxu
    There-is-an-X which is-a-dog : X breathes.
    Some dog breathes.
</pre>

    <h3><a id="s5" name="s5">5. Dropping the prenex</h3>

    <p>It isn't really necessary for every Lojban bridi involving
    variables to have a prenex on the front. In fact, none of the
    examples we've seen so far required prenexes at all! The rule
    for dropping the prenex is simple: if the variables appear in
    the same order within the bridi as they did in the prenex, then
    the prenex is superfluous. However, any ``ro'' or ``poi''
    appearing in the prenex must be transferred to the first
    occurrence of the variable in the main part of the bridi. Thus,
    <a href="#e2d3">Example 2.3</a> becomes just:</p>
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  da viska mi
    There-is-an-X-which sees me.
    Something sees me.
</pre>
    and <a href="#e4d4">Example 4.4</a> becomes: 
<pre>
<a id="e5d2" name="e5d2">5.2)</a>  ro da poi gerku cu vasxu
    For-every X which is-a-dog, it-breathes.
    Every dog breathes.
</pre>
    You might well suppose, then, that the purpose of the prenex is
    to allow the variables in it to appear in a different order
    than the bridi order, and that would be correct. Consider 

    <p></p>
<pre>
<a id="e5d3" name="e5d3">5.3)</a>  ro da poi prenu ku'o
        de poi gerku ku'o zo'u
            de batci da
    For-every X which is-a-person,
        there-is-a-Y which is-a-dog:
            Y bites X.
</pre>

    <p>The prenex of <a href="#e5d3">Example 5.3</a> is like that
    of <a href="#e3d4">Example 3.4</a> (but with relative clauses):
    it notes that the following bridi is true of every person with
    respect to some dog, not necessarily the same dog for each. But
    in the main bridi part, the ``de'' appears before the ``da''.
    Therefore, the true translation is</p>
<pre>
<a id="e5d4"
name="e5d4">5.4)</a>  Every person is bitten by some dog (or other).
</pre>

    <p>If we tried to omit the prenex and move the ``ro'' and the
    relative clauses into the main bridi, we would get:</p>
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  de poi gerku cu batci
        ro da poi prenu
    There-is-a-Y which is-a-dog which-bites
        every Y which is-a-person
    Some dog bites everyone.
</pre>
    which has the structure of <a href="#e3d5">Example 3.5</a>: it
    says that there is a dog (call him Fido) who bites, has bitten,
    or will bite every person that has ever existed! We can safely
    rule out Fido's existence, and say that <a href="#e5d5">Example
    5.5</a> is false, while agreeing to <a href="#e5d3">Example
    5.3</a>. 

    <p>Even so, <a href="#e5d3">Example 5.3</a> is most probably
    false, since some people never experience dogbite. Examples
    like 5.3 and 4.4 (might there be some dogs which never have
    breathed, because they died as embryos?) indicate the danger in
    Lojban of universal claims even when restricted. In English we
    are prone to say that ``Everyone says'' or that ``Everybody
    does'' or that ``Everything is'' when in fact there are obvious
    counterexamples which we are ignoring for the sake of making a
    rhetorical point. Such statements are plain falsehoods in
    Lojban, unless saved by a context (such as tense) which
    implicitly restricts them.</p>

    <p>How can we express <a href="#e5d3">Example 5.3</a> in Lojban
    without a prenex? Since it is the order in which variables
    appear that matters, we can say:</p>
<pre>
<a id="e5d6" name="e5d6">5.6)</a>  ro da poi prenu cu se batci
        de poi gerku
    Every-X which is-a-person is-bitten-by some-Y
        which is-a-dog.
</pre>
    using the conversion operator ``se'' (explained in <a
    href="chapter5.html">Chapter 5</a>) to change the selbri ``batci''
    (``bites'') into ``se batci'' (``is bitten by''). The
    translation given in <a href="#e5d4">Example 5.4</a> uses the
    corresponding strategy in English, since English does not have
    prenexes (except in strained ``logician's English''). This
    implies that a sentence with both a universal and an
    existential variable can't be freely converted with ``se''; one
    must be careful to preserve the order of the variables. 

    <p>If a variable occurs more than once, then any ``ro'' or
    ``poi'' decorations are moved only to the first occurrence of
    the variable when the prenex is dropped. For example,</p>

    <p></p>
<pre>
<a id="e5d7" name="e5d7">5.7)</a>  di poi prenu zo'u
        ti xarci di di
    There-is-a-Z which is-a-person :
        this-thing is-a-weapon for-use-against-Z by-Z
    This is a weapon for someone to use against
        himself/herself.
</pre>
    (in which ``di'' is used rather than ``da'' just for variety)
    loses its prenex as follows: 
<pre>
<a id="e5d8" name="e5d8">5.8)</a>  ti xarci di
        poi prenu ku'o di
    This-thing is-a-weapon-for-use-against
        some-Z which is-a-person by-Z.
</pre>
    As the examples in this section show, dropping the prenex makes
    for terseness of expression often even greater than that of
    English (Lojban is meant to be an unambiguous language, not
    necessarily a terse or verbose one), provided the rules are
    observed. 

    <h3><a id="s6" name="s6">6. Variables with generalized quantifiers</h3>

    <p>So far, we have seen variables with either nothing in front,
    or with the cmavo ``ro'' in front. Now ``ro'' is a Lojban
    number, and means ``all''; thus ``ro prenu'' means ``all
    persons'', just as ``re prenu'' means ``two persons''. In fact,
    unadorned ``da'' is also taken to have an implicit number in
    front of it, namely ``su'o'', which means ``at least one''. Why
    is this? Consider <a href="#e2d3">Example 2.3</a> again, this
    time with an explicit ``su'o'':</p>

    <p></p>
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  su'o da zo'u da viska mi
    For-at-least-one X : X sees me.
    Something sees me.
</pre>

    <p>From this version of <a href="#e2d3">Example 2.3</a>, we
    understand the speaker's claim to be that of all the things
    that there are, at least one of them sees him or her. The
    corresponding universal claim, <a href="#e3d2">Example 3.2</a>,
    says that of all the things that exist, every one of them can
    see the speaker.</p>

    <p>Any other number can be used instead of ``ro'' or ``su'o''
    to precede a variable. Then we get claims like:</p>
<pre>
<a id="e6d2" name="e6d2">6.2)</a>  re da zo'u da viska mi
    For-two-Xes : X sees me.
    Two things see me.
</pre>
    This means that exactly two things, no more or less, saw the
    speaker on the relevant occasion. In English, we might take
    ``Two things see me'' to mean that at least two things see the
    speaker, but there might be more; in Lojban, though, that claim
    would have to be made as: 
<pre>
<a id="e6d3" name="e6d3">6.3)</a>  su'ore da zo'u da viska mi
    For-at-least-two Xes : X sees me.
</pre>
    which would be false if nothing, or only one thing, saw the
    speaker, but not otherwise. We note the ``su'o'' here meaning
    ``at least''; ``su'o'' by itself is short for ``su'opa'' where
    ``pa'' means ``one'', as is explained in <a
    href="chapter18.html">Chapter 18</a>. 

    <p>The prenex may be removed from <a href="#e6d2">Examples
    6.2</a> and <a href="#e6d3">6.3</a> as from the others, leading
    to:</p>
<pre>
<a id="e6d4" name="e6d4">6.4)</a>  re da viska mi
    Two Xes see me.
</pre>
    and 
<pre>
<a id="e6d5" name="e6d5">6.5)</a>  su'ore da viska mi
    At-least-two Xes see me.
</pre>
    respectively, subject to the rules prescribed in <a
    href="#s5">Section 5</a>. 

    <p>Now we can explain the constructions ``ro prenu'' for ``all
    persons'' and ``re prenu'' for ``two persons'' which were
    casually mentioned at the beginning of this Section. In fact,
    ``ro prenu'', a so-called ``indefinite description'', is
    shorthand for ``ro DA poi prenu'', where ``DA'' represents a
    fictitious variable that hasn't been used yet and will not be
    used in future. (Even if all three of ``da'', ``de'', and
    ``di'' have been used up, it does not matter, for there are
    ways of getting more variables, discussed in <a
    href="#s14">Section 14</a>.) So in fact</p>
<pre>
<a id="e6d6" name="e6d6">6.6)</a>  re prenu viska mi
    Two persons see me.
</pre>
    is short for 
<pre>
<a id="e6d7" name="e6d7">6.7)</a>  re da poi prenu cu viska mi
    Two Xes which are-persons see me.
</pre>
    which in turn is short for: 
<pre>
<a id="e6d8" name="e6d8">6.8)</a>  re da poi prenu zo'u da viska mi
    For-two Xes which are-persons : X sees me.
</pre>
    Note that when we move more than one variable to the prenex
    (along with its attached relative clause), we must make sure
    that the variables are in the same order in the prenex as in
    the bridi proper. 

    <h3><a id="s7" name="s7">7. Grouping of quantifiers</h3>

    <p>Let us consider a sentence containing two quantifier
    expressions neither of which is ``ro'' or ``su'o'' (remembering
    that ``su'o'' is implicit where no explicit quantifier is
    given):</p>

    <p></p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  ci gerku cu batci re nanmu
    Three dogs bite two men.
</pre>
    The question raised by <a href="#e7d1">Example 7.1</a> is, does
    each of the dogs bite the same two men, or is it possible that
    there are two different men per dog, for six men altogether? If
    the former interpretation is taken, the number of men involved
    is fixed at two; but if the latter, then the speaker has to be
    taken as saying that there might be any number of men between
    two and six inclusive. Let us transform <a href="#e7d1">Example
    7.1</a> step by step as we did with <a href="#e6d6">Example
    6.6</a>: 
<pre>
<a id="e7d2"
name="e7d2">7.2)</a>  ci da poi gerku cu batci re de poi nanmu
    Three Xes which are-dogs bite two Ys which are-men.
</pre>
    (Note that we need separate variables ``da'' and ``de'',
    because of the rule that says each indefinite description gets
    a variable never used before or since.) 
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  ci da poi gerku ku'o
        re de poi nanmu zo'u
            da batci de
    For-three Xes which are-dogs,
        for-two Ys which are-men :
            X bites Y.
</pre>

    <p>Here we see that indeed each of the dogs is said to bite two
    men, and it might be different men each time; a total of six
    biting events altogether.</p>

    <p>How then are we to express the other interpretation, in
    which just two men are involved? We cannot just reverse the
    order of variables in the prenex to</p>
<pre>
<a id="e7d4" name="e7d4">7.4)</a>  re de poi nanmu ku'o
        ci da poi gerku zo'u da batci de
    For-two Ys which are-men,
        for-three Xes which are-dogs, X bites Y
</pre>
    for although we have now limited the number of men to exactly
    two, we end up with an indeterminate number of dogs, from three
    to six. The distinction is called a ``scope distinction'': in
    <a href="#e7d2">Example 7.2</a>, ``ci gerku'' is said to have
    wider scope than ``re nanmu'', and therefore precedes it in the
    prenex. In <a href="#e7d4">Example 7.4</a> the reverse is true.
    

    <p>The solution is to use a termset, which is a group of terms
    either joined by ``ce'e'' (of selma'o CEhE) between each term,
    or else surrounded by ``nu'i'' (of selma'o NUhI) on the front
    and ``nu'u'' (of selma'o NUhU) on the rear. Terms (which are
    either sumti or sumti prefixed by tense or modal tags) that are
    grouped into a termset are understood to have equal scope:</p>
<pre>
<a id="e7d5" name="e7d5">7.5)</a>  ci gerku ce'e re nanmu cu batci
    nu'i ci gerku re nanmu [nu'u] cu batci
    Three dogs [plus] two men, bite.
</pre>
    which picks out two groups, one of three dogs and the other of
    two men, and says that every one of the dogs bites each of the
    men. The second Lojban version uses forethought; note that
    ``nu'u'' is an elidable terminator, and in this case can be
    freely elided. 

    <p>What about descriptors, like ``ci lo gerku'', ``le nanmu''
    or ``re le ci mlatu''? They too can be grouped in termsets, but
    usually need not be, except for the ``lo'' case which functions
    like the case without a descriptor. Unless an actual quantifier
    precedes it, ``le nanmu'' means ``ro le nanmu'', as is
    explained in <a href="chapter6.html">Chapter 6</a>. Two sumti with
    ``ro'' quantifiers are independent of order, so:</p>
<pre>
<a id="e7d6"
name="e7d6">7.6)</a>  [ro] le ci gerku cu batci [ro] le re nanmu
    [All of] the three dogs bite [all of] the two men.
</pre>
    means that each of the dogs specified bites each of the men
    specified, for six acts of biting altogether. However, if there
    is an explicit quantifier before ``le'' other than ``ro'', the
    problems of this section reappear. 

    <h3><a id="s8" name="s8">8. The problem of ``any''</h3>

    <p>Consider the English sentence</p>

    <p></p>
<pre>
<a id="e8d1"
name="e8d1">8.1)</a>  Anyone who goes to the store, walks across the field.
</pre>

    <p>Using the facilities already discussed, a plausible
    translation might be</p>
<pre>
<a id="e8d2"
name="e8d2">8.2)</a>  ro da poi klama le zarci cu cadzu le foldi
    All X such-that-it goes-to the store walks-on the field.
    Everyone who goes to the store walks across the field.
</pre>
    But there is a subtle difference between <a
    href="#e8d1">Example 8.1</a> and <a href="#e8d2">Example
    8.2</a>. <a href="#e8d2">Example 8.2</a> tells us that, in
    fact, there are people who go to the store, and that they walk
    across the field. A sumti of the type ``ro da poi klama''
    requires that there are things which ``klama'': Lojban
    universal claims always imply the corresponding existential
    claims as well. <a href="#e8d1">Example 8.1</a>, on the other
    hand, does not require that there are any people who go to the
    store: it simply states, conditionally, that if there is anyone
    who goes to the store, he or she walks across the field as
    well. This conditional form mirrors the true Lojban translation
    of <a href="#e8d1">Example 8.1</a>: 
<pre>
<a id="e8d3"
name="e8d3">8.3)</a>  ro da zo'u ganai da klama le zarci
        gi cadzu le foldi
    For-every X: if X is-a-goer-to the store
        then X is-a-walker-on the field.
</pre>
    Although <a href="#e8d3">Example 8.3</a> is a universal claim
    as well, its universality only implies that there are objects
    of some sort or another in the universe of discourse. Because
    the claim is conditional, nothing is implied about the
    existence of goers-to-the-store or of walkers-on-the-field,
    merely that any entity which is one is also the other. 

    <p>There is another use of ``any'' in English that is not
    universal but existential. Consider</p>

    <p></p>
<pre>
<a id="e8d4"
name="e8d4">8.4)</a>  I need any box that is bigger than this one.
</pre>
    <a href="#e8d4">Example 8.4</a> does not at all mean that I
    need every box bigger than this one, for indeed I do not; I
    require only one box. But the naive translation 
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  mi nitcu da poi tanxe
        gi'e bramau ti
    I need some-X which is-a-box
        and is-bigger-than this-one
</pre>
    does not work either, because it asserts that there really is
    such a box, as the prenex paraphrase demonstrates: 
<pre>
<a id="e8d6" name="e8d6">8.6)</a>  da poi tanxe
        gi'e bramau ti zo'u mi nitcu da
    There-is-an-X which is-a-box
        and is-bigger-than this : I need X.
</pre>

    <p>What to do? Well, the x2 place of ``nitcu'' can be filled
    with an event as well as an object, and in fact <a
    href="#e8d5">Example 8.5</a> can also be paraphrased as:</p>
<pre>
<a id="e8d7" name="e8d7">8.7)</a>  mi nitcu lo nu mi ponse
        lo tanxe poi bramau ti
    I need an event-of I possess
        some box(es) which-are bigger-than this-one.
</pre>

    <p>Rewritten using variables, <a href="#e8d7">Example 8.7</a>
    becomes</p>
<pre>
<a id="e8d8" name="e8d8">8.8)</a>  mi nitcu lo nu da zo'u
        da se ponse mi gi'e tanxe
            gi'e bramau ti
    I need an event-of there-being an-X such-that
        X is-possessed-by me and is-a-box
            and is-bigger-than this-thing.
</pre>
    So we see that a prenex can be attached to a bridi that is
    within a sentence. By default, a variable always behaves as if
    it is bound in the prenex which (notionally) is attached to the
    smallest enclosing bridi, and its scope does not extend beyond
    that bridi. However, the variable may be placed in an outer
    prenex explicitly: 
<pre>
<a id="e8d9" name="e8d9">8.9)</a>  da poi tanxe
        gi'e bramau ti zo'u
        mi nitcu le nu mi ponse da
    There-is-an-X which is-a-box
        and is-bigger-than this-one such-that
        I need the event-of my possessing X.
</pre>
    But what are the implications of <a href="#e8d7">Example
    8.7</a> and <a href="#e8d9">Example 8.9</a>? The main
    difference is that in <a href="#e8d9">Example 8.9</a>, the
    ``da'' is said to exist in the real world of the outer bridi;
    but in <a href="#e8d7">Example 8.7</a>, the existence is only
    within the inner bridi, which is a mere event that need not
    necessarily come to pass. So <a href="#e8d9">Example 8.9</a>
    means 
<pre>
<a id="e8d10"
name="e8d10">8.10)</a>    There's a box, bigger than this one, that I need
</pre>
    which is what <a href="#e8d6">Example 8.6</a> says, whereas <a
    href="#e8d7">Example 8.7</a> turns out to be an effective
    translation of our original <a href="#e8d1">Example 8.1</a>. So
    uses of ``any'' that aren't universal end up being reflected by
    variables bound in the prenex of a subordinate bridi. 

    <h3><a id="s9" name="s9">9. Negation boundaries</h3>

    <p>This section, as well as <a href="#s10">Section 10</a>
    through <a href="#s12">Section 12</a>, are in effect a
    continuation of <a href="chapter15.html">Chapter 15</a>,
    introducing features of Lojban negation that require an
    understanding of prenexes and variables. In the examples below,
    ``there is a Y'' and the like must be understood as ``there is
    at least one Y, possibly more''.</p>

    <p>As explained in <a href="chapter15.html">Chapter 15</a>, the
    negation of a bridi is usually accomplished by inserting ``na''
    at the beginning of the selbri:</p>

    <p></p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  mi na klama le zarci
    I [false] go-to the store.
    It is false that I go to the store.
    I don't go to the store.
</pre>
    The other form of bridi negation is expressed by using the
    compound cmavo ``naku'' in the prenex, which is identified and
    compounded by the lexer before looking at the sentence grammar.
    In Lojban grammar, ``naku'' is then treated like a sumti. In a
    prenex, ``naku'' means precisely the same thing as the
    logician's ``it is not the case that'' in a similar English
    context. (Outside of a prenex, ``naku'' is also grammatically
    treated as a single entity --- the equivalent of a sumti ---
    but does not have this exact meaning; we'll discuss these other
    situations in <a href="#s11">Section 11</a>.) 

    <p>To represent a bridi negation using a prenex, remove the
    ``na'' from before the selbri and place ``naku'' at the left
    end of the prenex. This form is called ``external bridi
    negation'', as opposed to ``internal bridi negation'' using
    ``na''. The prenex version of <a href="#e9d1">Example 9.1</a>
    is</p>
<pre>
<a id="e9d2" name="e9d2">9.2)</a>  naku zo'u la djan. klama
    It is not the case that: John comes.
    It is false that: John comes.
</pre>
    However, ``naku'' can appear at other points in the prenex as
    well. Compare 

    <p></p>
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  naku de zo'u de zutse
    It is not the case that: for some Y, Y sits.
    It is false that: for at least one Y, Y sits.
    It is false that something sits.
    Nothing sits.
</pre>
    with 
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  su'ode naku zo'u de zutse
    For at least one Y, it is false that: Y sits.
    There is something that doesn't sit.
</pre>

    <p>The relative position of negation and quantification terms
    within a prenex has a drastic effect on meaning. Starting
    without a negation, we can have:</p>

    <p></p>
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  roda su'ode zo'u da prami de
    For every X, there is a Y, such that X loves Y.
    Everybody loves at least one thing (each,
        not necessarily the same thing).
</pre>
    or: 

    <p></p>
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  su'ode roda zo'u da prami de
    There is a Y, such that for each X, X loves Y.
    There is at least one particular thing
        that is loved by everybody.
</pre>

    <p>The simplest form of bridi negation to interpret is one
    where the negation term is at the beginning of the prenex:</p>
<pre>
<a id="e9d7" name="e9d7">9.7)</a>  naku roda su'ode zo'u
        da prami de
    It is false that: for every X, there is a Y, such that:
        X loves Y.
    It is false that: everybody loves at least one thing.
    (At least) someone doesn't love anything.
</pre>
    the negation of <a href="#e9d5">Example 9.5</a>, and 
<pre>
<a id="e9d8" name="e9d8">9.8)</a>  naku su'ode roda zo'u
        da prami de
    It is false that: there is a Y such that for each X,
        X loves Y.
    It is false that: there is at least one thing that is
        loved by everybody.
    There isn't any one thing that everybody loves.
</pre>
    the negation of <a href="#e9d6">Example 9.6</a>. 

    <p>The rules of formal logic require that, to move a negation
    boundary within a prenex, you must ``invert any quantifier''
    that the negation boundary passes across. Inverting a
    quantifier means that any ``ro'' (all) is changed to ``su'o''
    (at least one) and vice versa. Thus, <a href="#e9d7">Example
    9.7</a> and <a href="#e9d8">Example 9.8</a> can be restated as,
    respectively:</p>
<pre>
<a id="e9d9" name="e9d9">9.9)</a>  su'oda naku su'ode zo'u
        da prami de
    For some X, it is false that: there is a Y such that:
        X loves Y.
    There is somebody who doesn't love anything.
</pre>
    and: 
<pre>
<a id="e9d10"
name="e9d10">9.10)</a>    rode naku roda zo'u da prami de
    For every Y, it is false that: for every X, X loves Y.
    For each thing, it is not true that everybody loves it.
</pre>

    <p>Another movement of the negation boundary produces:</p>
<pre>
<a id="e9d11" name="e9d11">9.11)</a>    su'oda rode naku zo'u
        da prami de
    There is an X such that, for every Y,
        it is false that X loves Y.
    There is someone who, for each thing,
        doesn't love that thing.
and

<a id="e9d12"
name="e9d12">9.12)</a> rode su'oda naku zo'u da prami de
    For every Y, there is an X, such that it is false that:
        X loves Y.
    For each thing there is someone who doesn't love it.
</pre>
    Investigation will show that, indeed, each transformation
    preserves the meanings of <a href="#e9d7">Example 9.7</a> and
    <a href="#e9d8">Example 9.8</a>. 

    <p>The quantifier ``no'' (meaning ``zero of'') also involves a
    negation boundary. To transform a bridi containing a variable
    quantified with ``no'', we must first expand it. Consider</p>
<pre>
<a id="e9d13" name="e9d13">9.13)</a>    noda rode zo'u da prami de
    There is no X, for every Y, such that X loves Y.
    Nobody loves everything.
</pre>
    which is negated by: 
<pre>
<a id="e9d14" name="e9d14">9.14)</a>    naku noda rode zo'u
        da prami de
    It is false that: there is no X that, for every Y,
        X loves Y.
    It is false that there is nobody who loves everything.
</pre>
    We can simplify <a href="#e9d14">Example 9.14</a> by
    transforming the prenex. To move the negation phrase within the
    prenex, we must first expand the ``no'' quantifier. Thus ``for
    no x'' means the same thing as ``it is false for some x'', and
    the corresponding Lojban ``noda'' can be replaced by ``naku
    su'oda''. Making this substitution, we get: 
<pre>
<a id="e9d15" name="e9d15">9.15)</a>    naku naku su'oda rode zo'u
        da prami de
    It is false that it is false that: for an X, for every Y:
        X loves Y.
</pre>

    <p>Adjacent double negation boundaries in the prenex can be
    dropped, so this means the same as:</p>
<pre>
<a id="e9d16"
name="e9d16">9.16)</a>    su'oda rode zo'u da prami de
    There is an X such that, for every Y, X loves Y.
    At least one person loves everything.
</pre>
    which is clearly the desired contradiction of <a
    href="#e9d13">Example 9.13</a>. 

    <p>The interactions between quantifiers and negation mean that
    you cannot eliminate double negatives that are not adjacent.
    You must first move the negation phrases so that they are
    adjacent, inverting any quantifiers they cross, and then the
    double negative can be eliminated.</p>

    <h3><a id="s10" name="s10">10. bridi negation and logical connectives</h3>

    <p>A complete discussion of logical connectives appears in <a
    href="chapter14.html">Chapter 14</a>. What is said here is
    intentionally quite incomplete and makes several
    oversimplifications.</p>

    <p>A logical connective is a cmavo or compound cmavo. In this
    chapter, we will make use of the logical connectives ``and''
    and ``or'' (where ``or'' really means ``and/or'', ``either or
    both''). The following simplified recipes explain how to make
    some logical connectives:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>To logically connect two Lojban sumti with ``and'', put
      them both in the bridi and separate them with the cmavo
      ``.e''.</dd>

      <dt></dt>

      <dd>To logically connect two Lojban bridi with ``and'',
      replace the regular separator cmavo ``.i'' with the compound
      cmavo ``.ije''.</dd>

      <dt></dt>

      <dd>To logically connect two Lojban sumti with ``or'', put
      them both in the bridi and separate them with the cmavo
      ``.a''.</dd>

      <dt></dt>

      <dd>To logically connect two Lojban bridi with ``or'',
      replace the regular separator cmavo ``.i'' with the compound
      cmavo ``.ija''.</dd>
    </dl>

    <p>More complex logical connectives also exist; in particular,
    one may place ``na'' before ``.e'' or ``.a'', or between ``.i''
    and ``je'' or ``ja''; likewise, one may place ``nai'' at the
    end of a connective. Both ``na'' and ``nai'' have negative
    effects on the sumti or bridi being connected. Specifically,
    ``na'' negates the first or left-hand sumti or bridi, and
    ``nai'' negates the second or right-hand one.</p>

    <p>Whenever a logical connective occurs in a sentence, that
    sentence can be expanded into two sentences by repeating the
    common terms and joining the sentences by a logical connective
    beginning with ``.i''. Thus the following sentence:</p>
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    mi .e do klama ti
    I and you come here.
</pre>
    can be expanded to: 
<pre>
<a id="e10d2"
name="e10d2">10.2)</a>    mi klama ti  .ije do klama ti
    I come here, and, you come here.
</pre>

    <p>The same type of expansion can be performed for any logical
    connective, with any valid combination of ``na'' or ``nai''
    attached. No change in meaning occurs under such a
    transformation.</p>

    <p>Clearly, if we know what negation means in the expanded
    sentence forms, then we know what it means in all of the other
    forms. But what does negation mean between sentences?</p>

    <p>The mystery is easily solved. A negation in a logical
    expression is identical to the corresponding bridi negation,
    with the negator placed at the beginning of the prenex.
    Thus:</p>
<pre>
<a id="e10d3" name="e10d3">10.3)</a>    mi .enai do prami roda
    I, and not you, love everything.
</pre>
    expands to: 
<pre>
<a id="e10d4"
name="e10d4">10.4)</a>    mi prami roda  .ijenai do prami roda
    I love everything, and-not, you love everything.
</pre>
    and then into prenex form as: 
<pre>
<a id="e10d5" name="e10d5">10.5)</a>    roda zo'u mi prami da
        .ije naku zo'u do prami da
    For each thing: I love it,
        and it is false that you love (the same) it.
</pre>
    By the rules of predicate logic, the ``ro'' quantifier on
    ``da'' has scope over both sentences. That is, once you've
    picked a value for ``da'' for the first sentence, it stays the
    same for both sentences. (The ``da'' continues with the same
    fixed value until a new paragraph or a new prenex resets the
    meaning.) 

    <p>Thus the following example has the indicated
    translation:</p>
<pre>
<a id="e10d6" name="e10d6">10.6)</a>    su'oda zo'u mi prami da
        .ije naku zo'u do prami da
    For at least one thing: I love that thing.
        And it is false that: you love that (same) thing.
    There is something that I love that you don't.
</pre>
    If you remember only two rules for prenex manipulation of
    negations, you won't go wrong: 

    <p></p>

    <dl>
      <dt></dt>

      <dd>Within a prenex, whenever you move ``naku'' past a bound
      variable (da, de, di, etc.), you must invert the
      quantifier.</dd>
    </dl>

    <dl>
      <dt></dt>

      <dd>A ``na'' before the selbri is always transformed into a
      ``naku'' at the left-hand end of the prenex, and vice
      versa.</dd>
    </dl>

    <h3><a id="s11" name="s11">11. Using ``naku'' outside a prenex</h3>

    <p>Let us consider the English sentence</p>

    <p></p>
<pre>
<a id="e11d1"
name="e11d1">11.1)</a>    Some children do not go to school.
</pre>

    <p>We cannot express this directly with ``na''; the apparently
    obvious translation</p>
<pre>
<a id="e11d2" name="e11d2">11.2)</a>    su'oda poi verba
        na klama su'ode poi ckule
    At-least-one X which-are child(ren)
        [false] go-to at-least-one Y which-are school(s).
</pre>
    which converts to the external negation: 
<pre>
<a id="e11d3" name="e11d3">11.3)</a>    naku zo'u su'oda poi verba
        cu klama su'ode poi ckule
    It is false that some which are children
        go-to some which are schools.
    All children don't go to some school
        (not just some children).
</pre>
    Lojban provides a negation form which more closely emulates
    natural language negation. This involves putting ``naku''
    before the selbri, instead of a ``na''. ``naku'' is clearly a
    contradictory negation, given its parallel with prenex bridi
    negation. Using ``naku'', <a href="#e11d1">Example 11.1</a> can
    be expressed as: 
<pre>
<a id="e11d4" name="e11d4">11.4)</a>    su'oda poi verba naku klama
        su'ode poi ckule
    Some which-are children don't go-to
        some which-are schools.
    Some children don't go to a school.
</pre>
    Although it is not technically a sumti, ``naku'' can be used in
    most of the places where a sumti may appear. We'll see what
    this means in a moment. 

    <p>When you use ``naku'' within a bridi, you are explicitly
    creating a negation boundary. As explained in <a
    href="#s9">Section 9</a>, when a prenex negation boundary
    expressed by ``naku'' moves past a quantifier, the quantifier
    has to be inverted. The same is true for ``naku'' in the bridi
    proper. We can move ``naku'' to any place in the sentence where
    a sumti can go, inverting any quantifiers that the negation
    boundary crosses. Thus, the following are equivalent to <a
    href="#e11d4">Example 11.4</a> (no good English translations
    exist):</p>
<pre>
<a id="e11d5"
name="e11d5">11.5)</a>    su'oda poi verba cu klama rode poi ckule naku
    For some children, for every school,
        they don't go to it.

<a id="e11d6"
name="e11d6">11.6)</a> su'oda poi verba cu klama naku su'ode poi ckule
    Some children don't go to (some) school(s).

<a id="e11d7"
name="e11d7">11.7)</a> naku roda poi verba cu klama su'ode poi ckule
    It is false that all children go to some school(s).
</pre>

    <p>In <a href="#e11d5">Example 11.5</a>, we moved the negation
    boundary rightward across the quantifier of ``de'', forcing us
    to invert it. In <a href="#e11d7">Example 11.7</a> we moved the
    negation boundary across the quantifier of ``da'', forcing us
    to invert it instead. <a href="#e11d6">Example 11.6</a> merely
    switched the selbri and the negation boundary, with no effect
    on the quantifiers.</p>

    <p>The same rules apply if you rearrange the sentence so that
    the quantifier crosses an otherwise fixed negation. You can't
    just convert the selbri of <a href="#e11d4">Example 11.4</a>
    and rearrange the sumti to produce</p>
<pre>
<a id="e11d8"
name="e11d8">11.8)</a>    su'ode poi ckule ku'o naku se klama roda poi verba
    Some schools aren't gone-to-by every child.
</pre>
    or rather, <a href="#e11d8">Example 11.8</a> means something
    completely different from <a href="#e11d4">Example 11.4</a>.
    Conversion with ``se'' under ``naku'' negation is not
    symmetric; not all sumti are treated identically, and some
    sumti are not invariant under conversion. These complications
    would make Lojban much harder to learn (just as their
    corresponding natural language constructs are difficult to
    learn). Thus, internal negation with ``naku'' is considered an
    advanced technique, used to achieve stylistic compatibility
    with natural languages. 

    <p>It isn't always easy to see which quantifiers have to be
    inverted in a sentence. <a href="#e11d4">Example 11.4</a> is
    identical in meaning to:</p>
<pre>
<a id="e11d9"
name="e11d9">11.9)</a>    su'o verba naku klama su'o ckule
    Some children don't go-to some school.
</pre>
    but in <a href="#e11d9">Example 11.9</a>, the bound variables
    ``da'' and ``de'' have been hidden. 

    <p>It is trivial to export an internal bridi negation expressed
    with ``na'' to the prenex, as we saw in <a href="#s9">Section
    9</a>; you just move it to the left end of the prenex. In
    comparison, it is non-trivial to export a ``naku'' to the
    prenex because of the quantifiers. The rules for exporting
    ``naku'' require that you export all of the quantified
    variables (implicit or explicit) along with ``naku'', and you
    must export them from left to right, in the same order that
    they appear in the sentence. Thus <a href="#e11d4">Example
    11.4</a> goes into prenex form as:</p>
<pre>
<a id="e11d10" name="e11d10">11.10)</a>  su'oda poi verba ku'o naku
        su'ode poi ckule zo'u
            da klama de
    For some X which is a child, it is not the case that
        there is a Y which is a school such that:
            X goes to Y.
</pre>

    <p>We can now move the ``naku'' to the left end of the prenex,
    getting a contradictory negation that can be expressed with
    ``na'':</p>
<pre>
<a id="e11d11" name="e11d11">11.11)</a>  naku roda poi verba
        su'ode poi ckule zo'u
            da klama de
    It is not the case that for all X's which are children,
        there is a Y which is a school such that:
            X goes to Y.
</pre>
    from which we can restore the quantified variables to the
    sentence, giving: 
<pre>
<a id="e11d12"
name="e11d12">11.12)</a>  naku zo'u roda poi verba cu klama su'ode poi ckule
    It is not the case that all children go to some school.
</pre>
    or more briefly 
<pre>
<a id="e11d13"
name="e11d13">11.13)</a>  ro verba cu na klama su'o ckule
    All children [false] go-to some school(s).
</pre>
    As noted in <a href="#s5">Section 5</a>, a sentence with two
    different quantified variables, such as <a
    href="#e11d13">Example 11.13</a>, cannot always be converted
    with ``se'' without first exporting the quantified variables.
    When the variables have been exported, the sentence proper can
    be converted, but the quantifier order in the prenex must
    remain unchanged: 
<pre>
<a id="e11d14" name="e11d14">11.14)</a>  roda poi verba
        su'ode poi ckule zo'u
            de na se klama da
    It is not the case that for all X's which are children,
        there is a Y which is a school such that:
            Y is gone to by X.
</pre>
    While you can't freely convert with ``se'' when you have two
    quantified variables in a sentence, you can still freely move
    sumti to either side of the selbri, as long as the order isn't
    changed. If you use ``na'' negation in such a sentence, nothing
    special need be done. If you use ``naku'' negation, then
    quantified variables that cross the negation boundary must be
    inverted. 

    <p>Clearly, if all of Lojban negation was built on ``naku''
    negation instead of ``na'' negation, logical manipulation in
    Lojban would be as difficult as in natural languages. In <a
    href="#s12">Section 12</a>, for example, we'll discuss
    DeMorgan's Law, which must be used whenever a sumti with a
    logical connection is moved across a negation boundary.</p>

    <p>Since ``naku'' has the grammar of a sumti, it can be placed
    almost anywhere a sumti can go, including ``be'' and ``bei''
    clauses; it isn't clear what these mean, and we recommend
    avoiding such constructs.</p>

    <p>You can put multiple ``naku''s in a sentence, each forming a
    separate negation boundary. Two adjacent ``naku''s in a bridi
    are a double negative and cancel out:</p>
<pre>
<a id="e11d16"
name="e11d16">11.16)</a>  mi naku naku le zarci cu klama
</pre>

    <p>Other expressions using two ``naku''s may or may not cancel
    out. If there is no quantified variable between them, then the
    ``naku''s cancel.</p>

    <p>Negation with internal ``naku'' is clumsy and non-intuitive
    for logical manipulations, but then, so are the natural
    language features it is emulating.</p>

    <h3><a id="s12" name="s12">12. Logical Connectives and DeMorgan's Law</h3>

    <p>DeMorgan's Law states that when a logical connective between
    terms falls within a negation, then expanding the negation
    requires a change in the connective. Thus (where ``p'' and
    ``q'' stand for terms or sentences) ``not (p or q)'' is
    identical to ``not p and not q'', and ``not (p and q)'' is
    identical to ``not p or not q''. The corresponding changes for
    the other two basic Lojban connectives are: ``not (p equivalent
    to q)'' is identical to ``not p exclusive-or not q'', and ``not
    (p whether-or-not q)'' is identical to both ``not p
    whether-or-not q'' and ``not p whether-or-not not q''. In any
    Lojban sentence having one of the basic connectives, you can
    substitute in either direction from these identities. (These
    basic connectives are explained in <a
    href="chapter14.html">Chapter 14</a>.)</p>

    <p>The effects of DeMorgan's Law on the logical connectives
    made by modifying the basic connectives with ``nai'', ``na''
    and ``se'' can be derived directly from these rules; modify the
    basic connective for DeMorgan's Law by substituting from the
    above identities, and then, apply each ``nai'', ``na'' and
    ``se'' modifier of the original connectives. Cancel any double
    negatives that result.</p>

    <p>When do we apply DeMorgan's Law? Whenever we wish to
    ``distribute'' a negation over a logical connective; and, for
    internal ``naku'' negation, whenever a logical connective moves
    in to, or out of, the scope of a negation --- when it crosses a
    negation boundary.</p>

    <p>Let us apply DeMorgan's Law to some sample sentences. These
    sentences make use of forethought logical connectives, which
    are explained in <a href="chapter14.html">Chapter 14</a>. It
    suffices to know that ``ga'' and ``gi'', used before each of a
    pair of sumti or bridi, mean ``either'' and ``or''
    respectively, and that ``ge'' and ``gi'' used similarly mean
    ``both'' and ``and''. Furthermore, ``ga'', ``ge'', and ``gi''
    can all be suffixed with ``nai'' to negate the bridi or sumti
    that follows.</p>

    <p>We have defined ``na'' and ``naku zo'u'' as, respectively,
    internal and external bridi negation. These forms being
    identical, the negation boundary always remains at the left end
    of the prenex. Thus, exporting or importing negation between
    external and internal bridi negation forms never requires
    DeMorgan's Law to be applied. <a href="#e12d1">Example 12.1</a>
    and <a href="#e12d2">Example 12.2</a> are exactly
    equivalent:</p>

    <p></p>
<pre>
<a id="e12d1"
name="e12d1">12.1)</a>    la djan. na klama ga la paris. gi la rom.
    John [false] goes-to either Paris or Rome.

<a id="e12d2"
name="e12d2">12.2)</a> naku zo'u la djan. klama ga la paris. gi la rom.
    It-is-false that: John goes-to either Paris or Rome.
</pre>
    It is not an acceptable logical manipulation to move a negator
    from the bridi level to one or more sumti. However, <a
    href="#e12d1">Example 12.1</a> and related examples are not
    sumti negations, but rather expand to form two logically
    connected sentences. In such a situation, DeMorgan's Law must
    be applied. For instance, <a href="#e12d2">Example 12.2</a>
    expands to: 
<pre>
<a id="e12d3"
name="e12d3">12.3)</a>    ge la djan. la paris. na klama
        gi la djan. la rom. na klama
    [It is true that] both John, to-Paris, [false] goes,
        and John, to-Rome, [false] goes.
</pre>

    <p>The ``ga'' and ``gi'', meaning ``either-or'', have become
    ``ge'' and ``gi'', meaning ``both-and'', as a consequence of
    moving the negators into the individual bridi.</p>

    <p>Here is another example of DeMorgan's Law in action,
    involving bridi-tail logical connection (explained in <a
    href="chapter14.html">Chapter 14</a>):</p>
<pre>
<a id="e12d4"
name="e12d4">12.4)</a>    la djein. le zarci na ge dzukla gi bajrykla
    Jane to-the market [false] both walks and runs.

<a id="e12d5"
name="e12d5">12.5)</a> la djein. le zarci ganai dzukla ginai bajrykla
    Jane to-the market either [false] walks or [false] runs.
    Jane to-the market if walks then ([false] runs).
</pre>
    (Placing ``le zarci'' before the selbri makes sure that it is
    properly associated with both parts of the logical connection.
    Otherwise, it is easy to erroneously leave it off one of the
    two sentences.) 

    <p>It is wise, before freely doing transformations such as the
    one from <a href="#e12d4">Example 12.4</a> to <a
    href="#e12d5">Example 12.5</a>, that you become familiar with
    expanding logical connectives to separate sentences,
    transforming the sentences, and then recondensing. Thus, you
    would prove the transformation correct by the following steps.
    By moving its ``na'' to the beginning of the prenex as a
    ``naku'', <a href="#e12d4">Example 12.4</a> becomes:</p>
<pre>
<a id="e12d6"
name="e12d6">12.6)</a>    naku zo'u la djein. le zarci
        ge dzukla gi bajrykla
    It is false that : Jane to-the market
        (both walks and runs).
</pre>

    <p>And by dividing the bridi with logically connected selbri
    into two bridi,</p>
<pre>
<a id="e12d7"
name="e12d7">12.7)</a>    naku zo'u ge la djein. le zarci dzukla
        gi la djein. le zarci bajrykla
    It-is-false-that: both (Jane to-the market walks)
        and (Jane to-the market runs).
</pre>
    is the result. 

    <p>At this expanded level, we apply DeMorgan's Law to
    distribute the negation in the prenex across both sentences, to
    get</p>
<pre>
<a id="e12d8"
name="e12d8">12.8)</a>    ga la djein. le zarci na dzukla
        gi la djein. le zarci na bajrykla
    Either Jane to-the market [false] walks,
        or Jane to-the market [false] runs.
</pre>
    which is the same as 
<pre>
<a id="e12d9"
name="e12d9">12.9)</a>    ganai la djein. le zarci dzukla
        ginai la djein. le zarci bajrykla
    If Jane to-the market walks,
        then Jane to-the market [false] runs.
    If Jane walks to the market, then she doesn't run.
</pre>
    which then condenses down to <a href="#e12d5">Example 12.5</a>.
    

    <p>DeMorgan's Law must also be applied to internal ``naku''
    negations:</p>
<pre>
<a id="e12d10"
name="e12d10">12.10)</a>  ga la paris. gi la rom. naku se klama la djan.
    (Either Paris or Rome) is-not gone-to-by John.

<a id="e12d11"
name="e12d11">12.11)</a>   la djan. naku klama ge la paris. gi la rom.
    John doesn't go-to both Paris and Rome.
</pre>

    <p>That <a href="#e12d10">Example 12.10</a> and <a
    href="#e12d11">Example 12.11</a> mean the same should become
    evident by studying the English. It is a good exercise to work
    through the Lojban and prove that they are the same.</p>

    <h3><a id="s13" name="s13">13. selbri variables</h3>

    <p>In addition to the variables ``da'', ``de'', and ``di'' that
    we have seen so far, which function as sumti and belong to
    selma'o KOhA, there are three corresponding variables ``bu'a'',
    ``bu'e'', and ``bu'i'' which function as selbri and belong to
    selma'o GOhA. These new variables allow existential or
    universal claims which are about the relationships between
    objects rather than the objects themselves. We will start with
    the usual silly examples; the literal translation will
    represent ``bu'a'', ``bu'e'' and ``bu'i'' with F, G, and H
    respectively.</p>

    <p></p>
<pre>
<a id="e13d1" name="e13d1">13.1)</a>    su'o bu'a zo'u
        la djim. bu'a la djan.
    For-at-least-one relationship-F :
        Jim stands-in-relationship-F to-John.
    There's some relationship between Jim and John.
</pre>
    The translations of <a href="#e13d1">Example 13.1</a> show how
    unidiomatic selbri variables are in English; Lojban sentences
    like <a href="#e13d1">Example 13.1</a> need to be totally
    reworded in English. Furthermore, when a selbri variable
    appears in the prenex, it is necessary to precede it with a
    quantifier such as ``su'o''; it is ungrammatical to just say
    ``bu'a zo'u''. This rule is necessary because only sumti can
    appear in the prenex, and ``su'o bu'a'' is technically a sumti
    --- in fact, an indefinite description like ``re nanmu'', since
    ``bu'a'' is grammatically equivalent to a brivla like
    ``nanmu''. However, indefinite descriptions involving the
    bu'a-series cannot be imported from the prenex. 

    <p>When the prenex is omitted, the preceding number has to be
    omitted too:</p>
<pre>
<a id="e13d2" name="e13d2">13.2)</a>    la djim. bu'a la djan.
    Jim stands-in-at-least-one-relationship to-John.
</pre>
    As a result, if the number before the variable is anything but
    ``su'o'', the prenex is required: 
<pre>
<a id="e13d3" name="e13d3">13.3)</a>    ro bu'a zo'u
        la djim. bu'a la djan.
    For-every relationship-F :
        Jim stands-in-relationship-F to-John.
    Every relationship exists between Jim and John.
</pre>
    <a href="#e13d1">Example 13.1</a> and <a href="#e13d2">Example
    13.2</a> are almost certainly true: Jim and John might be
    brothers, or might live in the same city, or at least have the
    property of being jointly human. <a href="#e13d3">Example
    13.3</a> is palpably false, however; if Jim and John were
    related by every possible relationship, then they would have to
    be both brothers and father-and-son, which is impossible. 

    <h3><a id="s14" name="s14">14. A few notes on variables</h3>

    <p>A variable may have a quantifier placed in front of it even
    though it has already been quantified explicitly or implicitly
    by a previous appearance, as in:</p>

    <p></p>
<pre>
<a id="e14d1"
name="e14d1">14.1)</a>    ci da poi mlatu cu blaci .ije re da cu barda
    Three Xs which-are cats are white, and two Xs are big.
</pre>

    <p>What does <a href="#e14d1">Example 14.1</a> mean? The
    appearance of ``ci da'' quantifies ``da'' as referring to three
    things, which are restricted by the relative clause to be cats.
    When ``re da'' appears later, it refers to two of the those
    three things --- there is no saying which ones. Further uses of
    ``da'' alone, if there were any, would refer once more to the
    three cats, so the requantification of ``da'' is purely
    local.</p>

    <p>In general, the scope of a prenex that precedes a sentence
    extends to following sentences that are joined by ijeks
    (explained in <a href="chapter14.html">Chapter 14</a>) such as the
    ``.ije'' in <a href="#e14d1">Example 14.1</a>. Theoretically, a
    bare ``.i'' terminates the scope of the prenex. Informally,
    however, variables may persist for a while even after an
    ``.i'', as if it were an ``.ije''. Prenexes that precede
    embedded bridi such as relative clauses and abstractions extend
    only to the end of the clause, as explained in <a
    href="#s8">Section 8</a>. A prenex preceding ``tu'e ... tu'u''
    long-scope brackets persists until the ``tu'u'', which may be
    many sentences or even paragraphs later.</p>

    <p>If the variables ``da'', ``de'', and ``di'' (or the selbri
    variables ``bu'a'', ``bu'e'', and ``bu'i'') are insufficient in
    number for handling a particular problem, the Lojban approach
    is to add a subscript to any of them. Each possible different
    combination of a subscript and a variable cmavo counts as a
    distinct variable in Lojban. Subscripts are explained in full
    in <a href="chapter19.html">Chapter 19</a>, but in general consist
    of the cmavo ``xi'' (of selma'o XI) followed by a number, one
    or more lerfu words forming a single string, or a general
    mathematical expression enclosed in parentheses.</p>

    <p>A quantifier can be prefixed to a variable that has already
    been bound either in a prenex or earlier in the bridi,
    thus:</p>
<pre>
<a id="e14d2"
name="e14d2">14.2)</a>    ci da poi prenu cu se ralju pa da
    Three Xs which are-persons are-led-by one-of X
    Three people are led by one of them.
</pre>

    <p>The ``pa da'' in <a href="#e14d2">Example 14.2</a> does not
    specify the number of things to which ``da'' refers, as the
    preceding ``ci da'' does. Instead, it selects one of them for
    use in this sumti only. The number of referents of ``da''
    remains three, but a single one (there is no way of knowing
    which one) is selected to be the leader.</p>

    <h3><a id="s15" name="s15">15. Conclusion</h3>

    <p>This chapter is incomplete. There are many more aspects of
    logic that I neither fully understand nor feel competent to
    explain, neither in abstract nor in their Lojban realization.
    Lojban was designed to be a language that makes predicate logic
    speakable, and achieving that goal completely will need to wait
    for someone who understands both logic and Lojban better than I
    do. I can only hope to have pointed out the areas that are
    well-understood (and by implication, those that are not).</p>

    <hr />
    
    <p>Última modificación: Mon Jun 27 23:13:01 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
