
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//SV" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="sv" lang="sv">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 14</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter14.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 14<br />
      If Wishes Were Horses: The Lojban Connective System</h2>

      <!--
      <h6>$Revision: 4.1 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. Logical connection and truth tables</h3>

    <p>Lojban is a logical language: the name of the language
    itself means ``logical language''. The fundamentals of ordinary
    logic (there are variant logics, which aren't addressed in this
    book) include the notions of a ``sentence'', (sometimes called
    a ``statement'' or ``proposition''), which asserts a truth or
    falsehood, and a small set of ``truth functions'', which
    combine two sentences to create a new sentence. The truth
    functions have the special characteristic that the truth value
    (that is, the truth or falsehood) of the results depends only
    on the truth value of the component sentences. For example,</p>

    <p></p>
<pre>
<a id="e1d1"
name="e1d1">1.1)</a>  John is a man or James is a woman.
</pre>
    is true if ``John is a man'' is true, or if ``James is a
    woman'' is true. If we know whether John is a man, and we know
    whether James is a woman, we know whether ``John is a man or
    James is a woman'' is true, provided we know the meaning of
    ``or''. Here ``John is a man'' and ``James is a woman'' are the
    component sentences. 

    <p>We will use the phrase ``negating a sentence'' to mean
    changing its truth value. An English sentence may always be
    negated by prefixing ``It is false that ... '', or more
    idiomatically by inserting ``not'' at the right point,
    generally before the verb. ``James is not a woman'' is the
    negation of ``James is a woman'', and vice versa. Recent slang
    can also negate a sentence by following it with the exclamation
    ``Not!''</p>

    <p>Words like ``or'' are called ``logical connectives'', and
    Lojban has many of them, as befits a logical language. This
    chapter is mostly concerned with explaining the forms and uses
    of the Lojban logical connectives. There are a number of other
    logical connectives in English such as ``and'', ``and/or'',
    ``if'', ``only if'', ``whether or not'', and others; however,
    not every use of these English words corresponds to a logical
    connective. This point will be made clear in particular cases
    as needed. The other English meanings are supported by
    different Lojban connective constructs.</p>

    <p>The Lojban connectives form a system (as the title of this
    chapter suggests), regular and predictable, whereas
    natural-language connectives are rather less systematic and
    therefore less predictable.</p>

    <p>There exist 16 possible different truth functions. A truth
    table is a graphical device for specifying a truth function,
    making it clear what the value of the truth function is for
    every possible value of the component sentences. Here is a
    truth table for ``or'':</p>
<pre>
   first       second      result
    -------     -------     ------
    True        True        True
    True        False       True
    False       True        True
    False       False       False
</pre>

    <p>This table means that if the first sentence stated is true,
    and the second sentence stated is true, then the result of the
    truth function is also true. The same is true for every other
    possible combination of truth values except the one where both
    the first and the second sentences are false, in which case the
    truth value of the result is also false.</p>

    <p>Suppose that ``John is a man'' is true (and ``John is not a
    man'' is false), and that ``James is a woman'' is false (and
    ``James is not a woman'' is true). Then the truth table tells
    us that</p>

    <dl>
      <dt></dt>

      <dd>``John is a man, or James is not a woman'' (true, true)
      is true; ``John is a man, or James is a woman'' (true, false)
      is true; ``John is not a man, or James is not a woman''
      (false, true) is true; ``John is not a man, or James is a
      woman'' (false, false) is false.</dd>
    </dl>

    <p>
    Note that the kind of ``or'' used
    in this example can also be expressed (in formal English) with
    ``and/or''. There is a different truth table for the kind of
    ``or'' that means ``either ... or ... but not both''. 
    </p>

    <p>To save space, we will write truth tables in a shorter
    format henceforth. Let the letters T and F stand for True and
    False. The rows will always be given in the order shown above:
    TT, TF, FT, FF for the two sentences. Then it is only necessary
    to give the four letters from the result column, which can be
    written TTTF, as can be seen by reading down the third column
    of the table above. So TTTF is the abbreviated truth table for
    the ``or'' truth function. Here are the 16 possible truth
    functions, with an English version of what it means to assert
    that each function is, in fact, true (``first'' refers to the
    first sentence, and ``second'' to the second sentence):</p>

    <p></p>
<pre>
   TTTT    (always true)
    TTTF    first is true and/or second is true.
    TTFT    first is true if second is true.
    TTFF    first is true whether or not second is true.
    TFTT    first is true only if second is true.
    TFTF    whether or not first is true, second is true.
    TFFT    first is true if and only if second is true.
    TFFF    first is true and second is true

    FTTT    first and second are not both true.
    FTTF    first or second is true, but not both.
    FTFT    whether or not first is true, second is false.
    FTFF    first is true, but second is false.
    FFTT    first is false whether or not second is true.
    FFTF    first is false, but second is true.
    FFFT    neither first nor second is true.
    FFFF    (always false)
</pre>

    <p>Skeptics may work out the detailed truth tables for
    themselves.</p>

    <h3><a id="s2" name="s2">2. The Four basic vowels</h3>

    <p>Lojban regards four of these 16 truth functions as
    fundamental, and assigns them the four vowels <span
    class="c3">A</span>, <span class="c3">E</span>, <span
    class="c3">O</span>, and <span class="c3">U</span>. These
    letters do not represent actual cmavo or selma'o, but rather a
    component vowel from which actual logical-connective cmavo are
    built up, as explained in the next section. Here are the four
    vowels, their truth tables, and rough English equivalents:</p>

    <p></p>
<pre>
   <span class="c3">A</span>   TTTF    or, and/or
    <span class="c3">E</span>   TFFF    and
    <span class="c3">O</span>   TFFT    if and only if
    <span class="c3">U</span>   TTFF    whether or not
</pre>

    <p>More precisely:</p>

    <dl>
      <dt></dt>

      <dd><span class="c3">A</span> is true if either or both
      sentences are true; <span class="c3">E</span> is true if both
      sentences are true, but not otherwise; <span
      class="c3">O</span> is true if the sentences are both true or
      both false; <span class="c3">U</span> is true if the first
      sentence is true, regardless of the truth value of the second
      sentence.</dd>
    </dl>
    With the four vowels, the ability to negate either sentence,
    and the ability to exchange the sentences, as if their order
    had been reversed, we can create all of the 16 possible truth
    functions except TTTT and FFFF, which are fairly useless
    anyway. The following table illustrates how to create each of
    the 14 remaining truth functions: 
<pre>
   TTTF    <span class="c3">A</span>
    TTFT    <span class="c3">A</span> with second sentence negated
    TTFF    <span class="c3">U</span>
    TFTT    <span class="c3">A</span> with first sentence negated
    TFTF    <span class="c3">U</span> with sentences exchanged
    TFFT    <span class="c3">O</span>
    TFFF    <span class="c3">E</span>

    FTTT    <span class="c3">A</span> with both sentences negated
    FTTF    <span
class="c3">O</span> with either first or second negated (not both)
    FTFT    <span
class="c3">U</span> with sentences exchanged and then second negated
    FTFF    <span class="c3">E</span> with second sentence negated
    FFTT    <span class="c3">U</span> with first sentence negated
    FFTF    <span class="c3">E</span> with first sentence negated
    FFFT    <span class="c3">E</span> with both sentences negated
</pre>
    Note that exchanging the sentences is only necessary with <span
    class="c3">U</span>. The three other basic truth functions are
    commutative; that is, they mean the same thing regardless of
    the order of the component sentences. There are other ways of
    getting some of these truth tables; these just happen to be the
    methods usually employed. 

    <h3><a id="s3" name="s3">3. The six types of logical connectives</h3>

    <p>In order to remain unambiguous, Lojban cannot have only a
    single logical connective for each truth function. There are
    many places in the grammar of the language where logical
    connection is permitted, and each must have its appropriate set
    of connectives. If the connective suitable for sumti were used
    to connect selbri, ambiguity would result. Consider the English
    sentence:</p>

    <p></p>
<pre>
<a id="e3d1"
name="e3d1">3.1)</a>  Mary went to the window and  ... 
</pre>
    where the last word could be followed by ``the door'', a noun
    phrase, or by ``saw the horses'', a sentence with subject
    omitted, or by ``John went to the door'', a full sentence, or
    by one of a variety of other English grammatical constructions.
    Lojban cannot tolerate such grammatical looseness. 

    <p>Instead, there are a total of five different selma'o used
    for logical connection: A, GA, GIhA, GUhA, and JA. Each of
    these includes four cmavo, one based on each of the four
    vowels, which is always the last vowel in the cmavo. In selma'o
    A, the vowel is the entire cmavo.</p>

    <p>Thus, in selma'o A, the cmavo for the function <span
    class="c3">A</span> is ``a''. (Do not confuse A, which is a
    selma'o, with <span class="c3">A</span>, which is a truth
    function, or ``a'', which is a cmavo.) Likewise, the cmavo for
    <span class="c3">E</span> in selma'o GIhA is ``gi'e'', and the
    cmavo for <span class="c3">U</span> in selma'o GA is ``gu''.
    This systematic regularity makes the cmavo easier to learn.</p>

    <p>Obviously, four cmavo are not enough to express the 14 truth
    functions explained in <a href="#s1">Section 1</a>. Therefore,
    compound cmavo must be used. These compound cmavo follow a
    systematic pattern: each has one cmavo from the five logical
    connection selma'o at its heart, and may also contain one or
    more of the auxiliary cmavo ``se'', ``na'', or ``nai''. Which
    auxiliaries are used with which logical connection cmavo, and
    with what grammar and meaning, will be explained in the
    following sections. The uses of each of these auxiliary cmavo
    relates to its other uses in other parts of Lojban grammar.</p>

    <p>For convenience, each of the types of compound cmavo used
    for logical connection is designated by a Lojban name. The name
    is derived by changing the final ``-A'' of the selma'o name to
    ``-ek''; the reasons for using ``-ek'' are buried deep in the
    history of the Loglan Project. Thus, compound cmavo based on
    selma'o A are known as eks, and those based on selma'o JA are
    known as jeks. (When writing in English, it is conventional to
    use ``eks'' as the plural of ``ek''.) When the term ``logical
    connective'' is used in this chapter, it refers to one or more
    of these kinds of compound cmavo.</p>

    <p>Why does the title of this section refer to ``six types''
    when there are only five selma'o? A jek may be preceded by
    ``.i'', the usual Lojban cmavo for connecting two sentences.
    The compound produced by ``.i'' followed by a jek is known as
    an ijek. It is useful to think of ijeks as a sixth kind of
    logical connective, parallel to eks, jeks, geks, giheks, and
    guheks.</p>

    <p>There also exist giks, joiks, ijoiks, and joigiks, which are
    not logical connectives but are other kinds of compound cmavo
    which will be introduced later.</p>

    <h3><a id="s4" name="s4">4. Logical connection of bridi</h3>

    <p>Now we are ready to express <a href="#e1d1">Example 1.1</a>
    in Lojban! The kind of logical connective which is placed
    between two Lojban bridi to connect them logically is an
    ijek:</p>
<pre>
<a id="e4d1"
name="e4d1">4.1)</a>  la djan. nanmu .ija la djeimyz. ninmu
    John is-a-man or James is-a-woman.
</pre>

    <p>Here we have two separate Lojban bridi, ``la djan. nanmu''
    and ``la djeimyz. ninmu''. These bridi are connected by
    ``.ija'', the ijek for the truth function <span
    class="c3">A</span>. The ``.i'' portion of the ijek tells us
    that we are dealing with separate sentences here. Similarly, we
    can now say:</p>
<pre>
<a id="e4d2"
name="e4d2">4.2)</a>  la djan. nanmu .ije la djeimyz. ninmu
    John is-a-man and James is-a-woman.

<a id="e4d3"
name="e4d3">4.3)</a>   la djan. nanmu .ijo la djeimyz. ninmu
    John is-a-man if-and-only-if James is-a-woman.

<a id="e4d4"
name="e4d4">4.4)</a>   la djan. nanmu .iju la djeimyz. ninmu
    John is-a-man whether-or-not James is-a-woman.
</pre>
    To obtain the other truth tables listed in <a
    href="#s2">Section 2</a>, we need to know how to negate the two
    bridi which represent the component sentences. We could negate
    them directly by inserting ``na'' before the selbri, but Lojban
    also allows us to place the negation within the connective
    itself. 

    <p>To negate the first or left-hand bridi, prefix ``na'' to the
    JA cmavo but after the ``.i''. To negate the second or
    right-hand bridi, suffix ``-nai'' to the JA cmavo. In either
    case, the negating word is placed on the side of the connective
    that is closest to the bridi being negated.</p>

    <p>So to express the truth table FTTF, which requires <span
    class="c3">O</span> with either of the two bridi negated (not
    both), we can say either:</p>
<pre>
<a id="e4d5"
name="e4d5">4.5)</a>  la djan. nanmu .inajo la djeimyz. ninmu
    John is-not-a-man if-and-only-if James is-a-woman.

<a id="e4d6"
name="e4d6">4.6)</a>   la djan. nanmu .ijonai la djeimyz. ninmu
    John is a man if-and-only-if James is-not-a-woman
</pre>

    <p>The meaning of both <a href="#e4d5">Example 4.5</a> and <a
    href="#e4d6">Example 4.6</a> is the same as that of:</p>
<pre>
<a id="e4d7"
name="e4d7">4.7)</a>  John is a man or James is a woman, but not both.
</pre>

    <p>Here is another example:</p>
<pre>
<a id="e4d8"
name="e4d8">4.8)</a>  la djan. nanmu .ijanai la djeimyz. ninmu
    John is-a-man or James is-not-a-woman.
    John is a man if James is a woman.
</pre>
    How's that again? Are those two English sentences in <a
    href="#e4d8">Example 4.8</a> really equivalent? In English, no.
    The Lojban TTFT truth function can be glossed ``A if B'', but
    the ``if'' does not quite have its English sense. <a
    href="#e4d8">Example 4.8</a> is true so long as John is a man,
    even if James is not a woman; likewise, it is true just because
    James is not a woman, regardless of John's gender. This kind of
    ``if-then'' is technically known as a ``material conditional''.
    

    <p>Since James is not a woman (by our assertions in <a
    href="#s1">Section 1</a>), the English sentence ``John is a man
    if James is a woman'' seems to be neither true nor false, since
    it assumes something which is not true. It turns out to be most
    convenient to treat this ``if'' as TTFT, which on investigation
    means that <a href="#e4d8">Example 4.8</a> is true. <a
    href="#e4d9">Example 4.9</a>, however, is equally true:</p>
<pre>
<a id="e4d9"
name="e4d9">4.9)</a>  la djan. ninmu .ijanai la djeimyz. ninmu
    John is a woman if James is a woman.
</pre>
    This can be thought of as a principle of consistency, and may
    be paraphrased as follows: ``If a false statement is true, any
    statement follows from it.'' All uses of English ``if'' must be
    considered very carefully when translating into Lojban to see
    if they really fit this Lojban mold. 

    <a href="#e4d10">Example 4.10</a>, which uses the TFTT truth
    function, is subject to the same rules: the stated gloss of TFTT as
    ``only if'' works naturally only when the left-hand bridi is true;
    if it is false, the right-hand bridi may be either true or false.
    The last gloss of <a href="#e4d10">Example 4.10</a> illustrates the
    use of ``if ... then'' as a more natural substitute for ``only
    if''.</p>
<pre>
<a id="e4d10"
name="e4d10">4.10)</a>    la djan. nanmu .inaja la djeimyz. ninmu
    John is-not-a-man or James is-a-woman.
    John is a man only if James is a woman.
    If John is a man, then James is a woman.
</pre>
    The following example illustrates the use of ``se'' to, in
    effect, exchange the two sentences. The normal use of ``se'' is
    to (in effect) tranpose places of a bridi, as explained in <a
    href="chapter5.html">Chapter 5</a>. 
<pre>
<a id="e4d11"
name="e4d11">4.11)</a>    la djan. nanmu .iseju la djeimyz. ninmu
    Whether or not John is a man, James is a woman.
</pre>
    If both ``na'' and ``se'' are present, which is legal but never
    necessary, ``na'' would come before ``se''. 

    <p>The full syntax of ijeks, therefore, is:</p>

    <dl>
      <dt></dt>

      <dd>.i [na] [se] JA [nai]</dd>
    </dl>
    where the cmavo in brackets are optional. 

    <h3><a id="s5" name="s5">5. Forethought bridi connection</h3>

    <p>Many concepts in Lojban are expressible in two different
    ways, generally referred to as ``afterthought'' and
    ``forethought''. <a href="#s4">Section 4</a> discussed what is
    called ``afterthought bridi logical connection''. The word
    ``afterthought'' is used because the connective cmavo and the
    second bridi were added, as it were, afterwards and without
    changing the form of the first bridi. This form might be used
    by someone who makes a statement and then wishes to add or
    qualify that statement after it has been completed. Thus,</p>
<pre>
<a id="e5d1" name="e5d1">5.1)</a>  la djan. nanmu
</pre>
    is a complete bridi, and adding an afterthought connection to
    make 
<pre>
<a id="e5d2"
name="e5d2">5.2)</a>  la djan. nanmu .ija la djeimyz. ninmu
    John is a man or James is a woman (or both)
</pre>
    provides additional information without requiring any change in
    the form of what has come before, which may not be possible or
    practical, especially in speaking. (The meaning, however, may
    be changed by the use of a negating connective.) Afterthought
    connectives make it possible to construct all the important
    truth-functional relationships in a variety of ways. 

    <p>In forethought style the speaker decides in advance, before
    expressing the first bridi, that a logical connection will be
    expressed. Forethought and afterthought connectives are
    expressed with separate selma'o: the forethought logical
    connectives corresponding to afterthought ijeks are geks:</p>
<pre>
<a id="e5d3"
name="e5d3">5.3)</a>  ga la djan. nanmu gi la djeimyz. ninmu
    Either John is a man or James is a woman (or both).
</pre>
    ``ga'' is the cmavo which represents the <span
    class="c3">A</span> truth function in selma'o GA. The word
    ``gi'' does not belong to GA at all, but constitutes its own
    selma'o: it serves only to separate the two bridi without
    having any content of its own. The English translation of ``ga
    ... gi'' is ``either ... or'', but in the English form the
    truth function is specified both by the word ``either'' and by
    the word ``or'': not so in Lojban. 

    <p>Even though two bridi are being connected, geks and giks do
    not have any ``.i'' in them. The forethought construct binds up
    the two bridi into a single sentence as far as the grammar is
    concerned.</p>

    <p>Some more examples of forethought bridi connection are:</p>
<pre>
<a id="e5d4"
name="e5d4">5.4)</a>  ge la djan. nanmu gi la djeimyz. ninmu
    (It is true that)
    both John is a man and James is a woman.
</pre>
<pre>
<a id="e5d5" name="e5d5">5.5)</a>  gu la djan. nanmu
        gi la djeimyz. ninmu
    It is true that John is a man,
        whether or not James is a woman.
</pre>

    <p>It is worth emphasizing that <a href="#e5d5">Example 5.5</a>
    does not assert that James is (or is not) a woman. The ``gu''
    which indicates that ``la djeimyz. ninmu'' may be true or false
    is unfortunately rather remote from the bridi thus
    affected.</p>

    <p>Perhaps the most important of the truth functions commonly
    expressed in forethought is TFTT, which can be paraphrased as
    ``if ... then ... '':</p>

    <p></p>
<pre>
<a id="e5d6"
name="e5d6">5.6)</a>  ganai la djan. nanmu gi la djeimyz. ninmu
    Either John is not a man, or James is a woman.
    If John is a man, then James is a woman.
</pre>
    Note the placement of the ``nai'' in <a href="#e5d6">Example
    5.6</a>. When added to afterthought selma'o such as JA, a
    following ``nai'' negates the second bridi, to which it is
    adjacent. Since GA cmavo precede the first bridi, a following
    ``nai'' negates the first bridi instead. 

    <p>Why does English insist on forethought in the translation of
    <a href="#e5d6">Example 5.6</a>? Possibly because it would be
    confusing to seemingly assert a sentence and then make it
    conditional (which, as the Lojban form shows, involves a
    negation). Truth functions which involve negating the first
    sentence may be confusing, even to the Lojbanic understanding,
    when expressed using afterthought.</p>

    <p>It must be reiterated here that not every use of English ``if ...
    then'' is properly translated by ``.inaja'' or ``ganai ... gi'';
    anything with implications of time needs a somewhat different Lojban
    translation, which will be discussed in <a href="#s18">Section
    18</a>. Causal sentences like ``If you feed the pig, then it will
    grow'' are not logical connectives of any type, but rather need a
    translation using ``rinka'' as the selbri joining two event
    abstractions, thus:</p>
<pre>
<a id="e5d7" name="e5d7">5.7)</a>  le nu do cidja dunda fi le xarju
        cu rinka le nu ri ba banro
    The event-of (you food-give to the pig)
        causes the event-of (it will grow).
</pre>

    <p>Causality is discussed in far more detail in <a
    href="chapter9.html">Chapter 9</a>.</p>

    <p><a href="#e5d8">Example 5.8</a> and <a href="#e5d9">Example
    5.9</a> illustrates a truth function, FTTF, which needs to
    negate either the first or the second bridi. We already
    understand how to negate the first bridi:</p>
<pre>
<a id="e5d8"
name="e5d8">5.8)</a>  gonai la djan. nanmu gi la djeimyz. ninmu
    John is-not-a-man if-and-only-if James is-a-woman,
    Either John is a man or James is a woman but not both.
</pre>
    How can the second bridi be negated? By adding ``-nai'' to the
    ``gi''. 
<pre>
<a id="e5d9"
name="e5d9">5.9)</a>  go la djan. nanmu ginai la djeimyz. ninmu
    John is-a-man if-and-only-if James is-not-a-woman.
    Either John is a man or James is a woman but not both.
</pre>
    A compound cmavo based on ``gi'' is called a gik; the only giks
    are ``gi'' itself and ``ginai''. 

    <p>Further examples:</p>
<pre>
<a id="e5d10"
name="e5d10">5.10)</a>    ge la djan. nanmu ginai la djeimyz. ninmu
    John is-a-man and James is-not-a-woman.
</pre>
<pre>
<a id="e5d11"
name="e5d11">5.11)</a>    ganai la djan. nanmu ginai la djeimyz. ninmu
    John is-not-a-man or James is-not-a-woman.
</pre>
    The syntax of geks is: 

    <dl>
      <dt></dt>

      <dd>[se] GA [nai]</dd>
    </dl>
    and of giks (which are not themselves connectives, but part of
    the machinery of forethought connection) is: 

    <dl>
      <dt></dt>

      <dd>gi [nai]</dd>
    </dl>

    <h3><a id="s6" name="s6">6. sumti connection</h3>

    <p>Geks and ijeks are sufficient to state every possible
    logical connection between two bridi. However, it is often the
    case that two bridi to be logically connected have one or more
    portions in common:</p>
<pre>
<a id="e6d1" name="e6d1">6.1)</a>  la djan. klama le zarci
        .ije la .alis. klama le zarci
    John goes to the market,
        and Alice goes to the market.
</pre>

    <p>Here only a single sumti differs between the two bridi.
    Lojban does not require that both bridi be expressed in full.
    Instead, a single bridi can be given which contains both of the
    different sumti and uses a logical connective from a different
    selma'o to combine the two sumti:</p>

    <p></p>
<pre>
<a id="e6d2"
name="e6d2">6.2)</a>  la djan .e la .alis. klama le zarci
    John and Alice go-to the market.
</pre>
    <a href="#e6d2">Example 6.2</a> means exactly the same thing as
    <a href="#e6d1">Example 6.1</a>: one may be rigorously
    transformed into the other without any change of logical
    meaning. This rule is true in general for every different kind
    of logical connection in Lojban; all of them, with one
    exception (see <a href="#s12">Section 12</a>), can always be
    transformed into a logical connection between sentences that
    expresses the same truth function. 

    <p>The afterthought logical connectives between sumti are eks,
    which contain a connective cmavo of selma'o A. If ijeks were
    used in <a href="#e6d2">Example 6.2</a>, the meaning would be
    changed:</p>
<pre>
<a id="e6d3"
name="e6d3">6.3)</a>  la djan. .ije la .alis. klama le zarci
    John [is/does something].  And Alices goes-to the market.
</pre>
    leaving the reader uncertain why John is mentioned at all. 

    <p>Any ek may be used between sumti, even if there is no direct
    English equivalent:</p>
<pre>
<a id="e6d4"
name="e6d4">6.4)</a>  la djan. .o la .alis. klama le zarci
    John if-and-only-if Alice goes-to the market.
    John goes to the market if, and only if, Alice does.
</pre>

    <p>The second line of <a href="#e6d3">Example 6.3</a> is highly
    stilted English, but the first line (of which it is a literal
    translation) is excellent Lojban.</p>

    <p>What about forethought sumti connection? As is the case for
    bridi connection, geks are appropriate. They are not the only
    selma'o of forethought logical-connectives, but are the most
    commonly used ones.</p>
<pre>
<a id="e6d5"
name="e6d5">6.5)</a>  ga la djan. gi la .alis. klama le zarci
    Either John or Alice (or both) goes-to the market.
</pre>
    Of course, eks include all the same patterns of compound cmavo
    that ijeks do. When ``na'' or ``se'' is part of an ek, a
    special writing convention is invoked, as in the following
    example: 

    <p></p>
<pre>
<a id="e6d6"
name="e6d6">6.6)</a>  la djan. na.a la .alis. klama le zarci
    John only if Alice goes-to the market.
    John goes to the market only if Alice does.
</pre>

    <p>Note the period in ``na.a''. The cmavo of A begin with
    vowels, and therefore must always be preceded by a pause. It is
    conventional to write all connective compounds as single words
    (with no spaces), but this pause must still be marked in
    writing as in speech; otherwise, the ``na'' and ``a'' would
    tend to run together.</p>

    <h3><a id="s7" name="s7">7. More than two propositions</h3>

    <p>So far we have seen logical connectives used to connect
    exactly two sentences. How about connecting three or more? Is
    this possible in Lojban? The answer is yes, subject to some
    warnings and some restrictions.</p>

    <p>Of the four primitive truth functions <span
    class="c3">A</span>, <span class="c3">E</span>, <span
    class="c3">O</span>, and <span class="c3">U</span>, all but
    <span class="c3">O</span> have the same truth values no matter
    how their component sentences are associated in pairs.
    Therefore,</p>
<pre>
<a id="e7d1"
name="e7d1">7.1)</a>  mi dotco .ije mi ricfu .ije mi nanmu
    I am-German.  And I am-rich.  And I am-a-man.
</pre>
    means that all three component sentences are true. Likewise, 
<pre>
<a id="e7d2"
name="e7d2">7.2)</a>  mi dotco .ija mi ricfu .ija mi nanmu
    I am-German.  Or I am-rich.  Or I am-a-man.
</pre>
    means that one or more of the component sentences is true. 

    <p><span class="c3">O</span>, however, is different. Working
    out the truth table for</p>
<pre>
<a id="e7d3" name="e7d3">7.3)</a>  mi dotco .ijo mi ricfu
        .ijo mi nanmu
    I am-German.  If-and-only-if I am-rich.
        If-and-only-if I am-a-man.
</pre>
    shows that <a href="#e7d3">Example 7.3</a> does not mean that
    either I am all three of these things or none of them; instead,
    an accurate translation would be: 

    <dl>
      <dt></dt>

      <dd>Of the three properties --- German-ness, wealth, and
      manhood -- I possess either exactly one or else all
      three.</dd>
    </dl>
    Because of the counterintuitiveness of this outcome, it is
    safest to avoid <span class="c3">O</span> with more than two
    sentences. Likewise, the connectives which involve negation
    also have unexpected truth values when used with more than two
    sentences. 

    <p>In fact, no combination of logical connectives can produce
    the ``all or none'' interpretation intended (but not achieved)
    by <a href="#e7d3">Example 7.3</a> without repeating one of the
    bridi. See <a href="#e8d11">Example 8.11</a>.</p>

    <p>There is an additional difficulty with the use of more than
    two sentences. What is the meaning of:</p>

    <p></p>
<pre>
<a id="e7d4"
name="e7d4">7.4)</a>  mi nelci la djan. .ije mi nelci la martas.
        .ija mi nelci la meris.
    I like John.  And I like Martha.
        Or I like Mary.
</pre>

    <p>Does this mean:</p>
<pre>
<a id="e7d5" name="e7d5">7.5)</a>  I like John, and I like
        either Martha or Mary or both.
</pre>

    <p>Or is the correct translation:</p>
<pre>
<a id="e7d6"
name="e7d6">7.6)</a>  Either I like John and I like Martha,
        or I like Mary, or both.
</pre>
    <a href="#e7d6">Example 7.6</a> is the correct translation of
    <a href="#e7d4">Example 7.4</a>. The reason is that Lojban
    logical connectives pair off from the left, like many
    constructs in the language. This rule, called the left-grouping
    rule, is easy to forget, especially when intuition pulls the
    other way. Forethought connectives are not subject to this
    problem: 
<pre>
<a id="e7d7"
name="e7d7">7.7)</a>  ga ge mi nelci la djan. gi mi nelci la martas.
        gi mi nelci la meris.
    Either (Both I like John and I like Martha)
        or I like Mary.
</pre>
    is equivalent in meaning to <a href="#e7d4">Example 7.4</a>,
    whereas 
<pre>
<a id="e7d8" name="e7d8">7.8)</a>  ge mi nelci la djan. gi
        ga mi nelci la martas. gi mi nelci la meris.
    Both I like John and
        (Either I like Martha or I like Mary).
</pre>
    is not equivalent to <a href="#e7d4">Example 7.4</a>, but is
    instead a valid translation into Lojban, using forethought, of
    <a href="#e7d5">Example 7.5</a>. 

    <h3><a id="s8" name="s8">8. Grouping of afterthought connectives</h3>

    <p>There are several ways in Lojban to render <a
    href="#e7d5">Example 7.5</a> using afterthought only. The
    simplest method is to make use of the cmavo ``bo'' (of selma'o
    BO). This cmavo has several functions in Lojban, but is always
    associated with high precedence and short scope. In particular,
    if ``bo'' is placed after an ijek, the result is a
    grammatically distinct kind of ijek which overrides the regular
    left-grouping rule. Connections marked with ``bo'' are
    interpreted before connections not so marked. <a
    href="#e8d1">Example 8.1</a> is equivalent in meaning to <a
    href="#e7d8">Example 7.8</a>:</p>
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  mi nelci la djan.
        .ije mi nelci la martas.
        .ijabo mi nelci la meris.
    I like John,
        and I like Martha or I like Mary.
</pre>

    <p>The English translation feebly indicates with a comma what
    the Lojban marks far more clearly: the ``I like Martha'' and
    ``I like Mary'' sentences are joined by ``.ija'' first, before
    the result is joined to ``I like John'' by ``.ije''.</p>

    <dl>
      <dt></dt>

      <dd>Eks can have ``bo'' attached in exactly the same way, so
      that <a href="#e8d2">Example 8.2</a> is equivalent in meaning
      to Example 8.l:</dd>

      <dt><a id="e8d2" name="e8d2">8.2)</a></dt>

      <dd>mi nelci la djan. .e la martas. .abo la meris.</dd>
    </dl>
    Forethought connectives, however, never can be suffixed with
    ``bo'', for every use of forethought connectives clearly
    indicates the intended pattern of grouping. 

    <p>What happens if ``bo'' is used on both connectives, giving
    them the same high precedence, as in <a href="#e8d3">Example
    8.3</a>?</p>
<pre>
<a id="e8d3"
name="e8d3">8.3)</a>  mi nelci la djan. .ebo la martas. .abo la meris.
</pre>
    Does this wind up meaning the same as <a href="#e7d4">Example
    7.4</a> and <a href="#e7d6">Example 7.6</a>? Not at all. A
    second rule relating to ``bo'' is that where several
    ``bo''-marked connectives are used in succession, the normal
    Lojban left-grouping rule is replaced by a right-grouping rule.
    As a result, <a href="#e8d3">Example 8.3</a> in fact means the
    same as <a href="#e8d1">Examples 8.1</a> and <a
    href="#e8d2">8.2</a>. This rule may be occasionally exploited
    for special effects, but is tricky to keep straight; in writing
    intended to be easy to understand, multiple consecutive
    connectives marked with ``bo'' should be avoided. 

    <p>The use of ``bo'', therefore, gets tricky in complex
    connections of more than three sentences. Looking back at the
    English translations of <a href="#e7d7">Examples 7.7</a> and
    <a href="#e7d8">7.8</a>, parentheses were used to clarify the
    grouping. These parentheses have their Lojban equivalents, two
    sets of them actually. ``tu'e'' and ``tu'u'' are used with
    ijeks, and ``ke'' and ``ke'e'' with eks and other connectives
    to be discussed later. (``ke'' and ``ke'e'' are also used in
    other roles in the language, but always as grouping markers).
    Consider the English sentence:</p>
<pre>
<a id="e8d4" name="e8d4">8.4)</a>  I kiss you and you kiss me,
        if I love you and you love me.
</pre>
    where the semantics tells us that the instances of ``and'' are
    meant to have higher precedence than that of ``if''. If we wish
    to express <a href="#e8d4">Example 8.4</a> in afterthought, we
    can say: 
<pre>
<a id="e8d5" name="e8d5">8.5)</a>  mi cinba do .ije[bo] do cinba mi
        .ijanai mi prami do .ijebo do prami mi
    I kiss you and you kiss me,
        if I love you and you love me.
</pre>
    marking two of the ijeks with ``bo'' for high precedence. (The
    first ``bo'' is not strictly necessary, because of the
    left-grouping rule, and is shown here in brackets.) 

    <p>But it may be clearer to use explicit parenthesis words and
    say:</p>
<pre>
<a id="e8d6"
name="e8d6">8.6)</a>  tu'e mi cinba do .ije do cinba mi tu'u
        .ijanai tu'e mi prami do .ije do prami mi [tu'u]
    ( I kiss you and you kiss me )
        if ( I love you and you love me ).
</pre>
    where the ``tu'e ... tu'u'' pairs set off the structure. The
    cmavo ``tu'u'' is an elidable terminator, and its second
    occurrence in <a href="#e8d6">Example 8.6</a> is bracketed,
    because all terminators may be elided at the end of text. 

    <p>In addition, parentheses are a general solution: multiple
    parentheses may be nested inside one another, and additional
    afterthought material may be added without upsetting the
    existing structure. Neither of these two advantages apply to
    ``bo'' grouping. In general, afterthought constructions trade
    generality for simplicity.</p>

    <p>Because of the left-grouping rule, the first set of ``tu'e
    ... tu'u'' parentheses may actually be left off altogether,
    producing:</p>
<pre>
<a id="e8d7" name="e8d7">8.7)</a>  mi cinba do .ije do cinba mi
        .ijanai tu'e mi prami do .ije do prami mi [tu'u]
    I kiss you and you kiss me
        if ( I love you and you love me ).
</pre>

    <p>What about parenthesized sumti connection? Consider</p>
<pre>
<a id="e8d8"
name="e8d8">8.8)</a>  I walk to either the market and the house,
        or the school and the office.
</pre>
    Two pairs of parentheses, analogous to <a href="#e8d6">Example
    8.6</a>, would seem to be the right approach. However, it is a
    rule of Lojban grammar that a sumti may not begin with ``ke'',
    so the first set of parentheses must be omitted, producing <a
    href="#e8d10">Example 8.10</a>, which is instead parallel to <a
    href="#e8d7">Example 8.7</a>: 
<pre>
<a id="e8d9" name="e8d9">8.9)</a>  mi dzukla le zarci .e le zdani
        .a ke le ckule .e le briju [ke'e]
    I walk-to the market and the house
        or ( the school and the office ).
</pre>
    If sumti were allowed to begin with ``ke'', unavoidable
    ambiguities would result, so ``ke'' grouping of sumti is
    allowed only just after a logical connective. This rule does
    not apply to ``tu'e'' grouping of bridi, as <a
    href="#e8d6">Example 8.6</a> shows. 

    <p>Now we have enough facilities to handle the problem of <a
    href="#e7d3">Example 7.3</a>: ``I am German, rich, and a man
    --- or else none of these.'' The following paraphrase has the
    correct meaning:</p>
<pre>
<a id="e8d10"
name="e8d10">8.10)</a>     [tu'e] mi dotco .ijo mi ricfu [tu'u]
        .ije tu'e mi dotco .ijo mi nanmu [tu'u]
    ( I am-German if-and-only-if I am-rich )
        and (I am-German if-and-only-if I am-a-man ).
</pre>

    <p>The truth table, when worked out, produces T if and only if
    all three component sentences are true or all three are
    false.</p>

    <h3><a id="s9" name="s9">9. Compound bridi</h3>

    <p>So far we have seen how to handle two sentences that need
    have no similarity at all (bridi connection) and sentences that
    are identical except for a difference in one sumti (sumti
    connection). It would seem natural to ask how to logically
    connect sentences that are identical except for having
    different selbri.</p>

    <p>Surprise! Lojban provides no logical connective that is
    designed to handle selbri and nothing else. Instead, selbri
    connection is provided as part of a more general-purpose
    mechanism called ``compound bridi''. Compound bridi result from
    logically connecting sentences that differ in their selbri and
    possibly some of their sumti.</p>

    <p>The simplest cases result when the x1 sumti is the only
    common point:</p>
<pre>
<a id="e9d1"
name="e9d1">9.1)</a>  mi klama le zarci .ije mi nelci la djan.
    I go to the market, and I like John.
</pre>
    is equivalent in meaning to the compound bridi: 
<pre>
<a id="e9d2"
name="e9d2">9.2)</a>  mi klama le zarci gi'e nelci la djan.
    I go-to the market and like John.
</pre>
    As <a href="#e9d2">Example 9.2</a> indicates, giheks are used
    in afterthought to create compound bridi; ``gi'e'' is the gihek
    corresponding to ``and''. The actual phrases ``klama le zarci''
    and ``nelci la djan.'' that the gihek connects are known as
    ``bridi-tails'', because they represent (in this use) the
    ``tail end'' of a bridi, including the selbri and any following
    sumti, but excluding any sumti that precede the selbri: 
<pre>
<a id="e9d3" name="e9d3">9.3)</a>  mi ricfu gi'e klama le zarci
    I am-rich and go-to the market.
</pre>

    <p>In <a href="#e9d3">Example 9.3</a>, the first bridi-tail is
    ``ricfu'', a simple selbri, and the second bridi-tail is
    ``klama le zarci'', a selbri with one following sumti.</p>

    <p>Suppose that more than a single sumti is identical between
    the two sentences:</p>
<pre>
<a id="e9d4" name="e9d4">9.4)</a>  mi dunda le cukta do
        .ije mi lebna lo rupnu do
    I give the book to-you,
        and I take some currency-units from-you.
</pre>
    In <a href="#e9d4">Example 9.4</a>, the first and last sumti of
    each bridi are identical; the selbri and the second sumti are
    different. By moving the final sumti to the beginning, a form
    analogous to <a href="#e9d2">Example 9.2</a> can be achieved: 
<pre>
<a id="e9d5" name="e9d5">9.5)</a>  fi do fa mi dunda le cukta
        gi'e lebna lo rupnu
    to/from you I give the book
        and take some currency-units.
</pre>
    where the ``fi'' does not have an exact English translation
    because it merely places ``do'' in the third place of both
    ``lebna'' and ``dunda''. However, a form that preserves natural
    sumti order also exists in Lojban. Giheks connect two
    bridi-tails, but also allow sumti to be added following the
    bridi-tail. These sumti are known as tail-terms, and apply to
    both bridi. The straightforward gihek version of <a
    href="#e9d4">Example 9.4</a> therefore is: 

    <p></p>
<pre>
<a id="e9d6" name="e9d6">9.6)</a>  mi dunda le cukta
        gi'e lebna lo rupnu vau do
    I (give the book)
        and (take some currency-units) to/from you.
</pre>
    The ``vau'' (of selma'o VAU) serves to separate the bridi-tail
    from the tail-terms. Every bridi-tail is terminated by an
    elidable ``vau'', but only in connection with compound bridi is
    it ever necessary to express this ``vau''. Thus: 
<pre>
<a id="e9d7" name="e9d7">9.7)</a>  mi klama le zarci [vau]
    I go-to the market.
</pre>
    has a single elided ``vau'', and <a href="#e9d2">Example
    9.2</a> is equivalent to: 
<pre>
<a id="e9d8" name="e9d8">9.8)</a>  mi klama le zarci [vau]
        gi'e nelci la djan. [vau] [vau]
</pre>
    where the double ``vau'' at the end of <a href="#e9d8">Example
    9.8</a> terminates both the right-hand bridi-tail and the
    unexpressed tail-terms. 

    <p>A final use of giheks is to combine bridi-tails used as
    complete sentences, the Lojban observative:</p>
<pre>
<a id="e9d9"
name="e9d9">9.9)</a>  klama le zarci gi'e dzukla le briju
    A goer to-the market and a walker to-the office.
</pre>
    Since x1 is omitted in both of the bridi underlying <a
    href="#e9d9">Example 9.9</a>, this compound bridi does not
    necessarily imply that the goer and the walker are the same.
    Only the presence of an explicit x1 (other than ``zo'e'', which
    is equivalent to omission) can force the goer and the walker to
    be identical. 

    <p>A strong argument for this convention is provided by
    analysis of the following example:</p>
<pre>
<a id="e9d10"
name="e9d10">9.10)</a>     klama la nu,IORK. la finyks.
        gi'e klama la nu,IORK. la rom.
    A goer to-New York from-Phoenix
        and a goer to-New York from-Rome.
</pre>

    <p>If the rule were that the x1 places of the two underlying
    bridi were identified, then (since there is nothing special
    about x1), the unspecified x4 (route) and x5 (means) places
    would also have to be the same, leading to the absurd result
    that the route from Phoenix to New York is the same as the
    route from Rome to New York. Inserting ``da'', meaning roughly
    ``something'', into the x1 place cures the problem:</p>
<pre>
<a id="e9d11"
name="e9d11">9.11)</a>    da klama la nu,IORK. la finyks.
        gi'e klama la nu,IORK. la rom.
    Something is-a-goer to-New York from-Phoenix
        and is-a-goer to-New York from-Rome.
</pre>
    The syntax of giheks is: 

    <dl>
      <dt></dt>

      <dd>[na] [se] GIhA [nai]</dd>
    </dl>
    which is exactly parallel to the syntax of eks. 

    <h3><a id="s10" name="s10">10. Multiple compound bridi</h3>

    <p>Giheks can be combined with ``bo'' in the same way as
    eks:</p>
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    mi nelci la djan.
        gi'e nelci la martas. gi'abo nelci la meris.
    I like John
        and (like Martha or like Mary).
</pre>
    <p>is equivalent in meaning to <a
    href="#e8d1">Example 8.1</a> and <a href="#e8d2">Example
    8.2</a>. Likewise, ``ke ... ke'e'' grouping can be used after
    giheks: 
    </p>
<pre>
<a id="e10d2"
name="e10d2">10.2)</a>    mi dzukla le zarci gi'e dzukla le zdani
        gi'a ke dzukla le ckule gi'e dzukla le briju [ke'e]
    I walk-to the market and walk-to the house,
        or walk-to the school and walk-to the office.
</pre>
    is the gihek version of <a href="#e8d9">Example 8.9</a>. The
    same rule about using ``ke ... ke'e'' bracketing only just
    after a connective applies to bridi-tails as to sumti, so the
    first two bridi-tails in <a href="#e10d2">Example 10.2</a>
    cannot be explicitly grouped; implicit left-grouping suffices
    to associate them. 

    <p>Each of the pairs of bridi-tails joined by multiple giheks
    can have its own set of tail-terms:</p>
<pre>
<a id="e10d3" name="e10d3">10.3)</a>    mi dejni lo rupnu la djan.
        .inaja mi dunda le cukta la djan.
        .ijabo mi lebna le cukta la djan.
    [If] I owe some currency-units to John,
        then I give the book to John
        or I take the book from John.
</pre>
    is equivalent in meaning to: 

    <p></p>
<pre>
<a id="e10d4"
name="e10d4">10.4)</a>    mi dejni lo rupnu nagi'a dunda gi'abo lebna vau
        le cukta vau la djan.
    [If] I owe some currency-units then (give or take)
        a book to/from John.
</pre>

    <p>The literal English translation in <a href="#e10d4">Example
    10.4</a> is almost unintelligible, but the Lojban is perfectly
    grammatical. ``mi'' fills the x1 place of all three selbri;
    ``lo rupnu'' is the x2 of ``dejni'', whereas ``le cukta'' is a
    tail-term shared between ``dunda'' and ``lebna''; ``la djan.''
    is a tail-term shared by ``dejni'' and by ``dunda gi'abo
    lebna''. In this case, greater clarity is probably achieved by
    moving ``la djan.'' to the beginning of the sentence, as in <a
    href="#e9d5">Example 9.5</a>:</p>
<pre>
<a id="e10d5"
name="e10d5">10.5)</a>    fi la djan. fa mi dejni lo rupnu
        nagi'a dunda gi'abo lebna vau le cukta
    To/from John, [if] I owe some currency-units
        then [I] give or take the book.
</pre>
    Finally, what about forethought logical connection of
    bridi-tails? There is no direct mechanism for the purpose.
    Instead, Lojban grammar allows a pair of forethought-connected
    sentences to function as a single bridi-tail, and of course the
    sentences need not have terms before their selbri. For example:
    
<pre>
<a id="e10d5.5"
name="e10d5.5">10.5.5)</a>    mi ge klama le zarci gi nelci la djan.
    I both go to the market and like John.
</pre>
    is equivalent in meaning to <a href="#e9d2">Example 9.2</a>. 

    <p>Of course, either of the connected sentences may contain
    giheks:</p>
<pre>
<a id="e10d6"
name="e10d6">10.6)</a>    mi ge klama le zarci gi'e dzukla le zdani
        gi nelci la djan.
    I both (go to the market and walk to the house)
        and like John.
</pre>
    The entire gek-connected sentence pair may be negated as a
    whole by prefixing ``na'': 
<pre>
<a id="e10d7"
name="e10d7">10.7)</a>    mi na ge klama le zarci gi dzukla le zdani
    [False!] I both go to the market and walk to the house.
</pre>
    Since a pair of sentences joined by geks is the equivalent of a
    bridi-tail, it may be followed by tail terms. The forethought
    equivalent of <a href="#e9d6">Example 9.6</a> is: 
<pre>
<a id="e10d8" name="e10d8">10.8)</a>    mi ge dunda le cukta
         gi lebna lo rupnu vau do
    I both (give the book)
        and (take some currency-units) to/from you.
</pre>
    Here is a pair of gek-connected observatives, a forethought
    equivalent of <a href="#e9d9">Example 9.9</a>: 
<pre>
<a id="e10d9"
name="e10d9">10.9)</a>    ge klama le zarci gi dzukla le briju
    Both a goer to-the market and a walker to-the office.
</pre>

    <p>Finally, here is an example of gek-connected sentences with
    both shared and unshared terms before their selbri:</p>

    <p></p>
<pre>
<a id="e10d10" name="e10d10">10.10)</a>  mi gonai le zarci cu klama
        gi le bisli cu dansu
    I either-but-not-both to-the office go
        or on-the ice dance.
    I either go to the office or dance on the ice
        (but not both).
</pre>

    <h3><a id="s11" name="s11">11. Termset logical connection</h3>
    So far we have seen sentences that differ in all components,
    and require bridi connection; sentences that differ in one
    sumti only, and permit sumti connection; and sentences that
    differ in the selbri and possibly one or more sumti, and permit
    bridi-tail connection. Termset logical connectives are employed
    for sentences that differ in more than one sumti but not in the
    selbri, such as: 
<pre>
<a id="e11d1"
name="e11d1">11.1)</a>    I go to the market from the office
        and to the house from the school.
</pre>
    The Lojban version of <a href="#e11d1">Example 11.1</a>
    requires two termsets joined by a logical connective. A
    ``term'' is either a sumti or a sumti preceded by a tense or
    modal tag such as ``pu'' or ``bai''. Afterthought termsets are
    formed by linking terms together by inserting the cmavo
    ``ce'e'' (of selma'o CEhE) between each of them. Furthermore,
    the logical connective (which is a jek) must be prefixed by the
    cmavo ``pe'e'' (of selma'o PEhE). (We could refer to the
    combination of ``pe'e'' and a jek as a ``pehejek'', I suppose.)
    

    <p></p>
<pre>
<a id="e11d2"
name="e11d2">11.2)</a>    mi klama le zarci ce'e le briju pe'e je
        le zdani ce'e le ckule
    I go to-the market [plus] from-the office [joint] and
        to-the house [plus] from-the school.
</pre>

    <p>The literal translation uses ``[plus]'' to indicate the
    termset connective, and ``[joint]'' to indicate the position of
    the logical connective joint. As usual, there is an equivalent
    bridi-connection form:</p>
<pre>
<a id="e11d3" name="e11d3">11.3)</a>    mi klama le zarci le briju
        .ije mi klama le zdani le ckule
    I go to-the market from-the office,
        and I go to-the house from-the school.
</pre>
    which illustrates that the two bridi differ in the x2 and x3
    places only. 

    <p>What happens if the two joined sets of terms are of unequal
    length? Expanding to bridi connection will always make clear
    which term goes in which place of which bridi. It can happen
    that a sumti may fall in the x2 place of one bridi and the x3
    place of another:</p>
<pre>
<a id="e11d4" name="e11d4">11.4)</a>    mi pe'e ja do ce'e le zarci
        cu klama le briju
    I [joint] or you to-the market [plus]
        go to/from-the office.
</pre>
    can be clearly understood by expansion to: 
<pre>
<a id="e11d5" name="e11d5">11.5)</a>    mi klama le briju
        .ija do le zarci cu klama le briju
    I go to-the office,
        or you to-the market go from-the office.
</pre>
    So ``le briju'' is your origin but my destination, and thus
    falls in the x2 and x3 places of ``klama'' simultaneously! This
    is legal because even though there is only one selbri,
    ``klama'', there are two distinct bridi expressed here. In
    addition, ``mi'' in <a href="#e11d4">Example 11.4</a> is
    serving as a termset containing only one term. An analogous
    paradox applies to compound bridi with tail-terms and unequal
    numbers of sumti within the connected bridi-tails: 
<pre>
<a id="e11d6"
name="e11d6">11.6)</a>     mi klama le zarci gi'e dzukla vau le briju
    I (go to-the market and walk) to/from-the office.
</pre>
    means that I go to the market from the office, and I walk to
    the office; ``le briju'' is the x3 place of ``klama'' and the
    x2 place of ``dzukla''. 

    <p>Forethought termsets also exist, and use ``nu'i'' of selma'o
    NUhI to signal the beginning and ``nu'u'' of selma'o NUhU (an
    elidable terminator) to signal the end. Nothing is inserted
    between the individual terms: they simply sit side-by-side. To
    make a logical connection in a forethought termset, use a gek,
    with the gek just after the ``nu'i'', and an extra ``nu'u''
    just before the gik:</p>
<pre>
<a id="e11d7"
name="e11d7">11.7)</a>    mi klama nu'i ge le zarci le briju
        nu'u gi le zdani le ckule [nu'u]
    I go [start termset] both to-the market from-the office
        [joint] and to-the house from-the school
        [end termset].
</pre>

    <p>Note that even though two termsets are being connected, only
    one ``nu'i'' is used.</p>

    <p>The grammatical uses of termsets that do not contain logical
    connectives are explained in <a href="chapter12.html">Chapter
    12</a> and <a href="chapter16.html">Chapter 16</a>.</p>

    <h3><a id="s12" name="s12">12. Logical connection within tanru</h3>

    <p>As noted at the beginning of <a href="#s9">Section 9</a>,
    there is no logical connective in Lojban that joins selbri and
    nothing but selbri. However, it is possible to have logical
    connectives within a selbri, forming a kind of tanru that
    involves a logical connection. Consider the simple tanru
    ``blanu zdani'', blue house. Now anything that is a blue ball,
    in the most ordinary understanding of the phrase at least, is
    both blue and a ball. And indeed, instead of ``blanu bolci'',
    Lojbanists can say ``blanu je bolci'', using a jek connective
    within the tanru. (We saw jeks used in <a href="#s11">Section
    11</a> also, but there they were always prefixed by ``pe'e'';
    in this section they are used alone.) Here is a pair of
    examples:</p>

    <p></p>
<pre>
<a id="e12d1" name="e12d1">12.1)</a>    ti blanu zdani
    This is-a-blue type-of house.

<a id="e12d2" name="e12d2">12.2)</a> ti blanu je zdani
    This is-blue and a-house.
</pre>
    But of course <a href="#e12d1">Example 12.1</a> and <a
    href="#e12d2">Example 12.2</a> are not necessarily equivalent
    in meaning! It is the most elementary point about Lojban tanru
    that <a href="#e12d1">Example 12.1</a> might just as well mean 
<pre>
<a id="e12d3"
name="e12d3">12.3)</a>    This is a house for blue inhabitants.
</pre>
    and <a href="#e12d2">Example 12.2</a> certainly is not
    equivalent in meaning to <a href="#e12d3">Example 12.3</a>. 

    <p>A full explanation of logical connection within tanru
    belongs rather to a discussion of selbri structure than to
    logical connectives in general. Why? Because although <a
    href="#e12d2">Example 12.2</a> happens to mean the same as</p>
<pre>
<a id="e12d4" name="e12d4">12.4)</a>    ti blanu gi'e zdani
</pre>
    and therefore as 
<pre>
<a id="e12d5" name="e12d5">12.5)</a>    ti blanu .ije ti zdani
</pre>
    the rule of expansion into separate bridi simply does not
    always work for tanru connection. Supposing Alice to be a
    person who lives in blue houses, then 
<pre>
<a id="e12d6"
name="e12d6">12.6)</a>    la .alis. cu blanu je zdani prenu
    Alice is-a (blue and house) type-of-person.
</pre>
    would be true, because tanru grouping with a jek has higher
    precedence than unmarked tanru grouping, but: 
<pre>
<a id="e12d7" name="e12d7">12.7)</a>    la .alis. cu blanu prenu
        .ije la .alis. cu zdani prenu
    Alice is-a blue person,
        and Alice is-a house person.
</pre>
    is probably false, because the blueness is associated with the
    house, not with Alice, even leaving aside the question of what
    it means to say ``Alice is a blue person''. (Perhaps she
    belongs to the Blue team, or is wearing blue clothes.) The
    semantic ambiguity of tanru make such logical manipulations
    impossible. 

    <p>It suffices to note here, then, a few purely grammatical
    points about tanru logical connection. ``bo'' may be appended
    to jeks as to eks, with the same rules:</p>
<pre>
<a id="e12d8"
name="e12d8">12.8)</a>    la teris. cu ricfu je nakni jabo fetsi
    Terry is rich and (male or female).
</pre>
    The components of tanru may be grouped with ``ke'' both before
    and after a logical connective: 
<pre>
<a id="e12d9"
name="e12d9">12.9)</a>    la .teris. cu [ke] ricfu ja pindi [ke'e]
        je ke nakni ja fetsi [ke'e]
    Terry is (rich or poor)
        and (male or female).
</pre>
    where the first ``ke ... ke'e'' pair may be omitted altogether
    by the rule of left-grouping, but is optionally permitted (as
    in bridi connection). In any case, both instances of ``ke'e''
    may be elided. 

    <p>The syntax of jeks is:</p>

    <dl>
      <dt></dt>

      <dd>[na] [se] JA [nai]</dd>
    </dl>
    parallel to eks and giheks. 

    <p>Forethought tanru connection does not use geks, but uses
    guheks instead. Guheks have exactly the same form as geks:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>[se] GUhA [nai]</dd>
    </dl>
    Using guheks in tanru connection (rather than geks) resolves
    what would otherwise be an unacceptable ambiguity between
    bridi-tail and tanru connection: 
<pre>
<a id="e12d10"
name="e12d10">12.10)</a>  la .alis. gu'e ricfu gi fetsi
    Alice is both rich and female.
</pre>
    Note that giks are used with guheks in exactly the same way
    they are used with geks. Like jeks, guheks bind more closely
    than unmarked tanru grouping does: 
<pre>
<a id="e12d11"
name="e12d11">12.11)</a>  la .alis. gu'e blanu gi zdani prenu
    Alice is-a-(both blue and a-house) type-of-person.
</pre>
    is the forethought version of <a href="#e12d6">Example
    12.6</a>. 

    <p>A word of caution about the use of logically connected tanru
    within descriptions. English-based intuition can lead the
    speaker astray. In correctly reducing</p>
<pre>
<a id="e12d12"
name="e12d12">12.12)</a>  mi viska pa nanmu .ije mi viska pa ninmu
    I see a man, and I see a woman.
</pre>
    to 
<pre>
<a id="e12d13"
name="e12d13">12.13)</a>  mi viska pa nanmu .e pa ninmu
    I see a man and a woman.
</pre>
    there is a great temptation to reduce further to: 

    <p></p>
<pre>
<a id="e12d14" name="e12d14">12.14)</a>  mi viska pa nanmu je ninmu
    I see a man and woman.
</pre>

    <p>But <a href="#e12d14">Example 12.14</a> means that you see
    one thing which is both a man and a woman simultaneously! A
    ``nanmu je ninmu'' is a manwoman, a presumably non-existent
    creature who is both a ``nanmu'' and a ``ninmu''.</p>

    <h3><a id="s13" name="s13">13. Truth questions and connective questions</h3>

    <p>So far we have addressed only sentences which are
    statements. Lojban, like all human languages, needs also to
    deal with sentences which are questions. There are many ways of
    asking questions in Lojban, but some of these (like questions
    about quantity, tense, and emotion) are discussed in other
    chapters.</p>

    <p>The simplest kind of question is of the type ``Is it true
    that ... '' where some statement follows. This type is called a
    ``truth question'', and can be represented in English by <a
    href="#e13d1">Example 13.1</a>:</p>
<pre>
<a id="e13d1"
name="e13d1">13.1)</a>    Is it true that Fido is a dog?
    Is Fido a dog?
</pre>
    Note the two formulations. English truth questions can always
    be formed by prefixing ``Is is true that'' to the beginning of
    a statement; there is also usually a more idiomatic way
    involving putting the verb before its subject. ``Is Alice a
    dog?'' is the truth question corresponding to ``Fido is a
    dog''. In Lojban, the equivalent mechanism is to prefix the
    cmavo ``xu'' (of selma'o UI) to the statement: 
<pre>
<a id="e13d2" name="e13d2">13.2)</a>    xu la faidon. gerku
    is-it-true-that Fido is-a-dog?
</pre>
    <a href="#e13d1">Example 13.1</a> and <a href="#e13d2">Example
    13.2</a> are equivalent in meaning. 

    <p>A truth question can be answered ``yes'' or ``no'',
    depending on the truth or falsity, respectively, of the
    underlying statement. The standard way of saying ``yes'' in
    Lojban is ``go'i'' and of saying ``no'' is ``nago'i''. (The
    reasons for this rule are explained in <a
    href="chapter7.html">Chapter 7</a>.) In answer to <a
    href="#e13d2">Example 13.2</a>, the possible answers are:</p>
<pre>
<a id="e13d3" name="e13d3">13.3)</a>    go'i
    Fido is a dog.
</pre>
    and 
<pre>
<a id="e13d4" name="e13d4">13.4)</a>    nago'i
    Fido is not a dog.
</pre>
    Some English questions seemingly have the same form as the
    truth questions so far discussed. Consider 

    <p></p>
<pre>
<a id="e13d5" name="e13d5">13.5)</a>    Is Fido a dog or a cat?
</pre>

    <p>Superficially, <a href="#e13d5">Example 13.5</a> seems like
    a truth question with the underlying statement:</p>
<pre>
<a id="e13d6" name="e13d6">13.6)</a>    Fido is a dog or a cat.
</pre>

    <p>By translating <a href="#e13d6">Example 13.6</a> into Lojban
    and prefixing ``xu'' to signal a truth question, we get:</p>
<pre>
<a id="e13d7"
name="e13d7">13.7)</a>    xu la faidon. gerku gi'onai mlatu
    is-it-true-that Fido is-a-dog or is-a-cat
        (but not both)?
</pre>

    <p>Given that Fido really is either a dog or a cat, the
    appropriate answer would be ``go'i''; if Fido were a fish, the
    appropriate answer would be ``nago'i''.</p>

    <p>But that is not what an English-speaker who utters <a
    href="#e13d5">Example 13.5</a> is asking! The true significance
    of <a href="#e13d5">Example 13.5</a> is that the speaker
    desires to know the truth value of either of the two underlying
    bridi (it is presupposed that only one is true).</p>

    <p>Lojban has an elegant mechanism for rendering this kind of
    question which is very unlike that used in English. Instead of
    asking about the truth value of the connected bridi, Lojban
    users ask about the truth function which connects them. This is
    done by using a special question cmavo: there is one of these
    for each of the logical connective selma'o, as shown by the
    following table:</p>

    <p></p>
<pre>
   ge'i    GA  forethought connective question
    gi'i    GIhA    bridi-tail connective question
    gu'i    GUhA    tanru forethought connective question
    je'i    JA  tanru connective question
    ji  A   sumti connective question
</pre>
    (This list unfortunately departs from the pretty regularity of
    the other cmavo for logical connection. The two-syllable
    selma'o, GIhA and GUhA, make use of the cmavo ending in ``-i''
    which is not used for a truth function, but ``gi'' and ``.i''
    were not available, and different cmavo had to be chosen. This
    table must simply be memorized, like most other non-connective
    cmavo assignments.) 

    <p>One correct translation of <a href="#e13d5">Example 13.5</a>
    employs a question gihek:</p>
<pre>
<a id="e13d8" name="e13d8">13.8)</a>    la .alis gerku gi'i mlatu
    Alice is-a-dog [truth function?] is-a-cat?
</pre>

    <p>Here are some plausible answers:</p>
<pre>
<a id="e13d9" name="e13d9">13.9)</a>    nagi'e
    Alice is not a dog and is a cat.

<a id="e13d10" name="e13d10">13.10)</a>   gi'enai
    Alice is a dog and is not a cat.

<a id="e13d11" name="e13d11">13.11)</a>   nagi'enai
    Alice is not a dog and is not a cat.

<a id="e13d12" name="e13d12">13.12)</a>   nagi'o
    gi'onai
    Alice is a dog or is a cat but not both
        (I'm not saying which).
</pre>
    <a href="#e13d12">Example 13.12</a> is correct but
    uncooperative. 

    <p>As usual, Lojban questions are answered by filling in the
    blank left by the question. Here the blank is a logical
    connective, and therefore it is grammatical in Lojban to utter
    a bare logical connective without anything for it to
    connect.</p>

    <p>The answer ``gi'e'', meaning that Alice is a dog and is a
    cat, is impossible in the real world, but for:</p>

    <p></p>
<pre>
<a id="e13d13" name="e13d13">13.13)</a>  do djica tu'a loi ckafi
        ji loi tcati
    you desire something-about a-mass-of coffee
        [truth function?] a-mass-of tea?
    Do you want coffee or tea?
</pre>
    the answer ``.e'', meaning that I want both, is perfectly
    plausible, if not necessarily polite. 

    <p>The forethought questions ``ge'i'' and ``gu'i'' are used
    like the others, but ambiguity forbids the use of isolated
    forethought connectives as answers --- they sound like the
    start of forethought-connected bridi. So although <a
    href="#e13d14">Example 13.14</a> is the forethought version of
    <a href="#e13d13">Example 13.13</a>:</p>
<pre>
<a id="e13d14" name="e13d14">13.14)</a>  do djica tu'a
        ge'i loi ckafi
        gi loi tcati
    you desire something-about
        [truth function?] a-mass-of coffee
        [or] a-mass-of tea?
</pre>
    the answer must be in afterthought form. 

    <p>There are natural languages, notably Chinese, which employ
    the Lojbanic form of connective question. The Chinese
    sentence</p>
<pre>
<a id="e13d15"
name="e13d15">13.15)</a>  ni<sup>3</sup> zou<sup>3</sup> hai<sup>2</sup>shi pao<sup>3</sup>
    you walk [or?] run?
</pre>
    means ``Do you walk or run?'', and is exactly parallel to the
    Lojban: 
<pre>
<a id="e13d16" name="e13d16">13.16)</a>  do cadzu gi'i bajra
    you walk [or?] run?
</pre>
    However, Chinese does not use logical connectives in the reply
    to such a question, so the resemblance, though striking, is
    superficial. 

    <p>Truth questions may be used in bridi connection. This form
    of sentence is perfectly legitimate, and can be interpreted by
    using the convention that a truth question is true if the
    answer is ``yes'' and false if the answer is ``no''.
    Analogously, an imperative sentence (involving the special
    pro-sumti ``ko'', which means ``you'' but marks the sentence as
    a command) is true if the command is obeyed, and false
    otherwise. A request of Abraham Lincoln's may be translated
    thus:</p>
<pre>
<a id="e13d17" name="e13d17">13.17)</a>   ganai ti ckafi
        gi ko bevri loi tcati mi
    .ije ganai ti tcati
        gi ko bevri loi ckafi mi
    If this is-coffee
        then [you!] bring a-mass-of tea to-me,
    and if this is-tea
        then [you!] bring a-mass-of coffee to-me.
    If this is coffee, bring me tea;
        but if this is tea, bring me coffee.
</pre>
    In logical terms, however, ``but'' is the same as ``and''; the
    difference is that the sentence after a ``but'' is felt to be
    in tension or opposition to the sentence before it. Lojban
    represents this distinction by adding the discursive cmavo
    ``ku'i'' (of selma'o UI), which is explained in <a
    href="chapter13.html">Chapter 13</a>, to the logical ``.ije''.) 

    <h3><a id="s14" name="s14">14. Non-logical connectives</h3>

    <p>Way back in <a href="#s1">Section 1</a>, the point was made
    that not every use of English ``and'', ``if ... then'', and so
    on represents a Lojban logical connective. In particular,
    consider the ``and'' of:</p>

    <p></p>
<pre>
<a id="e14d1"
name="e14d1">14.1)</a>    John and Alice carried the piano.
</pre>
    Given the nature of pianos, this probably means that John
    carried one end and Alice the other. So it is not true that: 
<pre>
<a id="e14d2" name="e14d2">14.2)</a>    John carried the piano,
        and Alice carried the piano.
</pre>
    which would mean that each of them carried the piano by
    himself/herself. Lojban deals with this particular linguistic
    phenomenon as a ``mass''. John and Alice are joined together
    into a mass, John-and-Alice, and it is this mass which carried
    the piano, not either of them separately. The cmavo ``joi'' (of
    selma'o JOI) is used to join two or more components into a
    mass: 
<pre>
<a id="e14d3"
name="e14d3">14.3)</a>    la djan. joi la .alis. cu bevri le pipno
    John massed-with Alice carry the piano.
</pre>
    <a href="#e14d3">Example 14.3</a> covers the case mentioned,
    where John and Alice divide the labor; it also could mean that
    John did all the hauling and Alice did the supervising. This
    possibility arises because the properties of a mass are the
    properties of its components, which can lead to apparent
    contradictions: if John is small and Alice is large, then
    John-and-Alice is both small and large. Masses are also
    discussed in <a href="chapter6.html">Chapter 6</a>. 

    <p>Grammatically, ``joi'' can appear between two sumti (like an
    ek) or between two tanru components (like a jek). This
    flexibility must be paid for in the form of occasional
    terminators that cannot be elided:</p>

    <p></p>
<pre>
<a id="e14d4"
name="e14d4">14.4)</a>    le nanmu ku joi le ninmu [ku] cu klama le zarci
    The man massed-with the woman go-to the market.
</pre>

    <p>The cmavo ``ku'' is the elidable terminator for ``le'',
    which can almost always be elided, but not in this case. If the
    first ``ku'' were elided here, Lojban's parsing rules would see
    ``le nanmu joi'' and assume that another tanru component is to
    follow; since the second ``le'' cannot be part of a tanru, a
    parsing error results. No such problem can occur with logical
    connectives, because an ek signals a following sumti and a jek
    a following tanru component unambiguously.</p>

    <p>Single or compound cmavo involving members of selma'o JOI
    are called joiks, by analogy with the names for logical
    connectives. It is not grammatical to use joiks to connect
    bridi-tails.</p>

    <p>In tanru, ``joi'' has the connotation ``mixed with'', as in
    the following example:</p>
<pre>
<a id="e14d5" name="e14d5">14.5)</a>    ti blanu joi xunre bolci
    This is-a-(blue mixed-with red) ball.
    This is a blue and red ball.
</pre>

    <p>Here the ball is neither wholly blue nor wholly red, but
    partly blue and partly red. Its blue/redness is a mass
    property. (Just how blue something has to be to count as
    ``wholly blue'' is an unsettled question, though. A ``blanu
    zdani'' may be so even though not every part of it is
    blue.)</p>

    <p>There are several other cmavo in selma'o JOI which can be
    used in the same grammatical constructions. Not all of them are
    well-defined as yet in all contexts. All have clear definitions
    as sumti connectives; those definitions are shown in the
    following table:</p>

    <p></p>
<pre>
   A joi B     the mass with components A and B
    A ce B      the set with elements A and B
    A ce'o B    the sequence with elements A and B in order
    A sece'o B  the sequence with elements B and A in order
    A jo'u B    A and B considered jointly
    A fa'u B    A and B respectively
    A sefa'u B  B and A respectively
    A jo'e B    the union of sets A and B
    A ku'a B    the intersection of sets A and B
    A pi'u B    the cross product of sets A and B
    A sepi'u B  the cross product of sets B and A
</pre>
    The cmavo ``se'' is grammatical before any JOI cmavo, but only
    useful with those that have inherent order. Here are some
    examples of joiks: 

    <p></p>
<pre>
<a id="e14d6"
name="e14d6">14.6)</a>    mi cuxna la .alis. la frank.
        ce la .alis. ce la djeimyz.
    I choose Alice from Frank
        and-member Alice and-member James.
    I choose Alice from among Frank, Alice, and James.
</pre>
    The x3 place of ``cuxna'' is a set from which the choice is
    being made. A set is an abstract object which is determined by
    specifying its members. Unlike those of a mass, the properties
    of a set are unrelated to its members' properties: the set of
    all rats is large (since many rats exist), but the rats
    themselves are small. This chapter does not attempt to explain
    set theory (the mathematical study of sets) in detail:
    explaining propositional logic is quite enough for one chapter!
    

    <p>In <a href="#e14d6">Example 14.6</a> we specify that set by
    listing the members with ``ce'' joining them.</p>

    <p></p>
<pre>
<a id="e14d7"
name="e14d7">14.7)</a>    ti liste mi ce'o do ce'o la djan.
    This is-a-list-of me and-sequence you and-sequence John.
    This is a list of you, me, and John.
</pre>
    The x2 place of ``liste'' is a sequence of the things which are
    mentioned in the list. (It is worth pointing out that ``lo
    liste'' means a physical object such as a grocery list: a
    purely abstract list is ``lo porsi'', a sequence.) Here the
    three sumti connected by ``ce'o'' are in a definite order, not
    just lumped together in a set or a mass. 

    <p>So ``joi'', ``ce'', and ``ce'o'' are parallel, in that the
    sumti connected are taken to be individuals, and the result is
    something else: a mass, a set, or a sequence respectively. The
    cmavo ``jo'u'' serves as a fourth element in this pattern: the
    sumti connected are individuals, and the result is still
    individuals --- but inseparably so. The normal Lojban way of
    saying that James and George are brothers is:</p>

    <p></p>
<pre>
<a id="e14d8"
name="e14d8">14.8)</a>    la djeimyz. bruna la djordj.
    James is-the-brother-of George.
</pre>
    possibly adding a discursive element meaning ``and vice
    versa''. However, ``James and George are brothers'' cannot be
    correctly translated as: 
<pre>
<a id="e14d9"
name="e14d9">14.9)</a>    la djeimyz. .e la djordj. bruna
    James and George is-a-brother.
</pre>
    since that expands to two bridi and means that James is a
    brother and so is George, but not necessarily of each other. If
    the ``.e'' is changed to ``jo'u'', however, the meaning of <a
    href="#e14d8">Example 14.8</a> is preserved: 
<pre>
<a id="e14d10"
name="e14d10">14.10)</a>  la djeimyz. jo'u la djordj.
        cu remei bruna
    James in-common-with George
        are-a-twosome type-of-brothers.
</pre>

    <p>The tanru ``remei bruna'' is not strictly necessary in this
    sentence, but is used to make clear that we are not saying that
    James and George are both brothers of some third person not
    specified. Alternatively, we could turn the tanru around: the
    x1 place of ``remei'' is a mass with two components, leading
    to:</p>

    <p></p>
<pre>
<a id="e14d11" name="e14d11">14.11)</a>  la djeimyz. joi la djordj.
        cu bruna remei
    James massed-with George
        are-a-brother type-of-twosome.
</pre>
    where ``joi'' is used to create the necessary mass. 

    <p>Likewise, ``fa'u'' can be used to put two individuals
    together where order matters. Typically, there will be another
    ``fa'u'' somewhere else in the same bridi:</p>
<pre>
<a id="e14d12"
name="e14d12">14.12)</a>  la djeimyz. fa'u la djordj.
        prami la meris. fa'u la martas.
    James jointly-in-order-with George
        loves Mary jointly-in-order-with Martha.
    James and George love Mary and Martha, respectively.
</pre>
    Here the information carried by the English adverb
    ``respectively'', namely that James loves Mary and George loves
    Martha, is divided between the two occurrences of ``fa'u''. If
    both uses of ``fa'u'' were to be changed to ``.e'', we would
    get: 
<pre>
<a id="e14d13" name="e14d13">14.13)</a>  la djeimyz. .e la djordj.
        prami la meris. .e la martas.
    James and George love Mary and Martha.
</pre>
    which can be transformed to four bridi: 
<pre>
<a id="e14d14"
name="e14d14">14.14)</a>  la djeimyz. prami la meris.
        .ije la djordj. prami la meris.
        .ije la djeimyz. prami la martas.
        .ije la djordj. prami la martas.
    James loves Mary, and George loves Mary,
        and James loves Martha, and George loves Martha
</pre>
    which represents quite a different state of affairs from <a
    href="#e14d12">Example 14.12</a>. The meaning of <a
    href="#e14d12">Example 14.12</a> can also be conveyed by a
    termset: 

    <p></p>
<pre>
<a id="e14d15" name="e14d15">14.15)</a>  la djeimyz. ce'e la meris.
        pe'e .e la djordj. ce'e la martas. prami
    James [plus] Mary
        [joint] and George [plus] Martha loves.
</pre>
    at the expense of re-ordering the list of names so as to make
    the pairs explicit. This option is not available when one of
    the lists is only described rather than enumerated: 
<pre>
<a id="e14d16"
name="e14d16">14.16)</a>  la djeimyz. fa'u la djordj. prami re sorme
    James and-respectively George love two sisters.
</pre>
    which conveys that James loves one sister and George the other,
    though we are not able to tell which of the sisters is which. 

    <h3><a id="s15" name="s15">15. More about non-logical connectives</h3>

    <p>The final three JOI cmavo, ``jo'e'', ``ku'a'', and ``pi'u'',
    are probably only useful when talking explicitly about sets.
    They represent three standard set operators usually called
    ``union'', ``intersection'', and ``cross product'' (also known
    as ``Cartesian product''). The union of two sets is a set
    containing all the members that are in either set; the
    intersection of two sets is a set containing all the members
    that are in both sets. The cross product of two sets is the set
    of all possible ordered pairs, where each ordered pair contains
    a single element from the first set followed by a single
    element from the second. This may seem very abstract;
    hopefully, the following examples will help:</p>

    <p></p>
<pre>
<a id="e15d1"
name="e15d1">15.1)</a>    lo'i ricfu ku jo'e lo'i dotco
        cu barda
    The-set-of rich-things union the-set-of German-things
        is large.
    
<a id="e15d2" name="e15d2">15.2)</a> lo'i ricfu ku ku'a
        lo'i dotco cu cmalu
    The set-of rich-things intersection
        the-set-of German-things is small.
</pre>
    There is a parallelism between logic and set theory that makes
    <a href="#e15d1">Example 15.1</a> and <a href="#e15d2">Example
    15.2</a> equivalent respectively to: 
<pre>
<a id="e15d3"
name="e15d3">15.3)</a>    lo'i ricfu ja dotco cu barda
    The-set-of rich-or-German-things is large.
</pre>
    and 
<pre>
<a id="e15d4"
name="e15d4">15.4)</a>    lo'i ricfu je dotco cu cmalu
    The-set-of rich-and-German-things is small.
</pre>

    <p>The following example uses ``se remei'', which is a set (not
    a mass) of two elements:</p>

    <p></p>
<pre>
<a id="e15d5"
name="e15d5">15.5)</a>    la djeimyz. ce[bo] la djordj.
        pi'u la meris. cebo la martas.
        cu prami se remei
    James and-set George
        cross-product Mary and-set Martha
        are-lover type-of-pairs.
</pre>
    means that each of the pairs James/Mary, George/Mary,
    James/Martha, and George/Martha love each other. Therefore it
    is similar in meaning to <a href="#e14d13">Example 14.13</a>;
    however, that example speaks only of the men loving the women,
    not vice versa. 

    <p>Joiks may be combined with ``bo'' or with ``ke'' in the same
    way as eks and jeks; this allows grouping of non-logical
    connections between sumti and tanru units, in complete
    parallelism with logical connections:</p>
<pre>
<a id="e15d6"
name="e15d6">15.6)</a>    mi joibo do ce la djan. joibo la djein.
        cu gunma se remei
    (I massed-with you) and (John massed-with Jane)
        are-a-mass type-of-two-set
</pre>
    asserts that there is a set of two items each of which is a
    mass. 

    <p>Non-logical connection is permitted at the joint of a
    termset; this is useful for associating more than one sumti or
    tagged sumti with each side of the non-logical connection. The
    place structure of ``casnu'' is:</p>

    <dl>
      <dt></dt>

      <dd>the mass x1 discusses/talks about x2</dd>
    </dl>
    so the x1 place must be occupied by a mass (for reasons not
    explained here); however, different components of the mass may
    discuss in different languages. To associate each participant
    with his or her language, we can say: 

    <p></p>
<pre>
<a id="e15d7" name="e15d7">15.7)</a>     mi ce'e bau la lojban.
        pe'e joi do ce'e bau la gliban. nu'u casnu
    ( I [plus] in-language Lojban
        massed-with you [plus] in-language English ) discuss.
</pre>

    <p>Like all non-logical connectives, the usage shown in <a
    href="#e15d7">Example 15.7</a> cannot be mechanically converted
    into a non-logical connective placed at another location in the
    bridi. The forethought equivalent of <a href="#e15d7">Example
    15.7</a> is:</p>
<pre>
<a id="e15d8"
name="e15d8">15.8)</a>     nu'i joigi mi bau la lojban
        gi do bau la gliban. nu'u casnu
</pre>
    Non-logical forethought termsets are also useful when the
    things to be non-logically connected are sumti preceded with
    tense or modal (BAI) tags: 
<pre>
<a id="e15d9"
name="e15d9">15.9)</a>    la djan. fa'u la frank. cusku
        nu'i bau la lojban.
        nu'u fa'u
            bai la djordj. [nu'u]
    John respectively-with Frank express
        [start termset] in-language Lojban
        [joint] respectively-with
            under-compulsion-by George.
    John and Frank speak in Lojban and under George's
        compulsion, respectively.
</pre>
    <a href="#e14d17">Example 14.17</a> associates speaking in
    Lojban with John, and speaking under George's compulsion with
    Frank. We do not know what language Frank uses, or whether John
    speaks under anyone's compulsion. 

    <p>Joiks may be prefixed with ``.i'' to produce ijoiks, which
    serve to non-logically connect sentences. The main known use
    here is ``.ice'o'', which indicates that the event of the
    second bridi follows that of the first bridi in some way other
    than a time relationship (which is handled with a tense):</p>

    <p></p>
<pre>
<a id="e15d10" name="e15d10">15.10)</a>  mi ba gasnu la'edi'e
        .i tu'e kanji lo ni cteki
        .ice'o lumci le karce
        .ice'o dzukansa le gerku tu'u
    I [future] do the-referent-of-the-following:
        ( Compute the quantity of taxes.
        And-then wash the car.
        And-then walkingly-accompany the dog. )
    List of things to do:
        Figure taxes.
        Wash car.
        Walk dog.
</pre>
    <a href="#e15d10">Example 15.10</a> represents a list of things
    to be done in priority order. The order is important, hence the
    need for a sequence connective, but does not necessarily
    represent a time order (the dog may end up getting walked
    first). Note the use of ``tu'e'' and ``tu'u'' as general
    brackets around the whole list. This is related to, but
    distinct from, their use in <a href="#s8">Section 8</a>,
    because there is no logical connective between the introductory
    phrase ``mi ba gasnu la'edi'e'' and the rest. The brackets
    effectively show how large an utterance the word ``di'e'',
    which means ``the following utterance'', refers to. 

    <p>The following ``nai'', if present, does not negate either of
    the things to be connected, but instead specifies that some
    other connection (logical or non-logical) is applicable: it is
    a scalar negation:</p>
<pre>
<a id="e15d11" name="e15d11">15.11)</a>  mi jo'unai do cu remei
    I in-common-with [not!] you are-a-twosome
</pre>

    <p>The result of ``mi jo'u do'' would be two individuals, not a
    mass, therefore ``jo'u'' is not applicable; ``joi'' would be
    the correct connective.</p>

    <p>There is no joik question cmavo as such; however, joiks and
    ijoiks may be uttered in isolation in response to a logical
    connective question, as in the following exchange:</p>

    <p></p>
<pre>
<a id="e15d12" name="e15d12">15.12)</a>  do djica tu'a
        loi ckafi
        ji loi tcati
    You desire something-about
        a-mass-of coffee [what connective?]
        a-mass-of tea?
    Do you want coffee or tea?

<a id="e15d13" name="e15d13">15.13)</a>   joi
    Mixed-mass-and.
    Both as a mass (i.e, mixed together).
</pre>
    Ugh. (Or in Lojban: .a'unaisairo'o.) 

    <h3><a id="s16" name="s16">16. Interval connectives and forethought non-logical
    connection</h3>

    <p>In addition to the non-logical connectives of selma'o JOI
    explained in <a href="#s14">Sections 14</a> and <a
    href="#s15">15</a>, there are three other connectives which can
    appear in joiks: ``bi'i'', ``bi'o'', and ``mi'i'', all of
    selma'o BIhI. The first two cmavo are used to specify
    intervals: abstract objects defined by two endpoints. The cmavo
    ``bi'i'' is correct if the endpoints are independent of order,
    whereas ``bi'o'' or ``sebi'o'' are used when order matters.</p>

    <p>An example of ``bi'i'' in sumti connection:</p>

    <p></p>
<pre>
<a id="e16d1" name="e16d1">16.1)</a>    mi ca sanli
        la drezdn. bi'i la frankfurt.
    I [present] stand-on-surface
        Dresden [interval] Frankfurt.
    I am standing between Dresden and Frankfurt.
</pre>
    In <a href="#e16d1">Example 16.1</a>, it is all the same
    whether I am standing between Dresden and Frankfurt or between
    Frankfurt and Dresden, so ``bi'i'' is the appropriate interval
    connective. The sumti ``la drezdn. bi'i la frankfurt.'' falls
    into the x2 place of ``sanli'', which is the surface I stand
    on; the interval specifies that surface by its limits.
    (Obviously, I am not standing on the whole of the interval; the
    x2 place of ``sanli'' specifies a surface which is typically
    larger in extent than just the size of the stander's feet.) 

    <p></p>
<pre>
<a id="e16d2" name="e16d2">16.2)</a>    mi cadzu ca
        la pacac. bi'o la recac.
    I walk simultaneous-with
        First-hour [ordered-interval] Second-hour.
    I walk from one o'clock to two o'clock.
</pre>
    In <a href="#e16d2">Example 16.2</a>, on the other hand, it is
    essential that ``la pacac.'' comes before ``la recac.'';
    otherwise we have an 11-hour (or 23-hour) interval rather than
    a one-hour interval. In this use of an interval, the whole
    interval is probably intended, or at least most of it. 

    <p><a href="#e16d2">Example 16.2</a> is equivalent to:</p>

    <p></p>
<pre>
<a id="e16d3" name="e16d3">16.3)</a>    mi cadzu ca
        la recac. sebi'o la pacac.
    I walk simultaneous-with
        Second-hour [reverse] [ordered] First-hour.
</pre>

    <p>English cannot readily express ``sebi'o'', but its meaning
    can be understood by reversing the two sumti.</p>

    <p>The third cmavo of selma'o BIhI, namely ``mi'i'', expresses
    an interval seen from a different viewpoint: not a pair of
    endpoints, but a center point and a distance. For example:</p>

    <p></p>
<pre>
<a id="e16d4"
name="e16d4">16.4)</a>    le jbama pu daspo la .uacintyn.
        mi'i lo minli be li muno
    the bomb [past] destroys Washington
        [center] what-is measured-in-miles by 50.
    The bomb destroyed Washington and fifty miles around.
</pre>

    <p>Here we have an interval whose center is Washington and
    whose distance, or radius, is fifty miles.</p>

    <p>In <a href="#e16d1">Example 16.1</a>, is it possible that I
    am standing in Dresden (or Frankfurt) itself? Yes. The
    connectives of selma'o BIhI are ambiguous about whether the
    endpoints themselves are included in or excluded from the
    interval. Two auxiliary cmavo ``ga'o'' and ``ke'i'' (of cmavo
    GAhO) are used to indicate the status of the endpoints:
    ``ga'o'' means that the endpoint is included, ``ke'i'' that it
    is excluded:</p>

    <p></p>
<pre>
<a id="e16d5" name="e16d5">16.5)</a>    mi ca sanli la drezdn.
        ga'o bi'i ga'o la frankfurt.
    I [present] stand Dresden
        [inclusive] [interval] [inclusive] Frankfurt.
    I am standing between Dresden and Frankfurt,
        inclusive of both.

<a id="e16d6" name="e16d6">16.6)</a> mi ca sanli la drezdn.
        ga'o bi'i ke'i la frankfurt.
    I [present] stand Dresden
        [inclusive] [interval] [exclusive] Frankfurt.
    I am standing between Dresden (inclusive)
        and Frankfurt (exclusive).

<a id="e16d7" name="e16d7">16.7)</a> mi ca sanli la drezdn.
        ke'i bi'i ga'o la frankfurt.
    I [present] stand Dresden
        [exclusive] [interval] [inclusive] Frankfurt.
    I am standing between Dresden (exclusive)
        and Frankfurt (inclusive).

<a id="e16d8" name="e16d8">16.8)</a> mi ca sanli la drezdn.
        ke'i bi'i ke'i la frankfurt.
    I [present] stand Dresden
        [exclusive] [interval] [exclusive] Frankfurt.
    I am standing between Dresden and Frankfurt,
        exclusive of both.
</pre>
    As these examples should make clear, the GAhO cmavo that
    applies to a given endpoint is the one that stands physically
    adjacent to it: the left-hand endpoint is referred to by the
    first GAhO, and the right-hand endpoint by the second GAhO. It
    is ungrammatical to have just one GAhO. 

    <p>(Etymologically, ``ga'o'' is derived from ``ganlo'', which
    means ``closed'', and ``ke'i'' from ``kalri'', which means
    ``open''. In mathematics, inclusive intervals are referred to
    as closed intervals, and exclusive intervals as open ones.)</p>

    <p>BIhI joiks are grammatical anywhere that other joiks are,
    including in tanru connection and (as ijoiks) between
    sentences. No meanings have been found for these uses.</p>

    <p>Negated intervals, marked with a ``-nai'' following the BIhI
    cmavo, indicate an interval that includes everything but what
    is between the endpoints (with respect to some understood
    scale):</p>

    <p></p>
<pre>
<a id="e16d9"
name="e16d9">16.9)</a>    do dicra .e'a mi ca la daucac. bi'onai la gaicac.
    You disturb (allowed) me at 10 not-from ... to 12
    You can contact me except from 10 to 12.
</pre>

    <p>The complete syntax of joiks is:</p>

    <p></p>

    <dl>
      <dt></dt>

      <dd>[se] JOI [nai] [se] BIhI [nai] GAhO [se] BIhI [nai]
      GAhO</dd>
    </dl>
    Notice that the colloquial English translations of ``bi'i'' and
    ``bi'o'' have forethought form: ``between ... and'' for
    ``bi'i'', and ``from ... to'' for ``bi'o''. In Lojban too,
    non-logical connectives can be expressed in forethought. Rather
    than using a separate selma'o, the forethought logical
    connectives are constructed from the afterthought ones by
    suffixing ``gi''. Such a compound cmavo is not unnaturally
    called a ``joigik''; the syntax of joigiks is any of: 

    <p></p>

    <dl>
      <dt></dt>

      <dd>[se] JOI [nai] GI [se] BIhI [nai] GI GAhO [se] BIhI [nai]
      GAhO GI</dd>
    </dl>
    Joigiks may be used to non-logically connect bridi, sumti, and
    bridi-tails; and also in termsets. 

    <p><a href="#e14d3">Example 14.3</a> in forethought
    becomes:</p>

    <p></p>
<pre>
<a id="e16d10"
name="e16d10">16.10)</a>  joigi la djan. gi la .alis. bevri le pipno
    [Together] John and Alice carry the piano.
</pre>

    <p>The first ``gi'' is part of the joigik; the second ``gi'' is
    the regular gik that separates the two things being connected
    in all forethought forms.</p>

    <p><a href="#e16d6">Example 16.6</a> can be expressed in
    forethought as:</p>

    <p></p>
<pre>
<a id="e16d11" name="e16d11">16.11)</a>  mi ca sanli ke'i bi'i ga'o
        gi la drezdn.
        gi la frankfurt.
    I [present] stand
        [exclusive] between [inclusive] Dresden
        and Frankfurt.
    I am standing between Dresden (exclusive)
        and Frankfurt (inclusive).
</pre>
    In forethought, unfortunately, the GAhOs become physically
    separated from the endpoints, but the same rule applies: the
    first GAhO refers to the first endpoint. 

    <h3><a id="s17" name="s17">17. Logical and non-logical connectives within mekso</h3>

    <p>Lojban has a separate grammar embedded within the main
    grammar for representing mathematical expressions (or mekso in
    Lojban) such as ``2 + 2''. Mathematical expressions are
    explained fully in <a href="chapter18.html">Chapter 18</a>. The
    basic components of mekso are operands, like ``2'', and
    operators, like ``+''. Both of these may be either logically or
    non-logically connected.</p>

    <p>Operands are connected in afterthought with eks and in
    forethought with geks, just like sumti. Operators, on the other
    hand, are connected in afterthought with jeks and in
    forethought with guheks, just like tanru components. (However,
    jeks and joiks with ``bo'' are not allowed for operators.) This
    parallelism is no accident.</p>

    <p>In addition, eks with ``bo'' and with ``ke ... ke'e'' are
    allowed for grouping logically connected operands, and ``ke ...
    ke'e'' is allowed for grouping logically connected operators,
    although there is no analogue of tanru among the operators.</p>

    <p>Only a few examples of each kind of mekso connection will be
    given. Despite the large number of rules required to support
    this feature, it is of relatively minor importance in either
    the mekso or the logical-connective scheme of things. These
    examples are drawn from <a href="chapter18.html">Chapter 18</a>,
    and contain many mekso features not explained in this
    chapter.</p>

    <p><a href="#e17d1">Example 17.1</a> exhibits afterthought
    logical connection between operands:</p>

    <p></p>
<pre>
<a id="e17d1"
name="e17d1">17.1)</a>    vei ci .a vo [ve'o] prenu cu klama le zarci
    ( three or four ) people go-to the market.
</pre>
    <a href="#e17d2">Example 17.2</a> is equivalent in meaning, but
    uses forethought connection: 
<pre>
<a id="e17d2"
name="e17d2">17.2)</a>    vei ga ci gi vo [ve'o] prenu cu klama le zarci
    ( either 3 or 4 ) people go-to the market.
</pre>
    Note that the mekso in <a href="#e17d1">Example 17.1</a> and <a
    href="#e17d2">Example 17.2</a> are being used as quantifiers.
    Lojban requires that any mekso other than a simple number be
    enclosed in ``vei'' and ``ve'o'' parentheses when used as a
    quantifier. The right parenthesis mark, ``ve'o'', is an
    elidable terminator. 

    <p>Simple examples of logical connection between operators are
    hard to come by. A contrived example is:</p>
<pre>
<a id="e17d3"
name="e17d3">17.3)</a>    li re su'i je pi'i re du li vo
    the-number 2 plus and times 2 equals the-number 4.
    2 + 2 = 4 and 2 x 2 = 4.
</pre>

    <p>The forethought form of <a href="#e17d3">Example 17.3</a>
    is:</p>
<pre>
<a id="e17d4" name="e17d4">17.4)</a>    li re ge su'i gi pi'i re
        du li vo
    the-number two both plus and times two
        equals the-number four.
    Both 2 + 2 = 4 and 2 x 2 = 4.
</pre>
    Non-logical connection with joiks or joigiks is also permitted
    between operands and between operators. One use for this
    construct is to connect operands with ``bi'i'' to create
    mathematical intervals: 

    <p></p>
<pre>
<a id="e17d5" name="e17d5">17.5)</a>    li no ga'o bi'i ke'i pa
    the-number zero (inclusive) from-to (exclusive) one
    [0,1)
    the numbers from zero to one,
        including zero but not including one
</pre>
    You can also combine two operands with ``ce'o'', the sequence
    connective of selma'o JOI, to make a compound subscript: 

    <p></p>
<pre>
<a id="e17d6"
name="e17d6">17.6)</a>     xy. boi xi vei by. ce'o dy. [ve'o]
    ``x'' sub ( ``b'' sequence ``d'' )
    $x<sub>b,d</sub>$
</pre>
    Note that the ``boi'' in <a href="#e17d5">Example 17.5</a> is
    not elidable, because the ``xi'' subscript needs something to
    attach to. 

    <h3><a id="s18" name="s18">18. Tenses, modals, and logical connection</h3>

    <p>The tense and modal systems of Lojban interact with the
    logical connective system. No one chapter can explain all of
    these simultaneously, so each chapter must present its own view
    of the area of interaction with emphasis on its own concepts
    and terminology. In the examples of this chapter, the many
    tenses of various selma'o as well as the modals of selma'o BAI
    are simplified to the simple time cmavo ``pu'', ``ca'', and
    ``ba'' (of selma'o PU) representing the past, the present, and
    the future respectively. Preceding a selbri, these cmavo state
    the time when the bridi was, is, or will be true (analogous to
    English verb tenses); preceding a sumti, they state that the
    event of the main bridi is before, simultaneous with, or after
    the event given by the sumti (which is generally a ``le nu''
    abstraction; see <a href="chapter11.html">Chapter 11</a>).</p>

    <p>The two types of interaction between tenses and logical
    connectives are logically connected tenses and tensed logical
    connections. The former are fairly simple. Jeks may be used
    between tense cmavo to specify two connected bridi that differ
    only in tense:</p>

    <p></p>
<pre>
<a id="e18d1" name="e18d1">18.1)</a>    la .artr. pu nolraitru
        .ije la .artr. ba nolraitru
    Arthur [past] is-a-noblest-governor.
        And Arthur [future] is-a-noblest-governor.
    Arthur was a king, and Arthur will be a king.
</pre>
    can be reduced to: 
<pre>
<a id="e18d2"
name="e18d2">18.2)</a>    la .artr. pu je ba nolraitru
    Arthur [past] and [future] is-a-noblest-governor.
    Arthur was and will be king.
</pre>
    <a href="#e18d1">Example 18.1</a> and <a href="#e18d2">Example
    18.2</a> are equivalent in meaning; neither says anything about
    whether Arthur is king now. 

    <p>Non-logical connection with joiks is also possible between
    tenses:</p>

    <p></p>
<pre>
<a id="e18d3" name="e18d3">18.3)</a>    mi pu bi'o ba vasxu
    I [past] from ... to [future] breathe.
    I breathe from a past time until a future time.
</pre>

    <p>The full tense system makes more interesting tense intervals
    expressible, such as ``from a medium time ago until a long time
    from now''.</p>

    <p>No forethought connections between tenses are permitted by
    the grammar, nor is there any way to override the default
    left-grouping rule; these limitations are imposed to keep the
    tense grammar simpler. Whatever can be said with tenses or
    modals can be said with subordinate bridi stating the time,
    place, or mode explicitly, so it is reasonable to try to remove
    at least some complications.</p>

    <p>Tensed logical connections are both more complex and more
    important than logical connections between tenses. Consider the
    English sentence:</p>

    <p></p>
<pre>
<a id="e18d4"
name="e18d4">18.4)</a>    I went to the market, and I bought food.
</pre>

    <p>The verbatim translation of <a href="#e18d4">Example
    18.4</a>, namely:</p>
<pre>
<a id="e18d5"
name="e18d5">18.5)</a>    mi pu klama le zarci .ije mi pu tervecnu lo cidja
    I [past] go-to the market. And I [past] buy items-of food.
</pre>
    fails to fully represent a feature of the English, namely that
    the buying came after the going. (It also fails to represent
    that the buying was a consequence of the going, which can be
    expressed by a modal that is discussed in <a
    href="chapter9.html">Chapter 9</a>.) However, the tense
    information --- that the event of my going to the market
    preceded the event of my buying food --- can be added to the
    logical connective as follows. The ``.ije'' is replaced by
    ``.ijebo'', and the tense cmavo ``ba'' is inserted between
    ``.ije'' and ``bo'': 

    <p></p>
<pre>
<a id="e18d6" name="e18d6">18.6)</a>    mi pu klama le zarci
        .ijebabo mi pu tervecnu lo cidja
    I [past] go-to the market.
        And [later] I [past] buy items-of food.
</pre>

    <p>Here the ``pu'' cmavo in the two bridi-tails express the
    time of both actions with respect to the speaker: in the past.
    The ``ba'' relates the two items to one another: the second
    item is later than the first item. The grammar does not permit
    omitting the ``bo''; if it were omitted, the ``ba'' and the
    second ``pu'' would run together to form a compound tense
    ``bapu'' applying to the second bridi-tail only.</p>

    <p>
    Adding tense or modal information to
    a logical connective is permitted only in the following
    situations:</p>

    <p>Between an ek (or joik) and ``bo'', as in:</p>

    <p></p>
<pre>
<a id="e18d7"
name="e18d7">18.7)</a>    la .djan .ecabo la .alis. klama le zarci
    John and [simultaneous] Alice go-to the market.
    John and Alice go to the market simultaneously.
</pre>
    Between an ek (or joik) and ``ke'', as
    in: 

    <p></p>
<pre>
<a id="e18d8" name="e18d8">18.8)</a>    mi dzukla le zarci
        .epuke le zdani .a le ckule [ke'e]
    I walk-to the market
        and [earlier] ( the house or the school ).
    I walk to the market and,
        before that, to the house or the school.
</pre>
    Between a gihek and ``bo'', as in: 

    <p></p>
<pre>
<a id="e18d9" name="e18d9">18.9)</a>    mi dunda le cukta
        gi'ebabo lebna lo rupnu vau do
    I give the book
        and [later] take some currency-units from/to you.
    I give you the book and then take some dollars
        (pounds, yen) from you.
</pre>
    Between a gihek and ``ke'', as in: 

    <p></p>
<pre>
<a id="e18d10" name="e18d10">18.10)</a>  mi dzukla le zarci
        gi'ecake cusku zo'e la djan. [ke'e]
    I walk-to the market
        and [simultaneous] express something to-John.
    I walk to the market and at the same time talk to John.
</pre>
    Between an ijek (or ijoik) and ``bo'',
    as in: 

    <p></p>
<pre>
<a id="e18d11"
name="e18d11">18.11)</a>  mi viska pa nanmu .ijebabo mi viska pa ninmu
    I see a man. And [later] I see a woman.
    I see a man, and then I see a woman.
</pre>
    Between an ijek (or ijoik) and
    ``tu'e'', as in: 

    <p></p>
<pre>
<a id="e18d12" name="e18d12">18.12)</a>  mi viska pa nanmu
        .ijebatu'e mi viska pa ninmu [tu'u]
    I see a man.
        And [later] I see a woman.
    I see a man, and then I see a woman.
</pre>
    And finally, between a jek (or joik)
    and ``bo'', as in: 

    <p></p>
<pre>
<a id="e18d13" name="e18d13">18.13)</a>  mi mikce jebabo ricfu
    I-am-a doctor and [later] rich
    I am a doctor and future rich person.
</pre>
    As can be seen from <a href="#e18d11">Example 18.11</a> and <a
    href="#e18d12">Example 18.12</a>, the choice between ``bo'' and
    ``ke'' (or ``tu'e'') is arbitrary when there are only two
    things to be connected. If there were no tense information to
    include, of course neither would be required; it is only the
    rule that tense information must always be sandwiched between
    the logical connective and a following ``bo'', ``ke'', or
    ``tu'e'' that requires the use of one of these grouping cmavo
    in <a href="#e18d7">Example 18.7</a> and <a
    href="#e18d9">Examples 18.9</a> through <a
    href="#e18d13">18.13</a>. 

    <p>Non-logical connectives with ``bo'' and ``ke'' can include
    tense information in exactly the same way as logical
    connectives. Forethought connectives, however (except as noted
    below) are unable to do so, as are termsets or tense
    connectives. Mathematical operands and operators can also
    include tense information in their logical connectives as a
    result of their close parallelism with sumti and tanru
    components respectively:</p>
<pre>
<a id="e18d14"
name="e18d14">18.14)</a>  vei ci .ebabo vo [ve'o] tadni cu zvati le kumfa
    ( 3 and [future] 4 ) students are-at the room.
    Three and, later, four students were in the room.
</pre>
    is a simple example. There is a special grammatical rule for
    use when a tense applies to both of the selbri in a forethought
    bridi-tail connection: the entire forethought construction can
    just be preceded by a tense. For example: 

    <p></p>
<pre>
<a id="e18d15"
name="e18d15">18.15)</a>  mi pu ge klama le zarci gi tervecnu lo cidja
    I [past] both go-to the market and buy some food
    I went to the market and bought some food.
</pre>
    <a href="#e18d15">Example 18.15</a> is similar to <a
    href="#e18d5">Example 18.5</a>. There is no time relationship
    specified between the going and the buying; both are simply set
    in the past. 

    <h3><a id="s19" name="s19">19. Abstractor connection and connection within
    abstractions</h3>

    <p>Last and (as a matter of fact) least: a logical connective
    is allowed between abstraction markers of selma'o NU. As usual,
    the connection can be expanded to a bridi connection between
    two bridi which differ only in abstraction marker. Jeks are the
    appropriate connective. <a href="#e19d1">Example 19.1</a> and
    <a href="#e19d2">Example 19.2</a> are equivalent in
    meaning:</p>

    <p></p>
<pre>
<a id="e19d1"
name="e19d1">19.1)</a>    le ka la frank. ciska cu xlali
        .ije le ni la frank. ciska cu xlali
    The quality-of Frank's writing is bad,
        and the quantity of Frank's writing is bad.

<a id="e19d2"
name="e19d2">19.2)</a> le ka je ni la frank. ciska cu xlali
    The quality and quantity of Frank's writing is bad.
</pre>
    As with tenses and modals, there is no forethought and no way
    to override the left-grouping rule. 

    <p>Logical connectives and abstraction are related in another
    way as well, though. Since an abstraction contains a bridi, the
    bridi may have a logical connection inside it. Is it legitimate
    to split the outer bridi into two, joined by the logical
    connection? Absolutely not. For example:</p>

    <p></p>
<pre>
<a id="e19d3"
name="e19d3">19.3)</a>    mi jinvi le du'u loi jmive cu zvati
        gi'onai na zvati vau la .iupiter.
    I opine the fact-that a-mass-of living-things (is-at
        or-else isn't-at) Jupiter.
    I believe there either is or isn't life on Jupiter.
</pre>
    is true, since the embedded sentence is a tautology, but: 
<pre>
<a id="e19d4" name="e19d4">19.4)</a>    mi jinvi le du'u loi jmive
        cu zvati la .iupiter.
    .ijonai mi jinvi le du'u loi jmive
        cu zvati la .iupiter.
    I opine the fact-that a-mass-of living-things
        is-at Jupiter
    or-else I opine the fact-that a-mass-of living-things
        isn't-at Jupiter
</pre>
    is false, since I have no evidence one way or the other
    (``jinvi'' requires some sort of evidence, real or fancied,
    unlike ``krici''). 

    <h3><a id="s20" name="s20">20. Constructs and appropriate connectives</h3>

    <p>The following table specifies, for each kind of construct
    that can be logically or non-logically connected in Lojban,
    what kind of connective is required for both afterthought and
    (when possible) forethought modes. An asterisk (*) indicates
    that tensed connection is permitted.</p>

    <p>A line of dashes indicates that connection of the specified
    type is not possible.</p>
<pre>
   construct   afterth. foreth.  afterth.  foreth.
                    logical  logical  non-log.  non-log.
    ---------   -------  -------  --------  --------

    bridi       ijek*    gek     ijoik*     joigik
    sumti       ek*      gek     joik*      joigik
    bridi-tails gihek*   gek     ---        joigik
    termsets    ek*      gek     joik*      joigik
    tanru parts jek      guhek   joik*      ---
    operands    ek*      gek     joik*      joigik
    operators   jek      guhek   joik       ---
    tenses/modals   jek      ---     joik       ---
    abstractors jek      ---     joik       ---
</pre>

    <h3><a id="s21" name="s21">21. Truth functions and corresponding logical
    connectives</h3>

    <p>The following table specifies, for each truth function, the
    most-often used compound cmavo which expresses it for each of
    the six types of logical connective. (Other compound cmavo are
    often possible: for example, ``se.a'' means the same as ``a'',
    and could be used instead.)</p>
<pre>
truth  ek  jek gihek     gek--gik  guhek--gik
-----   --  --- -----     --------- -----------

TTTF    .a  ja  gi'a      ga--gi    gu'a--gi
TTFT    .anai   janai   gi'anai   ga--ginai gu'a--ginai
TTFF    .u  ju  gi'u      gu--gi    gu'u--gi
TFTT    na.a    naja    nagi'a    ganai--gi gu'anai--gi
TFTF    se.u    seju    segi'u    segu--gi  segu'u--gi
TFFT    .o  jo  gi'o      go--gi    gu'o--gi
TFFF    .e  je  gi'e      ge--gi    gu'e--gi
FTTT    na.anai najanai nagi'anai ganai--ginai  gu'anai--ginai
FTTF    .onai   jonai   gi'onai   go--ginai gu'o--ginai
FTFT    se.unai sejunai segi'unai segu--ginai   segu'u--ginai
FTFF    .enai   jenai   gi'enai   ge--ginai gu'e--ginai
FFTT    na.u    naju    nagi'u    gunai--gi gu'unai--gi
FFTF    na.e    naje    nagi'e    genai--gi gu'enai--gi
FFFT    na.enai najenai nagi'enai genai--ginai  gu'enai--ginai
</pre>

    <p>Note: Ijeks are exactly the same as the corresponding jeks,
    except for the prefixed ``.i''.</p>

    <h3><a id="s22" name="s22">22. Rules for making logical and non-logical
    connectives</h3>

    <p>The full set of rules for inserting ``na'', ``se'', and
    ``nai'' into any connective is:</p>

    <p>Afterthought logical connectives (eks, jeks, giheks,
    ijeks):</p>

    <p>Negate first construct:</p>

    <dl>
      <dt></dt>

      <dd>place ``na'' before the connective cmavo (but after the
      ``.i'' of an ijek).</dd>
    </dl>

    <p>Negate second construct:</p>

    <dl>
      <dt></dt>

      <dd>place ``nai'' after the connective cmavo.</dd>
    </dl>

    <p>Exchange constructs:</p>

    <dl>
      <dt></dt>

      <dd>place ``se'' before the connective cmavo (after ``na'' if
      any).</dd>
    </dl>

    <p>Forethought logical connectives (geks, guheks):</p>

    <p>Negate first construct:</p>

    <dl>
      <dt></dt>

      <dd>place ``nai'' after the connective cmavo.</dd>
    </dl>

    <p>Negate second construct:</p>

    <dl>
      <dt></dt>

      <dd>place ``nai'' after the ``gi''.</dd>
    </dl>

    <p>Exchange constructs:</p>

    <dl>
      <dt></dt>

      <dd>place ``se'' before the connective cmavo.</dd>
    </dl>

    <p>Non-logical connectives (joiks, joigiks):</p>

    <p>Negate connection:</p>

    <dl>
      <dt></dt>

      <dd>place ``nai'' after the connective cmavo (but before the
      ``gi'' of a joigik).</dd>
    </dl>

    <p>Exchange constructs:</p>

    <dl>
      <dt></dt>

      <dd>place ``se'' before the connective cmavo.</dd>
    </dl>

    <h3><a id="s23" name="s23">23. Locations of other tables</h3>

    <p><a href="#s1">Section 1</a>: a table explaining the meaning
    of each truth function in English.</p>

    <p><a href="#s2">Section 2</a>: a table relating the truth
    functions to the four basic vowels.</p>

    <p><a href="#s13">Section 13</a>: a table of the connective
    question cmavo.</p>

    <p><a href="#s14">Section 14</a>: a table of the meanings of
    JOI cmavo when used to connect sumti.</p>

    <hr />
    
    <p>Senast modifierad: Mon Jun 27 23:10:56 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
