
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//ES" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">
<head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta name="VPSiteProject"
    content="file:///C|/U/MIRROR/TEMP/lojban-current/site/lojban.vpp" />

    <title>Lojban Reference Grammar: Chapter 13</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >

    <div class="centered">
      <img src="chapter13.gif" alt="[Cartoon]"
      width="405" height="405" />

      <h2>Chapter 13<br />
      Oooh! Arrgh! Ugh! Yecch! Attitudinal and Emotional
      Indicators</h2>

      <!--
      <h6>$Revision: 4.2 $<br />
      mkhtml: 1.1</h6>
      -->
    </div>

    <h3><a id="s1" name="s1">1. What are attitudinal indicators?</h3>
    This chapter explains the various words that Lojban provides
    for expressing attitude and related notions. In natural
    languages, attitudes are usually expressed by the tone of voice
    when speaking, and (very imperfectly) by punctuation when
    writing. For example, the bare words 
<pre>
<a id="e1d1" name="e1d1">1.1)</a>  John is coming.
</pre>
    can be made, through tone of voice, to express the speaker's
    feeling of happiness, pity, hope, surprise, or disbelief. These
    fine points of tone cannot be expressed in writing. Attitudes
    are also expressed with various sounds which show up in print
    as oddly spelled words, such as the ``Oooh!'', ``Arrgh!'',
    ``Ugh!'', and ``Yecch!'' in the title. These are part of the
    English language; people born to other languages use a
    different set; yet you won't find any of these words in a
    dictionary. 

    <p>In Lojban, everything that can be spoken can also be
    written. Therefore, these tones of voice must be represented by
    explicit words known as ``attitudinal indicators'', or just
    ``attitudinals''. This rule seems awkward and clunky to
    English-speakers at first, but is an essential part of the
    Lojbanic way of doing things.</p>

    <p>The simplest way to use attitudinal indicators is to place
    them at the beginning of a text. In that case, they express the
    speaker's prevailing attitude. Here are some examples,
    correlated with the attitudes mentioned following <a
    href="#e1d1">Example 1.1</a>:</p>

    <p></p>
<pre>
<a id="e1d2" name="e1d2">1.2)</a>  .ui la djan klama
    [Whee!] John is coming!
</pre>
<pre>
<a id="e1d3" name="e1d3">1.3)</a>  .uu la djan klama
    [Alas!] John is coming.
</pre>
<pre>
<a id="e1d4" name="e1d4">1.4)</a>  .a'o la djan klama
    [Hopefully] John is coming.
</pre>
<pre>
<a id="e1d5" name="e1d5">1.5)</a>  .ue la djan klama
    [Wow!] John is coming!
</pre>
<pre>
<a id="e1d6" name="e1d6">1.6)</a>  .ianai la djan klama
    [Nonsense!] John is coming.
</pre>
    The primary Lojban attitudinals are all the cmavo of the form
    VV or V'V: one of the few cases where cmavo have been
    classified solely by their form. There are 39 of these cmavo:
    all 25 possible vowel pairs of the form V'V, the four standard
    diphthongs (``.ai'', ``.au'', ``.ei'', and ``.oi''), and the
    ten more diphthongs that are permitted only in these
    attitudinal indicators and in names and borrowings (``.ia'',
    ``.ie'', ``.ii'', ``.io'', ``.iu'', ``.ua'', ``.ue'', ``.ui'',
    ``.uo'', and ``.uu''). Note that each of these cmavo has a
    period before it, marking the pause that is mandatory before
    every word beginning with a vowel. Attitudinals, like most of
    the other kinds of indicators described in this chapter, belong
    to selma'o UI. 

    <p>Attitudinals can also be compound cmavo, of the types
    explained in Sections 4-8; <a href="#e1d6">Example 1.6</a>
    illustrates one such possibility, the compound attitudinal
    ``.ianai''. In attitudinals, ``-nai'' indicates polar negation:
    the opposite of the simple attitudinal without the ``-nai''.
    Thus, as you might suppose, ``.ia'' expresses belief, since
    ``.ianai'' expresses disbelief.</p>

    <p>In addition to the attitudinals, there are other classes of
    indicators: intensity markers, emotion categories, attitudinal
    modifiers, observationals, and discursives. All of them are
    grammatically equivalent, which is why they are treated
    together in this chapter.</p>

    <p>Every indicator behaves in more or less the same way with
    respect to the grammar of the rest of the language. In general,
    one or more indicators can be inserted at the beginning of an
    utterance or after any word. Indicators at the beginning apply
    to the whole utterance; otherwise, they apply to the word that
    they follow. More details can be found in <a href="#s9">Section
    9</a>.</p>

    <p>Throughout this chapter, tables of indicators will be
    written in four columns. The first column is the cmavo itself.
    The second column is a corresponding English word, not
    necessarily a literal translation. The fourth column represents
    the opposite of the second column, and shows the approximate
    meaning of the attitudinal when suffixed with ``-nai''. The
    third column, which is sometimes omitted, indicates a neutral
    point between the second and fourth columns, and shows the
    approximate meaning of the attitudinal when it is suffixed with
    ``-cu'i''. The cmavo ``cu'i'' belongs to selma'o CAI, and is
    explained more fully in <a href="#s4">Section 4</a>.</p>

    <p>One flaw that the English glosses are particularly subject
    to is that in English it is often difficult to distinguish
    between expressing your feelings and talking about them,
    particularly with the limited resource of the written word. So
    the gloss for ``.ui'' should not really be ``happiness'' but
    some sound or tone that expresses happiness. However, there
    aren't nearly enough of those that have unambiguous or obvious
    meanings in English to go around for all the many, many
    different emotions Lojban speakers can readily express.</p>

    <p>Many indicators of CV'V form are loosely derived from
    specific gismu. The gismu should be thought of as a memory
    hook, not an equivalent of the cmavo. Such gismu are shown in
    this chapter between square brackets, thus: [gismu].</p>

    <h3><a id="s2" name="s2">2. Pure emotion indicators</h3>

    <p>Attitudinals make no claim: they are expressions of
    attitude, not of facts or alleged facts. As a result,
    attitudinals themselves have no truth value, nor do they
    directly affect the truth value of a bridi that they modify.
    However, since emotional attitudes are carried in your mind,
    they reflect reactions to that version of the world that the
    mind is thinking about; this is seldom identical with the real
    world. At times, we are thinking about our idealized version of
    the real world; at other times we are thinking about a
    potential world that might or might not ever exist.</p>

    <p>Therefore, there are two groups of attitudinals in Lojban.
    The ``pure emotion indicators'' express the way the speaker is
    feeling, without direct reference to what else is said. These
    indicators comprise the attitudinals which begin with ``u'' or
    ``o'' and many of those beginning with ``i''.</p>

    <p>The cmavo beginning with ``u'' are simple emotions, which
    represent the speaker's reaction to the world as it is, or as
    it is perceived to be.</p>
<pre>
   .ua discovery           confusion
    .u'a    gain                loss
    .ue surprise    no surprise expectation
    .u'e    wonder              commonplace
    .ui happiness           unhappiness
    .u'i    amusement           weariness
    .uo completion          incompleteness
    .u'o    courage     timidity    cowardice
    .uu     pity                cruelty
    .u'u    repentance  lack of regret  innocence
</pre>

    <p>Here are some typical uses of the ``u'' attitudinals:</p>

    <p></p>
<pre>
<a id="e2d1" name="e2d1">2.1)</a>  .ua mi facki fi le mi mapku
    [Eureka!] I found my hat!
        [emphasizes the discovery of the hat]

<a id="e2d2" name="e2d2">2.2)</a>   .u'a mi facki fi le mi mapku
    [Gain!] I found my hat!
        [emphasizes the obtaining of the hat]
</pre>
<pre>
<a id="e2d3" name="e2d3">2.3)</a>  .ui mi facki fi le mi mapku
    [Yay!] I found my hat!
        [emphasizes the feeling of happiness]

<a id="e2d4" name="e2d4">2.4)</a>   .uo mi facki fi le mi mapku
    [At last!] I found my hat!
        [emphasizes that the finding is complete]
</pre>
<pre>
<a id="e2d5" name="e2d5">2.5)</a>  .uu do cortu
    [Pity!] You feel-pain.
        [expresses speaker's sympathy]

<a id="e2d6" name="e2d6">2.6)</a>   .u'u do cortu
    [Repentance!] You feel-pain
        [expresses that speaker feels guilty]
</pre>
    In <a href="#e2d4">Example 2.4</a>, note that the attitudinal
    ``.uo'' is translated by an English non-attitudinal phrase:
    ``At last!'' It is common for the English equivalents of Lojban
    attitudinals to be short phrases of this sort, with more or
    less normal grammar, but actually expressions of emotion. 

    <p>In particular, both ``.uu'' and ``.u'u'' can be translated
    into English as ``I'm sorry''; the difference between these two
    attitudes frequently causes confusion among English-speakers
    who use this phrase, leading to responses like ``Why are you
    sorry? It's not your fault!''</p>

    <p>It is important to realize that ``.uu'', and indeed all
    attitudinals, are meant to be used sincerely, not ironically.
    In English, the exclamation ``Pity!'' is just as likely to be
    ironically intended, but this usage does not extend to Lojban.
    Lying with attitudinals is (normally) as inappropriate to
    Lojban discourse as any other kind of lying: perhaps worse,
    because misunderstood emotions can cause even greater problems
    than misunderstood statements.</p>

    <p>The following examples display the effects of ``nai'' and
    ``cu'i'' when suffixed to an attitudinal:</p>
<pre>
<a id="e2d7" name="e2d7">2.7)</a>  .ue la djan. klama
    [Surprise!] John comes.

<a id="e2d8" name="e2d8">2.8)</a>   .uecu'i la djan. klama
    [Ho hum.] John comes.

<a id="e2d9" name="e2d9">2.9)</a>   .uenai la djan. klama
    [Expected!] John comes.
</pre>

    <p>In <a href="#e2d9">Example 2.9</a>, John's coming has been
    anticipated by the speaker. In <a href="#e2d7">Example 2.7</a>
    and <a href="#e2d8">Example 2.8</a>, no such anticipation has
    been made, but in <a href="#e2d7">Example 2.7</a> the
    lack-of-anticipation goes no further --- in <a
    href="#e2d8">Example 2.8</a>, it amounts to actual
    surprise.</p>

    <p>It is not possible to firmly distinguish the pure emotion
    words beginning with ``o'' or ``i'' from those beginning with
    ``u'', but in general they represent more complex, more
    ambivalent, or more difficult emotions.</p>
<pre>
   .o'a    pride       modesty     shame
    .o'e    closeness   detachment  distance
    .oi complaint/pain  doing OK    pleasure
    .o'i    caution     boldness    rashness
    .o'o    patience    mere tolerance  anger
    .o'u    relaxation  composure   stress
</pre>

    <p>Here are some examples:</p>

    <p></p>
<pre>
<a id="e2d10" name="e2d10">2.10)</a>    .oi la djan. klama
    [Complaint!] John is coming.
</pre>

    <p>Here the speaker is distressed or discomfited over John's
    coming. The word ``.oi'' is derived from the Yiddish word
    ``oy'' of similar meaning. It is the only cmavo with a Yiddish
    origin.</p>

    <p></p>
<pre>
<a id="e2d11" name="e2d11">2.11)</a>    .o'onai la djan. klama
    [Anger!] John is coming!
</pre>

    <p>Here the speaker feels anger over John's coming.</p>

    <p></p>
<pre>
<a id="e2d12" name="e2d12">2.12)</a>    .o'i la djan. klama
    [Beware!] John is coming.
</pre>

    <p>Here there is a sense of danger in John's arrival.</p>

    <p></p>
<pre>
<a id="e2d13" name="e2d13">2.13)</a>    .o'ecu'i la djan. klama
    [Detachment!] John is coming.
</pre>
<pre>
<a id="e2d14" name="e2d14">2.14)</a>    .o'u la djan. klama
    [Phew!] John is coming.
</pre>

    <p>In <a href="#e2d13">Example 2.13</a> and <a
    href="#e2d14">Example 2.14</a>, John's arrival is no problem:
    in the former example, the speaker feels emotional distance
    from the situation; in the latter example, John's coming is
    actually a relief of some kind.</p>

    <p>The pure emotion indicators beginning with ``i'' are those
    which could not be fitted into the ``u'' or ``o'' groups
    because there was a lack of room, so they are a mixed lot.
    ``.ia'', ``.i'a'', ``.ie'', and ``.i'e'' do not appear here, as
    they belong in <a href="#s3">Section 3</a> instead.</p>
<pre>
   .ii fear        nervousness security
    .i'i    togetherness            privacy
    .io respect             disrespect
    .i'o    appreciation            envy
    .iu     love        no love lost    hatred
    .i'u    familiarity         mystery
</pre>

    <p>Here are some examples:</p>
<pre>
<a id="e2d15" name="e2d15">2.15)</a>    .ii smacu
    [Fear!] [Observative:] a-mouse
    Eek!  A mouse!
</pre>
<pre>
<a id="e2d16" name="e2d16">2.16)</a>    la djan. .iu klama
    John [love!] is coming.
</pre>
<pre>
<a id="e2d17" name="e2d17">2.17)</a>    la djan. .ionai klama
    John [disrespect!] is coming.
</pre>
    <a href="#e2d15">Example 2.15</a> shows an attitude-colored
    observative; the attitudinal modifies the situation described
    by the observative, namely the mouse that is causing the
    emotion. Lojban-speaking toddlers, if there ever are any, will
    probably use sentences like <a href="#e2d15">Example 2.15</a> a
    lot. 

    <p><a href="#e2d16">Example 2.16</a> and <a
    href="#e2d17">Example 2.17</a> use attitudinals that follow
    ``la djan.'' rather than being at the beginning of the
    sentence. This form means that the attitude is attached to John
    rather than the event of his coming; the speaker loves or
    disrespects John specifically. Compare:</p>
<pre>
<a id="e2d18" name="e2d18">2.18)</a>    la djan. klama .iu
    John is-coming [love!]
</pre>
    where it is specifically the coming of John that inspires the
    feeling. 

    <p><a href="#e2d17">Example 2.17</a> is a way of swearing at
    John: you could translate it as ``That good-for-nothing John is
    coming.''</p>

    <h3><a id="s3" name="s3">3. Propositional attitude indicators</h3>

    <p>As mentioned at the beginning of <a href="#s2">Section
    2</a>, attitudinals may be divided into two groups, the pure
    emotion indicators explained in that section, and a contrasting
    group which may be called the ``propositional attitude
    indicators''. These indicators establish an internal,
    hypothetical world which the speaker is reacting to, distinct
    from the world as it really is. Thus we may be expressing our
    attitude towards ``what the world would be like if ...'', or
    more directly stating our attitude towards making the potential
    world a reality.</p>

    <p>In general, the bridi paraphrases of pure emotions look (in
    English) something like ``I'm going to the market, and I'm
    happy about it''. The emotion is present with the subject of
    the primary claim, but is logically independent of it.
    Propositional attitudes, though, look more like ``I intend to
    go to the market'', where the main claim is logically
    subordinate to the intention: I am not claiming that I am
    actually going to the market, but merely that I intend to.</p>

    <p>There is no sharp distinction between attitudinals beginning
    with ``a'' and those beginning with ``e''; however, the
    original intent (not entirely realized due to the need to cram
    too many attitudes into too little space) was to make the
    members of the ``a''-series the purer, more attitudinal
    realizers of a potential world, while the members of the
    ``e''-series were more ambivalent or complex about the
    speaker's intention with regard to the predication. The
    relationship between the ``a''-series and the ``e''-series is
    similar to that between the ``u''-series and the ``o''-series,
    respectively. A few propositional attitude indicators
    overflowed into the ``i''-series as well.</p>

    <p>In fact, the entire distinction between pure emotions and
    propositional attitudes is itself a bit shaky: ``.u'u'' can be
    seen as a propositional attitude indicator meaning ``I regret
    that ...'', and ``a'e'' (discussed below) can be seen as a pure
    emotion meaning ``I'm awake/aware''. The division of the
    attitudinals into pure-emotion and propositional-attitude
    classes in this chapter is mostly by way of explanation; it is
    not intended to permit firm rulings on specific points.
    Attitudinals are the part of Lojban most distant from the
    ``logical language'' aspect.</p>

    <p>Here is the list of propositional attitude indicators
    grouped by initial letter, starting with those beginning with
    ``a'':</p>
<pre>
   .a'a    attentive   inattentive avoiding
    .a'e    alertness           exhaustion
    .ai intent      indecision  refusal
    .a'i    effort      no real effort  repose
    .a'o    hope                despair
    .au desire      indifference    reluctance
    .a'u    interest    no interest repulsion
</pre>

    <p>Some examples (of a parental kind):</p>

    <p></p>
<pre>
<a id="e3d1" name="e3d1">3.1)</a>  .a'a do zgana le veltivni
    [attentive] you observe the television-receiver.
    I'm noticing that you are watching the TV.
</pre>
<pre>
<a id="e3d2" name="e3d2">3.2)</a>  .a'enai do ranji bacru
    [exhaustion] you continuously utter.
    I'm worn out by your continuous talking.
</pre>
<pre>
<a id="e3d3" name="e3d3">3.3)</a>  .ai mi benji do le ckana
    [intent] I transfer you to-the bed.
    I'm putting you to bed.
</pre>
<pre>
<a id="e3d4" name="e3d4">3.4)</a>  .a'i mi ba gasnu
        le nu do cikna binxo
    [effort] I [future] am-the-actor-in
        the event-of you awake-ly become.
    It'll be a real pain for me to wake you up.
</pre>
<pre>
<a id="e3d5" name="e3d5">3.5)</a>  .a'o mi kanryze'a
        ca le bavlamdei
    [hope] I am-health-increased at-time
        the future-adjacent-day.
    I hope I feel better tomorrow!
</pre>
<pre>
<a id="e3d6" name="e3d6">3.6)</a>  .au mi sipna
    [desire] I sleep.
    I want to sleep.
</pre>
<pre>
<a id="e3d7" name="e3d7">3.7)</a>  a'ucu'i do pante
    [no interest] you complain
    I have no interest in your complaints.
</pre>
    (In a real-life situation, Examples 3.1-3.7 would also be
    decorated by various pure emotion indicators, certainly
    including ``.oicai'', but probably also ``.iucai''.) 

    <p>Splitting off the attitude into an indicator allows the
    regular bridi grammar to do what it does best: express the
    relationships between concepts that are intended, desired,
    hoped for, or whatever. Rephrasing these examples to express
    the attitude as the main selbri would make for unacceptably
    heavyweight grammar.</p>

    <p>Here are the propositional attitude indicators beginning
    with ``e'', which stand roughly in the relation to those
    beginning with ``a'' as the pure-emotion indicators beginning
    with ``o'' do to those beginning with ``u'' --- they are more
    complex or difficult:</p>
<pre>
   .e'a    permission          prohibition
    .e'e    competence          incompetence
    .ei obligation          freedom
    .e'i    constraint  independence    resistance to constraint
    .e'o    request             negative request
    .e'u    suggestion  no suggestion   warning
</pre>
    More examples (after a good night's sleep): 

    <p></p>
<pre>
<a id="e3d8" name="e3d8">3.8)</a>  .e'a do sazri le karce
    [permission] You drive the car.
    Sure, you can drive the car.
</pre>
<pre>
<a id="e3d9" name="e3d9">3.9)</a>  e'e mi lifri tu'a do
    [competence] I experience something-related-to you
    I feel up to dealing with you.
</pre>
<pre>
<a id="e3d10" name="e3d10">3.10)</a>    .ei mi tisna
        le karce ctilyvau
    [obligation] I fill
        the car-type-of petroleum-container.
    I should fill the car's gas tank.
</pre>
<pre>
<a id="e3d11" name="e3d11">3.11)</a>    .e'o ko ko kurji
    [request] You-imperative of-you-imperative take-care.
    Please take care of yourself!
</pre>
<pre>
<a id="e3d12" name="e3d12">3.12)</a>    .e'u do klama le panka
    [suggestion] You go to-the park.
    I suggest going to the park.
</pre>

    <p>Finally, the propositional attitude indicators beginning
    with ``i'', which are the overflow from the other sets:</p>
<pre>
   .ia belief      skepticism  disbelief
    .i'a    acceptance          blame
    .ie agreement           disagreement
    .i'e    approval    non-approval    disapproval
</pre>

    <p>Still more examples (much, much later):</p>

    <p></p>
<pre>
<a id="e3d13"
name="e3d13">3.13)</a>    .ianai do pu pensi le nu tcica mi
    [disbelief] You [past] think the event-of deceiving me.
    I can't believe you thought you could fool me.
</pre>
<pre>
<a id="e3d14"
name="e3d14">3.14)</a>    do .i'anai na xruti do le zdani
    You [blame] did-not return you to-the house
    I blame you for not coming home.
</pre>
<pre>
<a id="e3d15" name="e3d15">3.15)</a>    .ie mi na cusku
        lu'e le tcika
        be le nu xruti
    [agreement] I did-not express
        a-symbol-for the time-of-day
        of the event-of (you return)
    It's true I didn't tell you when to come back.
</pre>
<pre>
<a id="e3d16" name="e3d16">3.16)</a>    .i'enai do .i'e zukte
    [disapproval] you [approval] act
    I don't approve of what you did, but I approve of you.
</pre>
    <a href="#e3d16">Example 3.16</a> illustrates the use of a
    propositional attitude indicator, ``i'e'', in both the usual
    sense (at the beginning of the bridi) and as a pure emotion
    (attached to ``do''). The event expressed by the main bridi is
    disapproved of by the speaker, but the referent of the sumti in
    the x1 place (namely the listener) is approved of. 

    <p>To indicate that an attitudinal discussed in this section is
    not meant to indicate a propositional attitude, the simplest
    expedient is to split the attitudinal off into a separate
    sentence. Thus, a version of <a href="#e3d8">Example 3.8</a>
    which actually claimed that the listener was or would be
    driving the car might be:</p>
<pre>
<a id="e3d17" name="e3d17">3.17)</a>    do sazri le karce .i e'a
    You drive the car.  [Permission].
    You're driving (or will drive) the car,
        and that's fine.
</pre>

    <h3><a id="s4" name="s4">4. Attitudes as scales</h3>

    <p>In Lojban, all emotions and attitudes are scales. These
    scales run from some extreme value (which we'll call
    ``positive'') to an opposite extreme (which we'll call
    ``negative''). In the tables above, we have seen three points
    on the scale: ``positive'', neutral, and ``negative''. The
    terms ``positive'' and ``negative'' are put into scare quotes
    because they are loaded words when applied to emotions, and the
    attitudinal system reflects this loading, which is a known
    cultural bias. Only two of the ``positive'' words, namely
    ``.ii'' (fear) and ``.oi'' (pain/complaint), represent emotions
    commonly thought of as less ``virtuous'' in most cases than
    their negative counterparts. But these two were felt to be
    instinctive, distinct, and very powerful emotions that needed
    to be expressible in a monosyllable when necessary, while their
    counterparts are less commonly expressed.</p>

    <p>(Why the overt bias? Because there are a lot of attitudinals
    and they will be difficult to learn as an entire set. By
    aligning our scales arbitrarily, we give the monosyllable
    ``nai'' a useful meaning and make it easier for a novice to
    recognize at least the positive or negative alignment of an
    indicator, if not the specific word. Other choices considered
    were ``random'' orientation, which would have unknown biases
    and be difficult to learn, and orientation based on our guesses
    as to which scale orientations made the most frequent usages
    shorter, which would be biased in favor of American perceptions
    of ``usefulness''. If bias must exist in our indicator set, it
    might as well be a known bias that eases learning, and in
    addition might as well favor a harmonious and positive
    world-view.)</p>

    <p>In fact, though, each emotional scale has seven positions
    defined, three ``positive'' ones (shown below on the left),
    three ``negative'' ones (shown below on the right), and a
    neutral one indicating that no particular attitude on this
    scale is felt. The following chart indicates the seven
    positions of the scale and the associated cmavo. All of these
    cmavo, except ``nai'', are in selma'o CAI.</p>
<pre>
     cai     sai     ru'e   cu'i   nairu'e naisai  naicai
    [carmi] [tsali] [ruble] [cumki]
</pre>
    A scalar attitude is expressed by using the attitudinal word,
    and then following it by the desired scalar intensity. The bias
    creeps in because the ``negative'' emotions take the extra
    syllable ``nai'' to indicate their negative position on the
    axis, and thus require a bit more effort to express. 

    <p>Much of this system is optional. You can express an attitude
    without a scale indicator, if you don't want to stop and think
    about how strongly you feel. Indeed, for most attitudinals,
    we've found that either no scalar value is used, or ``cai'' is
    used to indicate especially high intensity. Less often,
    ``ru'e'' is used for a recognizably weak intensity, and
    ``cu'i'' is used in response to the attitudinal question
    ``pei'' (see <a href="#s10">Section 10</a>) to indicate that
    the emotion is not felt.</p>

    <p>The following shows the variations resulting from intensity
    variation:</p>

    <p></p>
<pre>
<a id="e4d1" name="e4d1">4.1)</a>  .ei
    I ought to
    (a non-specific obligation)
</pre>
<pre>
<a id="e4d2" name="e4d2">4.2)</a>  .eicai
    I shall/must
    (an intense obligation or requirement, possibly
        a formal one)
</pre>
<pre>
<a id="e4d3" name="e4d3">4.3)</a>  .eisai
    I should
    (a strong obligation or necessity, possibly an
        implied but not formal requirement)
</pre>
<pre>
<a id="e4d4" name="e4d4">4.4)</a>  .eiru'e
    I might
    (a weak obligation --- in English often mixed
        with permission and desire)
</pre>
<pre>
<a id="e4d5" name="e4d5">4.5)</a>  .eicu'i
    No matter
    (no particular obligation)
</pre>
<pre>
<a id="e4d6" name="e4d6">4.6)</a>  .einai
    I need not
    (a non-obligation)
</pre>
    You can also utter a scale indicator without a specific
    emotion. This is often used in the language: in order to
    emphasize a point about which you feel strongly, you mark what
    you are saying with the scale indicator ``cai''. You could also
    indicate that you don't care using ``cu'i'' by itself. 

    <h3><a id="s5" name="s5">5. The space of emotions</h3>

    <p>Each of the attitude scales constitutes an axis in a
    multi-dimensional space. In effect, given our total so far of
    39 scales, we have a 39-dimensional space. At any given time,
    our emotions and attitudes are represented by a point in this
    39-dimensional space, with the intensity indicators serving as
    coordinates along each dimension. A complete attitudinal
    inventory, should one decide to express it, would consist of
    reading off each of the scale values for each of the emotions,
    with the vector sum serving as a distinct single point, which
    is our attitude.</p>

    <p>Now no one is going to ever utter a string of 100-odd
    attitudinals to express their emotions. If asked, we normally
    do not recognize more than one or two emotions at a time ---
    usually the ones that are strongest or which most recently
    changed in some significant way. But the scale system provides
    some useful insights into a possible theory of emotion (which
    might be testable using Lojban), and incidentally explains how
    Lojbanists express compound emotions when they do recognize
    them.</p>

    <p>The existence of 39 scales highlights the complexity of
    emotion. We also aren't bound to the 39. There are modifiers
    described in <a href="#s6">Section 6</a> that multiply the set
    of scales by an order of magnitude. You can also have mixed
    feelings on a scale, which might be expressed by ``cu'i'', but
    could also be expressed by using both the ``positive'' and
    ``negative'' scale emotions at once. One expression of
    ``fortitude'' might be ``.ii.iinai'' --- fear coupled with
    security.</p>

    <p>Uttering one or more attitudinals to express an emotion
    reflects several things. We will tend to utter emotions in
    their immediate order of importance to us. We feel several
    emotions at once, and our expression reflects these emotions
    simultaneously, although their order of importance to us is
    also revealing --- of our attitude towards our attitude, so to
    speak. There is little analysis necessary; for those emotions
    you feel, you express them; the ``vector sum'' naturally
    expresses the result. This is vital to their nature as
    attitudinals --- if you had to stop and think about them, or to
    worry about grammar, they wouldn't be emotions but
    rationalizations.</p>

    <p>People have proposed that attitudinals be expressed as bridi
    just like everything else; but emotions aren't logical or
    analytical --- saying ``I'm awed'' is not the same as saying
    ``Wow!!!''. The Lojban system is intended to give the effects
    of an analytical system without the thought involved. Thus, you
    can simply feel in Lojban.</p>

    <p>A nice feature of this design is that you can be simple or
    complex, and the system works the same way. The most immediate
    benefit is in learning. You only need to learn a couple of the
    scale words and a couple of attitude words, and you're ready to
    express your emotions Lojbanically. As you learn more, you can
    express your emotions more thoroughly and more precisely, but
    even a limited vocabulary offers a broad range of
    expression.</p>

    <h3><a id="s6" name="s6">6. Emotional categories</h3>

    <p>The Lojban attitudinal system was designed by starting with
    a long list of English emotion words, far too many to fit into
    the 39 available VV-form cmavo. To keep the number of cmavo
    limited, the emotion words in the list were grouped together by
    common features: each group was then assigned a separate cmavo.
    This was like making tanru in reverse, and the result is a
    collection of indicators that can be combined, like tanru, to
    express very complex emotions. Some examples in a moment.</p>

    <p>The most significant ``common feature'' we identified was
    that the emotional words on the list could easily be broken
    down into six major groups, each of which was assigned its own
    cmavo:</p>

    <p></p>
<pre>
   ro'a    social      asocial     antisocial
    ro'e    mental              mindless
    ro'i    emotional           denying emotion
    ro'o    physical            denying physical
    ro'u    sexual              sexual abstinence
    re'e    spiritual   secular     sacrilegious
</pre>

    <p>Using these, we were able to assign ``o'u'' to mark a scale
    of what we might call ``generalized comfort''. When you are
    comfortable, relaxed, satisfied, you express comfort with
    ``o'u'', possibly followed by a scale indicator to indicate how
    comfortable you are. The six cmavo given above allow you to
    turn this scale into six separate ones, should you wish.</p>

    <p>For example, embarrassment is a social discomfort,
    expressible as ``.o'unairo'a''. Some emotions that we label
    ``stress'' in English are expressed in Lojban with
    ``.o'unairo'i''. Physical distress can be expressed with
    ``.o'unairo'o'', which makes a nice groan if you say it with
    feeling. Mental discomfort might be what you feel when you
    don't know the answer to the test question, but feel that you
    should. Most adults can recall some instance where we felt
    sexual discomfort, ``o'unairo'u''. Spiritual discomfort,
    ``o'unaire'e'', might be felt by a church-goer who has wandered
    into the wrong kind of religious building.</p>

    <p>Most of the time when expressing an emotion, you won't
    categorize it with these words. Emotional expressions should be
    quickly expressible without having to think about them.
    However, we sometimes have mixed emotions within this set, as
    for example emotional discomfort coupled with physical comfort
    or vice versa.</p>

    <p>Coupling these six words with our 39 attitude scales, each
    of which has a positive and negative side, already gives you
    far more emotional expression words than we have emotional
    labels in English. Thus, you'll never see a Lojban-English
    emotional dictionary that covers all the Lojban possibilities.
    Some may be useless, but others convey emotions that probably
    never had a word for them before, though many have felt them
    (``.eiro'u'', for example --- look it up).</p>

    <p>You can use scale markers and ``nai'' on these six category
    words, and you can also use category words without specifying
    the emotion. Thus, ``I'm trying to concentrate'' could be
    expressed simply as ``ro'e'', and if you are feeling
    anti-social in some non-specific way, ``ro'anai'' will express
    it.</p>

    <p>There is a mnemonic device for the six emotion categories,
    based on moving your arms about. In the following table, your
    hands begin above your head and move down your body in
    sequence.</p>
<pre>
   ro'a    hands above head    social
    ro'e    hands on head       intellectual
    ro'i    hands on heart      emotional
    ro'o    hands on belly      physical
    ro'u    hands on groin      sexual
    re'e    hands moving around spiritual
</pre>

    <p>The implicit metaphors ``heart'' for emotional and ``belly''
    for physical are not really Lojbanic, but they work fine for
    English-speakers.</p>

    <h3><a id="s7" name="s7">7. Attitudinal modifiers</h3>

    <p>The following cmavo are discussed in this section:</p>

    <p></p>
<pre>
   ga'i    hauteur/rank    equal rank  meekness/lack of rank
            [galtu]
    le'o    aggressive  passive     defensive
    vu'e    virtue (zabna)          sin (mabla)
            [vrude]
    se'i    self-orientation        other-orientation
            [sevzi]
    ri'e    release     restraint   control
            [zifre]
    fu'i    with help      without help with opposition
        easily              with difficulty
            [frili]
    be'u     lack/need  presence/satisfaction   satiation
    se'a     self-sufficiency           dependency
            [sevzi]
</pre>
    It turned out that, once we had devised the six emotion
    categories, we also recognized some other commonalities among
    emotions. These tended to fit nicely on scales of their own,
    but generally tend not to be thought of as separate emotions.
    Some of these are self-explanatory, some need to be placed in
    context. Some of these tend to go well with only a few of the
    attitudinals, others go with nearly all of them. To really
    understand these modifiers, try to use them in combination with
    one or two of the attitudinals found in <a href="#s2">Sections
    2</a> and <a href="#s3">3</a>, and see what emotional pictures
    you can build: 

    <p>The cmavo ``ga'i'' expresses the scale used to indicate
    condescension or polite deference; it is not respect in
    general, which is ``.io''. Whatever it is attached to is marked
    as being below (for ``ga'i'') or above (for ``ga'inai'') the
    speaker's rank or social position. Note that it is always the
    referent, not the speaker or listener, who is so marked: in
    order to mark the listener, the listener must appear in the
    sentence, as with ``doi ga'inai'', which can be appended to a
    statement addressed to a social inferior.</p>
<pre>
<a id="e7d1" name="e7d1">7.1)</a>  ko ga'inai
        nenri klama le mi zdani
    you-imperative [low-rank!]
        enter-type-of come-to my house.
    I would be honored if you would enter my residence.
</pre>
    Note that imperatives in Lojban need not be imperious!
    Corresponding examples with ``ga'icu'i'' and ``ga'inai'': 
<pre>
<a id="e7d2" name="e7d2">7.2)</a>  ko ga'icu'i
        nenri klama le mi zdani
    you-imperative [equal-rank!]
        enter-type-of come-to my house.
    Come on in to my place.

<a id="e7d3" name="e7d3">7.3)</a>   ko ga'i
        nenri klama le mi zdani
    you-imperative [high-rank!]
        enter-type-of come-to my house.
    You! Get inside!
</pre>

    <p>Since ``ga'i'' expresses the relative rank of the speaker
    and the referent, it does not make much sense to attach it to
    ``mi'', unless the speaker is using ``mi'' to refer to a group
    (as in English ``we''), or a past or future version of himself
    with a different rank.</p>

    <p>It is also possible to attach ``ga'i'' to a whole bridi, in
    which case it expresses the speaker's superiority to the event
    the bridi refers to:</p>
<pre>
<a id="e7d4" name="e7d4">7.4)</a>  ga'i le xarju pu citka
    [high-rank!] the pig [past] eats
    The pig ate (which is an event beneath my notice).
</pre>
    When used without being attached to any bridi, ``ga'i''
    expresses the speaker's superiority to things in general, which
    may represent an absolute social rank: ``ga'icai'' is an
    appropriate opening word for an emperor's address from the
    throne. 

    <p>The cmavo ``le'o'' represents the scale of aggressiveness.
    We seldom overtly recognize that we are feeling aggressive or
    defensive, but perhaps in counseling sessions, a psychologist
    might encourage someone to express these feelings on this
    scale. And football teams could be urged on by their coach
    using ``ro'ole'o''. ``le'o'' is also useful in threats as an
    alternative to ``o'onai'', which expresses anger.</p>

    <p>The cmavo ``vu'e'' represents ethical virtue or its absence.
    An excess of almost any emotion is usually somewhat ``sinful''
    in the eyes of most ethical systems. On the other hand, we
    often feel virtuous about our feelings --- what we call
    righteous indignation might be ``o'onaivu'e''. Note that this
    is distinct from lack of guilt: ``.u'unai''.</p>

    <p>The cmavo ``se'i'' expresses the difference between selfish
    and generous, for example (in combination with ``.au''):</p>
<pre>
<a id="e7d5" name="e7d5">7.5)</a>  ause'i
    [desire] [self]
    I want it!

<a id="e7d6" name="e7d6">7.6)</a>   ause'inai
    [desire] [other]
    I want you to have it!
</pre>

    <p>In both cases, the English ``it'' is vague, reflecting the
    absence of a bridi. <a href="#e7d5">Example 7.5</a> and <a
    href="#e7d6">Example 7.6</a> are pure expressions of attitude.
    Analogously, ``.uuse'i'' is self-pity, whereas ``.uuse'inai''
    is pity for someone else.</p>

    <p>The modifier ``ri'e'' indicates emotional release versus
    emotional control. ``I will not let him know how angry I am'',
    you say to yourself before entering the room. The Lojban is
    much shorter:</p>
<pre>
<a id="e7d7" name="e7d7">7.7)</a>  .o'onai ri'enai
    [anger] [control]
</pre>

    <p>On the other hand, ``ri'e'' can be used by itself to signal
    an emotional outburst.</p>

    <p>The cmavo ``fu'i'' may express a reason for feeling the way
    we do, as opposed to a feeling in itself; but it is a reason
    that is more emotionally determined than most. For example, it
    could show the difference between the mental discomfort
    mentioned in <a href="#s6">Section 6</a> when it is felt on an
    easy test, as opposed to on a hard test. When someone gives you
    a back massage, you could use ``.o'ufu'i'' to show appreciation
    for the assistance in your comfort.</p>

    <p>The cmavo ``be'u'' expresses, roughly speaking, whether the
    emotion it modifies is in response to something you don't have
    enough of, something you have enough of, or something you have
    too much of. It is more or less the attitudinal equivalent of
    the subjective quantifier cmavo ``mo'a'', ``rau'', and ``du'e''
    (these belong to selma'o PA, and are discussed in <a
    href="chapter18.html">Chapter 18</a>). For example,</p>
<pre>
<a id="e7d8" name="e7d8">7.8)</a>  .uiro'obe'unai
    [Yay!] [physical] [Enough!]
</pre>
    might be something you say after a large meal which you
    enjoyed. 

    <p>Like all modifiers, ``be'u'' can be used alone:</p>
<pre>
<a id="e7d9" name="e7d9">7.9)</a>  le cukta be'u cu zvati ma
    The book [Needed!] is at-location [what sumti?]
    Where's the book? --- I need it!
</pre>
    Lastly, the modifier ``se'a'' shows whether the feeling is
    associated with self-sufficiency or with dependence on others. 
<pre>
<a id="e7d10" name="e7d10">7.10)</a>    .e'ese'a
    [I can!] [self-sufficient!]
    I can do it all by myself!
</pre>
    is something a Lojban-speaking child might say. On the other
    hand, 
<pre>
<a id="e7d11" name="e7d11">7.11)</a>    .e'ese'anai
    [I can!] [dependent]
    I can do it if you help me.
</pre>
    from the same child would indicate a (hopefully temporary) loss
    of self- confidence. It is also possible to negate the ``.e'e''
    in <a href="#e7d7">Example 7.7</a> and <a href="#e7d8">Example
    7.8</a>, leading to: 
<pre>
<a id="e7d12" name="e7d12">7.12)</a>    .e'enaise'a
    [I can't] [self-sufficient]
    I can't do it by myself!
</pre>
    and 
<pre>
<a id="e7d13" name="e7d13">7.13)</a>    .e'enaise'anai
    [I can't!] [dependent]
    I can't do it if you insist on ``helping'' me!
</pre>
    Some of the emotional expressions may seem too complicated to
    use. They might be for most circumstances. It is likely that
    most combinations will never get used. But if one person uses
    one of these expressions, another person can understand (as
    unambiguously as the expresser intends) what emotion is being
    expressed. Most probably as the system becomes well-known and
    internalized by Lojban-speakers, particular attitudinal
    combinations will come to be standard expressions (if not
    cliches) of emotion. 

    <h3><a id="s8" name="s8">8. Compound indicators</h3>

    <p>The grammar of indicators is quite simple; almost all facets
    are optional. You can combine indicators in any order, and they
    are still grammatical. The presumed denotation is additive;
    thus the whole is the sum of the parts regardless of the order
    expressed, although the first expressed is presumed most
    important to the speaker. Every possible string of UI cmavo has
    some meaning.</p>

    <p>Within a string of indicators, there will be conventions of
    interpretation which amount to a kind of second-order grammar.
    Each of the modifier words is presumed to modify an indicator
    to the left, if there is one. (There is an ``unspecified
    emotion'' word, ``ge'e'', reserved to ensure that if you want
    to express a modifier without a root emotion, it doesn't attach
    to and modify a previous but distinct emotional
    expression.)</p>

    <p>For example, ``.ieru'e'' expresses a weak positive value on
    the scale of agreement: the speaker agrees (presumably with the
    listener or with something else just stated), but with the
    least possible degree of intensity. But ``.ie ge'eru'e''
    expresses agreement (at an unspecified level), followed by some
    other unstated emotion which is felt at a weak level. A rough
    English equivalent of ``.ie ge'eru'e'' might be ``I agree, but
    ...'' where the ``but'' is left hanging. (Again, attitudes
    aren't always expressed in English by English
    attitudinals.)</p>

    <p>A scale variable similarly modifies the previous emotion
    word. You put the scale word for a root emotion word before a
    modifier, since the latter can have its own scale word. This
    merely maximizes the amount of information expressible. For
    example, ``.oinaicu'i ro'ucai'' expresses a feeling midway
    between pain (``.oi'') and pleasure (``.oinai'') which is
    intensely sexual (``ro'u'') in nature.</p>

    <p>The cmavo ``nai'' is the most tightly bound modifier in the
    language: it always negates exactly one word --- the preceding
    one. Of all the words used in indicator constructs, ``nai'' is
    the only one with any meaning outside the indicator system. If
    you try to put an indicator between a non-indicator cmavo and
    its ``nai'' negator, the ``nai'' will end up negating the last
    word of the indicator. The result, though unambiguous, is not
    what you want. For example,</p>
<pre>
<a id="e8d1" name="e8d1">8.1)</a>  mi .e .ui nai do
    I and [Yay!] [Not!] you
</pre>
    means ``I and (unfortunately) you'', whereas 
<pre>
<a id="e8d2" name="e8d2">8.2)</a>  mi .e nai .ui do
    I and [Not!] [Yay!] you
</pre>
    means ``I but (fortunately) not you''. Attitudinal ``nai''
    expresses a ``scalar negation'', a concept explained in <a
    href="chapter15.html">Chapter 15</a>; since every attitudinal word
    implies exactly one scale, the effect of ``nai'' on each should
    be obvious. 

    <p>Thus, the complete internal grammar of UI is as follows,
    with each listed part optionally present or absent without
    affecting grammaticality, though it obviously would affect
    meaning.</p>

    <dl>
      <dt></dt>

      <dd>attitudinal ``nai'' intensity-word ``nai'' modifier
      ``nai'' intensity-word ``nai'' (possibly repeated)</dd>
    </dl>
    ``ge'e'', the non-specific emotion word, functions as an
    attitudinal. If multiple attitudes are being expressed at once,
    then in the 2nd or greater position, either ``ge'e'' or a VV
    word must be used to prevent any modifiers from modifying the
    previous attitudinal. 

    <h3><a id="s9" name="s9">9. The uses of indicators</h3>

    <p>The behavior of indicators in the ``outside grammar'' is
    nearly as simple as their internal structure. Indicator
    groupings are identified immediately after the metalinguistic
    erasers ``si'', ``sa'', and ``su'' and some, though not all,
    kinds of quotations. The details of such interactions are
    discussed in <a href="chapter19.html">Chapter 19</a>.</p>

    <p>A group of indicators may appear anywhere that a single
    indicator may, except in those few situations (as in ``zo''
    quotation, explained in <a href="chapter19.html">Chapter 19</a>)
    where compound cmavo may not be used.</p>

    <p>At the beginning of a text, indicators modify everything
    following them indefinitely: such a usage is taken as a raw
    emotional expression, and we normally don't turn off our
    emotions when we start and stop sentences. In every other place
    in an utterance, the indicator (or group) attaches to the word
    immediately to its left, and indicates that the attitude is
    being expressed concerning the object or concept to which the
    word refers.</p>

    <p>If the word that an indicator (or group) attaches to is
    itself a cmavo which governs a grammatical structure, then the
    indicator construct pertains to the referent of the entire
    structure. There is also a mechanism, discussed in <a
    href="chapter19.html">Chapter 19</a>, for explicitly marking the
    range of words to which an indicator applies.</p>

    <p>More details about the uses of indicators, and the way they
    interact with other specialized cmavo, are given in <a
    href="chapter19.html">Chapter 19</a>. It is worth mentioning that
    real-world interpretation is not necessarily consistent with
    the formal scope rules. People generally express emotions when
    they feel them, with only a minimum of grammatical constraint
    on that expression; complexities of emotional expression are
    seldom logically analyzable. Lojban attempts to provide a
    systematic reference that could possibly be ingrained to an
    instinctive level. However, it should always be assumed that
    the referent of an indicator has some uncertainty.</p>

    <p>For example, in cases of multiple indicators expressed
    together, the combined form has some ambiguity of
    interpretation. It is possible to interpret the second
    indicator as expressing an attitude about the first, or to
    interpret both as expressing attitudes about the common
    referent. For example, in</p>
<pre>
<a id="e9d1" name="e9d1">9.1)</a>  mi pu tavla do .o'onai .oi
    I [past] talk-to you [Grrr!] [Oy!]
</pre>
    can be interpreted as expressing complaint about the anger, in
    which case it means ``Damn, I snapped at you''; or as
    expressing both anger and complaint about the listener, in
    which case it means ``I told you, you pest!'' 

    <p>Similarly, an indicator after the final brivla of a tanru
    may be taken to express an attitude about the particular brivla
    placed there --- as the rules have it --- or about the entire
    bridi which hinges on that brivla. Remembering that indicators
    are supposedly direct expressions of emotion, this ambiguity is
    acceptable.</p>

    <p>Even if the scope rules given for indicators turn out to be
    impractical or unintuitive for use in conversation, they are
    still useful in written expression. There, where you can go
    back and put in markers or move words around, the scope rules
    can be used in lieu of elaborate nuances of body language and
    intonation to convey the writer's intent.</p>

    <h3><a id="s10" name="s10">10. Attitude questions; empathy; attitude contours</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   pei attitude question
    dai empathy
    bu'o    start emotion   continue emotion end emotion
</pre>

    <p>You can ask someone how they are feeling with a normal bridi
    sentence, but you will get a normal bridi answer in response,
    one which may be true or false. Since the response to a
    question about emotions is no more logical than the emotion
    itself, this isn't appropriate.</p>

    <p>The word ``pei'' is therefore reserved for attitude
    questions. Asked by itself, it captures all of the denotation
    of English ``How are you?'' coupled with ``How do you feel?''
    (which has a slightly different range of usage).</p>

    <p>When asked in the context of discourse, ``pei'' acts like
    other Lojban question words --- it requests the respondent to
    ``fill in the blank'', in this case with an appropriate
    attitudinal describing the respondent's feeling about the
    referent expression. As with other questions, plausibility is
    polite; if you answer with an irrelevant UI cmavo, such as a
    discursive, you are probably making fun of the questioner. (A
    ``ge'e'', however, is always in order --- you are not required
    to answer emotionally. This is not the same as ``.i'inai'',
    which is privacy as the reverse of conviviality.)</p>

    <p>Most often, however, the asker will use ``pei'' as a place
    holder for an intensity marker. (As a result, ``pei'' is placed
    in selma'o CAI, although selma'o UI would have been almost as
    appropriate. Grammatically, there is no difference between UI
    and CAI.) Such usage corresponds to a whole range of idiomatic
    usages in natural languages:</p>
<pre>
<a id="e10d1" name="e10d1">10.1)</a>    .iepei
    [agreement] [question]
    Do you agree?

<a id="e10d2" name="e10d2">10.2)</a> .iare'epei
    [belief] [spiritual] [question]
    Are you a Believer?

<a id="e10d3" name="e10d3">10.3)</a> .aipei
    [intention] [question]
    Are you going to do it?
</pre>
    <a href="#e10d3">Example 10.3</a> might appear at the end of a
    command, to which the response 
<pre>
<a id="e10d4" name="e10d4">10.4)</a>    .aicai
    [intention] [maximal]
</pre>
    corresponds to ``Aye! Aye!'' (hence the choice of cmavo). 
<pre>
<a id="e10d5" name="e10d5">10.5)</a>    .e'apei
    [permission] [question]
    Please, Mommy!  Can I??
</pre>
    Additionally, when ``pei'' is used at the beginning of an
    indicator construct, it asks specifically if that construct
    reflects the attitude of the respondent, as in (asked of
    someone who has been ill or in pain): 
<pre>
<a id="e10d6" name="e10d6">10.6)</a>    pei.o'u
    [question] [comfort]
    Are you comfortable?

<a id="e10d7" name="e10d7">10.7)</a> pei.o'ucu'i
    [question] [comfort] [neutral]
    Are you no longer in pain?

<a id="e10d8" name="e10d8">10.8)</a> pei.o'usai
    [question] [comfort] [strong]
    Are you again healthy?
</pre>
    Empathy, which is not really an emotion, is expressed by the
    indicator ``dai''. (Don't confuse empathy with sympathy, which
    is ``.uuse'inai''.) Sometimes, as when telling a story, you
    want to attribute emotion to someone else. You can of course
    make a bridi claim that so-and-so felt such-and-such an
    emotion, but you can also make use of the attitudinal system by
    adding the indicator ``dai'', which attributes the preceding
    attitudinal to someone else --- exactly whom, must be
    determined from context. You can also use ``dai''
    conversationally when you empathize, or feel someone else's
    emotion as if it were your own: 
<pre>
<a id="e10d9" name="e10d9">10.9)</a>    .oiro'odai
    [pain!] [physical] [empathy]
    Ouch, that must have hurt!
</pre>

    <p>It is even possible to ``empathize'' with a non-living
    object:</p>

    <p></p>
<pre>
<a id="e10d10" name="e10d10">10.10)</a>  le bloti .iidai .uu pu
        klama le xasloi
    the ship [fear!] [empathy] [pity!] [past]
        goes-to the ocean-floor
    Fearfully the ship, poor thing, sank.
</pre>
    suggesting that the ship felt fear at its impending
    destruction, and simultaneously reporting the speaker's pity
    for it. 

    <p>Both ``pei'' and ``dai'' represent exceptions to the normal
    rule that attitudinals reflect the speaker's attitude.</p>

    <p>Finally, we often want to report how our attitudes are
    changing. If our attitude has not changed, we can just repeat
    the attitudinal. (Therefore, ``.ui .ui .ui'' is not the same as
    ``.uicai'', but simply means that we are continuing to be
    happy.) If we want to report that we are beginning to feel,
    continuing to feel, or ceasing to feel an emotion, we can use
    the attitudinal contour cmavo ``bu'o''.</p>

    <p>When attached to an attitudinal, ``bu'o'' means that you are
    starting to have that attitude, ``bu'ocu'i'' that you are
    continuing to have it, and ``bu'onai'' that you are ceasing to
    have it. Some examples:</p>
<pre>
<a id="e10d11" name="e10d11">10.11)</a>  o'onai bu'o
    [anger!] [start emotion]
    I'm getting angry!

<a id="e10d12" name="e10d12">10.12)</a>   .iu bu'onai .uinai
    [love!] [end emotion] [unhappiness!]
    I don't love you any more; I'm sad.
</pre>

    <p>Note the difference in effect between <a
    href="#e10d12">Example 10.12</a> and:</p>
<pre>
<a id="e10d13"
name="e10d13">10.13)</a>  mi ca ba'o prami do ja'e le nu
        mi badri
    I [present] [cessitive] love you with-result the event-of
        (I am-sad).
    I no longer love you; therefore, I am sad.
</pre>
    which is a straightforward bridi claim. <a
    href="#e10d13">Example 10.13</a> states that you have (or have
    had) certain emotions; <a href="#e10d12">Example 10.12</a>
    expresses those emotions directly. 

    <h3><a id="s11" name="s11">11. Evidentials</h3>

    <p>The following cmavo are discussed in this section:</p>
<pre>
   ja'o    I conclude
            [jalge]
    ca'e    I define
    ba'a    I expect    I experience    I remember
            [balvi]
    su'a    I generalize            I particularize
            [sucta]
    ti'e    I hear (hearsay)
            [tirna]
    ka'u    I know by cultural means
            [kulnu]
    se'o    I know by internal experience
            [senva]
    za'a    I observe
            [zgana]
    pe'i    I opine [pensi]
    ru'a    I postulate
            [sruma]
    ju'a    I state [jufra]
</pre>
    Now we proceed from the attitudinal indicators and their
    relatives to the other, semantically unrelated, categories of
    indicators. The indicators known as ``evidentials'' show how
    the speaker came to say the utterance; i.e. the source of the
    information or the idea. Lojban's list of evidentials was
    derived from lists describing several American Indian
    languages. Evidentials are also essential to the constructed
    language L&aacute;adan, designed by the linguist and novelist
    Suzette Haden Elgin. L&aacute;adan's set of indicators was
    drawn on extensively in developing the Lojban indicator system.
    

    <p>It is important to realize, however, that evidentials are
    not some odd system used by some strange people who live at the
    other end of nowhere: although their English equivalents aren't
    single words, English-speakers have vivid notions of what
    constitutes evidence, and of the different kinds of
    evidence.</p>

    <p>Like the attitudinal indicators, the evidentials belong to
    selma'o UI, and may be treated identically for grammatical
    purposes. Most of them are not usually considered scalar in
    nature, but a few have associated scales.</p>

    <p>A bridi with an evidential in it becomes ``indisputable'',
    in the sense that the speaker is saying ``how it is with him or
    her'', which is beyond argument. Claims about one's own mental
    states may be true or false, but are hardly subject to other
    people's examination. If you say that you think, or perceive,
    or postulate such-and-such a predication, who can contradict
    you? Discourse that uses evidentials has therefore a different
    rhetorical flavor than discourse that does not; arguments tend
    to become what can be called dialogues or alternating
    monologues, depending on your prejudices.</p>

    <p>Evidentials are most often placed at the beginning of
    sentences, and are often attached to the ``.i'' that separates
    sentences in connected discourse. It is in the nature of an
    evidential to affect the entire bridi in which it is placed:
    like the propositional attitude indicators, they strongly
    affect the claim made by the main bridi.</p>

    <p>A bridi marked by ``ja'o'' is a conclusion by the speaker
    based on other (stated or unstated) information or ideas. Rough
    English equivalents of ``ja'o'' are ``thus'' and
    ``therefore''.</p>

    <p>A bridi marked by ``ca'e'' is true because the speaker says
    so. In addition to definitions of words, ``ca'e'' is also
    appropriate in what are called performatives, where the very
    act of speaking the words makes them true. An English example
    is ``I now pronounce you husband and wife'', where the very act
    of uttering the words makes the listeners into husband and
    wife. A Lojban translation might be:</p>
<pre>
<a id="e11d1"
name="e11d1">11.1)</a>    ca'e le re do cu simxu speni
    [I define!] The two of-you are-mutual spouses.
</pre>
    The three scale positions of ``ba'a'', when attached to a
    bridi, indicate that it is based on the speaker's view of the
    real world. Thus ``ba'a'' means that the statement represents a
    future event as anticipated by the speaker; ``ba'acu'i'', a
    present event as experienced by the speaker; ``ba'anai'', a
    past event as remembered by the speaker. It is accidental that
    this scale runs from future to past instead of past to future. 
<pre>
<a id="e11d2"
name="e11d2">11.2)</a>    ba'acu'i le tuple be mi cu se cortu
    [I experience!] The leg of me is-the-locus-of-pain.
    My leg hurts.
</pre>
    A bridi marked by ``su'a'' is a generalization by the speaker
    based on other (stated or unstated) information or ideas. The
    difference between ``su'a'' and ``ja'o'' is that ``ja'o''
    suggests some sort of reasoning or deduction (not necessarily
    rigorous), whereas ``su'a'' suggests some sort of induction or
    pattern recognition from existing examples (not necessarily
    rigorous). 

    <p>The opposite point of the scale, ``su'anai'', indicates
    abduction, or drawing specific conclusions from general
    premises or patterns.</p>

    <p>This cmavo can also function as a discursive (see <a
    href="#s12">Section 12</a>), in which case ``su'a'' means
    ``abstractly'' or ``in general'', and ``su'anai'' means
    ``concretely'' or ``in particular''.</p>

    <p>A bridi marked by ``ti'e'' is relayed information from some
    source other than the speaker. There is no necessary
    implication that the information was relayed via the speaker's
    ears; what we read in a newspaper is an equally good example of
    ``ti'e'', unless we have personal knowledge of the content.</p>
<pre>
<a id="e11d3" name="e11d3">11.3)</a>    ti'e la .uengas cu zergau
    [I hear!] Wenga is-a-criminal-doer.
    I hear that Wenga is a crook.
</pre>
    A bridi marked by ``ka'u'' is one held to be true in the
    speaker's cultural context, as a matter of myth or custom, for
    example. Such statements should be agreed on by a community of
    people --- you cannot just make up your own cultural context
    --- although ``objectivity'' in the sense of actual
    correspondence with the facts is certainly not required. 

    <p>On the other hand, ``se'o'' marks a bridi whose truth is
    asserted by the speaker as a result of an internal experience
    not directly available to others, such as a dream, vision, or
    personal revelation. In some cultures, the line between
    ``ka'u'' and ``se'o'' is fuzzy or even nonexistent.</p>

    <p>A bridi marked by ``za'a'' is based on perception or direct
    observation by the speaker. This use of ``observe'' is not
    connected with the Lojban ``observative'', or bridi with the
    first sumti omitted. The latter has no explicit aspect, and
    could be a direct observation, a conclusion, an opinion, or
    other aspectual point of view.</p>
<pre>
<a id="e11d4" name="e11d4">11.4)</a>    za'a do tatpi
    [I observe!] You are-tired.
    I see you are tired.
</pre>
    A bridi marked by ``pe'i'' is the opinion of the speaker. The
    form ``pe'ipei'' is common, meaning ``Is this your opinion?''.
    (Strictly, this should be ``peipe'i'', in accordance with the
    distinction explained in Examples 10.6-10.8, but since ``pe'i''
    is not really a scale, there is no real difference between the
    two orders.) 

    <p></p>
<pre>
<a id="e11d5"
name="e11d5">11.5)</a>    pe'i la kartagos. .ei se daspo
    [I opine!] Carthage [obligation] is-destroyed.
    In my opinion, Carthage should be destroyed.
</pre>
    A bridi marked by ``ru'a'' is an assumption made by the
    speaker. This is similar to one possible use of ``.e'u''. 

    <p></p>
<pre>
<a id="e11d6" name="e11d6">11.6)</a>    ru'a doi livinston.
    Dr. Livingstone, I presume?
        (A rhetorical question: Stanley knew who he was.)
</pre>
    Finally, the evidential ``ju'a'' is used to avoid stating a
    specific basis for a statement. It can also be used when the
    basis for the speaker's statement is not covered by any other
    evidential. For the most part, using ``ju'a'' is equivalent to
    using no evidential at all, but in question form it can be
    useful: ``ju'apei'' means ``What is the basis for your
    statement?'' and serves as an evidential, as distinct from
    emotional, question. 

    <h3><a id="s12" name="s12">12. Discursives</h3>

    <p>The term ``discursive'' is used for those members of selma'o
    UI that provide structure to the discourse, and which show how
    a given word or utterance relates to the whole discourse. To
    express these concepts in regular bridi would involve extra
    layers of nesting: rather than asserting that ``I also came'',
    we would have to say ``I came; furthermore, the event of my
    coming is an additional instance of the relationship expressed
    by the previous sentence'', which is intolerably clumsy.
    Typical English equivalents of discursives are words or phrases
    like ``however'', ``summarizing'', ``in conclusion'', and ``for
    example''.</p>

    <p>Discursives are not attitudinals: they express no particular
    emotion. Rather, they are abbreviations for metalinguistic
    claims that reference the sentence or text they are found
    in.</p>

    <p>Discursives are most often used at the beginning of
    sentences, often attached to the ``.i'' that separates
    sentences in running discourse, but can (like all other
    indicators) be attached to single words when it seems necessary
    or useful.</p>

    <p>The discursives discussed in this section are given in
    groups, roughly organized by function. First, the ``consecutive
    discourse'' group:</p>

    <p></p>
<pre>
   ku'i    however/but/in contrast     [karbi]
    ji'a    additionally            [jmina]
    si'a    similarly           [simsa]
    mi'u    ditto               [mintu]
    po'o    the only relevant case
</pre>
    These five discursives are mutually exclusive, and therefore
    they are not usually considered as scales. The first four are
    used in consecutive discourse. The first, ``ku'i'', makes an
    exception to the previous argument. The second, ``ji'a'', adds
    weight to the previous argument. The third, ``si'a'', adds
    quantity to the previous argument, enumerating an additional
    example. The fourth, ``mi'u'', adds a parallel case to the
    previous argument, and can also be used in tables or the like
    to show that something is being repeated from the previous
    column. It is distinct from ``go'i'' (of selma'o GOhA,
    discussed in <a href="chapter7.html">Chapter 7</a>), which is a
    non-discursive version of ``ditto'' that explicitly repeats the
    claim of the previous bridi. 

    <p>Lastly, ``po'o'' is used when there is no other comparable
    case, and thus corresponds to some of the uses of ``only'', a
    word difficult to express in pure bridi form:</p>

    <p></p>
<pre>
<a id="e12d1"
name="e12d1">12.1)</a>    mi po'o darxi le mi tamne fo le nazbi
    I [only] hit my cousin at-locus the nose.
    Only I (nobody else) hit my cousin on his nose.

<a id="e12d2"
name="e12d2">12.2)</a> mi darxi po'o le mi tamne fo le nazbi
    I hit [only] my cousin at-locus the nose.
    I only hit my cousin on his nose
        (I did nothing else to him).

<a id="e12d3"
name="e12d3">12.3)</a> mi darxi le mi tamne po'o fo le nazbi
    I hit my cousin [only] at-locus the nose.
    I hit only my cousin on his nose (no one else).

<a id="e12d4"
name="e12d4">12.4)</a> mi darxi le mi tamne fo le nazbi po'o
    I hit my cousin at-locus the nose [only].
    I hit my cousin only on his nose (nowhere else).
</pre>
    Note that ``only'' can go before or after what it modifies in
    English, but ``po'o'', as an indicator, always comes afterward.
    

    <p>Next, the ``commentary on words'' group:</p>

    <p></p>
<pre>
   va'i    in other words      in the same words
            [valsi]
    ta'u    expanding a tanru   making a tanru
            [tanru]
</pre>
    The discursives ``va'i'' and ``ta'u'' operate at the level of
    words, rather than discourse proper, or if you like, they deal
    with how things are said. An alternative English expression for
    ``va'i'' is ``rephrasing''; for ``va'inai'', ``repeating''.
    Also compare ``va'i'' with ``ke'u'', discussed below. 

    <p>The cmavo ``ta'u'' is a discursive unique to Lojban; it
    expresses the particularly Lojbanic device of tanru. Since
    tanru are semantically ambiguous, they are subject to
    misunderstanding. This ambiguity can be removed by expanding
    the tanru into some semantically unambiguous structure, often
    involving relative clauses or the introduction of additional
    brivla. The discursive ``ta'u'' marks the transition from the
    use of a brief but possibly confusing tanru to its fuller,
    clearer expansion; the discursive ``ta'unai'' marks a
    transition in the reverse direction.</p>

    <p>Next, the ``commentary on discourse'' group:</p>

    <p></p>
<pre>
   li'a    clearly/obviously       obscurely
            [klina]
    ba'u    exaggeration    accuracy    understatement
            [banli]
    zo'o    humorously  dully       seriously

    sa'e    precisely speaking      loosely speaking
            [satci]
    to'u    in brief            in detail
            [tordu]
    do'a    generously          parsimoniously
            [dunda]
    sa'u    simply              elaborating
            [sampu]
    pa'e    justice             prejudice
            [pajni]
    je'u    truly               falsely
            [jetnu]
</pre>
    This group is used by the speaker to characterize the nature of
    the discourse, so as to prevent misunderstanding. It is
    well-known that listeners often fail to recognize a humorous
    statement and take it seriously, or miss an exaggeration, or
    try to read more into a statement than the speaker intends to
    put there. In speech, the tone of voice often provides the
    necessary cue, but the reader of ironic or understated or
    imprecise discourse is often simply clueless. As with the
    attitudinals, the use of these cmavo will seem fussy to new
    Lojbanists, but it is important to remember that ``zo'o'', for
    example, is the equivalent of smiling while you speak, not the
    equivalent of a flat declaration like ``What I'm about to say
    is supposed to be funny.'' 

    <p>A few additional English equivalents: for ``sa'enai'',
    ``roughly speaking'' or ``approximately speaking''; for
    ``sa'unai'', ``furthermore''; for ``to'u'', ``in short'' or
    ``skipping details''; for ``do'a'', ``broadly construed''; for
    ``do'anai'' (as you might expect), ``narrowly construed''.</p>

    <p>The cmavo ``pa'e'' is used to claim (truly or falsely) that
    one is being fair or just to all parties mentioned, whereas
    ``pa'enai'' admits (or proclaims) a bias in favor of one
    party.</p>

    <p>The scale of ``je'u'' and ``je'unai'' is a little different
    from the others in the group. By default, we assume that people
    speak the truth --- or at least, that if they are lying, they
    will do their best to conceal it from us. So under what
    circumstances would ``je'unai'' be used, or ``je'u'' be useful?
    For one thing, ``je'u'' can be used to mark a tautology: a
    sentence that is a truth of logic, like ``All cats are cats.''
    Its counterpart ``je'unai'' then serves to mark a logical
    contradiction. In addition, ``je'unai'' can be used to express
    one kind of sarcasm or irony, where the speaker pretends to
    believe what he/she says, but actually wishes the listener to
    infer a contrary opinion. Other forms of irony can be marked
    with ``zo'o'' (humor) or ``.ianai'' (disbelief).</p>

    <p>When used as a discursive, ``su'a'' (see <a
    href="#s11">Section 11</a>) belongs to this group.</p>

    <p>Next, the ``knowledge'' group:</p>

    <p></p>
<pre>
   ju'o    certainly   uncertain   certainly not
            [djuno]
    la'a    probably            improbably
            [lakne]
</pre>
    These two discursives describe the speaker's state of knowledge
    about the claim of the associated bridi. They are similar to
    the propositional attitudes of <a href="#s3">Section 3</a>, as
    they create a hypothetical world. We may be quite certain that
    something is true, and label our bridi with ``ju'o''; but it
    may be false all the same. 

    <p>Next, the ``discourse management'' group:</p>

    <p></p>
<pre>
   ta'o    by the way          returning to point
            [tanjo]
    ra'u    chiefly     equally     incidentally
            [ralju]
    mu'a    for example omitting ex.    end examples
            [mupli]
    zu'u    on the one hand         on the other hand

    ke'u    repeating           continuing
            [krefu]
    da'i    supposing           in fact
</pre>
    This final group is used to perform what may be called
    ``managing the discourse'': providing reference points to help
    the listener understand the flow from one sentence to the next.
    

    <p>Other English equivalents of ``ta'onai'' are ``anyway'',
    ``anyhow'', ``in any case'', ``in any event'', ``as I was
    saying'', and ``continuing''.</p>

    <p>The scale of ``ra'u'' has to do with the importance of the
    point being, or about to be, expressed: ``ra'u'' is the most
    important point, ``ra'ucu'i'' is a point of equal importance,
    and ``ra'unai'' is a lesser point. Other English equivalents of
    ``ra'u'' are ``above all'' and ``primarily''.</p>

    <p>The cmavo ``ke'u'' is very similar to ``va'i'', although
    ``ke'unai'' and ``va'inai'' are quite different. Both ``ke'u''
    and ``va'i'' indicate that the same idea is going to be
    expressed using different words, but the two cmavo differ in
    emphasis. Using ``ke'u'' emphasizes that the content is the
    same; using ``va'i'' emphasizes that the words are different.
    Therefore, ``ke'unai'' shows that the content is new (and
    therefore the words are also); ``va'inai'' shows that the words
    are the same (and therefore so is the content). One English
    equivalent of ``ke'unai'' is ``furthermore''.</p>

    <p>The discursive ``da'i'' marks the discourse as possibly
    taking a non-real-world viewpoint (``Supposing that'', ``By
    hypothesis''), whereas ``da'inai'' insists on the real-world
    point of view (``In fact'', ``In truth'', ``According to the
    facts''). A common use of ``da'i'' is to distinguish
    between:</p>

    <p></p>
<pre>
<a id="e12d5"
name="e12d5">12.5)</a>     ganai da'i do viska le mi citno mensi
        gi ju'o do djuno le du'u ri pazvau
    If you [hypothetical] see my young sister,
        then [certain] you know that she is-pregnant.
    If you were to see my younger sister,
        you would certainly know she is pregnant.
</pre>
    and: 
<pre>
<a id="e12d6"
name="e12d6">12.6)</a>     ganai da'inai do viska le mi citno mensi
        gi ju'o do djuno le du'u ri pazvau
    If you [factual] see my young sister,
        then [certainty] you know that she is-pregnant.
    If you saw my younger sister,
        you would certainly know she is pregnant.
</pre>

    <p>It is also perfectly correct to omit the discursive
    altogether, and leave the context to indicate which
    significance is meant. (Chinese always leaves this distinction
    to the context: the Chinese sentence</p>
<pre>
<a id="e12d7"
name="e12d7">12.7)</a>    ru<sup>2</sup>guo^3 ni^3 kan<sup>4</sup>dao^4 wo^3 mei<sup>4</sup>mei,
        ni^3 yi<sup>2</sup>ding^4 zhi<sup>1</sup>dao^4 ta^1 huai<sup>2</sup>yun^4 le
    if you see-arrive my younger-sister,
        you certainly know she pregnant
</pre>
    is the equivalent of either <a href="#e12d5">Example 12.5</a>
    or <a href="#e12d6">Example 12.6</a>.) 

    <h3><a id="s13" name="s13">13. Miscellaneous indicators</h3>

    <p>Some indicators do not fall neatly into the categories of
    attitudinal, evidential, or discursive. This section discusses
    the following miscellaneous indicators:</p>
<pre>
   ki'a    metalinguistic confusion
    na'i    metalinguistic negator
    jo'a    metalinguistic affirmer
    li'o    omitted text (quoted material)
    sa'a    material inserted by editor/narrator
    xu  true-false question
    pau question premarker      rhetorical question
    pe'a    figurative language     literal language
    bi'u    new information         old information
    ge'e    non-specific indicator
</pre>
    The cmavo ``ki'a'' is one of the most common of the
    miscellaneous indicators. It expresses metalinguistic
    confusion; i.e. confusion about what has been said, as opposed
    to confusion not tied to the discourse (which is ``.uanai'').
    The confusion may be about the meaning of a word or of a
    grammatical construct, or about the referent of a sumti. One of
    the uses of English ``which'' corresponds to ``ki'a'': 
<pre>
<a id="e13d1" name="e13d1">13.1)</a>    mi nelci le ctuca
    .i le ki'a ctuca

    I like the teacher
    Which teacher?
</pre>

    <p>Here, the second speaker does not understand the referent of
    the sumti ``le ctuca'', and so echoes back the sumti with the
    confusion marker.</p>

    <p>The metalinguistic negation cmavo ``na'i'' and its opposite
    ``jo'a'' are explained in full in <a href="chapter15.html">Chapter
    15</a>. In general, ``na'i'' indicates that there is something
    wrong with a piece of discourse: either an error, or a false
    underlying assumption, or something else of the sort. The
    discourse is invalid or inappropriate due to the marked word or
    construct.</p>

    <p>Similarly, ``jo'a'' marks something which looks wrong but is
    in fact correct. These two cmavo constitute a scale, but are
    kept apart for two reasons: ``na'inai'' means the same as
    ``jo'a'', but would be too confusing as an affirmation;
    ``jo'anai'' means the same as ``na'i'', but is too long to
    serve as a convenient metalinguistic negator.</p>

    <p>The next two cmavo are used to assist in quoting texts
    written or spoken by others. It is often the case that we wish
    to quote only part of a text, or to supply additional material
    either by way of commentary or to make a fragmentary text
    grammatical. The cmavo ``li'o'' serves the former function. It
    indicates that words were omitted from the quotation. What
    remains of the quotation must be grammatical, however, as
    ``li'o'' does not serve any grammatical function. It cannot,
    for example, take the place of a missing selbri in a bridi, or
    supply the missing tail of a description sumti: ``le li'o'' in
    isolation is not grammatical.</p>

    <p>The cmavo ``sa'a'' indicates in a quotation that the marked
    word or construct was not actually expressed, but is inserted
    for editorial, narrative, or grammatical purposes. Strictly,
    even a ``li'o'' should appear in the form ``li'osa'a'', since
    the ``li'o'' was not part of the original quotation. In
    practice, this and other forms which are already associated
    with metalinguistic expressions, such as ``sei'' (of selma'o
    SEI) or ``to'i'' (of selma'o TO) need not be marked except
    where confusion might result.</p>

    <p>In the rare case that the quoted material already contains
    one or more instances of ``sa'a'', they can be changed to
    ``sa'asa'a''.</p>

    <p>The cmavo ``xu'' marks truth questions, which are discussed
    in detail in <a href="chapter15.html">Chapter 15</a>. In general,
    ``xu'' may be translated ``Is it true that ... ?'' and
    questions whether the attached bridi is true. When ``xu'' is
    attached to a specific word or construct, it directs the focus
    of the question to that word or construct.</p>

    <p>Lojban question words, unlike those of English, frequently
    do not stand at the beginning of the question. Placing the
    cmavo ``pau'' at the beginning of a bridi helps the listener
    realize that the bridi is a question, like the symbol at the
    beginning of written Spanish questions that looks like an
    upside-down question mark. The listener is then warned to watch
    for the actual question word.</p>

    <p>Although ``pau'' is grammatical in any location (like all
    indicators), it is not really useful except at or near the
    beginning of a bridi. Its scalar opposite, ``paunai'', signals
    that a bridi is not really a question despite its form. This is
    what we call in English a rhetorical question: an example
    appears in the English text near the beginning of <a
    href="#s11">Section 11</a>.</p>

    <p>The cmavo ``pe'a'' is the indicator of figurative speech,
    indicating that the previous word should be taken figuratively
    rather than literally:</p>
<pre>
<a id="e13d2"
name="e13d2">13.2)</a>    mi viska le blanu pe'a zdani
    I see the blue [figurative] house.
    I see the ``blue'' house.
</pre>

    <p>Here the house is not blue in the sense of color, but in
    some other sense, whose meaning is entirely culturally
    dependent. The use of ``pe'a'' unambiguously marks a cultural
    reference: ``blanu'' in <a href="#e13d2">Example 13.2</a> could
    mean ``sad'' (as in English) or something completely
    different.</p>

    <p>The negated form, ``pe'anai'', indicates that what has been
    said is to be interpreted literally, in the usual way for
    Lojban; natural-language intuition is to be ignored.</p>

    <p>Alone among the cmavo of selma'o UI, ``pe'a'' has a rafsi,
    namely ``pev''. This rafsi is used in forming figurative
    (culturally dependent) lujvo, whose place structure need have
    nothing to do with the place structure of the components. Thus
    ``risnyjelca'' (heart burn) might have a place structure
    like:</p>

    <dl>
      <dt></dt>

      <dd>x1 is the heart of x2, burning in atmosphere x3 at
      temperature x4</dd>
    </dl>
    whereas ``pevrisnyjelca'', explicitly marked as figurative,
    might have the place structure: 

    <dl>
      <dt></dt>

      <dd>x1 is indigestion/heartburn suffered by x2</dd>
    </dl>
    which obviously has nothing to do with the places of either
    ``risna'' or ``jelca''. 

    <p>The uses of ``bi'u'' and ``bi'unai'' correspond to one of
    the uses of the English articles ``the'' and ``a/an''. An
    English-speaker telling a story may begin with ``I saw a man
    who ...''. Later in the story, the same man will be referred to
    with the phrase ``the man''. Lojban does not use its articles
    in the same way: both ``a man'' and ``the man'' would be
    translated ``le nanmu'', since the speaker has in mind a
    specific man. However, the first use might be marked ``le bi'u
    nanmu'', to indicate that this is a new man, not mentioned
    before. Later uses could correspondingly be tagged ``le bi'unai
    nanmu''.</p>

    <p>Most of the time, the distinction between ``bi'u'' and
    ``bi'unai'' need not be made, as the listener can infer the
    right referent. However, if a different man were referred to
    still later in the story, ``le bi'u nanmu'' would clearly show
    that this man was different from the previous one.</p>

    <p>Finally, the indicator ``ge'e'' has been discussed in <a
    href="#s8">Sections 8</a> and <a href="#s10">10</a>. It is used
    to express an attitude which is not covered by the existing
    set, or to avoid expressing any attitude.</p>

    <p>Another use for ``ge'e'' is to explicitly avoid expressing
    one's feeling on a given scale; in this use, it functions like
    a member of selma'o CAI: ``.iige'e'' means roughly ``I'm not
    telling whether I'm afraid or not.''</p>

    <p></p>
<pre>
   kau indirect question
</pre>

    <p>This cmavo is explained in detail in <a
    href="chapter11.html">Chapter 11</a>. It marks the word it is
    attached to as the focus of an indirect question:</p>
<pre>
<a id="e13d3" name="e13d3">13.3)</a>    mi djuno le du'u
        dakau klama le zarci
    I know the statement-that
        somebody [ind. ?] goes to-the store.
    I know who goes to the store.
</pre>

    <h3><a id="s14" name="s14">14. Vocative scales</h3>

    <p>``Vocatives'' are words used to address someone directly;
    they precede and mark a name used in direct address, just as
    ``la'' (and the other members of selma'o LA) mark a name used
    to refer to someone. The vocatives actually are indicators ---
    in fact, discursives --- but the need to tie them to names and
    other descriptions of listeners requires them to be separated
    from selma'o UI. But like the cmavo of UI, the members of
    selma'o COI can be ``negated'' with ``nai'' to get the opposite
    part of the scale.</p>

    <p>Because of the need for redundancy in noisy environments,
    the Lojban design does not compress the vocatives into a
    minimum number of scales. Doing so would make a non-redundant
    ``nai'' too often vital to interpretation of a protocol signal,
    as explained later in this section.</p>

    <p>The grammar of vocatives is explained in <a
    href="chapter6.html">Chapter 6</a>; but in brief, a vocative may
    be followed by a name (without ``la''), a description (without
    ``le'' or its relatives), a complete sumti, or nothing at all
    (if the addressee is obvious from the context). There is an
    elidable terminator, ``do'u'' (of selma'o DOhU) which is almost
    never required unless no name (or other indication of the
    addressee) follows the vocative.</p>

    <p>Using any vocative except ``mi'e'' (explained below)
    implicitly defines the meaning of the pro-sumti ``do'', as the
    whole point of vocatives is to specify the listener, or at any
    rate the desired listener --- even if the desired listener
    isn't listening! We will use the terms ``speaker'' and
    ``listener'' for clarity, although in written Lojban the
    appropriate terms would be ``writer'' and ``reader''.</p>

    <p>In the following list of vocatives, the translations include
    the symbol X. This represents the name (or identifying
    description, or whatever) of the listener.</p>

    <p>The cmavo ``doi'' is the general-purpose vocative. Unlike
    the cmavo of selma'o COI, explained below, ``doi'' can precede
    a name directly without an intervening pause. It is not
    considered a scale, and ``doinai'' is not grammatical. In
    general, ``doi'' needs no translation in English (we just use
    names by themselves without any preceding word, although in
    poetic styles we sometimes say ``Oh X'', which is equivalent to
    ``doi''). One may attach an attitudinal to ``doi'' to express
    various English vocatives. For example, ``doi .io'' means
    ``Sir/Madam!'', whereas ``doi .ionai'' means ``You
    there!''.</p>

    <p>All members of selma'o COI require a pause when used
    immediately before a name, in order to prevent the name from
    absorbing the COI word. This is unlike selma'o DOI and LA,
    which do not require pauses because the syllables of these
    cmavo are not permitted to be embedded in a Lojban name. When
    calling out to someone, this is fairly natural, anyway. ``Hey!
    John!'' is thus a better translation of ``ju'i .djan.'' than
    ``Hey John!''. No pause is needed if the vocative reference is
    something other than a name, as in the title of the Lojban
    journal, ``ju'i lobypli''.</p>

    <p>(Alternatively, ``doi'' can be inserted between the COI
    cmavo and the name, making a pause unnecessary: ``coi doi
    djan.'')</p>

    <p></p>
<pre>
   coi greetings
</pre>
    ``Hello, X''; ``Greetings, X''; indicates a greeting to the
    listener. 

    <p></p>
<pre>
   co'o    partings
</pre>
    ``Good-bye, X''; indicates parting from immediate company by
    either the speaker or the listener. ``coico'o'' means
    ``greeting in passing''. 

    <p></p>
<pre>
   ju'i    attention   at ease     ignore me/us
            [jundi]
</pre>
    ``Attention/Lo/Hark/Behold/Hey!/Listen, X''; indicates an
    important communication that the listener should listen to. 

    <p></p>
<pre>
   nu'e    promise     release promise non-promise
            [nupre]
</pre>
    ``I promise, X''; indicates a promise to the listener. In some
    contexts, ``nu'e'' may be prefixed to an oath or other formal
    declaration. 

    <p></p>
<pre>
   ta'a    interruption
            [tavla]
</pre>
    ``I interrupt, X'', ``I desire the floor, X''; a vocative
    expression to (possibly) interrupt and claim the floor to make
    a statement or expression. This can be used for both rude and
    polite interruptions, although rude interruptions will probably
    tend not to use a vocative at all. An appropriate response to
    an interruption might be ``re'i'' (or ``re'inai'' to ignore the
    interruption). 

    <p></p>
<pre>
   pe'u    request
            [cpedu]
</pre>
    ``Please, X''; indicates a request to the listener. It is a
    formal, non-attitudinal, equivalent of ``.e'o'' with a specific
    recipient being addressed. On the other hand, ``.e'o'' may be
    used when there is no specific listener, but merely a ``sense
    of petition floating in the air'', as it were. 

    <p></p>
<pre>
   ki'e    appreciation                disappreciation
            [ckire]
        gratitude           ingratitude
</pre>
    ``Thank you, X''; indicates appreciation or gratitude toward
    the listener. The usual response is ``je'e'', but ``fi'i'' is
    appropriate on rare occasions: see the explanation of ``fi'i''.
    
<pre>
   fi'i    welcome,        unwelcome,
        offering        inhospitality
            [friti]
</pre>
    ``At your service, X''; ``Make yourself at home, X''; offers
    hospitality (possibly in response to thanks, but not
    necessarily) to the listener. Note that ``fi'i'' is NOT the
    equivalent of American English ``You're welcome'' as a
    mechanical response to ``Thank you''; that is ``je'e'', as
    noted below. 
<pre>
   be'e    request to send
            [benji]
</pre>
    ``Request to send to X''; indicates that the speaker wishes to
    express something, and wishes to ensure that the listener is
    listening. In a telephone conversation, can be used to request
    the desired conversant(s). A more colloquial equivalent is
    ``Hello? Can I speak to X?''. 
<pre>
   re'i    ready to receive        not ready
            [bredi]
</pre>
    ``Ready to receive, X''; indicates that the speaker is
    attentive and awaiting communication from the listener. It can
    be used instead of ``mi'e'' to respond when called to the
    telephone. The negative form can be used to prevent the
    listener from continuing to talk when the speaker is unable to
    pay attention: it can be translated ``Hold on!'' or ``Just a
    minute''. 
<pre>
   mu'o    completion of utterance     more to follow
            [mulno]
</pre>
    ``Over, X''; indicates that the speaker has completed the
    current utterance and is ready to hear a response from the
    listener. The negative form signals that the pause or
    non-linguistic sound which follows does not represent the end
    of the current utterance: more colloquially, ``I'm not done
    talking!'' 
<pre>
   je'e    successful          unsuccessful
         receipt            receipt
            [jimpe]
</pre>
    ``Roger, X!'', ``I understand''; acknowledges the successful
    receipt of a communication from the listener. The negative form
    indicates failure to receive correctly, and is usually followed
    by ``ke'o''. The colloquial English equivalents of ``je'e'' and
    ``je'enai'' are the grunt typically written ``uh-huh'' and
    ``What?/Excuse me?'': ``je'e'' is also used to mean ``You're
    welcome'' when that is a response to ``Thank you''. 
<pre>
   vi'o    will comply         will not comply
</pre>
    ``Wilco, X'', ``I understand and will comply''. Similar to
    ``je'e'' but signals an intention (similar to ``.ai'') to
    comply with the other speaker's request. This cmavo is the main
    way of saying ``OK'' in Lojban, in the usual sense of
    ``Agreed!'', although ``.ie'' carries some of the same meaning.
    The negative form indicates that the message was received but
    that you will not comply: a very colloquial version is ``No
    way!''. 
<pre>
   ke'o    please repeat           no repeat needed
            [krefu]
</pre>
    ``What did you say, X?''; a request for repetition or
    clarification due to unsuccessful receipt or understanding.
    This is the vocative equivalent of ``ki'a'', and is related to
    ``je'enai''. The negative form may be rendered ``Okay, already;
    I get the point!'' 
<pre>
   fe'o    end of communication        not done
            [fanmo]
</pre>
    ``Over and out, X''; indicates completion of statement(s) and
    communication directed at the identified person(s). Used to
    terminate a letter if a signature is not required because the
    sender has already been identified (as in memos). The negative
    form means ``Wait, hold it, we're not done!'' and differs from
    ``mu'onai'' in that it means more exchanges are to follow,
    rather than that the current exchange is incomplete. 

    <p>Do not confuse ``fe'o'' with ``fa'o'' (selma'o FAhO) which
    is a mechanical, extra-grammatical signal that a text is
    complete. One may say ``fe'o'' to one participant of a
    multi-way conversation and then go on speaking to the
    others.</p>

    <p></p>
<pre>
   mi'e    self-identification     non-identification
        [cmavo: mi]
</pre>
    ``And I am X''; a generalized self-vocative. Although
    grammatically just like the other members of selma'o COI,
    ``mi'e'' is quite different semantically. In particular, rather
    than specifying the listener, the person whose name (or
    description) follows ``mi'e'' is taken to be the speaker.
    Therefore, using ``mi'e'' specifies the meaning of the
    pro-sumti ``mi''. It can be used to introduce oneself, to close
    letters, or to identify oneself on the telephone. 

    <p>This cmavo is often combined with other members of COI:
    ``fe'omi'e'' would be an appropriate closing at the end of a
    letter; ``re'imi'e'' would be a self-vocative used in delayed
    responses, as when called to the phone, or possibly in a
    roll-call. As long as the ``mi'e'' comes last, the following
    name is that of the speaker; if another COI cmavo is last, the
    following name is that of the listener. It is not possible to
    name both speaker and listener in a single vocative expression,
    but this fact is of no importance, because wherever one
    vocative expression is grammatical, any number of consecutive
    ones may appear.</p>

    <p>The negative form denies an identity which someone else has
    attributed to you; ``mi'enai .djan.'' means that you are saying
    you are not John.</p>

    <p>Many of the vocatives been listed with translations which
    are drawn from radio use: ``roger'', ``wilco'', ``over and
    out''. This form of translation does not mean that Lojban is a
    language of CB enthusiasts, but rather that in most natural
    languages these forms are so well handled by the context that
    only in specific domains (like speaking on the radio) do they
    need special words. In Lojban, dependence on the context can be
    dangerous, as speaker and listener may not share the right
    context, and so the vocatives provide a formal protocol for use
    when it is appropriate. Other appropriate contexts include
    computer communications and parliamentary procedure: in the
    latter context, the protocol question ``ta'apei'' would mean
    ``Will the speaker yield?''</p>

    <h3><a id="s15" name="s15">15. A sample dialogue</h3>

    <p>The following dialogue in Lojban illustrates the uses of
    attitudinals and protocol vocatives in conversation. The
    phrases enclosed in ``sei ... se'u'' indicate the speaker of
    each sentence.</p>
<pre>
<a id="e15d1"
name="e15d1">15.1)</a>    la rik. .e la .alis. nerkla le kafybarja
    Rick and Alice in-go to-the coffee-bar.
    Rick and Alice go into the coffee bar.

<a id="e15d2" name="e15d2">15.2)</a> .i sei la rik. cusku se'u
        ta'a ro zvati be ti
        mi baza speni ti .iu
    [Comment] Rick says, [end-comment]
        [Interrupt] all at this-place,
        I [future] [medium] am-spouse-to this-one [love].
    Rick said, ``Sorry to break in, everybody.
        Pretty soon I'm getting married
        to my love here.''

<a id="e15d3" name="e15d3">15.3)</a> .i sei la djordj. cusku se'u
        a'o ko gleki doi ma
    [Comment] George says, [end-comment]
        [Hope] [You-imperative] are-happy, O [who?].
    George said, ``I hope you'll be happy, um, ...?''

<a id="e15d4" name="e15d4">15.4)</a> .i sei la pam. cusku se'u
        pe'u .alis.
        xu mi ba terfriti
            le nunspenybi'o
    [Comment] Pam says,
        [Please] Alice, [end-comment]
        [Is it true?] I [future] receive-offer-of
            the event-of-spouse-becoming?
    Pam said, ``Please, Alice, am I going to be
        invited to the wedding?''

<a id="e15d5" name="e15d5">15.5)</a> .i sei la mark. cusku se'u
        coi baza speni
        a'o le re do lifri
            le ka xamgu
    [Comment] Mark says, [end-comment]
        [Greetings] [future] [medium] spouse(s),
        [Hope] the two of-you experience
            the-property-of being-happy
    Mark said, ``Hello, spouses-to-be.  I hope both of
        you will be very happy.''

<a id="e15d6" name="e15d6">15.6)</a> .i sei la rik. cusku se'u
        mi'e .rik. doi terpreti
    [Comment] Rick says, [end-comment]
        [I am] Rick, O questioners.
    Rick said, ``My name is Rick, for those of you who
        want to know.''

<a id="e15d7" name="e15d7">15.7)</a> .i sei la .alis. cusku se'u
        nu'e .pam. .o'ero'i
        do ba zvati
    [Comment] Alice says, [end-comment]
        [Promise-to] Pam, [closeness] [emotional]
        you [future] are-at.
    Alice said, ``I promise you'll be there, Pam honey.''

<a id="e15d8" name="e15d8">15.8)</a> .i sei la fred. cusku se'u
        .uinaicairo'i
        mi ji'a prami la .alis.
        fe'o .rik.
    [Comment] Fred says, [end-comment]
        [Happy] [not] [emphatic] [emotional]
        I [additionally] love Alice.
        [Over and out to] Rick.
    ``I love Alice too,'' said Fred miserably.  ``Have a
        nice life, Rick.''

<a id="e15d9" name="e15d9">15.9)</a> .i la fred. cliva
    Fred leaves.
    And he left.

<a id="e15d10" name="e15d10">15.10)</a>   .i sei la rik. cusku se'u
        fi'i ro zvati
        ko pinxe pa ckafi
            fi'o pleji mi
    [Comment] Rick says, [end-comment]
        [Welcome-to] all at-place,
        [You-imperative] drink one coffee
            with-payer me.
    Rick said, raising his voice, ``A cup of coffee
        for the house, on me.''

<a id="e15d11" name="e15d11">15.11)</a>   .i sei la pam. cusku se'u
        be'e selfu
    [Comment] Pam says, [end-comment]
        [Request to speak to] server.
    Pam said, ``Waiter!''

<a id="e15d12"
name="e15d12">15.12)</a>   .i sei le selfu cu cusku se'u
        re'i [end-comment]
    [Comment] The server says,
        [Ready to receive].
    The waiter replied, ``May I help you?''

<a id="e15d13" name="e15d13">15.13)</a>   .i sei la pam. cusku se'u
        e'o ko selfu
        le traji xamgu ckafi
        le baza speni
        fi'o selpleji mi
    [Comment] Pam says, [end-comment]
        [Petition] [You-imperative] serve
        the (superlatively good) coffee
        to-the [future] [medium] spouse
        with-payment me.
    Pam said, ``One Jamaica Blue for the lovebirds here,
        on my tab.''

<a id="e15d14"
name="e15d14">15.14)</a>   .i sei le selfu cucusku se'u
        vi'o
    [Comment] The server says, [end-comment]
        [Will comply].
    ``Gotcha'', said the waiter.

<a id="e15d15" name="e15d15">15.15)</a>   .i sei la rik. cusku se'u
        ki'e .pam.
    [Comment] Rick says, [end-comment]
        [Thanks O] Pam.
    ``Thanks, Pam'', said Rick.

<a id="e15d16" name="e15d16">15.16)</a>   .i sei la pam. cusku se'u
        je'e
    [Comment] Pam says, [end-comment]
        [Acknowledge].
    ``Sure'', said Pam.

<a id="e15d17"
name="e15d17">15.17)</a>   .i sei la djan. cusku se'u
        .y. mi .y. mutce spopa .y.
        le nu le speni si .y.
        ba speni .y. .y.
        su .yyyyyy. mu'o
    [Comment] John says, [end-comment]
        [Uh] I [uh] very [nonexistent gismu] [uh]
        the event-of the spouse [erase] [uh]
        [future] spouse [uh] [uh]
        [erase all] [uh] [over]
    John said, ``I, er, a lotta, uh, marriage,
        upcoming marriage, ....  Oh, forget it.
        Er, later.''

<a id="e15d18"
name="e15d18">15.18)</a>   .i sei la djordj. cusku se'u
        ke'o .djan. zo'o
    [Comment] George says, [end-comment]
        [Repeat O] John [humor].
    ``How's that again, John?'' said George.

<a id="e15d19" name="e15d19">15.19)</a>   .i sei la pam. cusku se'u
        ju'i .djordj.
        .e'unai le kabri bazi farlu
    [Comment] Pam says, [end-comment]
        [Attention] George,
        [Warning] the cup [future] [short] falls
    ``George, watch out!'' said Pam.  ``The cup's falling!''

<a id="e15d20" name="e15d20">15.20)</a>   .i le kabri cu je'a farlu
    The cup indeed falls.
    The cup fell.

<a id="e15d21"
name="e15d21">15.21)</a>   .i sei la djan. cusku se'u
        e'o doi djordj. zo'o rapygau
    [Comment] John says, [end-comment]
        [Petition] O George [humor] repeat-cause.
    John said, ``Try that again, George!''

<a id="e15d22"
name="e15d22">15.22)</a>   .i sei la djordj. cusku se'u
        co'o ro zvati pe secau la djan. ga'i
    [Comment] George says, [end-comment]
        [Partings] all at-place without John [superiority]
    ``Goodbye to all of you,'' said George sneeringly,
        ``except John.''

<a id="e15d23" name="e15d23">15.23)</a>   .i la djordj. cliva
    George leaves.
    George left.
</pre>

    <h3><a id="s16" name="s16">16. Tentative conclusion</h3>

    <p>The exact ramifications of the indicator system in actual
    usage are unknown. There has never been anything like it in
    natural language before. The system provides great potential
    for emotional expression and transcription, from which
    significant Sapir-Whorf effects can be anticipated. When
    communicating across cultural boundaries, where different
    indicators are often used for the same emotion, accidental
    offense can be avoided. If we ever ran into an alien race, a
    culturally neutral language of emotion could be vital. (A
    classic example, taken from the science fiction of Larry Niven,
    is to imagine speaking Lojban to the carnivorous warriors
    called Kzinti, noting that a human smile bares the teeth, and
    could be seen as an intent to attack.) And for communicating
    emotions to computers, when we cannot identify all of the
    signals involved in subliminal human communication (things like
    body language are also cultural), a system like this is
    needed.</p>

    <p>We have tried to err on the side of overkill. There are
    distinctions possible in this system that no one may care to
    make in any culture. But it was deemed more neutral to
    overspecify and let usage decide, than to choose a limited set
    and constrain emotional expression. For circumstances in which
    even the current indicator set is not enough, it is possible
    using the cmavo ``sei'', explained in <a
    href="chapter19.html">Chapter 19</a>, to create metalinguistic
    comments that act like indicators.</p>

    <p>We envision an evolutionary development. At this point, the
    system is little more than a mental toy. Many of you who read
    this will try playing around with various combinations of
    indicators, trying to figure out what emotions they express and
    when the expressions might be useful. You may even find an
    expression for which there currently is no good English word
    and start using it. Why not, if it helps you express your
    feelings?</p>

    <p>There will be a couple dozen of these used pretty much
    universally -- mostly just simple attitudinals with, at most,
    intensity markers. These are the ones that will quickly be
    expressed at the subconscious level. But every Lojbanist who
    plays with the list will bring in a couple of new words. Poets
    will paint emotional pictures, and people who identify with
    those pictures will use the words so created for their own
    experiences.</p>

    <p>Just as a library of tanru is built up, so will a library of
    attitudes be built. Unlike the tanru, though, the emotional
    expressions are built on some fairly nebulous root emotions ---
    words that cannot be defined with the precision of the gismu.
    The emotion words of Lojban will very quickly take on a life of
    their own, and the outline given here will evolve into a true
    system of emotions.</p>

    <p>There are several theories as to the nature of emotion, and
    they change from year to year as we learn more about ourselves.
    Whether or not Lojban's additive/scalar emotional model is an
    accurate model for human emotions, it does support the
    linguistic needs for expressing those emotions. Researchers may
    learn more about the nature of human emotions by exploring the
    use of the system by Lojban speakers. They also may be able to
    use the Lojban system as a means for more clearly recording
    emotions.</p>

    <p>The full list of scales and attitudes will probably not be
    used until someone speaks the language from birth. Until then,
    people will use the attitudes that are important to them. In
    this way, we counter cultural bias --- if a culture is prone to
    recognizing and/or expressing certain emotions more than
    others, its members will use only those out of the enormous set
    available. If a culture hides certain emotions, its members
    simply won't express them.</p>

    <p>Perhaps native Lojban speakers will be more expressively
    clear about their emotions than others. Perhaps they will feel
    some emotions more strongly than others in ways that can be
    correlated with the word choices; any difference from the norms
    of other cultures could be significant. Psychologists have
    devised elaborate tests for measuring attitudes and
    personality; this may be the easiest area in which to detect
    any systematic cultural effect of the type sought to confirm
    Sapir-Whorf, simply because we already have tools in existence
    to test it. Because Lojban is unique among languages in having
    such extensive and expressive indicators, it is likely that a
    Sapir-Whorf effect will occur and will be recognized.</p>

    <p>It is unlikely that we will know the true potential of a
    system like this one until and unless we have children raised
    entirely in a multi-cultural Lojban-speaking environment. We
    learn too many cultural habits in the realm of emotional
    communication ``at our mother's knee''. Such children will have
    a Lojban system that has stronger reinforcement than any
    typical culture system. The second generation of such children,
    then, could be said to be the start of a true Lojbanic
    culture.</p>

    <p>We shouldn't need to wait that long to detect significant
    effects. Emotion is so basic to our lives that even a small
    change or improvement in emotional communication would have
    immediately noticeable effects. Perhaps it will be the case
    that the most important contribution of our ``logical
    language'' will be in the non-logical realm of emotion!</p>

    <hr />
    
    <p>Última modificación: Mon Jun 27 23:13:41 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
