
<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//ES" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="es" lang="es">

<head>
    <title>Lojban Reference Grammar: Chapter 1</title>

    <meta name="keywords" content="lojban lojban.org www.lojban.org constructed language linguistics reference grammar" />

    <!-- <body background="lalojbana2.jpg"> -->

    <style type="text/css">
    <!--
	body
	{
	    background-color: #ffffff; color: #000000;
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1. h2, h3, h4, h5, h6
	{
	    font-family: verdana,arial,helvetica,sans-serif;
	}

	h1
	{
	    font-size: x-large;
	}

	h2
	{
	    font-size: large;
	}

	h3
	{
	    font-size: medium;
	}

	h4
	{
	    font-size: medium;
	}

	h5
	{
	    font-size: small;
	}

	h6
	{
	    font-size: x-small;
	}

	div.leftbar
	{
	    float: left;
	    width: 219px;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    margin-right: 2%;
	    font-size: small;
	}

	div.rightbar
	{
	    float: right;
	    min-width: 90px;
	    width: 15%;
	    height: auto;
	    background: #c0c0c0;
	    color: black;
	    border-style: outset;
	    font-size: small;
	    top: 1%;
	    padding: 1%;
	}

	div.centered
	{
	    text-align: center;
	}

        div.main
        {
            padding-right: 1%;
	    padding-left: 2%;
        }

	li
	{
	    padding-right: 1%;
	    padding-left: 1%;
	    margin-left: 1%;
	}

	img.noborder
	{
	    text-align: center;
	    border-style: none;
	    border: 0;
	}

	hr
	{
	    width: 60%;
	}
    -->
    </style>

</head>

<body>

    <div class="leftbar">
	<h4>Reference Grammar Chapters</h4>

	<ol>
	    <li>
		<a
		href="chapter1.html">
		Lojban As We Mangle It In Lojbanistan: About This Book</a>
	    </li>
	
	    <li>
		<a
		href="chapter2.html">
		A Quick Tour of Lojban Grammar, With Diagrams</a>
	    </li>
	
	    <li>
		<a
		href="chapter3.html">
		The Hills Are Alive With The Sounds Of Lojban</a>
	    </li>
	
	    <li>
		<a
		href="chapter4.html">
		The Shape Of Words To Come: Lojban Morphology</a>
	    </li>
	
	    <li>
		<a
		href="chapter5.html">
		"Pretty Little Girls' School": The Structure Of Lojban
		selbri</a>
	    </li>
	
	    <li>
		<a
		href="chapter6.html">
		To Speak Of Many Things: The Lojban sumti</a>
	    </li>
	
	    <li>
		<a
		href="chapter7.html">
		Brevity Is The Soul Of Language: Pro-sumti And Pro-bridi</a>
	    </li>
	
	    <li>
		<a
		href="chapter8.html">
		Relative Clauses, Which Make sumti Even More Complicated</a>
	    </li>
	
	    <li>
		<a href="chapter9.html"> To Boston Via The Road
		Go I, With An Excursion Into The Land Of Modals</a>
	    </li>
	
	    <li>
		<a href="chapter10.html"> Imaginary Journeys: The
		Lojban Space/Time Tense System</a>
	    </li>
	
	    <li>
		<a href="chapter11.html"> Events, Qualities,
		Quantities, And Other Vague Words: On Lojban Abstraction</a>
	    </li>
	
	    <li>
		<a href="chapter12.html"> Dog House And White
		House: Determining lujvo Place Structures</a>
	    </li>
	
	    <li>
		<a href="chapter13.html"> Oooh! Arrgh! Ugh!
		Yecch! Attitudinal and Emotional Indicators</a>
	    </li>
	
	    <li>
		<a href="chapter14.html"> If Wishes Were Horses:
		The Lojban Connective System</a>
	    </li>
	
	    <li>
		<a href="chapter15.html"> "No" Problems: On
		Lojban Negation</a>
	    </li>
	
	    <li>
		<a href="chapter16.html"> "Who Did You Pass On
		The Road? Nobody": Lojban And Logic</a>
	    </li>
	
	    <li>
		<a href="chapter17.html"> As Easy As A-B-C? The
		Lojban Letteral System And Its Uses</a>
	    </li>
	
	    <li>
		<a href="chapter18.html"> lojbau mekso:
		Mathematical Expressions in Lojban</a>
	    </li>
	
	    <li>
		<a href="chapter19.html"> Putting It All
		Together: Notes on the Structure of Lojban Texts</a>
	    </li>
	
	    <li>
		<a href="chapter20.html"> A Catalogue of
		selma'o</a>
	    </li>
	
	    <li>
		<a href="chapter21.html">Formal Grammars</a>
	    </li>
	</ol>

    </div>

    <div class="main" >
 

<div class="centered">
<img src="chapter1.gif" alt="[Cartoon]" class="noborder"
width="405" height="405" />

<h2>Chapter 1<br />
Lojban As We Mangle It In Lojbanistan: About This Book</h2>

<!--
<h6>$Revision: 4.4 $<br />
mkhtml: 1.1</h6>
-->

</div>

<div class="main">

<h3>1. What is Lojban?</h3>

<p>Lojban (pronounced ``LOZH-bahn'') is a constructed language.
Previous versions of the language were called ``Loglan'' by Dr.
James Cooke Brown, who founded the Loglan Project and started the
development of the language in 1955. The goals for the language
were first described in the open literature in the article
``Loglan'', published in <cite>Scientific American</cite>, June,
1960. Made well-known by that article and by occasional references
in science fiction (most notably in Robert Heinlein's novel
<cite>The Moon Is A Harsh Mistress</cite> and computer
publications, Loglan and Lojban have been built over four decades
by dozens of workers and hundreds of supporters, led since 1987 by
The Logical Language Group (who are the publishers of this
book).</p>

<p>There are thousands of artificial languages (of which Esperanto
is the best-known), but Loglan/Lojban has been engineered to make
it unique in several ways. The following are the main features of
Lojban:</p>

<ul>
<li>Lojban is designed to be used by people in communication with
each other, and possibly in the future with computers.</li>

<li>Lojban is designed to be neutral between cultures.</li>

<li>Lojban grammar is based on the principles of predicate
logic.</li>

<li>Lojban has an unambiguous yet flexible grammar.</li>

<li>Lojban has phonetic spelling, and unambiguously resolves its
sounds into words.</li>

<li>Lojban is simple compared to natural languages; it is easy to
learn.</li>

<li>Lojban's 1300 root words can be easily combined to form a
vocabulary of millions of words.</li>

<li>Lojban is regular; the rules of the language are without
exceptions.</li>

<li>Lojban attempts to remove restrictions on creative and clear
thought and communication.</li>

<li>Lojban has a variety of uses, ranging from the creative to the
scientific, from the theoretical to the practical.</li>

<li>Lojban has been demonstrated in translation and in original
works of prose and poetry.</li>
</ul>

<h3>2. What is this book?</h3>

<p>This book is what is called a ``reference grammar''. It attempts
to expound the whole Lojban language, or at least as much of it as
is understood at present. Lojban is a rich language with many
features, and an attempt has been made to discover the functions of
those features. The word ``discover'' is used advisedly; Lojban was
not ``invented'' by any one person or committee. Often, grammatical
features were introduced into the language long before their usage
was fully understood. Sometimes they were introduced for one
reason, only to prove more useful for other reasons not recognized
at the time.</p>

<p>By intention, this book is complete in description but not in
explanation. For every rule in the formal Lojban grammar (given in
<a href="chapter21.html">Chapter 21</a>), there is a bit of
explanation and an example somewhere in the book, and often a great
deal more than a bit. In essence, <a href="chapter2.html">Chapter
2</a> gives a brief overview of the language, <a
href="chapter21.html">Chapter 21</a> gives the formal structure of the
language, and the chapters in between put semantic bones on that
formal flesh. I hope that eventually more grammatical material
founded on (or even correcting) the explanations in this book will
become available.</p>

<p>Nevertheless, the publication of this book is, in one sense, the
completion of a long period of language evolution. With the
exception of a possible revision of the language that will not even
be considered until five years from publication date, and any
revisions of this book needed to correct outright errors, the
language described in this book will not be changing by deliberate
act of its creators any more. Instead, language change will take
place in the form of new vocabulary --- Lojban does not yet have
nearly the vocabulary it needs to be a fully usable language of the
modern world, as <a href="chapter12.html">Chapter 12</a> explains ---
and through the irregular natural processes of drift and (who
knows?) native-speaker evolution. (Teach your children Lojban!) You
can learn the language described here with assurance that (unlike
previous versions of Lojban and Loglan, as well as most other
artificial languages) it will not be subject to further fiddling by
language-meisters.</p>

<p>It is probably worth mentioning that this book was written
somewhat piecemeal. Each chapter began life as an explication of a
specific Lojban topic; only later did these begin to clump together
into a larger structure of words and ideas. Therefore, there are
perhaps not as many cross-references as there should be. However, I
have attempted to make the index as comprehensive as possible.</p>

<p>Each chapter has a descriptive title, often involving some play
on words; this is an attempt to make the chapters more memorable.
The title of <a href="chapter1.html">Chapter 1</a> (which you are now
reading), for example, is an allusion to the book <cite>English As
We Speak It In Ireland</cite>, by P. W. Joyce, which is sort of
informal reference work about Hiberno-English. ``Lojbanistan'' is
both an imaginary country where Lojban is the native language, and
a term for the actual community of Lojban-speakers, scattered over
the world. Why ``mangle''? As yet, nobody in the real Lojbanistan
speaks the language at all well, by the standards of the imaginary
Lojbanistan; that is one of the circumstances this book is meant to
help remedy.</p>

<h3>3. What are the typographical conventions of this book?</h3>

<p>Each chapter is broken into numbered sections; each section
contains a mixture of expository text, numbered examples, and
possibly tables.</p>

<p>The reader will notice a certain similarity in the examples used
throughout the book. One chapter after another rings the changes on
the self-same sentences:</p>

<pre>
<a id="e1d1" name="e1d1">1.1)  mi klama le zarci
    I go-to that-which-I-describe-as-a store.
    I go to the store.
</a>
</pre>

<p>
will become wearisomely familiar before <a
href="chapter21.html">Chapter 21</a> is reached. This method is
deliberate; I have tried to use simple and (eventually) familiar
examples wherever possible, to avoid obscuring new grammatical
points with new vocabulary. Of course, this is not the method of a
textbook, but this book is not a textbook (although people have
learned Lojban from it and its predecessors). Rather, it is
intended both for self-learning (of course, at present would-be
Lojban teachers must be self-learners) and to serve as a reference
in the usual sense, for looking up obscure points about the
language. 
</p>

<p>It is useful to talk further about <a href="#e1d1">Example
1.1</a> for what it illustrates about examples in this book.
Examples usually occupy three lines. The first of these is in
Lojban, the second in a word-by-word literal translation of the
Lojban into English, and the third in colloquial English. The
second and third lines are sometimes called the ``literal
translation'' and the ``colloquial translation'' respectively.
Sometimes, when clarity is not sacrificed thereby, one or both are
omitted. If there is more than one Lojban sentence, it generally
means that they have the same meaning.</p>

<p>Words are sometimes surrounded by square brackets. In Lojban
texts, these enclose optional grammatical particles that may (in
the context of the particular example) be either omitted or
included. In literal translations, they enclose words that are used
as conventional translations of specific Lojban words, but don't
have exactly the meanings or uses that the English word would
suggest. In <a href="chapter3.html">Chapter 3</a>, square brackets
surround phonetic representations in the International Phonetic
Alphabet.</p>

<p>Many of the tables, especially those placed at the head of
various sections, are in three columns. The first column contains
Lojban words discussed in that section; the second column contains
the grammatical category (represented by an UPPER CASE Lojban word)
to which the word belongs, and the third column contains a brief
English gloss, not necessarily or typically a full explanation.
Other tables are explained in context.</p>

<p>A few Lojban words are used in this book as technical terms. All
of these are explained in <a href="chapter2.html">Chapter 2</a>,
except for a few used only in single chapters, which are explained
in the introductory sections of those chapters.</p>

<h3>4. Disclaimers</h3>

<p>It is necessary to add, alas, that the examples used in this
book do not refer to any existing person, place, or institution,
and that any such resemblance is entirely coincidental and
unintentional, and not intended to give offense.</p>

<p>When definitions and place structures of gismu, and especially
of lujvo, are given in this book, they may differ from those given
in the English-Lojban dictionary (which, as of this writing, is not
yet published). If so, the information given in the dictionary
supersedes whatever is given here.</p>

<h3>5. Acknowledgements and Credits</h3>

<p>Although the bulk of this book was written for the Logical
Language Group (LLG) by John Cowan, who is represented by the
occasional authorial ``I'', certain chapters were first written by
others and then heavily edited by me to fit into this book.</p>

<p>In particular: <a href="chapter2.html">Chapter 2</a> is a fusion of
originally separate documents, one by Athelstan, and one by Nora
Tansky LeChevalier and Bob LeChevalier; <a
href="chapter3.html">Chapters 3</a> and <a href="chapter4.html">4</a>
were originally written by Bob LeChevalier with contributions by
Chuck Barton; <a href="chapter12.html">Chapter 12</a> was originally
written (in much longer form) by Nick Nicholas; the dialogue near
the end of <a href="chapter13.html">Chapter 13</a> was contributed by
Nora Tansky LeChevalier; <a href="chapter15.html">Chapter 15</a> and
parts of <a href="chapter16.html">Chapter 16</a> were originally by
Bob LeChevalier; and the YACC grammar in <a
href="chapter21.html">Chapter 21</a> is the work of several hands, but
is primarily by Bob LeChevalier and Jeff Taylor. The BNF grammar,
which is also in <a href="chapter21.html">Chapter 21</a>, was
originally written by me, then rewritten by Clark Nelson, and
finally touched up by me again.</p>

<p>The research into natural languages from which parts of <a
href="chapter5.html">Chapter 5</a> draw their material was performed
by Ivan Derzhanski. LLG acknowledges his kind permission to use the
fruits of his research.</p>

<p>The pictures in this book were drawn by Nora Tansky LeChevalier,
except for the picture appearing in <a href="chapter4.html">Chapter
4</a>, which is by Sylvia Rutiser.</p>

<p>I would like to thank the following people for their detailed
reviews, suggestions, comments, and early detection of my
embarrassing errors in Lojban, logic, English, and
cross-references: Nick Nicholas, Mark Shoulson, Veijo Vilva, Colin
Fine, And Rosta, Jorge Llambias, Iain Alexander, Paulo S. L. M.
Barreto, Robert J. Chassell, Ivan Derzhanski, Jim Carter, Irene
Gates, Bob LeChevalier, John Parks-Clifford (also known as ``pc''),
and Nora Tansky LeChevalier.</p>

<p>Nick Nicholas (NSN) would like to thank the following
Lojbanists: Mark Shoulson, Veijo Vilva, Colin Fine, And Rosta, and
Iain Alexander for their suggestions and comments; John Cowan, for
his extensive comments, his exemplary trailblazing of Lojban
grammar, and for solving the ``manskapi'' dilemma for NSN; Jorge
Llambias, for his even more extensive comments, and for forcing NSN
to think more than he was inclined to; Bob LeChevalier, for his
skeptical overview of the issue, his encouragement, and for
scouring all Lojban text his computer has been burdened with for
lujvo; Nora Tansky LeChevalier, for writing the program converting
old rafsi text to new rafsi text, and sparing NSN from embarrassing
errors; and Jim Carter, for his dogged persistence in analyzing
lujvo algorithmically, which inspired this research, and for first
identifying the three lujvo classes.</p>

<p>Of course, the entire Loglan Project owes a considerable debt to
James Cooke Brown as the language inventor, and also to several
earlier contributors to the development of the language. Especially
noteworthy are Doug Landauer, Jeff Prothero, Scott Layson, Jeff
Taylor, and Bob McIvor. Final responsibility for the remaining
errors and infelicities is solely mine.</p>

<h3>6. Informal Bibliography</h3>

<p>The founding document for the Loglan Project, of which this book
is one of the products, is <cite>Loglan 1: A Logical
Language</cite> by James Cooke Brown (4th ed. 1989, The Loglan
Institute, Gainesville, Florida, U.S.A.) The language described
therein is not Lojban, but is very close to it and may be
considered an ancestral version. It is regrettably necessary to
state that nothing in this book has been approved by Dr. Brown, and
that the very existence of Lojban is disapproved of by him.</p>

<p>The logic of Lojban, such as it is, owes a good deal to the
American philosopher W. v.O. Quine, especially <cite>Word and
Object</cite> (1960, M.I.T. Press). Much of Quine's philosophical
writings, especially on observation sentences, reads like a literal
translation from Lojban.</p>

<p>The theory of negation expounded in <a
href="chapter15.html">Chapter 15</a> is derived from a reading of
Larry Horn's work <cite>The Natural History of Negation</cite>.</p>

<p>Of course, neither Brown nor Quine nor Horn is in any way
responsible for the uses or misuses I have made of their works.</p>

<p>Depending on just when you are reading this book, there may be
three other books about Lojban available: a textbook, a
Lojban/English dictionary, and a book containing general
information about Lojban. You can probably get these books, if they
have been published, from the same place where you got this book.
In addition, other books not yet foreseen may also exist.</p>

<h3>7. Captions to Pictures</h3>

<p>The following examples list the Lojban caption, with a
translation, for the picture at the head of each chapter. If a
chapter's picture has no caption, ``(none)'' is specified
instead.</p>

<pre>
<a id="e7d1" name="e7d1">7.1)</a>  <a
href="chapter1.gif">coi lojban.       coi rodo</a>
    Greetings, O Lojban!    Greetings, all-of you

<a id="e7d2" name="e7d2">7.2) </a>  (none)

<a id="e7d3" name="e7d3">7.3) </a>  <a
href="chapter3.gif">.i .ai .i .ai .o</a>
    [untranslatable]

<a id="e7d4" name="e7d4">7.4) </a>  <a href="chapter4.gif">jbobliku</a>
    Lojbanic-blocks

<a id="e7d5" name="e7d5">7.5) </a>  (none)

<a id="e7d6" name="e7d6">7.6)  </a> <a
href="chapter6.gif">lei re nanmu cu bevri le re nanmu</a>
    The-mass-of two men carry the two men
    Two men (jointly) carry two men (both of them).

<a id="e7d7" name="e7d7">7.7)  </a> <a
href="chapter7.gif">ma drani danfu</a>
        .i di'e
        .i di'u
        .i dei
        .i ri
        .i do'i
    [What sumti] is-the-correct type-of-answer?
        The-next-sentence.
        The-previous-sentence.
        This-sentence.
        The-previous-sentence.
        An-unspecified-utterance.

<a id="e7d8" name="e7d8">7.8)  </a> <a
href="chapter8.gif">ko viska re prenu poi bruna la santas.</a>
    [You!] see two persons who-are brothers-of Santa.

<a id="e7d9" name="e7d9">7.9)</a>   (none)

<a id="e7d10" name="e7d10">7.10)</a> <a
href="chapter10.gif">za'o klama</a>
    [superfective] come/go
    Something goes (or comes) for too long.

<a id="e7d11" name="e7d11">7.11)</a> <a
href="chapter11.gif">le si'o kunti</a>
    The concept-of emptiness

<a id="e7d12" name="e7d12">7.12)</a> (none)

<a id="e7d13" name="e7d13">7.13)</a> <a
href="chapter13.gif">.oi ro'i ro'a ro'e</a>
    [Pain!] [emotional] [social] [mental]

<a id="e7d14" name="e7d14">7.14)</a> (none)

<a id="e7d15" name="e7d15">7.15)</a> <a
href="chapter15.gif">mi na'e lumci le karce</a>
    I other-than wash the car
    I didn't wash the car.

<a id="e7d16" name="e7d16">7.16)</a> <a
href="chapter16.gif">drata mupli pe'u .djan.</a>
    another example [please] John
    Another example, John, please!

<a id="e7d17" name="e7d17">7.17)</a> <a
href="chapter17.gif">zai xanlerfu by. ly. .obu .jy by. .abu ny.</a>
    [Shift] hand-letters l o j b a n
    "Lojban" in the manual alphabet

<a id="e7d18" name="e7d18">7.18)</a> <a href="chapter18.gif">no no</a>
    0 0

<a id="e7d19" name="e7d19">7.19)</a> (none)

<a id="e7d20" name="e7d20">7.20)</a> (none)

<a id="e7d21" name="e7d21">7.21)</a> (none)
</pre>

<h3>8. Boring Legalities</h3>

<p>This book is Copyright &copy; 1997 by The Logical Language
Group, Inc.</p>

<p>Permission is granted to make and distribute verbatim copies of
this book, either in electronic or in printed form, provided the
copyright notice and this permission notice are preserved on all
copies.</p>

<p>Permission is granted to copy and distribute modified versions
of this book, provided that the modifications are clearly marked as
such, and provided that the entire resulting derived work is
distributed under the terms of a permission notice identical to
this one.</p>

<p>Permission is granted to copy and distribute translations of
this manual into another language, under the above conditions for
modified versions, except that this permission notice may be stated
in a translation that has been approved by the Logical Language
Group, rather than in English.</p>

<p>The contents of <a href="chapter21.html">Chapter 21</a> are in the
public domain.</p>

    <hr />
    
    <p>Última modificación: Mon Jun 27 23:13:49 PDT 2005</p>

    <p>Please <a href="../../llg/feedback.php">contact us</a> with any comments, suggestions or concerns.</p>

</body>
</html>
